/*************************************************************************

    ThreeD 0.02
    Copyright (c) 1994 CSC Three
    Walk in a three dimensional maze.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#ifndef __BORLANDC__
#error This program requires the Borland C++ compiler.
#endif

// Standard C++ includes
#include <assert.h>
#include <ctype.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <iostream.h>
#include <limits.h>
#include <conio.h>
#include <time.h>
#include <dos.h>

// Application includes
#include "Basic.h"
#include "ThreeD.h"
#include "Angle.h"
#include "Maze.h"
#include "Display.h"
#include "Texture.h"
#include "GrafDrvr.h"

/* -----------------------------------------------------------------------
    Globals
----------------------------------------------------------------------- */

// Program updating information
char *ProgramName      = "3D-Lab 0.02";
char *ProgramAuthors[] = {"Sheldon Young", "Mike Lyons", NULL};
char *ProgramAbstract  = "Walk in a three dimensional maze";

// The maze itself
tMaze Maze;

/* -----------------------------------------------------------------------
    main
----------------------------------------------------------------------- */

int main(void)
// Overview: Program entry point
{

    // Some assertions before we begin to check our sanity.
    // These disappear when NDEBUG is defined.
    assert(Sine(0) == 0);
    assert(Sine(USHRT_MAX) == 0);
    assert(Sine(USHRT_MAX/4) == SHRT_MAX);
    assert(Cosine(0) == SHRT_MAX);
    assert(Cosine(USHRT_MAX) == SHRT_MAX);
    assert(Cosine(USHRT_MAX/4) == 0);

#ifdef TMAZE_TEST
    // Vertices
    Maze.AddVertex(-1000,-1000);        // 0
    Maze.AddVertex(-1000,    0);        // 1
    Maze.AddVertex(-1000, 1000);        // 2
    Maze.AddVertex(    0, 1000);        // 3
    Maze.AddVertex( 1000, 2000);        // 4
    Maze.AddVertex(    0, 2000);        // 5
    Maze.AddVertex(    0, 2400);        // 6
    Maze.AddVertex(- 400, 2400);        // 7
    Maze.AddVertex(- 800, 1800);        // 8
    Maze.AddVertex(-1400, 2600);        // 9
    Maze.AddVertex(- 800, 3400);        // 10
    Maze.AddVertex(- 400, 2800);        // 11
    Maze.AddVertex(    0, 2800);        // 12
    Maze.AddVertex(  400, 2600);        // 13
    Maze.AddVertex(  400, 2200);        // 14
    Maze.AddVertex(    0, 3000);        // 15
    Maze.AddVertex( 1000, 3000);        // 16
    Maze.AddVertex( 2000, 2000);        // 17
    Maze.AddVertex( 3000, 1000);        // 18
    Maze.AddVertex( 3000, 1600);        // 19
    Maze.AddVertex( 2200, 2000);        // 20
    Maze.AddVertex( 2200, 2600);        // 21
    Maze.AddVertex( 2600, 2800);        // 22
    Maze.AddVertex( 3000, 2400);        // 23
    Maze.AddVertex( 3000, 2000);        // 24
    Maze.AddVertex( 4000, 2000);        // 25
    Maze.AddVertex( 4000, 1000);        // 26
    Maze.AddVertex( 4000,    0);        // 27
    Maze.AddVertex( 3000,    0);        // 28
    Maze.AddVertex( 2000,    0);        // 29
    Maze.AddVertex( 2000, 1000);        // 30
    Maze.AddVertex( 1000,    0);        // 31
    Maze.AddVertex( 1000,-1000);        // 32
    Maze.AddVertex(    0,-1000);        // 33

    // Walls
    Maze.AddWall( 0, 1, 500,stone1  ); // 0
    Maze.AddWall( 1, 2, 500,stone1  ); // 1
    Maze.AddWall( 2, 3, 500,stone1  ); // 2
    Maze.AddWall( 3, 4, 500,stone1  ); // 3
    Maze.AddWall( 4, 5, 500,stone1  ); // 4
    Maze.AddWall( 5, 6, 500,stone1  ); // 5
    Maze.AddWall( 6, 7, 400,marblue1); // 6
    Maze.AddWall( 7, 8, 400,marblue1); // 7
    Maze.AddWall( 8, 9, 350,marblue1); // 8
    Maze.AddWall( 9,10, 350,marblue1); // 9
    Maze.AddWall(10,11, 400,marblue1); // 10
    Maze.AddWall(11,12, 450,marblue1); // 11
    Maze.AddWall(12,13, 300,wood1   ); // 12
    Maze.AddWall(13,14, 300,wood1   ); // 13
    Maze.AddWall(14,13, 300,wood1   ); // 14
    Maze.AddWall(13,12, 300,wood1   ); // 15
    Maze.AddWall(12,15, 500,stone1  ); // 16
    Maze.AddWall(15,16, 500,stone1  ); // 17
    Maze.AddWall(16,17, 500,stone1  ); // 18
    Maze.AddWall(17,18, 500,stone1  ); // 19
    Maze.AddWall(18,19, 500,stone1  ); // 20
    Maze.AddWall(19,20, 450,brick1  ); // 21
    Maze.AddWall(20,21, 300,brick1  ); // 22
    Maze.AddWall(21,22, 200,starry  ); // 23
    Maze.AddWall(22,23, 200,starry  ); // 24
    Maze.AddWall(23,24, 300,brick1  ); // 25
    Maze.AddWall(24,25, 500,stone1  ); // 26
    Maze.AddWall(25,26, 500,stone1  ); // 27
    Maze.AddWall(26,27, 500,stone1  ); // 28
    Maze.AddWall(27,28, 500,stone1  ); // 29
    Maze.AddWall(28,29, 500,stone1  ); // 30
    Maze.AddWall(29,30, 500,stone1  ); // 31
    Maze.AddWall(30,31, 500,stone1  ); // 32
    Maze.AddWall(31,32, 500,stone1  ); // 33
    Maze.AddWall(32,33, 500,stone1  ); // 34
    Maze.AddWall(33, 0, 500,stone1  ); // 35
#endif

    // Set default display modes
    Maze.Display.FillScreen(DefaultBackgroundColor);
    Maze.Display.SetMode(ThreeD);
    Maze.Display.SetDoubleBuffer(True);
    Maze.SetMouse(True);
    Maze.SetPlayer(0, 0, 0);

#ifdef BENCHMARKS
    // Test for speed if wanted
    Benchmark();
#endif

    // Display intro, skipping if key hit
    if (!kbhit())
        {
        DisplayAbout();
        DisplayCopyright();
        Maze.DissolveToView();
        }
    else
        getch();

    // Main loop
    char Key;
    do
        {
        Key = Maze.MovePlayer();
        switch(Key)
            {
            // Tab toggles display modes
            case 9:
                Maze.Display.ToggleMode();
                Maze.DissolveToView();
                break;
            // Escape to quit
            case 27:
                if (ReallyQuit() == True)
                    Maze.Display.DissolveScreenToColor(Black, 0, 0, 0);
                else
                    {
                    Key = 0;
                    Maze.DissolveToView();
                    }
                break;
            // Center player
            case 'c':
                Maze.SetPlayer(0,0,0);
                break;
            // Set display mode
            case 'd':
                SetDisplayMode();
                break;
            // Title screen
            case 't':
                DisplayAbout();
                Maze.DissolveToView();
                break;
            // Help
            case 'h':
                DisplayHelp();
                Maze.DissolveToView();
                break;
            // Bad key if not 0, beep
            default:
                if (Key != 0)
                    {
                    Maze.Display.GotoXY(0, SCREEN_SIZE_Y - 18);
                    Maze.Display.SetTextColor(2);
                    Maze.Display.CenterString("Press H for help");
                    Maze.Display.Update();
                    sound(500);
                    delay(250);
                    sound(250);
                    delay(500);
                    nosound();
                    }
                break;
            }
        Maze.DrawView(False);
        }
    while (Key != 27);      // Until escape pressed
    return(EXIT_SUCCESS);

}

/* -----------------------------------------------------------------------
    Menu routines
----------------------------------------------------------------------- */

// Overview: Sets the display mode from a menu choice.
void SetDisplayMode(void)
{
    // Draw menu
    Maze.Display.SetTextColor(Blue);
    Maze.Display.GotoXY(0,18);
    Maze.Display.CenterString("Display Mode\n\n");
    Maze.Display.SetTextColor(DarkGrey);
    Maze.Display.GotoXY(75,Maze.Display.YCursor());
    Maze.Display.OutString("\tT - Three dimensional\n");
    Maze.Display.GotoXY(75,Maze.Display.YCursor());
    Maze.Display.OutString("\tW - Wireframe\n");
    Maze.Display.GotoXY(75,Maze.Display.YCursor());
    Maze.Display.OutString("\tO - Overhead\n");
    Maze.Display.GotoXY(75,Maze.Display.YCursor());
    Maze.Display.OutString("\tC - Clipped overhead\n");
    Maze.Display.GotoXY(75,Maze.Display.YCursor());
    Maze.Display.OutString("\tS - Solid colors\n");
    Maze.Display.SetTextColor(Blue);
    Maze.Display.GotoXY(0, SCREEN_SIZE_Y - 18);
    Maze.Display.SetTextColor(Blue);
    Maze.Display.CenterString("Enter choice");
    Maze.Display.DissolveToVideoMemory(0, 0, 0xFFF);

    // Wait for key
    switch(tolower(getch()))
        {
        case 't' :  Maze.Display.SetMode(ThreeD);
                    break;
        case 'w' :  Maze.Display.SetMode(Wireframe);
                    break;
        case 'c' :  Maze.Display.SetMode(Clipped);
                    break;
        case 'o' :  Maze.Display.SetMode(Overhead);
                    break;
        case 's' :  Maze.Display.SetMode(Solid);
                    break;
        }
    Maze.DissolveToView();
}

tBool ReallyQuit(void)
// Overview: Asks the user if they really want to quit.
// Returns:  True if the user wants to quit, False otherwise.
{
    Maze.Display.SetTextColor(Green);
    Maze.Display.SetTextBorder(True);
    Maze.Display.GotoXY(0,20);
    Maze.Display.CenterString("Quit");
    Maze.Display.SetTextColor(DarkGrey);
    Maze.Display.GotoXY(0, 80);
    Maze.Display.CenterString("Do you really want\n");
    Maze.Display.GotoXY(0, Maze.Display.YCursor() + 5);
    Maze.Display.CenterString("to quit? (y/N)");

    // Put it on the screen
    Maze.Display.DissolveToVideoMemory(0, 0, 0xFFF);
    if (tolower(getch()) == 'y')
        return(True);
    return(False);
}

/* -----------------------------------------------------------------------
    Information routines
----------------------------------------------------------------------- */

void DisplayAbout(void)
// Overview: Displays a short blurb about this program on it's own screen.
{
    // Draw background
    Maze.Display.GotoXY(0,0);
    Maze.Display.DrawRect(0,0, 319,199, transparent, marblue1, TileRect);
    Maze.Display.DrawTextureTrapezoid(0L,30,170, 200,80,120, stone1);
    Maze.Display.DrawTextureTrapezoid(200L,80,120, 319,30,170, brick1);
    Maze.Display.SetTextColor(13);
    Maze.Display.SetTextBorder(True);

    // Display title and abstract
    Maze.Display.OutChar('\n');
    Maze.Display.CenterString(ProgramName);
    Maze.Display.OutString("\n\n");
    Maze.Display.SetTextColor(9);
    Maze.Display.CenterString(ProgramAbstract);
    Maze.Display.OutString("\n\n");

    // Display program authors
    Maze.Display.GotoXY(75, Maze.Display.YCursor());
    Maze.Display.SetTextColor(11);
    Maze.Display.OutString("By:");
    Maze.Display.SetTextColor(10);
    for (int i = 0 ; ProgramAuthors[i] != NULL ; i++)
        {
        Maze.Display.GotoXY(105, Maze.Display.YCursor());
        Maze.Display.OutString(ProgramAuthors[i]);
        Maze.Display.OutChar('\n');
        }

    // Display Press any key message
    Maze.Display.GotoXY(0, SCREEN_SIZE_Y-15);
    Maze.Display.SetTextColor(8);
    Maze.Display.CenterString("Press any key to continue...");

    // Put it on the screen
    Maze.Display.DissolveToVideoMemory(0, 0, 0xFFF);
    getch();
}

void DisplayCopyright(void)
// Overview: Displays a legal message and waits for a keypress.
{
    // Draw background
    Maze.Display.GotoXY(0,0);
    Maze.Display.DrawRect(0,0, 319,199, transparent, marblue1, TileRect);
    Maze.Display.DrawTextureTrapezoid(0L,30,170, 200,80,120, stone1);
    Maze.Display.DrawTextureTrapezoid(200L,80,120, 319,30,170, brick1);
    Maze.Display.SetTextColor(13);
    Maze.Display.SetTextBorder(True);

    // Display title and abstract
    Maze.Display.GotoXY(0, 15);
    Maze.Display.CenterString("Legal information");
    Maze.Display.GotoXY(0, 40);
    Maze.Display.SetTextColor(12);
    Maze.Display.OutString(" ");
    Maze.Display.OutString(ProgramName);
    Maze.Display.OutString(" is copyright (C) 1994 CSC\n");
    Maze.Display.OutString(" Three and comes with ABSOLUTELY\n");
    Maze.Display.OutString(" NO WARRANTY; for details please\n");
    Maze.Display.OutString(" read the included GNU Public License.\n\n");
    Maze.Display.OutString(" This is free software and you are\n");
    Maze.Display.OutString(" welcome to redistribute it under the\n");
    Maze.Display.OutString(" conditions in the above documents.");

    // Display Press any key message
    Maze.Display.GotoXY(0, SCREEN_SIZE_Y-15);
    Maze.Display.SetTextColor(8);
    Maze.Display.CenterString("Press any key to continue...");

    // Put it on the screen
    Maze.Display.DissolveToVideoMemory(0, 0, 0xFFF);
    getch();
}

void DisplayHelp(void)
// Overview: Displays some help on how to use the program.
{
    // Title
    Maze.Display.SetTextColor(Green);
    Maze.Display.SetTextBorder(True);
    Maze.Display.GotoXY(0,20);
    Maze.Display.CenterString("Help");

    // Help messages
    Maze.Display.SetTextColor(DarkGrey);
    Maze.Display.GotoXY(35, 55);
    Maze.Display.OutString("J & L");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  Rotate left and right\n");
    Maze.Display.GotoXY(35, Maze.Display.YCursor());
    Maze.Display.OutString("U & O");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  Move left and right\n");
    Maze.Display.GotoXY(35, Maze.Display.YCursor());
    Maze.Display.OutString("I & K");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  Move up and down\n");
    Maze.Display.GotoXY(35, Maze.Display.YCursor());
    Maze.Display.OutString("H");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  This help screen\n");
    Maze.Display.GotoXY(35, Maze.Display.YCursor());
    Maze.Display.OutString("D");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  Set display mode\n");
    Maze.Display.GotoXY(35, Maze.Display.YCursor());
    Maze.Display.OutString("Esc");
    Maze.Display.GotoXY(85, Maze.Display.YCursor());
    Maze.Display.OutString("-  Quit\n");
    Maze.Display.OutString("\n");
    Maze.Display.SetTextColor(Green);

    // Put it on the screen
    Maze.Display.DissolveToVideoMemory(0, 0, 0xFFF);
    Maze.Display.GotoXY(0, SCREEN_SIZE_Y-15);
    Maze.Display.SetTextColor(Green);
    Maze.Display.CenterString("Press any key to continue...");
    getch();
    Maze.DissolveToView();

}


/* -----------------------------------------------------------------------

    BENCHMARKS

    Little routine to see just how fast this thing is.  It generates
    a file called Benchmrk.txt with the stats inclosed, as to prevent
    too much disturbance when running.  The statistics will be appended
    makinging it easy to view the progress made.

    The code isn't very pretty, but it's functional.

----------------------------------------------------------------------- */

#ifdef BENCHMARKS

#include <fstream.h>
#include <time.h>
#include <math.h>
#include "GrafDrvr.h"

void Benchmark(void)
{
    const long AngleTimes      = USHRT_MAX * 150;   // Loop limits
    const long DisplayTimes    = 750;
    const long PlotPointTimes  = ULONG_MAX / 500;
    const long PlotBitmapTimes = 300;
    const long TrapezoidTimes  = 90;
    const long DistanceTimes   = SHRT_MAX;
    tAngle Angle;                                   // Timer loop indices
    long i;
    time_t Start, End;                              // Start and end times

    // Open benchmark file
    ofstream StatFile;
    StatFile.open("Benchmrk.txt", ios::app);
    if (StatFile == NULL)
        {
        cerr << "Unable to open statistics file.\n";
        exit(EXIT_FAILURE);
        }
    time_t CurrentTime = time(NULL);
    StatFile << '\n' << ProgramName << " benchmark generated "
             << ctime(&CurrentTime);

    // Test tDisplay functions
    StatFile << "tDisplay functions\n";
    Maze.Display.ClearScreen();
    Start = clock();
    for (i = 0 ; i < PlotBitmapTimes ; i++)
        {
        Maze.Display.PlotBitmap(marblue1Bmp, 10, 10);
        Maze.Display.Update();
        }
    End = clock();
    StatFile << "\tPlotBitmap = " << PlotBitmapTimes*CLK_TCK/(End-Start) << " textures per second\n";

    Start = clock();
    for (i = TrapezoidTimes ; i > 0 ; i--)
        {
        Maze.Display.DrawTextureTrapezoid(i, i, SCREEN_SIZE_Y-1-i,
                                          SCREEN_SIZE_X-1-i, i, SCREEN_SIZE_Y-i,
                                          marblue1);
        Maze.Display.Update();
        }
    End = clock();
    StatFile << "\tTrapezoid  = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second (zooming)\n";

    Start = clock();
    for (i = 0 ; i < PlotPointTimes ; i++)
        Maze.Display.PlotPoint(10, 10, Yellow);
    End = clock();
    StatFile << "\tPlotPoint  = " << PlotPointTimes*CLK_TCK/((End-Start) * 1000) << " thousand pixels per second\n";

    // tDisplay modes
    StatFile << "tDisplay modes\n";
    Maze.Display.SetMode(Overhead);
    Start = clock();
    for (i = 0 ; i < DisplayTimes ; i++)
        Maze.DrawView(True);
    End = clock();
    StatFile << "\tOverhead   = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second\n";

    Maze.Display.SetMode(Clipped);
    Start = clock();
    for (i = 0 ; i < DisplayTimes ; i++)
        Maze.DrawView(True);
    End = clock();
    StatFile << "\tClipped    = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second\n";

    Maze.Display.SetMode(Wireframe);
    Start = clock();
    for (i = 0 ; i < DisplayTimes ; i++)
        Maze.DrawView(True);
    End = clock();
    StatFile << "\tWireframe  = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second\n";

    Maze.Display.SetMode(Solid);
    Start = clock();
    for (i = 0 ; i < DisplayTimes ; i++)
        Maze.DrawView(True);
    End = clock();
    StatFile << "\tSolid      = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second\n";

    Maze.Display.SetMode(ThreeD);
    Start = clock();
    for (i = 0 ; i < DisplayTimes ; i++)
        Maze.DrawView(True);
    End = clock();
    StatFile << "\tThreeD     = " << DisplayTimes*CLK_TCK/(End-Start) << " frames per second\n";

    // Invisible functions
    Maze.Display.GotoXY(0, 80);
    Maze.Display.SetTextColor(13);
    Maze.Display.CenterString("Invisible\n");
    Maze.Display.CenterString("benchmarks");
    Maze.Display.Update();

    // Grafdrvr functions

    StatFile << "Grafdrvr functions\n";
    Start = clock();
    for(i = 0 ; i < DistanceTimes ; i++)
        DistanceToPoint(i, i);
    End = clock();
    StatFile << "\tDistanceToPoint = " << DistanceTimes*CLK_TCK/(End-Start) << " per second\n";

    // Test trig
    StatFile << "tAngle trig functions\n";
    Start = clock();
    for(Angle = 0 ; Angle < AngleTimes ; Angle++)
        Sine(Angle);
    End = clock();
    StatFile << "\tSine(tAngle)   = " << AngleTimes*CLK_TCK/(End-Start) << " per second\n";

    Start = clock();
    for(Angle = 0 ; Angle < AngleTimes ; Angle++)
        Cosine(Angle);
    End = clock();
    StatFile << "\tCosine(tAngle) = " << AngleTimes*CLK_TCK/(End-Start) << " per second\n";

    Start = clock();
    for(Angle = 0 ; Angle < AngleTimes ; Angle++)
        sin(Angle);
    End = clock();
    StatFile << "\tsin(double)    = " << AngleTimes*CLK_TCK/(End-Start) << " per second\n";

    Start = clock();
    for(Angle = 0 ; Angle < AngleTimes ; Angle++)
        cos(Angle);
    End = clock();
    StatFile << "\tcos(double)    = " << AngleTimes*CLK_TCK/(End-Start) << " per second\n";

    StatFile.close();
}
#endif

