// sprite.h : interface of the CSprite class
//
/////////////////////////////////////////////////////////////////////////////

#define DT_SHOWSPRITE	1
#define DT_MOVESPRITE	2
#define DT_INITSPRITE	3
#define	DT_KEEPIMAGE	4
#define DT_ONPAINT		5

class CSpriteMgr;

class CSprite : public CObject
{
	friend CSpriteMgr;

	DECLARE_SERIAL(CSprite)
public:	
	CSprite(int nID = -1, BOOL bVisible = TRUE, BOOL bDraggable = FALSE, BOOL bOwnerDraw = FALSE);
	
// Attributes
public:
	int			m_nID;
	BOOL		m_bVisible;
	BOOL		m_nZOrder;
	BOOL		m_bDraggable;

protected:
   	CPoint		m_PrevPos;     		// Previous location
   	CRect		m_BitmapRect;		// Bitmap origin, Bitmap width, Bitmap height
	CRect		m_LastStoredRect;	// Size and position of last stored rect
	CSize		m_DeltaLeftTop;		// offset of the last stored rectangle in m_BkgBitmap
	CObArray	m_ImageBitmaps;		// Sprite's images									
	CUIntArray	m_LoopsPerImage;	// how much loops should the bitmaps be displayed
   	CBitmap		m_BkgBitmap;		// What's behind our sprite
	COLORREF	m_TransparentColor;	// Transparent color of sprite bitmap
	int			m_nBitmaps;			// number of attached image bitmaps objects
	int			m_nBitmapIdx;		// next image bitmap to show
	int 		m_nLoopIdx;			// how often was the actual bitmap diplayed
	BOOL 		m_bAutoSkip;		// should the bitmap index skip automatically in every MoveSprite call
	BOOL		m_bOwnerDraw;		// use the given bitmaps or let the user override OnRenderSprite
	BOOL 		m_bTransparent;		// have the given images a transparent color
	
// Operations
public:				// "normal" functions
	virtual void InitSpriteInfo(CDC* pDC, CBitmap& newBitmap, int nLoops, BOOL bTransparent, COLORREF transparent, CPoint& spritePos, BOOL bAutoSkip, CSize* pStretchSize = NULL);	
	virtual void AddSpriteImage(CDC* pDC, CBitmap& newBitmap, int nLoops);
	
					// "owner draw" functions
	virtual void InitSpriteInfo(CDC* pDC, CRect& spriteRect);
	virtual BOOL OnRenderSprite(CDC* /*pDC*/, CRect /*positionInfo*/, COLORREF& /*transparent*/, int /*nDrawingType*/)
		{ASSERT(FALSE); return FALSE;};	// has to be overwritten in an owner draw sprite	
	
	virtual void DrawSprite(CDC* pDC, int nDrawingType, CSize offset = CSize(0, 0));
	virtual void StoreBkg(CDC* pDC, CSize offset = CSize(0, 0));
	virtual void RestoreBkg(CDC *pDC, CSize offset = CSize(0, 0));

	virtual BOOL IntersectSprite(CRect& rect);
	virtual BOOL HitTest(CPoint& pos, BOOL bExact = FALSE, CDC* pDC = NULL);
	
	virtual void MoveSprite(CDC* pDC, CPoint &pos);
	
	virtual void AnimateSprite(CDC *pDC, CPoint& newPos, int nStepFactor);	
	
	virtual void BeginSpriteDragging(CWnd* pWnd, CPoint &pos);
	virtual void EndSpriteDragging(CDC* pDC, CPoint& newPos);

	virtual	void SkipFrames(int nOffset = 1);

	virtual void FreeBitmaps(BOOL bDeleteObjectsOnly = FALSE);

	virtual void GetSpritePos(CRect& pos);
	virtual void GetBoundingRect(CRect& rect);

protected:
	virtual void UpdateOwnerDrawBitmap(CDC* pDC, int nDrawingType);

// Implementation
public:
	virtual ~CSprite();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif

};

/////////////////////////////////////////////////////////////////////////////
