
#include "stdafx.h"

#include "sprite.h"
#include "sprmgr.h"

#include "owndrw.h"

COwnerDraw::COwnerDraw(int nID) 
	: CSprite(nID, TRUE, TRUE, TRUE)
{
}

COwnerDraw::~COwnerDraw()
{
}

BOOL COwnerDraw::OnRenderSprite(CDC* pDC, CRect positionInfo, COLORREF& transparent, int nDrawingType)
{
	static long count = 0L;

	CBrush greenBrush;
	greenBrush.CreateSolidBrush(RGB(0, 255, 0));

	pDC->FillRect(CRect(0, 0, positionInfo.Width(), positionInfo.Height()), &greenBrush);

	greenBrush.DeleteObject();

	CPen bluePen;
	bluePen.CreatePen(PS_SOLID, 3, RGB(0, 0, 255));

	CPen* pOldPen = pDC->SelectObject(&bluePen);

	pDC->MoveTo(0,0);
	pDC->LineTo(positionInfo.Width(), positionInfo.Height());

	pDC->MoveTo(positionInfo.Width(), 0);
	pDC->LineTo(0, positionInfo.Height());

	pDC->SelectObject(pOldPen);
	bluePen.DeleteObject();

	char text[50];
	sprintf(text, "%ld", count);

	CSize textSize = pDC->GetTextExtent(text, strlen(text));
	pDC->TextOut((positionInfo.Width() - textSize.cx) / 2, 
				 0, 
				 text, strlen(text));
	
	count++;

	transparent = RGB(0, 255, 0);

	return TRUE;
}
