// spritvw.cpp : implementation of the CSpritesView class
//

#include "stdafx.h"
#include "sprites.h"

#include "sprite.h"
#include "sprmgr.h"

#include "owndrw.h"

#include "spritdoc.h"
#include "spritvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define LOOPSPERIMAGE	20

/////////////////////////////////////////////////////////////////////////////
// CSpritesView

IMPLEMENT_DYNCREATE(CSpritesView, CView)

BEGIN_MESSAGE_MAP(CSpritesView, CView)
	//{{AFX_MSG_MAP(CSpritesView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpritesView construction/destruction

CSpritesView::CSpritesView()
{
	// TODO: add construction code here	
}

CSpritesView::~CSpritesView()
{
	KillTimer( (UINT)101 );
}

void CSpritesView::OnInitialUpdate()
{
	CClientDC dc(this);

	for(int id = 1; id < 6; id ++)
	{
		CSprite* pSprite;
		if (id < 5)
			pSprite = new CSprite(id, TRUE, FALSE );
		else
		{
			pSprite = new COwnerDraw(id);
			pSprite->InitSpriteInfo(&dc, CRect(400,200,450,250));
			m_SpriteMgr.AddSprite(pSprite);
			continue;
		}

		CPoint pos;

		switch(id)
		{
			case 5:
				pos = CPoint(400,200);
				break;
			case 1:
				pos = CPoint(0,0);
				break;
			case 2:
				pos = CPoint(100,0);
				break;
			case 3:
				pos = CPoint(50,0);
				break;
			case 4:
				pos = CPoint(0,50);
				break;
		}

		CBitmap bitmap;
		bitmap.LoadBitmap(IDB_BITMAP1);

		pSprite->InitSpriteInfo(&dc, bitmap, LOOPSPERIMAGE, TRUE, RGB(0, 0, 255), pos, TRUE );

		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP2);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);

		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP3);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);

		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP4);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);

		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP5);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);
	
		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP6);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);

		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP7);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);
	
		bitmap.DeleteObject();
		bitmap.LoadBitmap(IDB_BITMAP8);

		pSprite->AddSpriteImage(&dc, bitmap, LOOPSPERIMAGE);

		bitmap.DeleteObject();

		m_SpriteMgr.AddSprite(pSprite);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CSpritesView drawing

void CSpritesView::OnDraw(CDC* pDC)
{
	CSpritesDoc* pDoc = GetDocument();

	// TODO: add draw code here

	CRect clipRect;
	pDC->GetClipBox(clipRect);
	
	if(clipRect.IsRectEmpty())
		GetClientRect(clipRect);
					  
	for( int i = 0; i < 100; i++)
	{
		pDC->MoveTo(i*10,clipRect.top);
		pDC->LineTo(i*10,clipRect.bottom);
	}
	for(i = 0; i < 100; i++)
	{
		pDC->MoveTo(clipRect.left, i*10);
		pDC->LineTo(clipRect.right, i*10);
	}	

	m_SpriteMgr.OnPaint(pDC);
}



/////////////////////////////////////////////////////////////////////////////
// CSpritesView diagnostics

#ifdef _DEBUG
void CSpritesView::AssertValid() const
{
	CView::AssertValid();
}

void CSpritesView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSpritesDoc* CSpritesView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSpritesDoc)));
	return (CSpritesDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSpritesView message handlers

void CSpritesView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	CClientDC dc(this);
	m_SpriteMgr.StartDrag(this, point, TRUE, &dc);
	
	CView::OnLButtonDown(nFlags, point);
}

void CSpritesView::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	if(m_SpriteMgr.IsDragging())
	{
		CClientDC dc(this);
		m_SpriteMgr.OnDrag(&dc, point);
	}

	CView::OnMouseMove(nFlags, point);
}

void CSpritesView::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default

	if(m_SpriteMgr.IsDragging())
	{
		CClientDC dc(this);
		m_SpriteMgr.EndDrag(&dc, point);
	}

	CView::OnLButtonUp(nFlags, point);
}

void CSpritesView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
		
	SetTimer( (UINT)101, (UINT)100, NULL );

	CView::OnRButtonDown(nFlags, point);
}

void CSpritesView::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	if(nIDEvent != 101)
		return;

	CClientDC dc(this);

	CRect spritePos;
	CPoint newPos;

	m_SpriteMgr[1]->GetSpritePos(spritePos);
	
	newPos = spritePos.TopLeft() + CSize(7, 7);

	if(newPos.x >= 100)
		newPos = CPoint(0, 0);

#ifdef _DEFER
	m_SpriteMgr.BeginDeferSpritePos();
	m_SpriteMgr.DeferSpritePos(1, newPos);
#else
	m_SpriteMgr.MoveSprite(1, &dc, newPos);
#endif


	m_SpriteMgr[2]->GetSpritePos(spritePos);
	
	newPos = spritePos.TopLeft() + CSize(-9, 7);
	
	if(newPos.x <= 0)
		newPos = CPoint(100, 0);

#ifdef _DEFER
	m_SpriteMgr.DeferSpritePos(2, newPos);
#else	
	m_SpriteMgr.MoveSprite(2, &dc, newPos);	
#endif

	m_SpriteMgr[3]->GetSpritePos(spritePos);
	
	newPos = spritePos.TopLeft() + CSize(0, 7);

	if(newPos.y >= 100)
		newPos = CPoint(50, 0);

#ifdef _DEFER
	m_SpriteMgr.DeferSpritePos(3, newPos);
#else
	m_SpriteMgr.MoveSprite(3, &dc, newPos);
#endif

	m_SpriteMgr[4]->GetSpritePos(spritePos);
	
	newPos = spritePos.TopLeft() + CSize(9, 0);
	
	if(newPos.x >= 100)
		newPos = CPoint(0, 50);

#ifdef _DEFER
	m_SpriteMgr.DeferSpritePos(4, newPos);
	m_SpriteMgr.EndDeferSpritePos(&dc);
#else
	m_SpriteMgr.MoveSprite(4, &dc, newPos);	
#endif

	CView::OnTimer(nIDEvent);
}
