// sprmgr.h : interface of the CSpriteMgr class
//
/////////////////////////////////////////////////////////////////////////////

#define TOPSPRITE		-1
#define BOTTOMSPRITE	-2
#define SPRITE_ERROR_ID	-1

class CSpriteMgr : public CObject
{
	DECLARE_SERIAL(CSpriteMgr)
public:
	CSpriteMgr();
	
// Attributes
protected:
	CObList		m_Sprites;
	BOOL		m_bDragging;
	CSprite*	m_pDraggedSprite;

	BOOL		m_bInDeferBlock;
	CPtrArray	m_DeferPositions;
	CObArray	m_DeferSprites;

// Operations
public:
	virtual BOOL AddSprite(CSprite* pSprite, int nPlaceInFrontOfID = TOPSPRITE);	
	virtual void RemoveSprite(CDC* pDC, int nID, BOOL bFreeMem = TRUE);

	virtual void ShowSprite(CDC* pDC, int nID, BOOL bShow);	
	virtual BOOL IsSpriteVisible(int nID);
	
	virtual BOOL IntersectSprites(CObArray* pObArray, CRect& rect);
	virtual BOOL IntersectSprites(CObArray* pBeneath, CObArray* pAbove, 
								  CSprite* pSprite, CRect additionalRect = CRect(0,0,0,0));

	virtual void MoveSprite(int nID, CDC* pDC, CPoint &pos);
	virtual void MoveSprite(CSprite* pSprite, CDC* pDC, CPoint &pos);

	virtual void AnimateSprite(int nID, CDC *pDC, CPoint& newPos, int nStepFactor);
	virtual void AnimateSprite(CSprite* pSprite, CDC *pDC, CPoint& newPos, int nStepFactor);

	virtual void SkipFrames(int nID, BOOL bShow, int nOffset = 1, CDC *pDC = NULL);

	virtual void OnPaint(CDC* pDC);

	virtual BOOL HitTest(CObArray* pObArray, CPoint& point, BOOL bExact, CDC* pDC);

	virtual int  StartDrag(CWnd* pWnd, CPoint& pos, BOOL bExact, CDC* pDC = NULL);	
	virtual void OnDrag(CDC* pDC, CPoint& pos);
	virtual void EndDrag(CDC* pDC, CPoint& pos);
	virtual BOOL IsDragging();

	virtual CSprite* GetSpriteFromID(int nID);
	CSprite* operator[](int nID);

	virtual void ChangeZOrder(CDC* pDC, int nID, int nPlaceInFrontOfID = TOPSPRITE);

	virtual BOOL BeginDeferSpritePos();
	virtual void DeferSpritePos(int nID, CPoint &pos);
	virtual void DeferSpritePos(CSprite* pSprite, CPoint &pos);
	virtual void EndDeferSpritePos(CDC* pDC);

protected:
	virtual POSITION GetPosFromID(int nID);

// Implementation
public:
	virtual ~CSpriteMgr();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif
};

/////////////////////////////////////////////////////////////////////////////
