// Program : MSGINPBX.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 03/10/94 19:57:52
// Note    : Copyright 1993-94, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1/4.0
//
//     This library will create message boxes and input boxes as simple or
// complex as needed.  The boxes can optionally close themselves after a
// specified period of inactivity and can have an optional timed beep upon
// opening.  By not specifying any buttons, you can have a timed display box
// that the user is required to look at until it expires.  The dialogs can
// explode and implode and are auto-sizing based on the larger of the title,
// longest message line, input line size, or button line size.  The make
// function is also screen size aware and will allow you to take advantage of
// 43/50 line mode if enabled.  Each passed message line can also have
// printf()-style formatting codes in it with the appropriate values passed
// after each line.
//

// Error codes returned by the functions.
#define mdCantInpInMsgBox  -1       // Can't use input options in MsgBox()
#define mdNoOptsForInpBox  -2       // No input options specified in InpBox()
#define mdLineTooLong      -3       // Text line exceeds 254 characters
#define mdTooManyLines     -4       // Too many line parameters
#define mdTooManyButtons   -5       // Too many button parameters
#define mdTooWide          -6       // Title or text line(s) are too wide
#define mdButtonsTooWide   -7       // Button line is too wide
#define mdTooHigh          -8       // Dialog box is too high for the screen
#define mdAllocationFailed -9       // Turbo Vision's lowMemory() said no way
#define mdInvalidView      -10      // validView() said it's invalid

// Some standard title strings.  Modifiable in the header so that
// the code doesn't need recompiling.
#define mdNoTitle       NULL
#define mdInformation   "* Information *"
#define mdConfirmation  "? Confirmation ?"
#define mdWarning       ">> Warning <<"
#define mdError         "! Error !"

// To prevent you from having to OR a whole lot of separate values together,
// these definitions will simplify telling the functions what you are
// passing.  You must specify one of them for the Options parameter.
//
// In the calls to MsgBox(), InpBox(), or makeMsgDialog(), follow the
// Options parameter with the necessary data in the order given in the
// comment for each type below.
#define mdPlain       0x0000 // No special options.  It expects the first
                             // message line immediately after Options.
#define mdTime        0x0001 // Time Limit
#define mdBeep        0x0002 // Beep Length, Beep Frequency
#define mdInput       0x0004 // Input Length (No history)
#define mdInputHis    0x0008 // Input Length, History Id
                             // Setting this bit implies that you are also
                             // passing an Input Length.  You can't have
                             // history without an input line!

#define mdTimeBeep    0x0003 // Time Limit, Beep Length, Beep Frequency
#define mdTimeInp     0x0005 // Time Limit, Input Length
#define mdTimeInpHis  0x0009 // Time Limit, Input Length, History Id
#define mdTimeBeepInp 0x0007 // Time Limit, Beep Length, Beep Frequency, Input
                             // Length
#define mdTimeBeepHis 0x000B // Time Limit, Beep Length, Beep Frequency, Input
                             // Length, History Id
#define mdBeepInp     0x0006 // Beep Length, Beep Frequency, Input Length
#define mdBeepInpHis  0x000A // Beep Length, Beep Frequency, Input Length,
                             // History Id

// Same as above, but the message/input box will explode and implode.
#define mdXPlain       0x0010
#define mdXTime        0x0011
#define mdXBeep        0x0012
#define mdXInput       0x0014
#define mdXInputHis    0x0018
#define mdXTimeBeep    0x0013
#define mdXTimeInp     0x0015
#define mdXTimeInpHis  0x0019
#define mdXTimeBeepInp 0x0017
#define mdXTimeBeepHis 0x001B
#define mdXBeepInp     0x0016
#define mdXBeepInpHis  0x001A

// These options may or may not be used so they are separate.
// OR them with the Option values above when needed.

// NOTE: Setting the password bit will cause the history button to be
// ignored if one is specified.  If not done, the history list could give
// away the password!
#define mdPwrd         0x0100       // Treat the input line as a password

// The lack of a color specification defaults it to the normal
// background color (like a TStaticText object).
//
// NOTE: To be used properly, the appropriate colors must have been
//       added to the application color palettes!
//       The values associated with the colors here are bit flags for
//       the make routine.  They bear no relation to the true values
//       or indices used to get the color for the display!
//
// See the demo for an example of using TVCOLR.H.  Complete details for
// using TVCOLR.H can be found by downloading TVCOLR.ZIP from library 11
// (Turbo Vision) in the BCPPDOS forum on CompuServe.
//
#define mdInfoColor    0x0200       // Use Information color for text
#define mdNotifyColor  0x0400       // Use Notification color for text
#define mdWarnColor    0x0800       // Use Warning color for text
#define mdErrColor     0x1000       // Use Error color for text

// Some standard beep durations.
#define mdNoBeep            0
#define mdShortBeep         1
#define mdMediumBeep        2
#define mdLongBeep          4
#define mdObnoxiousBeep     8       // Trying to get someone's attention?

// Some standard pitch values for the beep.  Note that the lowest pitch that
// can be generated by a PC is about 20.  Values lower than 20 will usually
// not generate any audible sound at all.  Values higher than 1000 are
// generally uncomfortable to hear.
#define mdNoPitch     0
#define mdLowPitch    100
#define mdMedPitch    500
#define mdHighPitch   1000

// Some default button patterns.  The given set is inserted automatically
// when one of these values is specified.  No data needs to be passed for them.
// No user defined buttons can be used when one of these options is specified.
#define mdNoButtons      0          // No buttons at all
#define mdOKOnly        -1          // OK button only
#define mdCancelOnly    -2          // Cancel button only
#define mdOKCancel      -3          // OK and Cancel buttons (Default=Ok)
#define mdYesNo         -4          // Yes and No buttons (Default=Yes)
#define mdYesNoCancel   -5          // Yes, No, and Cancel buttons (Default=Yes)

class far TDialog;
class far TResourceFile;

// ****************************************************************************
// Message box function.  This builds and executes a message dialog box.
// I have chosen to implement the return value as a short instead of an
// unsigned short.  That way, negative error codes can be returned and they
// won't interfere with any defined Turbo Vision commands.  You'll lose
// the extra 32,768 possible command values but I'm sure you can live
// without them <g>.
// ****************************************************************************
short MsgBox(const char *aTitle, short NumLines, short NumButtons,
             short Options, ...);

// Read and execute a pre-defined message box from a resource file.
short rscMsgBox(TResourceFile *rsc, const char *Name);

// ****************************************************************************
// Input box function.  Same as a message box but has an input line.
// REMEMBER: Input Length is the length of the string in the data structure!!!
//           Actual width for input is Input Length - 1!!!
// ****************************************************************************
short InpBox(char *data, const char *aTitle, short NumLines, short NumButtons,
             short Options, ...);

// Read and execute a pre-defined input box from a resource file.
short rscInpBox(char *data, TResourceFile *rsc, const char *Name);

// ****************************************************************************
// The message dialog box builder.  This validates the information passed to
// it and builds the dialog accordingly.  It can be called directly by the user
// in a resource builder program to create message or input boxes that have
// constant text (no variable parameters such as %d or %s in the message
// lines at runtime) and store them on a stream.
//
// A negative return value in RetCode indicates one of the error conditions
// listed previously.  A non-negative RetCode indicates how many variable
// parameters were processed from the "..." variable arguments list.
//
// ****************************************************************************
TDialog *makeMsgDialog(const char *aTitle, short NumLines, short NumButtons,
                       short &RetCode, short Options, ...);
