// File    : MSGTST.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 03/10/94 19:57:52
// Note    : Copyright 1993-94, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1/4.0
//
// This program will demonstrate the message box and input box functions.
//
// Included is my standard front end.  It will also serve as a fairly good
// tutorial on selecting color palettes from the command line as well as
// saving and restoring colors to a configuration file.
//
// You may use any of the following command line parameters:
//
//     /MC | /MB | /MM | /MA    -  Select color, black & white, monochrome,
//                                 or alternate color palette.  If not
//                                 specified, it defaults to the palette
//                                 best suited for the monitor in use.
//
//     /Cdr:\path\filename.ext  -  Specify different default config filename.
//
//     /Rdr:\path\filename.ext  -  Specify different resource filename.
//
// This program uses a resource file for some of the objects like the menu
// bar, status line, color dialog box, etc.  If you use this code elsewhere
// without a resource file, you can generally replace the rsc->get() calls
// with calls to the functions from BLDRSC.CPP that create the objects.  Just
// include those functions in here or in a separate module and remove all
// references to the resource file.
//

//#define FINAL            // Uncomment this line to allow searching the
                           // the end of the executable for the resource file.

#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <float.h>
#include <stdlib.h>
#include <string.h>

//extern unsigned _stklen = 10240U;

#define Uses_TApplication
#define Uses_TColorDialog
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TPalette
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TScrollBar
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#define Uses_TWindow
#define Uses_TVCOLR         // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

//#include <heapview.h>

// ****************************************************************************
// Headers not in the standard front end file.

#include <msginpbx.h>           // Message Box/Input Box header file.

#include "msgtst.h"             // Demo program header file.

// ****************************************************************************

#include "link.h"           // Resource file link definitions.

//extern int    _Cdecl _argc;  // Global pointers to the command line args.
//extern char **_Cdecl _argv;  // This way the app's constructor can access
                               // them.  Declarations are in DOS.H too.

extern TPoint shadowSize;   // Altered when screen size changes.

char demo_cfg[MAXPATH],     // Configuration filename.
     demo_rsc[MAXPATH];     // Resource filename.

// Resource file pointers.
fpstream *s;
TResourceFile *rsc = NULL;  // NULL to start with.

// The value of this variable determines what is printed when the program
// exits back to DOS.
short ExitValue = EXIT_NOERR;

// Monitor type palette index as set from the command line (/MC | /MB | /MM |
// /MA).  By default it is -1 to let the application use the default palette
// selected by TProgram::initScreen().
short CmdLinePalette = -1;

// Global pointer to the user screen buffer for the User Screen event.
char *ScrBuf = NULL;

// ****************************************************************************
// Global variables not in the standard front end file.
char TestString[TEST_STR_SIZE];
TextRecord  MsgDialogText;
ParamRecord MsgDialogOpts;
Boolean ButtonMenuOpen = True;

//*****************************************************************************
// Standard front end functions.  Modify as needed.

void exitfunc(void)
{
    switch(ExitValue)
    {
        case EXIT_NOERR:
            cout << endl << "Thank you for using this demo program." << endl;
            break;

        case EXIT_RSCERR:
            cout << "Could not locate or open resource file: " <<
                demo_rsc << endl;
            break;

        case EXIT_SWERR:
            cout << "Bad parameter: " << _argv[_argc] << endl << endl;
            // Fall through and display command line syntax.

        case EXIT_SYNTAX:
            cout << "Command line syntax:" << endl << _argv[0] <<
                " [/MC | /MB | /MC /MA] [/Rrsc_file.ext] [/Ccfg_file.ext]" <<
                endl;
            break;
    }
}

// Tell the exit code to call the display function just prior to quiting.
#pragma exit exitfunc 31

//
// This will kick everything off.  Note that no argc, or argv parameters are
// used.  The global _argc and _argv variables are used instead so that we
// don't have to pass them to the constructor.  You don't need to do things
// this way, it's just one alternative.
//
void main(void)
{
    short index = 1;

    // To begin with, assume that the resource file is appended to the
    // executable.  If it isn't, we'll try a different approach.
    // To append the resource file to the executable you would issue the
    // command:
    //          COPY /B filename1.EXE+filename.RSC filename2.EXE
    //
    // Make sure the destination .EXE name is not the same as the source
    // .EXE name or you will overwrite the source .EXE file.
    // Also note that the source .EXE can't have debug info at the end of it.
    //
    strcpy(demo_rsc, _argv[0]);

// Until the final production version, don't bother trying to access the
// executable.  Debugging from within the IDE will cause a general access
// failure on the drive when it tries to open it.  TResourceFile won't
// read past the debug info at the end of the executable anyway so use a
// separate resource file until debugging is all done.
#ifndef FINAL
    strcpy(strchr(demo_rsc, '.') + 1, "RSC");
#endif

    // Modify executable name to get location and name of the default
    // configuration file.  We'll assume the config file (if any) is in the
    // same directory as the executable and has the same name with a .CFG
    // extension.  It can be changed with a /C command line switch to
    // specify a different path to it or a different name.

    strcpy(demo_cfg, _argv[0]);
    strcpy(strchr(demo_cfg, '.') + 1, "CFG");

    // Look for command line switches affecting configuration and resource
    // files.  A check for a user requested palette is also included here.
    // That way everything will come up in the proper colors when
    // setScreenMode() is called in the application's constructor or in
    // the loadConfig() function.
    //
    // I've found it best to scan for and process these items here because
    // I do have some cases where the command line arguments are processed
    // in the application's constructor to insert some default objects into
    // the desktop such as file or directory viewers, editor windows, etc
    // specified with other command line switches.  If there is an error
    // doing one of them, you need the screen active so that you can see
    // the error message box.  Also, you don't have to do anything special
    // in the application's constructor to switch palettes if one of these
    // is found.
    //
    while(index != _argc)
    {
        // Allow -opt or /opt.
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
            switch(toupper(_argv[index][1]))
            {
                case 'M':       // Change the default palette.
                    switch(toupper(_argv[index][2]))
                    {
                        case 'C':
                            CmdLinePalette = apColor;
                            break;

                        case 'B':
                            CmdLinePalette = apBlackWhite;
                            break;

                        case 'M':
                            CmdLinePalette = apMonochrome;
                            break;

                        case 'A':
                            CmdLinePalette = apAltColor;
                            break;

                        default:
                            ExitValue = EXIT_SWERR;  // Signal bad switch value.
                            _argc = index;
                            exit(EXIT_SWERR);
                            break;
                    }
                    break;

                case 'C':           // Use a different configuration filename.
                    strcpy(demo_cfg, &_argv[index][2]);
                    break;

                case 'R':           // Use a different resource filename.
                    strcpy(demo_rsc, &_argv[index][2]);
                    break;

                case '?':
                    ExitValue = EXIT_SYNTAX;    // Display command syntax.
                    exit(EXIT_SYNTAX);
                    break;

//                case 'X':         // Ignore other valid switches that
//                case 'Y':         // will be processed in the application's
//                case 'Z':         // constructor.
//                    break;

                default:
                    ExitValue = EXIT_SWERR;  // Signal bad switch value.
                    _argc = index;
                    exit(EXIT_SWERR);
                    break;
            }

        index++;
    }

    // Now try to open the resource file and use it.
    s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);
    if(s->good())
    {
        rsc = (TResourceFile *)new TResourceFile(s);

        if(!rsc->count())
        {
            TObject::destroy(rsc);      // No resource file in the EXE or
            rsc = NULL;                 // user supplied filename.
        }
    }
    else
        delete s;

    if(!rsc)
    {
        // As long as a /R switch wasn't specified, modify the executable name
        // to get the location and name of the default resource file.
        // We'll assume the resource file is in the same directory as the
        // executable and has the same name with a .RSC extension.  It can be
        // changed with a /R command line switch to specify a different path
        // to it or a different name.  If that is the case, it wasn't
        // accessible.
        if(!strnicmp(_argv[0], demo_rsc, strlen(_argv[0]) - 3))
        {
            strcpy(strchr(demo_rsc, '.') + 1, "RSC");
            s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);

            if(!s->good())
                ExitValue = EXIT_RSCERR;      // Still not accessible.
            else
            {
                rsc = (TResourceFile *)new TResourceFile(s);
                if(!rsc->count())
                {
                    TObject::destroy(rsc);      // Not a valid resource file.
                    ExitValue = EXIT_RSCERR;
                }
            }
        }
        else
            ExitValue = EXIT_RSCERR;   // User specified file isn't accessible.

        if(ExitValue)
            exit(EXIT_RSCERR);
    }

    // Set data for the demo.
    strcpy(TestString, "Initial Data");
    strcpy(MsgDialogText.Lines[0], "This is Line #1");
    strcpy(MsgDialogText.Lines[1], "\\003This is Line #2");
    strcpy(MsgDialogText.Lines[2], "This is Line #3. It's longer than the rest");
    strcpy(MsgDialogText.Lines[3], "\\003This is Line #4");
    strcpy(MsgDialogText.Lines[4], "This is Line #5\\n\\003This is line #6");
    strcpy(MsgDialogText.Lines[5], "This is Line #7");
    strcpy(MsgDialogText.Lines[6], "This is Line #8");
    strcpy(MsgDialogText.Lines[7], "This is Line #9");
    strcpy(MsgDialogText.Lines[8], "This is Line #10");
    strcpy(MsgDialogText.Lines[9], "This is Line #11");
    strcpy(MsgDialogText.Lines[10], "This is Line #12");
    strcpy(MsgDialogText.Lines[11], "This is Line #13");
    strcpy(MsgDialogText.Lines[12], "This is Line #14");
    strcpy(MsgDialogText.Lines[13], "This is Line #15");
    strcpy(MsgDialogText.Lines[14], "This is Line #16");
    strcpy(MsgDialogText.Lines[15], "This is Line #17");
    strcpy(MsgDialogText.Buttons[0], "Button ~1~");
    strcpy(MsgDialogText.Buttons[1], "Button ~2~");
    strcpy(MsgDialogText.Buttons[2], "Button ~3~");
    strcpy(MsgDialogText.Buttons[3], "Button ~4~");
    strcpy(MsgDialogText.Buttons[4], "Button ~5~");
    strcpy(MsgDialogText.Buttons[5], "Button ~6~");
    strcpy(MsgDialogText.Buttons[6], "Button ~7~");
    strcpy(MsgDialogText.Buttons[7], "Button ~8~");
    strcpy(MsgDialogText.Buttons[8], "Button ~9~");
    strcpy(MsgDialogText.Buttons[9], "Button 1~0~");
    strcpy(MsgDialogText.Buttons[10], "~B~utton 11");
    strcpy(MsgDialogText.Buttons[11], "B~u~tton 12");
    strcpy(MsgDialogText.Buttons[12], "Bu~t~ton 13");
    strcpy(MsgDialogText.Buttons[13], "Butt~o~n 14");
    strcpy(MsgDialogText.Buttons[14], "Butto~n~ 15");
    strcpy(MsgDialogText.Title, "Test");

    MsgDialogOpts.LineCount = MsgDialogOpts.ButtonCount = 1;
    MsgDialogOpts.Options = MsgDialogOpts.Color = 0;
    strcpy(MsgDialogOpts.LineLen, "0");     // Will atoi() it for simplicity.
    strcpy(MsgDialogOpts.MaxTime, "0");
    strcpy(MsgDialogOpts.BeepTime, "0");
    strcpy(MsgDialogOpts.Pitch, "500");

    // Application Instance.  Change class name of application as needed.
    TDemoApp Demo;
    Demo.run();

    // Shutdown the app and close the resource file.
    Demo.shutDown();
    TObject::destroy(rsc);

    if(ScrBuf)
        delete [] ScrBuf;     // Delete User Screen buffer if used.

    exit(EXIT_NOERR);
}

// ****************************************************************************
// Standard front end functions follow, modify as needed.

//
// Constructor for the application.
//
TDemoApp::TDemoApp(void) :
  TProgInit( &TDemoApp::initStatusLine, &TDemoApp::initMenuBar,
    &TDemoApp::initDeskTop )
{
    TRect  r;
    TEvent event;
    short  index = 1,
           Ignored = 0;        // Count of ignored command line parameters.

//    // Create the heap view (optional).
//    r = getExtent();
//    r.a.x = r.b.x - 21;
//    r.b.y = r.a.y + 1;
//    heap = new THeapView( r );
//    insert(heap);

    // **********************************************************************
    // Application-specific setup code.

    // NONE

    // **********************************************************************
    // All the default objects and views have been constructed, now we
    // can do some stuff with the desktop.

    // If there is a configuration file, read in the data now.
    // Then, here or in loadConfig, turn on the screen and redraw it.
    // If it is done earlier than this, the proper colors won't be used
    // for the initial screen when an alternate palette is specified.
    if(!access(demo_cfg, 0))
        loadConfig(False);
    else
    {
        setScreenMode(TScreen::screenMode);

        if(TMouse::present())       // Adjust mouse limits if present.
            TMouse::setRange(TScreen::screenWidth - 1,
                TScreen::screenHeight - 1);
    }

    // **********************************************************************

    // Process any other command line arguments now.
    // Don't forget to ignore any of the one's parsed in main().
    while(index != _argc)
    {
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
        {
            switch(toupper(_argv[index][1]))
            {
//                case 'X':
//                case 'Y':
//                case 'Z':
//                    do something
//                    break;

                case 'C':                  // Ignore config file selection
                case 'R':                  // Ignore resource file selection.
                case 'M':                  // Ignore palette selection.
                    Ignored++;             // They're already taken care of.
                    break;

                default:
                    Ignored++;
                    MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor,
                        5, mdShortBeep, mdLowPitch,
                        "Invalid command line switch: %s", _argv[index]);
                    break;
            }
        }
        else  // If not a switch, default to doing something else with it.
        {
            // Ignored by default.
            Ignored++;
            MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor,
                5, mdShortBeep, mdLowPitch,
                "Invalid command line parameter: %s", _argv[index]);
        }

//      Processing to be done after each switch command (if any).
//      Insert default views, etc.

        index++;
    }

    // Display the About Box if no command line parameters are passed
    // or only /Mx, /C, or /R parameters were used.
    if(_argc < 2 || (_argc - Ignored) < 2)
    {
        event.what = evCommand;
        event.message.command = cmAbout;
        putEvent(event);
    }
}

// This is where the palettes for the application are defined.
TPalette &TDemoApp::getPalette() const
{
    // The Color and Alternate Color attribute maps are swapped in these
    // definitions so that my color preferences are used by default for
    // color monitors.

    static TPalette color( cpExtAltColor, sizeof( cpExtAltColor)-1 );
    static TPalette blackwhite( cpExtBlackWhite, sizeof( cpExtBlackWhite)-1 );
    static TPalette monochrome( cpExtMonochrome, sizeof( cpExtMonochrome)-1 );
    static TPalette altcolor( cpExtColor, sizeof( cpExtColor)-1 );

    static TPalette *palettes[] =
    {
        &color,
        &blackwhite,
        &monochrome,
        &altcolor        // Additional palettes must come after standard ones
                         // in this array.
    };
    return *(palettes[appPalette]);
}

//
// Desktop initialization.
//
TDeskTop *TDemoApp::initDeskTop(TRect r)
{
    // Prevent drawing the desktop until the colors are set correctly.
    TProgram::application->setState(sfExposed, False);

    r.a.y++;
    r.b.y--;
    return new TDeskTop(r);
}

//
// Screen initialization.  This is overridden so that a command line
// specified color palette can be used.  If not, the default initScreen()
// will reset the palette based on monitor type every time it is called.
//
void TDemoApp::initScreen()
{
    TProgram::initScreen();

    // Force palette to equal the user-specified palette.
    if(CmdLinePalette > -1 && TApplication::appPalette != CmdLinePalette)
    {
        TApplication::appPalette = CmdLinePalette;

        // If monochrome, turn off shadows and turn on markers.
        if(CmdLinePalette == apMonochrome)
        {
            shadowSize.x = 0;
            shadowSize.y = 0;
            showMarkers = True;
        }
    }
}

//
// Menubar initialization.
//
TMenuBar *TDemoApp::initMenuBar(TRect)
{
    return (TMenuBar *)rsc->get("MenuBar");
}

//
// Create statusline.
//
TStatusLine *TDemoApp::initStatusLine( TRect )
{
    TStatusLine *statLine = (TStatusLine *)rsc->get("StatusLine");

    // If the application starts up in anything other than a screen mode
    // of 25 lines, the status bar will end up in the wrong place.
    if(statLine->origin.y != TScreen::screenHeight - 1)
        statLine->origin.y = TScreen::screenHeight - 1;

    return statLine;
}

//
// Application idle function.  Modify or remark out as required.
//
void TDemoApp::idle(void)
{
    TProgram::idle();
//    heap->update();
//
//    // Turn off Tile and Cascade if other window commands are disabled.
//    if(!commandEnabled(cmPrev))
//    {
//        disableCommand(cmCloseTileable);
//        disableCommand(cmTile);
//        disableCommand(cmCascade);
//    }
//    else
//    {
//        enableCommand(cmCloseTileable);
//        enableCommand(cmTile);
//        enableCommand(cmCascade);
//    }
//
    // Select the menu bar if the desktop is empty.
    if(!deskTop->current && !menuBar->getState(sfSelected))
    {
        TEvent event;
        event.what = evCommand;
        event.message.command = cmMenu;
        putEvent(event);
    }
}

//
//  Event handler to distribute the work.
//
void TDemoApp::handleEvent(TEvent &event)
{
    TDialog *dlg;
    TColorDialog *c;
    TEvent   next_event;
    short    MenuCmd, InpVal, newMode;
    char     old_str[TEST_STR_SIZE];

    TApplication::handleEvent(event);

    if(event.what == evCommand)
    {
        switch(event.message.command)
        {
    // Standard front end evCommand events.

            case cmAbout:               //  About Dialog Box
                  // This also could also have been stored in a resource file.
                  // See BLDRSC.CPP for details.
//                rscMsgBox(rsc, "AboutBox");

                // Note that this only passes 1 line NOT 4!
                // The compiler will concatenate the strings into one
                // because there are no separating commas.  MsgBox()
                // will then interpret the carriage returns and size the
                // message dialog accordingly.  This cuts down on the
                // number of parameters you have to pass.
                MsgBox("About", 1, mdNoButtons, mdXTime | mdInfoColor, 4,
                    "\003Message Box Demo - "    // \003 = Center lines.
                    "Version 1.00\n"             // \n = Start new line.
                    "\003by Eric Woodruff\n\n"   // \n\n = Make a blank line.
                    "\003CIS ID: 72134,1150");
                break;

            case cmRepaint:
                setScreenMode(TScreen::screenMode);
                break;

//            case cmSaveAll:
//                // Change it from a command to a broadcast event.
//                message(deskTop, evBroadcast, cmSaveAll, NULL);
//                break;
//
            case cmDOSshell:
                suspend();          // Suspend Turbo Vision and shell to DOS.
                cout << "Type EXIT to return...";
                system("");
                _fpreset();         // Reset math co-processor.

                if(!ScrBuf)
                    ScrBuf = new char[4100];    // At least 4000 bytes.

                gettext(1, 1, 80, 25, ScrBuf);  // Get screen image.

                resume();       // Restart Turbo Vision.
                redraw();
                break;

//            case cmTile:                //  Tile current windows
//                deskTop->tile(deskTop->getExtent());
//                break;
//
//            case cmCascade:             //  Cascade current windows
//                deskTop->cascade(deskTop->getExtent());
//                break;
//
//            case cmCloseTileable:  // Close all views that have ofTileable set.
//                TView *vw;
//                while((vw = deskTop->firstThat(isTileable, 0)) != NULL)
//                    message(vw, evCommand, cmClose, NULL);
//                break;

            case cmScreenSize:          // Change screen size.
                newMode = TScreen::screenMode ^ TDisplay::smFont8x8;

                if(newMode & TDisplay::smFont8x8)
                    shadowSize.x = 1;
                else
                    shadowSize.x = 2;

                setScreenMode(newMode);

                // Adjust mouse limits if present.
                if(TMouse::present())
                    TMouse::setRange(TScreen::screenWidth - 1,
                        TScreen::screenHeight - 1);
                break;

            case cmUserScreen:
                suspend();      // Suspend Turbo Vision and display user
                if(ScrBuf)      // screen if there is one.
                    puttext(1, 1, 80, 25, ScrBuf);

                getch();        // Wait for keypress and restart Turbo Vision.
                resume();
                redraw();
                break;

            case cmColors:
                c = (TColorDialog *)rsc->get("ColorDlg");

                if(validView(c))
                {

//*     NOTE: I have found that this is the *proper* way to set up *all*
//* TColorDialog boxes.  If you follow the TVDEMO example, you pass
//* TColorDialog a NULL pointer in its constructor (the palette pointer is
//* also NULL after you restore it from a resource file!).
//* You then call its setData() member to initialize the color set.  The
//* problem is that TColorDialog::setData() does a memcpy() using that NULL
//* pointer.  If you trace into the assembler code at that point, you'll see
//* that it takes the address stored in interrupt zero (the Divide by Zero
//* handler) and copies the palette to that address.  Most of the time you
//* don't know anything is wrong, but I have found cases where it crashes
//* immediately or at some point shortly after that.  Even if it doesn't
//* crash, you are still asking for trouble.  The method below is the only
//* way to get a TColorDialog box to work safely and properly when created
//* at runtime or stored in a resource file.

                    TPalette x = getPalette();      // Create temporary
                    c->pal = &x;                    // palette and assign it.
                    c->setData(&getPalette());      // Call setData() with
                                                    // the initial colors.
                    // Execute the color dialog box.
                    if(deskTop->execView(c) != cmCancel)
                    {
                        // Do a straight assignment to get the modified colors.
                        getPalette() = *(c->pal);

                        // Repaint the entire desktop by calling
                        // setScreenMode().  Calling deskTop->setState()
                        // to set sfVisible off and then on as in TVDEMO
                        // doesn't always redraw the entire screen if
                        // there is a window or some other view on the
                        // desktop that has the focus.
                        setScreenMode(TScreen::screenMode);
                    }
                    destroy(c);
                }
                break;

            case cmChangePalettes:
                CmdLinePalette = appPalette + 1;

                if(CmdLinePalette == apTotalPalettes)
                    CmdLinePalette = apColor;

                setScreenMode(TScreen::screenMode);
                break;

            case cmLoadCfg:
                if(execDialog(new TFileDialog(demo_cfg, "Load Configuration",
                  "~N~ame", fdOpenButton, 100), demo_cfg) != cmCancel)
                    loadConfig(True);
                break;

            case cmSaveCfg:
                if(execDialog(new TFileDialog(demo_cfg, "Save Configuration",
                  "~N~ame", fdOKButton, 100), demo_cfg) != cmCancel)
                    saveConfig();
                break;

    // Non-standard evCommand events.
            case cmButtonMenu:      // A simple button menu.
                ButtonMenuOpen = True;

                // This "button menu" could just as easily been created
                // and stored in the resource file.

                // Because it's the widest, the space-padded first button
                // sets the width for all buttons.
                MenuCmd = MsgBox("A Simple Button Menu", 0, 10, mdXPlain,
                    "               ~A~bout Box               ",        // 1
                        cmAbout, bfNormal,
                    "Toggle ~S~creen size", cmScreenSize, bfNormal,     // 2
                    "~F~ormatted String Test", cmFormatTest, bfNormal,  // 3
                    "~C~hange Demo Text", cmChgText, bfNormal,          // 4
                    "~T~est Demo Message Box", cmTestMsgBox, bfNormal,  // 5
                    "T~e~st Demo Input Box", cmTestInpBox, bfNormal,    // 6
                    "~G~et MsgBox from stream", cmStrmMsgBox, bfNormal, // 7
                    "Get ~I~npBox from stream", cmStrmInpBox, bfNormal, // 8
                    "C~l~ose Button Menu", cmQuitMenu, bfNormal,        // 9
                    "~Q~uit Program", cmQuit, bfNormal);                // 10

                if(MenuCmd > 0 && MenuCmd != cmQuitMenu && MenuCmd != cmCancel)
                {
                    next_event.what = evCommand;
                    next_event.message.command = MenuCmd;    // Send command.
                    putEvent(next_event);
                }
                else
                    ButtonMenuOpen = False;
                break;

            case cmFormatTest:
                FormatTest();
                break;

            case cmTestInpBox:
                // Here, two separate lines are passed to the function.
                // When passed separately, the ending '\n' is implied.
                InpVal = InpBox(TestString, "Test Input Box", 2,
                    mdOKCancel, mdInputHis, TEST_STR_SIZE, HISTORY_ID,
                    "Enter some data in the test string.",  // Separate lines
                    "Last time it was: %s", TestString);    // but they don't
                                                            // need to be.
                if(InpVal == cmOK)
                //      <perform some action here based on input>
                    MsgBox(mdInformation, 1, mdOKOnly, mdPlain,
                           "You Entered: %s", TestString);
                break;

            case cmStrmMsgBox:
                rscMsgBox(rsc, "StrmMsgBox");
                break;

            case cmStrmInpBox:      // Use TestString again for simplicity.
                strcpy(old_str, TestString);

                rscInpBox(TestString, rsc, "StrmInpBox");

                if(strcmp(old_str, TestString))
                    MsgBox(mdInformation, 1, mdOKOnly, mdPlain,
                        "You changed TestString from %s to %s",
                         old_str, TestString);
                break;

            case cmChgText:
                // Change test message strings.
                dlg = (TDialog *)rsc->get("TextDialog");
                if(validView(dlg))
                {
                    dlg->setData(&MsgDialogText);

                    if(deskTop->execView(dlg) == cmOK)
                        dlg->getData(&MsgDialogText);

                    destroy(dlg);
                }
                break;

            case cmTestMsgBox:
                // Put the message and input box functions through their
                // paces.  Allows the user to vary the parameters for
                // easier testing.
                dlg = (TDialog *)rsc->get("ParamDialog");

                if(validView(dlg))
                {
                    dlg->setData(&MsgDialogOpts);

                    // Stay here until cancelled.
                    while(deskTop->execView(dlg) != cmCancel)
                    {
                        dlg->getData(&MsgDialogOpts);

                        // We need a special function for this one due
                        // to the modifiable parameter passing.
                        // Normal calls would look something like any other
                        // example call found in the program.
                        TDialog *demod = makeTestDialog();

                        if(demod)
                        {
                            MsgBox(mdInformation, 1, mdOKOnly, mdTime, 10,
                              "Message Dialog returned %d",
                              deskTop->execView(demod));

                            destroy(demod);
                        }
                    }
                    destroy(dlg);
                }
                break;

            default:
                return;
        }

        if(ButtonMenuOpen && event.message.command != cmButtonMenu)
        {
            next_event.what = evCommand;
            next_event.message.command = cmButtonMenu;
            putEvent(next_event);        // After the menu events finish,
        }                                // redisplay the button menu.

        clearEvent (event);
    }
}

// Standard Out Of Memory error dialog.
void TDemoApp::outOfMemory(void)
{
    MsgBox(mdWarning, 1, mdCancelOnly, mdBeep | mdWarnColor,
        mdShortBeep, mdLowPitch,
        "Not enough memory for this operation.");
}

//
// Standard load config file.  Modify as needed.
//
void TDemoApp::loadConfig(Boolean UseFileSetting)
{
    fpstream *f = new fpstream(demo_cfg, ios::in | ios::nocreate | ios::binary);

    if(!f->good())
    {
        //  Turn on the screen?
        if(!(state & sfExposed))
        {
            setScreenMode(TScreen::screenMode);

            if(TMouse::present())       // Adjust mouse limits if present.
                TMouse::setRange(TScreen::screenWidth - 1,
                    TScreen::screenHeight - 1);
        }

        MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor,
            5, mdShortBeep, mdLowPitch,
            "Could not open configuration file: ", demo_cfg);

        delete f;
        return;
    }

    ipstream &strm = *f;

    // Read palettes from the configuration file.
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.readBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Get the video mode
    ushort scrMode;
    strm.readBytes(&scrMode, sizeof(scrMode));

    // Get the palette that was in use.
    short usePalette;
    strm.readBytes(&usePalette, sizeof(usePalette));

    // If not overridden from the command line, set the palette.
    if(CmdLinePalette == -1 || (CmdLinePalette != -1 && UseFileSetting))
        CmdLinePalette = usePalette;

    if(scrMode & TDisplay::smFont8x8)
        shadowSize.x = 1;
    else
        shadowSize.x = 2;

    setScreenMode(scrMode);

    if(TMouse::present())       // Adjust mouse limits if present.
        TMouse::setRange(TScreen::screenWidth - 1, TScreen::screenHeight - 1);

    // ************************************************************************
    // Add code here to load non-standard application-specific config data.

    delete f;
}

//
// Standard save config file.  Modify as needed.
//
void TDemoApp::saveConfig(void)
{
    fpstream *f = new fpstream(demo_cfg, ios::trunc | ios::binary);

    if(!f->good())
    {
        MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor,
            5, mdShortBeep, mdLowPitch,
            "Could not open configuration file: ", demo_cfg);

        delete f;
        return;
    }

    opstream &strm = *f;

    // Store the palettes
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.writeBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Store current video mode
    strm.writeBytes(&TScreen::screenMode, sizeof(TScreen::screenMode));

    // Store current palette in use.
    strm.writeBytes(&appPalette, sizeof(appPalette));

    // ************************************************************************
    // Add code here to save non-standard application-specific config data.

    delete f;
}

// ****************************************************************************
//
// The isTileable() function checks for a tileable view on the desktop.
//
//Boolean isTileable(TView *p, void *)
//{
//    // Must ignore such objects as the clipboard when they are hidden!
//    if(!(p->options & ofTileable) || !(p->state & sfVisible))
//        return False;
//
//    return True;
//}

// This function executes any dialog passed to it and destroys it when done.
ushort execDialog(TDialog *d, void *data)
{
    TView *p = TProgram::application->validView(d);
    if(!p)
        return cmCancel;

    if(data)
        p->setData(data);

    ushort result = TProgram::deskTop->execView(p);

    if(result != cmCancel && data)
        p->getData(data);

    TObject::destroy(p);
    return result;
}

// ****************************************************************************
// End of standard front end functions.
// ****************************************************************************
// Other functions not in the standard front end file.

// Test formatted message lines.
void TDemoApp::FormatTest(void)
{
    int n10 = 10, n20 = 20, n30 = 30, n40 = 40, n50 = 50, n60 = 60;
    short s10 = 10;
    float f10 = 10.0, f20 = 20.0, f30 = 30.0, f40 = 40.0, f50 = 50.0;

    char ch = 'C';
    char str[10], lstr[10], *ptr;
    int len = 10, count;

    long lng = 75001L;
    double dbl = (double)101.0;
    long double lng_dbl = (long double)201.0;

    strcpy(str, "Test #3");
    strcpy(lstr, "(Test #4)");
    ptr = (char *)MK_FP(0x040, 0x0017);

    // Note that you can combine one or more lines separated by
    // '\n' if you want to.
    //
    // It is EXTREMELY important that the number of parameters passed
    // match watch the format string specifies.
    // Otherwise, like printf(), you'll end up with garbage.
    //
    short code = MsgBox(mdInformation, 6, mdOKOnly, mdPlain | mdInfoColor,
        "%02d %3hd %i %o %u %#x %#X", 1, 1, 2, 3, 4, 5, 6,            // 1
        "%d %hd %i %o %u %#x %#X", n10, s10, n20, n30, n40, n50, n60, // 2

        "%f %e %g %E %G\n%7.3f %e %g %E %G", 10.0, 20.0, 30.0, 40.0, 50.0,
            f10, f20, f30, f40, f50,                                  // 3

        "%c %s %*s", 'C', "Test #1", 10, "(Test #2)",                 // 4
        "%c %-20s %-*s %n %p %p", ch, str, len, lstr, &count,
            &count, ptr,                                              // 5

        "%ld %lf %10.4Lf\n%ld %lf %Lf", 75000L, (double)100.0,        // 6
            (long double)200.0, lng, dbl, lng_dbl);

    // See MSGINPBX.H for the meaning of any error code.
    if(code < 0)
        MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor, 20,
            mdShortBeep, mdLowPitch, "Error #%d opening dialog box!", code);
}

// The only reason this function exists is for the test program.  Under
// all other circumstances, you will just create a message or input dialog
// as you normally would (call the MsgBox() or InpBox() function).  This is
// used simply to put the make function through its paces by letting you
// interact with another dialog box that sets the options.  With the variable
// parameter list, there is a seemingly infinite number of ways to use the
// make function so this simplifies matters greatly.
TDialog *makeTestDialog(void)
{
    TDialog *dlg;
    short NumButtons, NumLines, BeepFreq, BeepDuration, TimeOutLen,
          ButtonCnt, LineLength, HasHistory, ErrorCode, i, TotParms = 0,
          Opts = mdPlain;
    char *p;

    // Do some character conversion.  For testing allow "\n" to get
    // converted to a literal '\n' character and "\003" to get converted
    // to a literal '\003' character.
    for(i = 0; i < 16; i++)
        for(p = MsgDialogText.Lines[i]; *p; p++)
            if(*p == '\\' && *(p + 1) == 'n')
            {
                *p = '\n';
                strcpy(p + 1, p + 2);
            }
            else
                if(!strncmp(p, "\\003", 4))
                {
                    *p = '\003';
                    strcpy(p + 1, p + 4);
                }

    // Get explode/implode setting.
    Opts |= ((MsgDialogOpts.Options & 0x01) << 4);

    // Get the password setting.
    Opts |= ((MsgDialogOpts.Options & 0x04) << 6);

    // Get color setting.
    Opts |= (MsgDialogOpts.Color == 1) ? mdInfoColor :
              (MsgDialogOpts.Color == 2) ? mdNotifyColor :
                (MsgDialogOpts.Color == 3) ? mdWarnColor :
                  (MsgDialogOpts.Color == 4) ? mdErrColor  : 0;

    NumLines     = MsgDialogOpts.LineCount;
    NumButtons   = MsgDialogOpts.ButtonCount;
    HasHistory   = MsgDialogOpts.Options & 0x02;
    LineLength   = atoi(MsgDialogOpts.LineLen);
    BeepFreq     = atoi(MsgDialogOpts.Pitch);
    BeepDuration = atoi(MsgDialogOpts.BeepTime);
    TimeOutLen   = atoi(MsgDialogOpts.MaxTime);

    // Determine option settings.
    if(LineLength > 0)
    {
        Opts |= mdInput;

        if(HasHistory)
            Opts |= mdInputHis;
    }

    if(BeepDuration > 0)
        Opts |= mdBeep;

    if(TimeOutLen > 0)
        Opts |= mdTime;

    if(NumButtons > 5)
    {
        NumButtons -= 5;                // Make it a valid count.
        ButtonCnt = NumButtons;         // Remember number for stack cleanup.
    }
    else
    {
        ButtonCnt = 0;
        NumButtons = 0 - NumButtons;    // Invert for default types.
    }

asm {
    // Push all the necessary parameters on the stack.
    mov     cx, NumButtons
    jcxz    short TextData       // Skip if there are to be no buttons.
    test    ch, 0x80
    jnz     short TextData       // Skip if there are to be default buttons.

    mov     ax, TEXT_SIZE        // Point to the last button to push.
    dec     cx
    mul     cx
    inc     cx
    mov     bx, offset MsgDialogText.Buttons
    add     bx, ax
    mov     ax, bfNormal        // Options.  For demo, always bfNormal.
    mov     dx, 500
    add     dx, cx
    }

PushButtonData:

asm {
    push    ax
    push    dx                  // Command.  For demo, 500 + button number.
    push    ds
    push    bx                  // Button text
    dec     dx
    sub     bx, TEXT_SIZE
    loop    PushButtonData      // Keep going until no more buttons to push.
    }

TextData:

asm {
    mov     cx, NumLines
    jcxz    short OtherParms    // Skip if no text lines.

    mov     ax, TEXT_SIZE       // Point to last text line to push.
    dec     cx
    mul     cx
    inc     cx
    mov     bx, offset MsgDialogText.Lines
    add     bx, ax
    }

TextLineData:

asm {
    push    ds
    push    bx                  // Dialog line text.
    sub     bx, TEXT_SIZE
    loop    TextLineData
    }

OtherParms:

asm {
    xor     dx, dx
    mov     bx, Opts
    test    bx, mdInputHis
    jz      short Skip1
    mov     ax, 1               // History ID of 1 for demo.
    push    ax
    inc     dx
    jmp     short PushInpLen    // Input length is implied.
    }
Skip1:

asm {
    test    bx, mdInput
    jz      short Skip2
    }
PushInpLen:

asm {
    mov     ax, LineLength
    push    ax
    inc     dx
    }
Skip2:

asm {
    test    bx, mdBeep
    jz      short Skip3
    mov     ax, BeepFreq
    push    ax
    mov     ax, BeepDuration
    push    ax
    inc     dx
    inc     dx
    }
Skip3:

asm {
    test    bx, mdTime
    jz      short Skip4
    mov     ax, TimeOutLen
    push    ax
    inc     dx
    }
Skip4:

asm {
    mov     ax, Opts                    // Fixed parameters.
    push    ax
    push    ss
    lea     ax, word ptr ErrorCode      // Return code.
    push    ax
    mov     ax, NumButtons
    push    ax
    mov     ax, NumLines
    push    ax
    xor     ax, ax
    or      ah, byte ptr MsgDialogText.Title    // If no title, push NULL.
    jz      short PushNULL
    push    ds
    mov     ax, offset MsgDialogText.Title
    push    ax
    jmp     short CallMake
    }

PushNULL:

asm {
    push    ax
    push    ax
    }

CallMake:

asm {
    add     dx, 7
    mov     TotParms, dx             // Remember the total pushed.

    call    far ptr makeMsgDialog

    mov     word ptr &dlg + 2, dx    // Save returned dialog pointer.
    mov     word ptr &dlg,     ax

    mov     ax, ButtonCnt       // Calculate number of bytes pushed onto
    mov     cl, 3               // the stack.
    sal     ax, cl
    mov     bx, NumLines
    mov     cl, 2
    sal     bx, cl
    add     ax, bx
    mov     bx, TotParms
    dec     cl
    sal     bx, cl
    add     ax, bx
    add     sp, ax              // Clear the bytes from stack
    }

    // See MSGINPBX.H for the meaning of any error code.
    if(!dlg)
        MsgBox(mdError, 1, mdCancelOnly, mdTimeBeep | mdErrColor, 30,
            mdMediumBeep, mdLowPitch, "Error #%d opening dialog box!",
            ErrorCode);

    // Put things back the way they were.
    for(i = 0; i < 16; i++)
        for(p = MsgDialogText.Lines[i]; *p; p++)
            if(*p == '\n')
            {
                memmove(p + 2, p + 1, strlen(p + 1) + 1);
                *p++ = '\\';
                *p = 'n';
            }
            else
                if(*p == '\003')
                {
                    memmove(p + 4, p + 1, strlen(p + 1) + 1);
                    strncpy(p, "\\003", 4);
                }

    return dlg;
}

// ****************************************************************************
// End of standard front end file.
// ****************************************************************************
