/*****************************************************************************
 *  Last Modified:  9/22/94                                                  *
 *  Filenanme   : DEMO.C                                                     *
 *                 This is an example program that demonstrates some         *
 *                 of the most commonly called LEADTOOLS functions.          *
 *                 It is a complete application and uses LEADTOOLS           *
 *                 compression/decompression, viewing, conversion,           *
 *                 and all the Bitmap processing functions for both          *
 *                 TARGAP and VGA/SuperVGA graphics cards.                    *
 *                                                                           *
 ****************************************************************************/
/********* INCLUDES  *********/
#include  <ctype.h>                /* Standard C header files */
#include  <conio.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
                                   /* LEADTOOLS headers                 */
#include  "l_error.h"    /* Error return codes                */
#include  "l_bitmap.h"   /* Bitmap file information           */
#include  "demo.h"                 /* Demo header file                  */

#if __BORLANDC__
/* Needed for Borland C to incease the stack size */
    extern unsigned _stklen = 14000U;
#endif

L_UINT uView = VIEW_VGA;

/****************************************************************************
 *                                main()                                    *
 ****************************************************************************/
L_VOID main(L_INT argc, L_CHAR *argv[])
{
  L_INT TARGA_FLAG;       /* Flag used to verify if a TARGA board is present  */
  L_INT function_type;    /* Switch to determine which function to call       */
  L_INT videotype;        /* To determine the VGA/SuperVGA graphics card type */
  L_INT width;            /* Image width       */
  L_INT height;           /* Image height      */
  BITMAPHANDLE Bitmap;    /* The main BITMAPHANDLE used in the program */
  L_INT Method;
  
  /* Reserve the TEXT Colors so that the text colors will not change images */
  L_ReserveTextColors();

   Welcome(&TARGA_FLAG,&videotype, &width, &height);
   SetDataFilesDirectory(argv[0]);
   RegisterSupportedFormats();

   L_SelectViewType(uView);

   L_InitBitmap( &Bitmap, 0, 0, 0) ;

    while(1)       /* Loops until user enters 100 to exit program */
     {
      printscreen();
      getint(&function_type,39,9);    /* Get user input */

      L_GraphColor (WHITE, RED);
      switch (function_type)     /* Main switch on user's input */
      {
       case 1: /* Case Load an image file to a memory Bitmap */
           LoadAFileToBitmap(&Bitmap);
       break;
       case 2: /* Case Save a memory Bitmap to a supported file format */
           SaveABitmapToFile(&Bitmap);
       break;
       case  3: /* Case Flip a Bitmap vertically */
           FlipTheBitmap(&Bitmap);
       break;
       case  4: /* Case Reverse a Bitmap horizontally */
           ReversTheBitmap(&Bitmap);
       break;
       case  5: /* Case Resize the image in the Bitmap */
           ResizeTheBitmap(&Bitmap);
       break;
       case  6: /* Case Rotate an image in a Bitmap */
           RotateTheBitmap(&Bitmap);
       break;
       case  7: /* Case Dither an image to 256 colors using LEAD's fixed palette  */
           Ditherto256Palette(&Bitmap,0);
       break;
       case  8: /* Case Optimize an image to 8bit 256 color image */
           Ditherto256Palette(&Bitmap,1);
       break;
       case  9: /* Case Clear a Bitmap */
           ClearTheBitmap(&Bitmap);
       break;
       case 10: /* Case GrayScale the Bitmap */
           GrayScaleTheBitmap(&Bitmap);
       break;
       case 11: /* Case View a Bitmap on the screen */
            ViewTheBitmap(&Bitmap);
       break;
       case 12: /* Case View a file to screen */
            ViewAFile();
       break;
       case 13: /* Case Compress a registered file format to LEAD, JFIF, or JTIF */
             CompressAFile2CMPJPEG();
       break;
       case 14: /* Case Convert one file format to another file format */
           ConvertAFile();
       break;
       case 15: /* Case Get information on a file */
           GetFileInformation();
       break;
       case 16: /* Case Reverse video color order */
           ReverseTheColorOrder();
       break;
       case 17: /* Case Set video resolution */
           ReSetTheVideoResolution();
       break;
       case 18: /* Case Set VGA memory */
           SetVGAMemorySize();
       break;
       case 19: /* Case Change brightness */
           ChangeBitmapBrightness(&Bitmap);
       break;
       case 20: /* Case Clear the screen */
           ClearVGAScreen();
       break;
       case 21: /* Case HalfTone the Bitmap */
           HalfToneTheBitmap(&Bitmap);
       break;
       case 22: /* Case Capture a portion of the screen */ 
           CaptureScreenToBitmap(&Bitmap);
       break;
	    case 23: /* Case Line drawing */
           DrawALine();
	    break;
	    case 24: /* Case Box drawing */
           DrawABox();
	    break;
	    case 25: /* Case Set TIFF page number */
           SetTIFFPageNumber();
           L_GraphText(FONT8X16, 0,"Press any Key to Continue.",5,9);
	    break;
	    case 26: /* Case Set TEXT mode */
           L_SetVideoMode(3, 0);
           printf("Type 'Exit' to return to the LEADTOOLS demo.\n");
           system("command");
           L_SetVGASize(VGA_SIZE);
           L_GraphColor(WHITE, BLACK);
           L_GraphText(FONT8X16, 0,"Press any Key to Continue.",5,9);
	    break;
	    case 27: /* Case Reserve text colors, to offset the following case */
           L_ReserveTextColors();
	    break;
	    case 28: /* Case Release text colors */
           L_ReservePaletteColors(NULL, 0);
	    break;
		 case 29: /* Case Set default dithering method */
			  GetDitheringMethod(&Method);
			  L_DefaultDithering(Method);
			  break;
       case 100: /* Case Exit the program */
           Exit_Prog(&Bitmap);
       default:   /* Anything Else is a wrong selection */
           L_GraphColor (GRAY, RED);
           L_GraphText(FONT8X16, 0, "Wrong selection!  Press any key to continue.", 6, 9);
           putch(7);
       break;
      } /* End switch */
      L_SleepKey(99); /* Waits 99 seconds or until key is pressed */
     } /* End of while loop  */

} /* end main(); */
/****************************END OF MAIN()***************************/



/***********
Prints the main menu to screen in graphics mode.
***********/
L_VOID printscreen(L_VOID)
{
   L_INT i;  /* For the loop to fill the BLANK screen and a */
             /* BLANK line storage array */

   L_GraphFontSize(16,32);
   i=SCREEN_MAX_HEIGHT-16;
   L_GraphColor (LIGHTYELLOW, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "LEADTOOLS DOS Real Mode Demo", 80, i);
   L_GraphFontSize(0,0);
   i=i-30;

   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, " 1", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Load Image File To Bitmap.            - Save Bitmap As Image File.", 5,i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "2", 42*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, " 3", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Flip Bitmap.                          - Reverse Bitmap.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "4", 42*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, " 5", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Resize Bitmap.                        - Rotate Bitmap.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "6", 42*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, " 7", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Dither Bitmap To Fixed Palette.       - Optimize Bitmap.", 5, i);          
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "8", 42*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, " 9", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Clear Bitmap.                         - Gray Scale The Bitmap.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "10", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "11", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - View The Bitmap.                      - View A Registered File.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "12", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "13", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Compress To CMP/JPG/JTF File.         - File To File Convert.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "14", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "15", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Get Information On A File.            - Reverse Video Color Order.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "16", 41*XCHR, i);
   i=i-16;
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "17", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Set Video Resolution.                 - Set VGA Card Memory Size.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "18", 41*XCHR, i);
   i=i-16;
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "19", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Change Bitmap Brightness.             - Clear The Screen.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "20", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "21", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Halftone Bitmap.                      - Capture A Portion Of The Screen.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "22", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "23", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Draw A Line On The Screen.            - Draw A Box On The Screen.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "24", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "25", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Set TIFF Page Number.                 - Shell To DOS.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "26", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "27", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Reserve TEXT Colors.                  - Disable Reserved Colors.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "28", 41*XCHR, i);
   i=i-16;
   L_GraphText(FONT8X16, 0, "29", XCHR, i);
   L_GraphColor (LIGHTCYAN, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "   - Set Default Dithering.                - DO NOTHING.", 5, i);
   L_GraphColor (WHITE, KEEPBACKGROUND);
   L_GraphText(FONT8X16, 0, "30", 41*XCHR, i);
   makebox();
   L_GraphText(FONT8X16, 0, "Enter your selection, or 100 to exit:                                           ", 5, 9);
}



/***********
Get an int value from the keyboard and print it to screen in graphics mode.
***********/
L_VOID getint(L_INT *answer, L_INT xpos, L_INT ypos)         
{
  L_INT ch, i,j;
  L_CHAR string[7];
  L_CHAR TextToType[2];
  i=xpos*XCHR;
  j=0;
  string[0]='\0';

  while(j < 5)
   {
    ch = getch();  /* Character typed is stored in ch */
    if( (ch == EOF) || (ch == '\r') || (ch == '\n') )
     {
      break;
     }
    /* Makes sure ch is a printable character */
    /* Also checks to see if ch is a Backspace key */
    if( (ch != 0x08) )
     {
      sprintf(TextToType,"%c",ch);
      L_GraphColor (WHITE, KEEPBACKGROUND);
      L_GraphText (FONT8X16, 0, TextToType, i, ypos);
      string[j]=(L_CHAR)ch;
      i=i+XCHR;
      j++;
     }
    else if(ch == 0x08)
     {
      if(j > 0)
        {
         /* If ch is a Backspace, then clear the current character
            on the screen
         */
         i=i-XCHR;
         j--;
         sprintf(TextToType," ");
         L_GraphColor (WHITE, RED);
         L_GraphText(FONT8X16, 0, TextToType, i, ypos);
        }
       else
        putch(7);
     }
   }
  string[j]='\0';
  *answer=atoi(string);
  makebox();
}



/***********
Get a string from the keyboard and print it to the screen in graphics mode
***********/
L_VOID getstring(L_CHAR *answer,L_INT xpos, L_INT ypos)
{
  L_INT ch, i, j=0;       /* Counters */
  L_CHAR string[128];     /* Character buffer */
  L_CHAR TextToType[2];
  i=xpos*XCHR;

  while(j < 128)
   {
    ch = getch();          /* Gets a character and stores it in ch */
    if( (ch == EOF) || (ch == '\r') || (ch == '\n') )
     {
      break;
     }
    /* Makes sure the key pressed is a printable character and
       not a Backspace key
    */
    if( (ch != 0x08) && (ch > 32 ) )
     {
      sprintf(TextToType,"%c",ch);
      L_GraphColor (WHITE, KEEPBACKGROUND);
      L_GraphText(FONT8X16, 0,TextToType, i, ypos);
      string[j]=(L_CHAR)ch;
      i=i+XCHR;
      j++;
     }
    else if (ch == 0x08)
     {
      if(j > 0)
       {
        /* If ch is a Backspace then clear the current character
           on the screen
         */
        i=i-XCHR;
        j--;
        sprintf(TextToType," ");
        L_GraphColor (WHITE, RED);
        L_GraphText(FONT8X16, 0, TextToType, i, ypos);
       }
      else
       putch(7);
     }
   }
  string[j] = '\0';
  strcpy(answer, string);
  makebox();
}


/***********
Get a Y or an N from the keyboard and return TRUE or FALSE
***********/
L_INT getYesNo()
{
  L_INT ch;

  while(1)
   {
    ch=getch();
    if( (ch == 'Y' ) || (ch == 'y') )
      return(TRUE);
    else if( (ch == 'N' ) || (ch == 'n') )
      return(FALSE);
    else
      putch(7);
   }
}



/***********
Register All the functions needed for this demo
***********/
L_VOID  RegisterSupportedFormats(L_VOID)
{

/* Register the supported Read File Formats. You May call L_RegisterReadALL() for all */
  L_RegisterReadCMP  ();
  L_RegisterReadCMP1Bit  ();
  L_RegisterReadJFIF ();
  L_RegisterReadJTIF ();
  L_RegisterReadTGA  ();
  L_RegisterReadPCX  ();
  L_RegisterReadTIF  ();
  L_RegisterReadLZWTIF ();
  L_RegisterReadCCITTTIF ();
  L_RegisterReadG3G4TIF ();
  L_RegisterReadGIF  ();
  L_RegisterReadBMP  ();
  L_RegisterReadCALS ();
  L_RegisterReadMAC  ();
  L_RegisterReadIMG  ();
  L_RegisterReadMSP  ();
  L_RegisterReadRAS  ();
  L_RegisterReadEPS  ();
  L_RegisterReadWPG  ();
  L_RegisterReadPCT  ();
/* Register the supported Write File Formats. You May call L_RegisterWriteALL() for all */
  L_RegisterWriteCMP  ();
  L_RegisterWriteCMP1Bit  ();
  L_RegisterWriteJFIF ();
  L_RegisterWriteJTIF ();
  L_RegisterWriteTGA ();
  L_RegisterWritePCX ();
  L_RegisterWriteTIF ();
  L_RegisterWriteLZWTIF ();
  L_RegisterWriteCCITTTIF ();
  L_RegisterWriteG3G4TIF ();
  L_RegisterWriteGIF ();
  L_RegisterWriteBMP  ();
  L_RegisterWriteCALS ();
  L_RegisterWriteMAC ();
  L_RegisterWriteIMG ();
  L_RegisterWriteMSP ();
  L_RegisterWriteRAS ();
  L_RegisterWriteEPS  ();
  L_RegisterWriteWPG  ();
  L_RegisterWritePCT ();
/*Register Dither to support Viewing 16, 24, and 32 bit images on 8bit display
  and to save 16, 24, and 32 bit images as 4 or 8bits
*/
  L_RegisterDitherForLoadAndSave();
/*Register Resize to support Resizing when viewing or saving
*/
  L_RegisterResizeForLoad ();

}


/***********
Set the Directory where 1bit.dat is located
***********/
L_VOID SetDataFilesDirectory(L_CHAR ExeName[])
{
  L_CHAR path[128];
  L_INT i;
  strcpy(path, ExeName);

/* Find out from argv[0] the exe's path name */
  for (i = strlen(path)-1; i > 0; i--)
   {
   if (path[i] == '\\' || path[i] == ':')
      break;
   }
 path[i+1] = 0;
 L_SetDataDirectory (path);
}


/***********
Print out the welcome screen.
***********/
L_VOID Welcome(L_INT *TFLAG, L_INT *Vtype, L_INT *Vwidth, L_INT *Vheight)
{
  printf("This is an evaluation program of the LEADTOOLS image processing toolkit\n");
  printf("available from LEAD Technologies.  It is not designed to be an end-user\n");
  printf("product. It is a collection of calls to LEADTOOLS high level functions.\n");
  printf("Menus were not included to avoid confusion when evaluating the code as to\n");
  printf("the processing calls versus the menuing code. This .EXE will demonstrate\n");
  printf("LEADTOOLS DOS 16-bit and is limited to an image width of 15,000 pixels.\n\n");

  printf("This demo program will default to color order RGB for 640x480 mode and color\n");
  printf("order BGR for 800x600 mode. If the image display color order is reversed\n");
  printf("then change the resolution (option 17) to 800x600, or Reverse the video color\n");
  printf("order (option 16).\n\n");
                
  printf("You can contact LEAD Technologies to obtain more information about image\n");
  printf("processing toolkits in several ways.\n");
  printf("By telephone, call 704-332-5532 from 9 am to 6 pm eastern time Monday - Friday.\n");
  printf("By fax, dial 704-372-8161.\n");
  printf("By BBS, dial 704-334-9045, with your modem set for 8N1.\n");
  printf("By CompuServe, Go LEADTECH.\n");
  printf("The address is 900 Baxter Street, Charlotte, NC 28204.\n");
  if(L_TARGAInit() <= 0)
   {
    printf("TARGA board initialization error or TARGA not present!\n");
    printf("You can use your SVGA display.\n");
    printf("You may not use any of the TARGA+ functions!\n");
    putch(7);
    *TFLAG=0;
   }
  else
   *TFLAG=1;
  printf("If this program cannot function properly, run the appropriate\n");
  printf("VESA TSR and force VESA support. Otherwise answer No to this question\n");
  printf("Do you want to force VESA mode (Y,N) ");
  if(getYesNo())
    L_SetVESA(1);
  printf("\n\nIf your card does not support Hi-color mode (32,000 or more)\n");
  printf("You must answer Yes. Otherwise answer No to this question\n");
  printf("Do you want to force 8Bit Mode(Y,N) ");
  if(getYesNo())
    L_SetVideoTrueColor(0);
  L_GetVideoInfo(Vtype, Vwidth, Vheight);
  if(*Vtype != VIDEO_SVGA)
   {
    L_SetVideoMode(3, 0);            /* Set TEXT mode*/
    printf("You must have a SuperVGA with 512K or more memory to run this demo\n");
    exit(0);
   }
  L_SetVGASize(VGA_SIZE);
  L_ReserveTextColors();
}



/***********
Exits to DOS
***********/
L_VOID Exit_Prog(pBITMAPHANDLE pBitmap)
{
  if(pBitmap->Flags.Allocated)  /* Release Bitmap information before quit */
    L_FreeBitmap(pBitmap);
  L_SetVideoMode(3, 0);            /* Set TEXT mode*/
  printf("EXIT DEMO\n\n\n");
  printf("       COPYRIGHT (c) 1994 LEAD Technologies Inc. ALL RIGHTS RESERVED.\n");
  printf("                           900 Baxter St.\n");
  printf("                           Charlotte NC 28204\n");
  printf("                           Tel # 704-332-5532\n");
  printf("This is an evaluation program of the LEADTOOLS image processing toolkit\n");
  printf("available from LEAD Technologies.  It is not designed to be an end-user\n");
  printf("product. It is a collection of calls to LEADTOOLS high level functions.\n\n");
  printf("You can contact LEAD Technologies to obtain more information about image\n");
  printf("processing toolkits in several ways.\n\n");
  printf("By telephone, call 704-332-5532 from 9 am to 6 pm eastern time Monday - Friday.\n");
  printf("By fax, dial 704-372-8161.\n");
  printf("By BBS, dial 704-334-9045, with your modem set for 8N1.\n");
  printf("By CompuServe, Go LEADTECH.\n");
  printf("The address is 900 Baxter Street, Charlotte, NC 28204.\n");
  exit(0);
}



/***********
Get the Dithering Method
***********/
L_VOID GetDitheringMethod(L_INT *DithMethod)
{
  L_INT i;

  i=SCREEN_MAX_HEIGHT-16;
  
  ClearVGAScreenNoBottom();
  L_GraphColor (LIGHTYELLOW, KEEPBACKGROUND);
  L_GraphFontSize(0,0);
  i=i-30;
  L_GraphText(FONT8X16, 0, " 0 - NO_DITHERING           1 - FLOYD STEIN DITHERING ", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 2 - STUCKI_DITHERING       3 - BURKES_DITHERING", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 4 - SIERRA_DITHERING       5 - STEVENSON_ARCE_DITHERING", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 6 - JARVIS_DITHERING ", 5,i);

  L_GraphText (FONT8X16, 0, "Dithering Method:", 5, 9);       
  getint(DithMethod, 19, 9);
  while( *DithMethod < 0 || *DithMethod > 6)
   {
    L_GraphText (FONT8X16, 0, "Error: Invalid Dithering Method. Re-enter Dithering method:", 5, 9);       
    getint(DithMethod, 61, 9);
   }
  ClearVGAScreenNoBottom();
}



/***********
Get the file format type and bits per pixel.
***********/
L_VOID getformat(L_INT *formatvalue, L_INT *BitsToSave)
{
  L_INT i;

  i=SCREEN_MAX_HEIGHT-16;
  ClearVGAScreenNoBottom();     
  L_GraphFontSize(16,32);
  L_GraphColor (LIGHTRED, KEEPBACKGROUND);
  L_GraphText(FONT8X16, 0, "Formats supported", 100, i);
  L_GraphFontSize(0,0);
  i=i-30;
  L_GraphColor (LIGHTYELLOW, KEEPBACKGROUND);
  L_GraphText(FONT8X16, 0, " 1 - Zsoft PCX.              2 - Compuserve GIF.   3 - Uncompressed TIFF.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 4 - TGA TARGA.              5 - LEAD CMP.         6 - Windows BMP.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 7 - JPEG JFIF 4:4:4.        8 - JPEG TIFF 4:4:4.  9 - OS2 BMP.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 10- WMF NOT Supported Under DOS. 11- Raster EPS.       12- LZW compress TIFF.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 13- 1Bit CCITT G4 CALS CAL.      14- MacPaint.         15- GEM IMG.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 16- Microsoft Paint MSP.         17- Raster WPG.       18- SUN Raster RAS.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 19- Microsoft Pict PCT.          24- JPEG FIF 4:1:1    25- JPEG TIF 4:1:1.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 26- JPEG FIF 4:2:2               27- JPEG TIF 4:2:2.   28- CCITT TIFF.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 29- LEAD 1bit compressed.        30- CCITT G3 1D TIFF. 31- CCITT G2 2D TIFF.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 32- CCITT G4 2D TIFF.", 5,i);
  i=i-16;
  makebox();
  L_GraphColor (WHITE, KEEPBACKGROUND);
  L_GraphText (FONT8X16, 0, "File Format Number: ", 5, 9);
  getint (formatvalue, 21, 9);
  while( *formatvalue < 0 || *formatvalue >33)
   {
    L_GraphText (FONT8X16, 0, "Invalid Format. Please re-enter File Format number: ", 5, 9);
    getint (formatvalue, 53, 9);
   }
  L_GraphText(FONT8X16, 0, "BitsPerPixel (0 to abort): ",5,9);
  getint(BitsToSave,28,9);
  while(*BitsToSave && ( ValidBits(formatvalue, BitsToSave) != 1 ))
  {
       L_GraphText(FONT8X16, 0,"Invalid BitsPerPixel for the Format. Re-enter BitsPerPixel (0 to abort): ",5,9);
       getint(BitsToSave,74,9);
  }
  ClearVGAScreenNoBottom();
}



/***********
Get the TARGA needed resolution
***********/
L_INT GetTargaResolution(L_VOID)
{
  L_INT i;
  L_INT ModeToSwitch=-1;

  i=SCREEN_MAX_HEIGHT-16;
  ClearVGAScreenNoBottom();     
  i=i-30;
  L_GraphColor (LIGHTYELLOW, KEEPBACKGROUND);
  L_GraphText(FONT8X16, 0, "  0 - Interlaced 512x400x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  1 - Noninterlaced 512x400x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  2 - Interlaced 512x400x32.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  3 - Noninterlaced 512x400x32.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  4 - Interlaced 512x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  5 - Noninterlaced 512x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  6 - Interlaced 512x486x32.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  7 - Noninterlaced 512x486x32.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  8 - Interlaced 640x480x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, "  9 - Noninterlaced 640x480x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 10 - SquareInterlaced 640x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 11 - SquareNoninterlaced 640x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 12 - Interlaced 720x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 13 - Noninterlaced 720x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 14 - Interlaced 756x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 15 - Noninterlaced 756x486x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 16 - Interlaced 800x600x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 17 - Interlaced 1024x768x16.", 5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 18 - Back to VGA mode.", 5,i);
  i=i-16;

  L_GraphText(FONT8X16, 0, "Set Targa+ Mode To:" , XCHR, 480-(YCHR*20));
  getint(&ModeToSwitch,38,9);
  return(ModeToSwitch);
}



/***********
Clear the VGA screen but don't clear the bottom portion.
***********/
L_VOID ClearVGAScreenNoBottom()
{
  L_INT nRow;
  L_UCHAR L_FAR *pBuf;
  L_INT nMaxWidth, nMaxHeight;

  L_SelectViewType(VIEW_VGA);
  L_GetScreenWidthHeight(&nMaxWidth, &nMaxHeight);
  pBuf = (L_UCHAR L_FAR *) calloc( nMaxWidth * 3, sizeof(L_UCHAR) );
  for( nRow = 0; nRow < nMaxHeight-26; nRow++ )
  	 L_ViewRow( pBuf, nRow, 0, nMaxWidth, nMaxWidth, nMaxHeight );
  L_SelectViewType(uView);
  free(pBuf);
}



/***********
Draw the bottom red box
***********/
L_VOID makebox(L_VOID)
{
  L_GraphColor (RED,KEEPBACKGROUND);
  L_GraphLine( 0, 0, SCREEN_MAX_WIDTH, 0 ,26);
  L_GraphColor (WHITE, KEEPBACKGROUND);
  L_GraphBox( 0, 0, SCREEN_MAX_WIDTH, 26, 1);
}



/***********
Check if the bits per pixel are supported for the format requested.
***********/
L_INT ValidBits(L_INT *format, L_INT *Bits)
{
  switch(*format)
   {
    case FILE_PCX:
    case FILE_BMP:
    case FILE_OS2:
    case FILE_PCT:
        if( 1==*Bits || 4==*Bits || 8==*Bits || 24==*Bits )
          return(TRUE);
    break;
    case FILE_GIF:
    case FILE_EPS:
        if( 8==*Bits )
          return(TRUE);
    break;
    case FILE_TIF:
    case FILE_TIFLZW:
        if( 1==*Bits || 4==*Bits || 8==*Bits || 16==*Bits || 24==*Bits )
          return(TRUE);
    break;
    case FILE_TGA:
        if( 8==*Bits || 16==*Bits || 24==*Bits || 32==*Bits )
          return(TRUE);
    break;
    case FILE_CMP:
    case FILE_JFIF:
    case FILE_JTIF:
    case FILE_SAVE_JFIF411:
    case FILE_SAVE_JTIF411:
    case FILE_SAVE_JFIF422:
    case FILE_SAVE_JTIF422:
        if( 8==*Bits || 24==*Bits )
          return(TRUE);
    break;
    case FILE_WPG:  
        if( 1==*Bits || 4==*Bits || 8==*Bits )
          return(TRUE);
    break;
    case FILE_RAS:
        if( 1==*Bits || 4==*Bits || 8==*Bits || 24==*Bits || 32==*Bits )
          return(TRUE);
    break;
    case FILE_MAC:
    case FILE_IMG:
    case FILE_MSP:
    case FILE_CALS:
    case FILE_SAVE_CCITT:
    case FILE_SAVE_LEAD1BIT:
    case FILE_SAVE_CCITT_GROUP3_1DIM:
    case FILE_SAVE_CCITT_GROUP3_2DIM:
    case FILE_SAVE_CCITT_GROUP4:
    case FILE_SAVE_LEAD1BITLOSSY:
        if( 1==*Bits )
          return(TRUE);
    break;
    default :
        return(BADFORMAT);
   }
  return(FALSE);
}



/***********
Get the compression method to use for color images.
***********/
L_INT GetCompressedFormat(L_VOID)
{
  L_INT i;
  L_INT Format;

  i=SCREEN_MAX_HEIGHT-16;
  ClearVGAScreenNoBottom();
  i=i-30;
  L_GraphText(FONT8X16, 0, " 5  -  LEAD Technologies CMP compressed Format.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 7  -  JPEG File Interchange Format JPG with y4:u4:v4 color spacing.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 8  -  JPEG TIFF JTF with y4:u4:v4 color spacing.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 24 -  JPEG File Interchange Format JPG with Y4:U1:V1 color spacing.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 25 -  JPEG TIFF JTF with Y4:U1:V1 color spacing.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 26 -  JPEG File Interchange Format JPG with Y4:U2:V2 color spacing.",5,i);
  i=i-16;
  L_GraphText(FONT8X16, 0, " 27 -  JPEG TIFF JTF with Y4:U2:V2 color spacing.",5,i);
  L_GraphText(FONT8X16, 0, "Enter compressed format number:", 5, 9);
  getint(&Format,33,9);
  while(Format != 5   &&  Format != 7   &&  Format != 8   &&   Format != 24 &&
        Format != 25  &&  Format != 26  &&  Format != 27 )
    {
     L_GraphText(FONT8X16, 0, "Bad value entered. Re-enter Compressed Format number:", 5, 9);
     getint(&Format,55,9);
    }
  ClearVGAScreenNoBottom();
  return(Format);
}



/***********
Get the compression factor for color compression
***********/
L_INT GetQFactorForCMPAndJPEG(L_INT Format)
{
  L_INT i, QFactor;

  i=SCREEN_MAX_HEIGHT-16;
  if( Format==FILE_SAVE_CMP )
   {
    ClearVGAScreenNoBottom();
    i=i-30;
    L_GraphText(FONT8X16, 0, "-1 - Perfect quality option 1.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-2 - Perfect quality option.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-3 - Quality far more important than size.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-4 - Quality more important than size.-",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-5 - Quality and size are equally important.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-6 - Size more important than quality Sharp.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-7 - Size more important than quality - Less Tilling.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-8 - Maximum Compression, keeping quality as good as possible.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "-9 - Maximum compression.",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "(The above are NEGATIVE numbers)",5,i);
    i=i-16;
    L_GraphText(FONT8X16, 0, "Or any value from 2 to 255",30,i);
    L_GraphText(FONT8X16, 0, "Enter Qfactor:",5, 9);
    getint(&QFactor,16,9);
    while((QFactor == 0) || (QFactor < -9) || (QFactor > 255) )
     {
      L_GraphText(FONT8X16, 0, "Bad Qfactor. Re-enter Qfactor:",5,9);
      getint(&QFactor,32,9);
      putch(7);
     }
    ClearVGAScreenNoBottom();
    return(QFactor);
   }
  else if((Format==FILE_SAVE_JFIF444) || (Format==FILE_SAVE_JFIF422) ||
          (Format==FILE_SAVE_JFIF411) || (Format==FILE_SAVE_JTIF444) ||
          (Format==FILE_SAVE_JTIF422) || (Format==FILE_SAVE_JTIF411))
   {
    L_GraphText(FONT8X16, 0, "Enter Qfactor, any value from 2 through 255:",5,9);
    getint(&QFactor,47,9);
    while(QFactor < 2 || QFactor >255)
     {
      L_GraphText(FONT8X16, 0, "Bad Qfactor. Re-enter a value from 2 through 255:",5,9);
      getint(&QFactor,49,9);
     }
    ClearVGAScreenNoBottom();
    return(QFactor);
   }
  return(NOTCOMPRESSEDFORMAT);
}



/***********
print the information about the file 
***********/
L_VOID PrintFormat(L_CHAR * name, L_CHAR * string, L_INT BitsPerPixel, L_INT Width, L_INT Height,
                 L_INT32 SizeDisk, L_INT32 SizeMem)
{
  L_INT i;
  L_CHAR TEXT[150];

  i=SCREEN_MAX_HEIGHT-16;
  ClearVGAScreenNoBottom();
  i=i-30;
  sprintf(TEXT,"File:   ""%s""", name); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Format: ""%s""", string); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Bits Per Pixels           = %d", BitsPerPixel); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Image Width               = %d", Width); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Image Height              = %d", Height); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Size On Disk              = %ld", SizeDisk); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
  i=i-16;
  sprintf(TEXT,"Size In Memory will be    = %ld", SizeMem); 
  L_GraphText(FONT8X16, 0,TEXT ,5,i);
}



/***********
Load a supported Image file to a memory Bitmap
***********/
L_VOID LoadAFileToBitmap(pBITMAPHANDLE pBitmap)
{
  L_CHAR InputFileName[150];
  L_CHAR TEXT[150];
  L_INT ret;

  /* If a Bitmap exists, we need to free it    */
  if(pBitmap->Flags.Allocated)
    L_FreeBitmap( pBitmap );

   L_GraphText( FONT8X16, 0, "Input file name: ", 5, 9);
   getstring(InputFileName, 18, 9);
   /* Load the Image filename directly into the Bitmap handle.*/
   if( (ret = L_LoadRBitmap ( InputFileName, pBitmap,
                              TYPE_NOCONV )) == SUCCESS )
    { /* It allocated a Bitmap successfully */
     sprintf (TEXT,"%s loaded to the Bitmap. Press any key to continue.",InputFileName);
     L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    }
   else 
    { /* An error occured while loading the Image file */
     sprintf(TEXT,"Error: %d loading Image File to Bitmap. Press any key to continue.", ret);
     L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     putch(7);
    }
}



/***********
Save a memory Bitmap to a supported file format
***********/
L_VOID SaveABitmapToFile(pBITMAPHANDLE pBitmap)
{
  L_CHAR TEXT[150];
  L_CHAR OutPutFileName[150];
  L_INT  OutPutFormat, OutPutBits, ret;
  L_INT Qfactor;

  /* Make sure the Bitmap is filled with image data */
  if(!pBitmap->Flags.Allocated)
   {
    /* Trying to save an empty Bitmap */
    sprintf(TEXT,"Error: No image in the Bitmap allocated. Press any key to continue.");
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    putch(7);
   }
  else
   {
    getformat(&OutPutFormat, &OutPutBits);
    if(OutPutBits)
      {
       L_GraphText(FONT8X16, 0, "Output file name: ", 5, 9);
       getstring (OutPutFileName, 20, 9);
       Qfactor=GetQFactorForCMPAndJPEG(OutPutFormat);
       if(Qfactor != NOTCOMPRESSEDFORMAT)
        {
         pBitmap->QFactor=Qfactor;
        }
       /* Save the image Data in the Bitmap to an Image file */
       if( (ret = L_SaveRBitmap( OutPutFileName,
                                pBitmap, OutPutBits, OutPutFormat )) == SUCCESS )
        {
         sprintf(TEXT,"%s saved OK.  Press any key to continue.",OutPutFileName);
         L_GraphText(FONT8X16, 0, TEXT, 5, 9);
        }
       else
        { /* Error saving the Bitmap to the file */
         sprintf(TEXT,"Error: %d saving Bitmap to Image File. Press any key to continue.", ret);
         L_GraphText(FONT8X16, 0, TEXT, 5, 9);
         putch(7);
        }
      }
    else
      {
       sprintf(TEXT,"Save/Convert aborted. Press any key to continue.");
       L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      }
   }
}



/***********
Flip the Bitmap vertically
***********/
L_VOID FlipTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT ret;
  L_CHAR TEXT[150];

  /* Make sure Bitmap is already being used and is filled with image data */
  if(!pBitmap->Flags.Allocated)
   {
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    /* Flip an image in the Bitmap (top to bottom) */
    if( (ret = L_FlipBitmap( pBitmap )) == SUCCESS)
     {
      sprintf(TEXT,"Image flipped. Press any key to continue.");
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     }
    else
     {
      sprintf(TEXT,"Error: %d could not flip image. Press any key to continue.", ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      putch(7);
     }
   }
}



/***********
Reverse a Bitmap horizontally
***********/
L_VOID ReversTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_CHAR TEXT[150];
  L_INT ret;

  /* Make sure Bitmap is already being used and is filled with image data */
  if(!pBitmap->Flags.Allocated)
   {
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    /* Reverse an image in a Bitmap (left to right) */
    if( (ret = L_ReverseBitmap( pBitmap )) == SUCCESS)
     {
      L_GraphText(FONT8X16, 0, "Image reversed. Press any key to continue.", 5, 9);
     }
    else
     {
      sprintf(TEXT,"Error: %d Reversing the image. Press any key to continue.", ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      putch(7);
     }
   }
}



/***********
Resize the image in the Bitmap
***********/
L_VOID ResizeTheBitmap(pBITMAPHANDLE pBitmap)
{
   L_CHAR TEXT[150];
   L_INT NewWidth, NewHeight, ret;
   /* Make sure Bitmap is already being used and is filled with image data */
   if( !pBitmap->Flags.Allocated )
    {
     L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
     putch(7);
    }
   else
    {
     sprintf(TEXT, "Original Width %d. Enter New Width: ", pBitmap->Width);
     L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     getint(&NewWidth,41,9);
     sprintf(TEXT, "Original Height %d. Enter New Height: ", pBitmap->Height); 
     L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     getint(&NewHeight,41,9);
     if( (ret = L_SizeBitmap( pBitmap, NewWidth, NewHeight ))
                        == SUCCESS )
      {
       sprintf(TEXT, "Bitmap resized to %d by %d OK.",pBitmap->Width, pBitmap->Height);
       L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      }
     else
      {
       sprintf(TEXT,"Error: %d resizing the Bitmap. Press any key to continue.", ret);
       L_GraphText(FONT8X16, 0, TEXT, 5, 9);
       putch(7);
      }
    }
}


/***********
Rotate The bitmap + or - degrees
***********/
L_VOID RotateTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT Degree, YesNo, ret;
  L_CHAR TEXT[150];

  if( !pBitmap->Flags.Allocated )
   {
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    L_GraphText(FONT8X16, 0, "Rotate by (degrees):", 5, 9);
    getint( &Degree,22,9 ) ;
    L_GraphText(FONT8X16, 0, "Resize? (0=No, 1=Yes):", 5, 9);
    getint( &YesNo,24,9 ) ;
    if( (ret=L_RotateBitmap( pBitmap, Degree, YesNo))==SUCCESS)
     {
      L_GraphText(FONT8X16, 0, "Bitmap rotated! Press any key to continue.", 5, 9);
     }
    else
     {
      sprintf(TEXT,"Error: %d rotating Bitmap",ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     }
   }
}



/***********
Dither an image for 256 colors (FLAG=1 optimizes palette)
                               (FLAG=0 Fixed Palette) 
***********/
L_VOID Ditherto256Palette(pBITMAPHANDLE pBitmap, L_INT FLAG)
{
  L_CHAR TEXT[150];
  L_INT ret;
  L_INT Method;
  L_INT PaletteToUse;
  L_INT BitsPerPixel;

  L_GraphText(FONT8X16, 0, "BitsPerPixel: ",5,9);
  getint(&BitsPerPixel, 15, 9);

  if(FLAG)
    PaletteToUse=CRF_OPTIMIZEDPALETTE;
  else
    PaletteToUse=CRF_FIXEDPALETTE ;

  /* Make sure Bitmap is already being used and is filled with image data */
  if( !pBitmap->Flags.Allocated )
   {
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    GetDitheringMethod(&Method);
    pBitmap->DitheringMethod=Method;
    /* Convert The Bitmap to an 8-bit palette image */
    if((ret = L_ColorResolution(pBitmap, BitsPerPixel, PaletteToUse, NULL, NULL)) == SUCCESS) 
     {
      L_GraphText(FONT8X16, 0, "Bitmap dithered OK.  Press any key to continue.", 5, 9);
     }
    else
     {
      sprintf(TEXT,"Error: %d dithering the Bitmap.  Press any key to continue.", ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      putch(7);
     }
   }
}



/***********
Clear a Bitmap to 0's
***********/
L_VOID ClearTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT ret;
  L_CHAR TEXT[150];

  /* Make sure Bitmap is already being used and is filled with image data */
  if( !pBitmap->Flags.Allocated )
    {
     L_GraphText(FONT8X16, 0, "Error: No image in Bitmap allocated. Press any key to continue.", 5, 9);
     putch(7);
    }
   else
    {
     /* Clear the Bitmap and fill it with zeros */
     if( (ret = L_ClearBitmap( pBitmap )) == SUCCESS )
      {
       L_GraphText(FONT8X16, 0, "Bitmap cleared and filled with zeros OK. Press any key to continue.", 5, 9);
      }
     else
      {
       sprintf(TEXT,"Error: %d clearing the Bitmap. Press any key to continue.", ret);
       L_GraphText(FONT8X16, 0, TEXT, 5, 9);
       putch(7);
      }
    }
}



/***********
GrayScale the Bitmap
***********/
L_VOID GrayScaleTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT ret;
  L_CHAR TEXT[150];

  if( !pBitmap->Flags.Allocated )
   {
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    /* GrayScale the Bitmap */
    if((ret=L_GrayScaleBitmap( pBitmap)) == SUCCESS)
     {
      L_GraphText(FONT8X16, 0, "Bitmap GrayScaled OK! Press any key to continue.", 5, 9);
     }
    else
     {
      sprintf(TEXT,"Error %d GrayScaling! Press any key to continue.",ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     }
   }
}



/***********
View the Bitmap to the screen at the position and size requested.
***********/
L_VOID ViewTheBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT BitmapX1, BitmapY1, BitmapX2, BitmapY2;
  L_INT ScreenX1, ScreenY1, ScreenX2, ScreenY2;
  L_INT ret;
  L_CHAR TEXT[150];

  if( !pBitmap->Flags.Allocated )
   { 
    L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   } 
  else
   {
    L_GraphText(FONT8X16, 0, "X Coordinate of Origin of the Bitmap: ", 5, 9);
    getint(&BitmapX1,39,9);
    L_GraphText(FONT8X16, 0, "Y Coordinate of Origin of the Bitmap: ", 5, 9);
    getint(&BitmapY1,39,9);
    L_GraphText(FONT8X16, 0, "X2 Coordinate of Top Right of the Bitmap: ", 5, 9);
    getint(&BitmapX2,43,9);
    L_GraphText(FONT8X16, 0, "Y2 Coordinate of Top Right of the Bitmap: ", 5, 9);
    getint(&BitmapY2,43,9);
    L_GraphText(FONT8X16, 0, "X1 Coordinate of Origin of the Screen: ", 5, 9);
    getint(&ScreenX1,40,9);
    L_GraphText(FONT8X16, 0, "Y1 Coordinate of Origin of the Screen: ", 5, 9);
    getint(&ScreenY1,40,9);
    L_GraphText(FONT8X16, 0, "X2 Coordinate (Top Right) of the Screen, 0 for No Resize: ", 5, 9);
    getint(&ScreenX2,59,9);
    L_GraphText(FONT8X16, 0, "Y2 Coordinate (Top Right) of the Screen, 0 for No Resize: ", 5, 9);
    getint(&ScreenY2,59,9);
    /* View the Bitmap with the new width and height.
       This will display the image with the new width and height
       and will not change the original Bitmap's width and height
     */
    if((ret=L_ViewBitmap (pBitmap, BitmapX1, BitmapY1, BitmapX2,
     	                    BitmapY2, ScreenX1, ScreenY1, ScreenX2,
                          ScreenY2))!= SUCCESS )
     {
      sprintf(TEXT,"Error %d viewing Bitmap.",ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
     }
   } 
}



/***********
View a file to screen. Do not keep in a memory bitmap. Just view.
***********/
L_VOID ViewAFile(L_VOID)
{
  L_CHAR InputFileName[150];
  L_CHAR TEXT[150];
  L_INT XPos, YPos, NewWidth, NewHeight;
  L_INT ret;

  L_GraphText(FONT8X16, 0,"Input file name:", 5, 9);
  getstring(InputFileName,18,9);
  L_GraphText(FONT8X16, 0, "Starting X display position, or 0 for normal position: ", 5, 9);
  getint(&XPos,56,9);
  L_GraphText(FONT8X16, 0, "Starting Y display position, or 0 for normal position: ", 5, 9);
  getint(&YPos,56,9);
  L_GraphText(FONT8X16, 0, "Display width, or 0 for current Width in the file: ", 5, 9);
  getint(&NewWidth,52,9);
  L_GraphText(FONT8X16, 0, "Display height, or 0 for current Height in the file: ", 5, 9);
  getint(&NewHeight,54,9);
  if( (ret = L_ViewRScreen (InputFileName, NewWidth, NewHeight,
                             XPos, YPos)) != SUCCESS)
   {
    /*Free the RGB table from memory*/
    sprintf(TEXT,"Error: %d trying to view %s. Press any key to continue.", ret, InputFileName);
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    putch(7);
   }
}



/***********
Compress A Registered file format to LEAD, JFIF, or JTIF
***********/	
L_VOID CompressAFile2CMPJPEG(L_VOID)
{
  L_CHAR TEXT[150];
  L_CHAR InputFileName[150];
  L_CHAR OutPutFileName[150];
  L_INT QFactor, CompressionFormat, ret;

  L_GraphText(FONT8X16, 0, "Input file name:", 5, 9);
  getstring(InputFileName,18,9);
  L_GraphText(FONT8X16, 0, "Output file name:", 5, 9);
  getstring(OutPutFileName,20,9);
  CompressionFormat=GetCompressedFormat();
  QFactor=GetQFactorForCMPAndJPEG(CompressionFormat);
  if ( (ret = L_CompressRFile (InputFileName, OutPutFileName,
                               CompressionFormat, QFactor)) == SUCCESS)
   {
    sprintf(TEXT,"File: %s compressed to %s. Press any key to continue.",InputFileName, OutPutFileName);
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
   }
  else
   {
    sprintf(TEXT,"Error: %d compressing %s. Press any key to continue.", ret, InputFileName);
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    putch(7);
   }
}



/***********
Convert a registered file to another registered file with a new width and height.
***********/
L_VOID ConvertAFile(L_VOID)
{
  L_CHAR TEXT[150];
  L_CHAR InputFileName[150];
  L_CHAR OutPutFileName[150];
  L_INT FormatType, FormatBits, Width, Height;
  L_INT ret;

  /*Convert one file format to another file format */
  L_GraphText(FONT8X16, 0, "Input file name: ", 5, 9);
  getstring(InputFileName,18,9);
  L_GraphText(FONT8X16, 0, "Output file name: ", 5, 9);
  getstring(OutPutFileName,19,9);
  L_GraphText(FONT8X16, 0, "Output format new width:", 5, 9);
  getint(&Width,26,9);
  L_GraphText(FONT8X16, 0, "Output format new height:", 5, 9);
  getint(&Height,27,9);
  getformat(&FormatType,&FormatBits);
  if( FormatBits )
   {
    if( (ret = L_FileConvert(InputFileName, OutPutFileName, FormatType,  Width,
                             Height, FormatBits )) == SUCCESS)
     {
      sprintf(TEXT,"File: %s converted to %s. Press any key to continue. ",InputFileName, OutPutFileName);
      L_GraphText(FONT8X16, 0, TEXT, 5,9);
     }
    else
     {
      sprintf(TEXT,"Error: %d while converting. Press any key to continue. ", ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      putch(7);
     }
   }
  else
   {
    sprintf(TEXT,"Save/Convert aborted. Press any key to continue.");
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
   }
}



/***********
Fill the FILEINFO Structure with the information about the requested file
then print to the screen.
***********/
L_VOID GetFileInformation(L_VOID)
{
  L_CHAR InputFileName[150];
  L_CHAR TEXT[150];
  L_CHAR string[50];

  FILEINFO     FileInfo;  /* Structure that L_FileInfo will fill to return
                             important information about an image file */
  L_GraphText(FONT8X16, 0, "Input file name: ", 5, 9);
  getstring(InputFileName,18,9);
  if(L_FileInfo(InputFileName, &FileInfo) != SUCCESS)
   {
    sprintf(TEXT,"Error: %s Unrecognized file format.  Press any key to continue.",InputFileName);
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    putch(7);
   }
  else
   {
    switch (FileInfo.Format)
     {
      case FILE_PCX:
          strcpy(string,"ZSoft PCX.");
      break;
      case FILE_GIF:
          strcpy(string,"CompuServe GIF.");
      break;
      case FILE_TIF:
          strcpy(string,"Tagged Image File Format TIFF.");
      break;
      case FILE_TGA:
          strcpy(string,"TrueVision Targa TGA.");
      break;
      case FILE_CMP:
          strcpy(string,"LEAD Technologies Inc. Compression CMP.");
      break;
      case FILE_BMP:
          strcpy(string,"Windows BMP.");
      break;
      case FILE_JFIF:
      case FILE_SAVE_JFIF411:             
      case FILE_SAVE_JFIF422:
          strcpy(string,"JPEG File Interchange Format JPG.");
      break;
      case FILE_JTIF:
      case FILE_SAVE_JTIF411:
      case FILE_SAVE_JTIF422:
          strcpy(string,"JPEG Tagged Image File Format JTIF.");
      break;
      case FILE_OS2:
          strcpy(string,"OS2 BMP.");
      break;
      case FILE_WMF:
           L_GraphText(FONT8X16, 0, "WMF is not supported under the DOS Version of LEADTOOLS.", 5, 9);
      break;
      case FILE_EPS:
          strcpy(string,"Encapsulated Post Script.");
      break;
      case FILE_TIFLZW:
          strcpy(string,"Tagged Image File Format with LZW Compression.");
      break;
      case FILE_CALS:
          strcpy(string,"CLAS RASTER CAL.");
      break;
      case FILE_MAC:                        
          strcpy(string,"MacPint MAC.");
      break;                                
      case FILE_IMG:                        
          strcpy(string,"GEM Image IMG.");
      break;                                
      case FILE_MSP:                        
          strcpy(string,"Microsoft Paint MSP.");
      break;                           
      case FILE_WPG:                   
          strcpy(string,"WordPerfect Raster WPG.");
      break;
      case FILE_RAS:
          strcpy(string,"SUN Raster RAS.");
      break;
      case FILE_PCT:
          strcpy(string,"Microsoft Pict PCT.");
      break;
      case FILE_LEAD1BIT:
          strcpy(string,"LEAD Technologies Inc. 1 bit compressed CMP.");
      break;
      case FILE_SAVE_CCITT:
      case FILE_SAVE_CCITT_GROUP3_1DIM:
      case FILE_SAVE_CCITT_GROUP3_2DIM:   
      case FILE_SAVE_CCITT_GROUP4:
          strcpy(string,"TIFF CCITT Compression TIFF.");
      break;
     }

    if( FileInfo.Format != FILE_WMF )
     {
      PrintFormat(InputFileName, string, FileInfo.BitsPerPixel,
        FileInfo.Width, FileInfo.Height, FileInfo.SizeDisk, FileInfo.SizeMem);

      L_GraphText(FONT8X16, 0, "Press any key to continue.", 5, 9);
     }
   }
  L_SleepKey( 99 );
  ClearVGAScreenNoBottom();
  makebox();
  L_GraphText(FONT8X16, 0, "Press another key to continue.", 5, 9);
}


/**********
Reverse video color order RGB to BGR or BGR to RGB
**********/
L_VOID ReverseTheColorOrder(L_VOID)
{
  if(L_RGB_flag == 0) /** BGR **/
    {
     L_SetVGAOrder(ORDER_RGB);
    }
   else
    {
     L_SetVGAOrder(ORDER_BGR);
    }
  L_GraphText(FONT8X16, 0, "The Video Color Order has been reversed.", 5, 9);
}




/**********
Reset the video resolution
**********/
L_VOID ReSetTheVideoResolution(L_VOID)
{
  L_INT VideoSize;
  L_INT VideoToUse;
  L_CHAR TEXT[150];

  L_GraphText(FONT8X16, 0, " 0 - Set VGA resolution. 1 - Set TARGA+ resolution.", 5, 9);
  getint(&VideoToUse,53,9);
  if(VideoToUse == 0)
   {
    L_GraphText(FONT8X16, 0, "MAX VGA resolution 0-320x200, 1-640x350, 2-640x480, 3-800x600, 4-1024x768. ", 5, 9);
    getint(&VideoSize,76,9);
    /* Checks for legal VGA/SuperVGA resolution */
    switch(VideoSize)
     {
      case SIZE_320x200:
          L_GraphText(FONT8X16, 0, "This demo must run at 640X480 or higher resolution.", 5, 9);
          putch(7);
      break;
      case SIZE_640x480:
	 	    uView = VIEW_VGA;
          L_SetVideoMode(3, 0);
          VGA_SIZE = SIZE_640x480;
          SCREEN_MAX_WIDTH=640;
          SCREEN_MAX_HEIGHT=480;
          L_SetVGASize(VGA_SIZE);
          makebox();
          L_GraphText(FONT8X16, 0, "VGA size set to 640X480 OK!  Press any key to continue.", 5, 9);
      break;
      case SIZE_800x600:
	 	    uView = VIEW_VGA;
          L_SetVideoMode(3, 0);
          VGA_SIZE = SIZE_800x600;
          SCREEN_MAX_WIDTH=800;
          SCREEN_MAX_HEIGHT=600;
          L_SetVGASize(VGA_SIZE);
          makebox();
          L_GraphText(FONT8X16, 0, "VGA size set to 800X600 OK!  Press any key to continue.", 5, 9);
      break;
      case SIZE_1024x768:
	 	    uView = VIEW_VGA;
          L_SetVideoMode(3, 0);
          VGA_SIZE = SIZE_1024x768;
          SCREEN_MAX_WIDTH=1024;
          SCREEN_MAX_HEIGHT=768;
          L_SetVGASize(VGA_SIZE);
          makebox();
          L_GraphText(FONT8X16, 0, "VGA size set to 1024X758 OK!  Press any key to continue.", 5, 9);
      break;
      default:
          L_GraphText(FONT8X16, 0, "Invalid Video Resloution.", 5, 9);
          putch(7);
      break;
     }
   }
  else if(VideoToUse == 1)
   {
    VideoSize=GetTargaResolution();
    if(VideoSize >0 && VideoSize < 19)
     {
      L_SetTARGAMode(VideoSize) ;
		uView = VIEW_TARGA;
      ClearVGAScreenNoBottom();     
      L_GraphText(FONT8X16, 0, "Targa+ mode set!  Press any key to continue.", 0, 9);
     }
    else
     {
      ClearVGAScreenNoBottom();     
      L_GraphText(FONT8X16, 0, "Invalid Targa mode!  Press any key to continue.", 0, 9);
     }
   }
  else
   {
    sprintf(TEXT, "Error: %d Unknown command number!");
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
    putch(7);
   }
	L_SelectViewType(uView);
}



/**********
Change LEADTOOLS Video memory to assume new size.
**********/
L_VOID SetVGAMemorySize(L_VOID)
{
  L_INT MemorySize;
  L_CHAR TEXT[150];

  /* Case set VGA memory */
  L_GraphText(FONT8X16, 0, "VGA memory in Kbytes: ", 5, 9);
  getint(&MemorySize,23,9);
  if(MemorySize < 256)
   {
    sprintf(TEXT,"Error: %d Unknown VGA memory size", MemorySize);
    L_GraphText(FONT8X16, 0, TEXT, 5, 9);
   }
  else
   {
    L_SetVideoMemory(MemorySize) ;  /* Force LEAD TOOLS TO USE THIS SIZE*/
    L_GraphText(FONT8X16, 0, "VGA memory set! Press any key to continue.", 5, 9);
   } 
}



/**********
Change the brightness of the Bitmap.
**********/
L_VOID ChangeBitmapBrightness(pBITMAPHANDLE pBitmap)
{
  L_INT Value;
  L_INT ret;
  L_CHAR TEXT[150];

  if( !pBitmap->Flags.Allocated )
   {
    L_GraphText(FONT8X16, 0, "Error: No image in Bitmap allocated. Press any key to continue.", 5, 9);
    putch(7);
   }
  else
   {
    L_GraphText(FONT8X16, 0, "+# Increase / -# Decrease Intensity by: ", 5, 9);
    getint( &Value,41,9 );
    if( (ret=L_ChangeBitmapIntensity(pBitmap, Value)) == SUCCESS)  /* Set new intensity */
      L_GraphText(FONT8X16, 0, "Change intensity successful!", 5, 9);
    else
      {
       sprintf(TEXT,"Error %d changing the Bitmap intensity.", ret);
       L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      }
   }
}




/**********
Clear the VGA screen.
**********/
L_VOID ClearVGAScreen(L_VOID)
{
  L_ClearVGAScreen();
  L_GraphColor(WHITE, BLACK);
  L_GraphText(FONT8X16, 0,"Press any key to continue.",5,9);
}



/**********
Half Tone the Bitmap for printing or viewing
**********/
L_VOID HalfToneTheBitmap(pBITMAPHANDLE pBitmap)
{
   L_INT Answer, ret;
   L_CHAR TEXT[150];

   /* case HalfTone the Bitmap */
   if ( !pBitmap->Flags.Allocated )
     {
      L_GraphText(FONT8X16, 0, "Error: No image in the Bitmap allocated. Press any key to continue.", 5, 9);
      putch(7);
     }
   else
    {
     L_GraphText(FONT8X16, 0, "HalfTone type (PRINT 0 or VIEW 1)", 5, 9);
     getint( &Answer,35,9 ) ;
     if(Answer == 0 || Answer == 1)
      {
       if((ret=L_HalfToneBitmap( pBitmap, Answer)) == SUCCESS)
        {
         L_GraphText(FONT8X16, 0, "Bitmap HalfToned OK! Press any key to continue.", 5, 9);
        }
       else
        {
         sprintf(TEXT,"Error %d HalfToning! Press any key to continue.",ret);
         L_GraphText(FONT8X16, 0, TEXT, 5, 9);
        }
      }
     else
       L_GraphText(FONT8X16, 0, "Invalid HalfTone method. Press any key to continue.", 5, 9);
    }
}



/**********
Draw a Line in the specified x1, y1, x2, y2.  
**********/
L_VOID DrawALine(L_VOID)
{
  L_INT x1, y1, x2, y2;
  L_INT NumberOfPixels;

  L_GraphText(FONT8X16, 0, "Beginning X Position of Line?", 5, 9);
  getint( &x1, 31, 9 ) ;
  L_GraphText(FONT8X16, 0, "Beginning Y Position of Line?", 5, 9);
  getint( &y1, 31, 9 ) ;
  L_GraphText(FONT8X16, 0, "Ending X Position of Line?", 5, 9);
  getint( &x2, 28, 9 ) ;
  L_GraphText(FONT8X16, 0, "Ending Y Position of Line?", 5, 9);
  getint( &y2, 28, 9 ) ;
  L_GraphText(FONT8X16, 0, "Thickness of Line?", 5, 9);
  getint( &NumberOfPixels, 20, 9 ) ;
  L_GraphLine( x1, y1, x2, y2, NumberOfPixels );
  L_GraphText(FONT8X16, 0, "Press any key to continue.", 5, 9);
}



/**********
Draw a Box in the specified x1, y1, x2, y2.  
**********/
L_VOID DrawABox(L_VOID)
{
  L_INT x1, y1, x2, y2;
  L_INT NumberOfPixels;


  L_GraphText(FONT8X16, 0, "Lower Left X Position of Box?", 5, 9);
  getint( &x1, 31, 9 ) ;
  L_GraphText(FONT8X16, 0, "Lower Left Y Position of Box?", 5, 9);
  getint( &y1, 31, 9 ) ;
  L_GraphText(FONT8X16, 0, "Upper Right X Position of Box?", 5, 9);
  getint( &x2, 32, 9 ) ;
  L_GraphText(FONT8X16, 0, "Upper Right Y Position of Box?", 5, 9);
  getint( &y2, 32, 9 ) ;
  L_GraphText(FONT8X16, 0, "Thickness of Box?", 5, 9);
  getint( &NumberOfPixels, 19, 9 ) ;
  L_GraphBox( x1, y1, x2, y2, NumberOfPixels );
  L_GraphText(FONT8X16, 0, "Press any key to continue.", 5, 9);
}




/**********
Set TIFF Page Number.
**********/
L_VOID SetTIFFPageNumber(L_VOID)
{
  L_INT Page;
  
  L_GraphText(FONT8X16, 0, "TIFF Page Number?", 5, 9);
  getint( &Page, 19, 9 ) ;
  L_tiffoption.PageNumber = Page;
}



/**********
Capture an area of the screen and put it in the Bitmap.
**********/
L_VOID CaptureScreenToBitmap(pBITMAPHANDLE pBitmap)
{
  L_INT ScreenX1, ScreenY1, ScreenX2, ScreenY2;
  L_INT ret;
  L_CHAR TEXT[150];

  /* If the Bitmap is allocated, we need to free it */
  if( pBitmap->Flags.Allocated )
    L_FreeBitmap( pBitmap );

    L_GraphText(FONT8X16, 0, "Enter X1 origin of the Screen : ", 5, 9);
    getint(&ScreenX1,43,9);
    L_GraphText(FONT8X16, 0, "Enter Y1 origin of the screen : ", 5, 9);
    getint(&ScreenY1,43,9);
    L_GraphText(FONT8X16, 0, "Enter X2 origin of the Screen : ", 5, 9);
    getint(&ScreenX2,43,9);
    L_GraphText(FONT8X16, 0, "Enter Y2 origin of the Screen : ", 5, 9);
    getint(&ScreenY2,43,9);

    /* Initialize the Bitmap handle to clear all values. We will let
       L_GetScreenBitmap fill the handle with the correct values */
    L_InitBitmap( pBitmap, 0, 0, 0 );

    /* Capture the desired portion of the screen*/
    if( (ret = L_GetScreenBitmap( pBitmap, ScreenX1, ScreenY1, ScreenX2,
                                  ScreenY2 )) != SUCCESS )
     {
      L_FreeBitmap( pBitmap );
      sprintf(TEXT, "Error %d during capture.  Press any key to continue. ",ret);
      L_GraphText(FONT8X16, 0, TEXT, 5, 9);
      putch(7);
     }
    else
      L_GraphText(FONT8X16, 0, "Screen captured OK. Press any key to continue.", 5, 9);
}

