#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <bios.h>
#include <direct.h>
#include "l_bitmap.h"
#include "l_error.h"
#if __BORLANDC__
/* Needed for Borland C to incease the stack size */
    extern unsigned _stklen = 14000U;
#endif



int CallBack( char far *FileName, unsigned int ScanCode,
                                  unsigned int ASCIICode, void far *pParam );

void SetDataFilesDirectory(char ExeName[]);
void SetPathAndExtension(int argc, char *argv[], char *Directory, char *Extension);
void Copyright( void );
int main(int argc, char *argv[]);

int main(int argc, char *argv[])
{
   int nInput;
   int nRet;
   int files = 10;
   char FileType[ 512 ];
   char Dir[ 256 ];
   argc--;

   if(argc < 1)
      {
       Copyright();
       printf("Do you want to force VESA mode? (Y,N)\n");
       nInput = getch();
       if( nInput == 'Y' || nInput == 'y' )
         L_SetVESA( 1 );

       printf("Do you want to force 8-Bit mode? (Y,N)\n");
       nInput = getch();
       if( nInput == 'Y' || nInput == 'y' )
         L_SetVideoTrueColor( 0 );
      }
   /* Specify the directory for the 1bit.dat */
   SetDataFilesDirectory(argv[0]);

   SetPathAndExtension(argc, argv, Dir, FileType);

   L_RegisterReadAll();
   L_RegisterDitherForLoadAndSave();
   L_RegisterResizeForLoad();
   L_SelectViewType( VIEW_VGA );
   L_SetVGASize(SIZE_640x480);
   L_SetVGAPalette(RGBFixedPalette);
   L_ReserveTextColors();

   nRet =  L_ListFiles( 500, 450, 1, files, Dir, FileType, CallBack, NULL);

   L_ReservePaletteColors( NULL, 0 );

   L_SetVideoMode( 3, 0 );
   printf( "Return value = %d\n", nRet );
   return( nRet );

}

int CallBack( char far *FileName, unsigned int ScanCode,
              unsigned int ASCIICode, void far *pParam )

{
   BITMAPHANDLE Bitmap;
   int i;
   int fontY = 16;
   int nRet;
   int xLow, yLow, xHigh, yHigh;
   int ScreenWidth, ScreenHeight;

   switch( ScanCode )
   {
        case 0x3b : /* Help Menu */
                  L_GetScreenWidthHeight( &ScreenWidth, &ScreenHeight );
                  xLow  = ( ScreenWidth  - 290  ) / 2;
                  yLow  = ( ScreenHeight - 190 ) / 2;
                  xHigh = ( ScreenWidth  + 290  ) / 2;
                  yHigh = ( ScreenHeight + 190 ) / 2;

                  if( (nRet = L_GetScreenBitmap( &Bitmap, 0, 0, ScreenWidth, ScreenHeight )) 
                                                 != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphColor(BLACK, BLACK)) != SUCCESS)
                     return( nRet );

                  for( i = yLow; i <= yHigh; i++ )
                     if( (nRet = L_GraphLine(xLow, i, xHigh, i, 1)) != SUCCESS)
                        return( nRet );

                  if( (nRet = L_GraphColor(GREEN, KEEPBACKGROUND)) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphBox( xLow, yLow, xHigh, yHigh, 2)) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphColor(YELLOW, KEEPBACKGROUND)) != SUCCESS)
                     return( nRet );


                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Up Arrow  : Scroll Up", 
                                          xLow + 10, yHigh - 2 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Down Arrow: Scroll Down", 
                                          xLow + 10, yHigh - 3 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Page Up   : Page up", 
                                          xLow + 10, yHigh - 4 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Page Down : Page down", 
                                          xLow + 10, yHigh - 5 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Home      : All the way up", 
                              xLow + 10, yHigh - 6 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "End       : All the way Down", 
                                          xLow + 10, yHigh - 7 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "D         : Display a file", 
                                          xLow + 10, yHigh - 8 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  if( (nRet = L_GraphText(FONT8X16, HORIZONTAL, "Esc       : Exit Box", 
                                          xLow + 10, yHigh - 9 * (fontY + 2))) != SUCCESS)
                     return( nRet );

                  L_SleepKey(99);

                  if( (nRet = L_ViewBitmap( &Bitmap, 0, 0, 0, 0, 0, 0, 0, 0 )) != SUCCESS)
                     return( nRet );

                  L_FreeBitmap( &Bitmap );
                  break;

        case 0x20 : /* 'D' or 'd' for display */
                  if( (nRet = L_ViewRScreen( FileName, 0, 0, 0, 0 )) == SUCCESS)
                      L_SleepKey(99);
                  break;

        case 0x2e : /* 'C' or 'c' to clear the screen */
                  L_ClearVGAScreen();
                  return( 2 );

        case 0x01 : /* 'Esc' to quit the program */
                  return( -100 );

        default   :
            return( 2 );
   }
   return( 2 );
}


void SetDataFilesDirectory(char ExeName[])
{
  char path[128];
  int i;
  strcpy(path, ExeName);

/* Find out from argv[0] the exe's path name */
  for (i = strlen(path)-1; i > 0; i--)
   {
   if (path[i] == '\\' || path[i] == ':')
      break;
   }
 path[i+1] = 0;
 L_SetDataDirectory (path);
}

void SetPathAndExtension(int argc, char *argv[], char *Directory, char *Extension)
{
   char temp[128];

   if(argc >= 1)
      strcpy(Extension, argv[1]);
   else
      strcpy(Extension, "*.*");

   if(argc >= 2)
      strcpy(Directory, argv[2]);
    else
      {
       if(getcwd(temp,128) == 0)
         {
          printf("\nERROR geting current directory\n");
          exit(0);
         }
       strcpy(Directory,temp );
      }
}

void Copyright( void )
{
  L_SetVideoMode( 3, 0 );
  printf("                    LEADTOOLS DOS EVALUATION copy V 2.2\n");
  printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
  printf("                    900 Baxter Street\n");
  printf("                    Charlotte NC 28204\n");
  printf("                    tel# (704) 332-5532\n\n");
  printf("\n       DOS - File viewer software utility Version 1.0\n\n");

  printf("\n\nUSAGE LISTBOX <file extention> <Drive and Directory>\n");
  printf("example LISTBOX *.CMP C:\\LTDOSEVAL\n\n");

  printf("\nPress 'D' or 'd' to display the highlighted file.\n");
  printf("\nPress 'C' or 'c' to clear the screen.\n");
  printf("\nPress 'F1' For Help clear the screen.\n");
  printf("\nPress 'Esc' to Quit.\n");
}







