#include <stdio.h>
#include <dos.h>
#include "..\include\L_Bitmap.h"
#include "..\include\L_error.h"

#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2

#if __BORLANDC__
    extern unsigned _stklen = 13000U;
#endif

L_VOID Copyright( L_VOID );
L_VOID USAGE( L_VOID );

L_INT  format = LEAD, qqfactor = PQ1;

main(L_INT argc, L_CHAR *argv[])
{
  FILEINFO FileInformation;
  struct find_t file;
  L_INT result;
  L_INT i;
  L_CHAR string[256];
  L_INT error;
  L_CHAR outfile[128], infile[128], pathname[128];
  L_INT wild_flag = 0;

#if !defined(FOR_386)
  L_RegisterReadTGA();
  L_RegisterReadGIF();
  L_RegisterReadPCX();
  L_RegisterReadTIF();
  L_RegisterReadBMP();
  L_RegisterWriteCMP();
  L_RegisterWriteJFIF();
  L_RegisterWriteJTIF();
#endif

  if(argc<=2)
  {
     USAGE();
     if(argc==1)
        printf("Error: No <source file> Or <target file> Specified.");
     else
        printf("Error: No <target file> Specified.");
     exit(0);
  }
  else if(argv[1][0]=='/')
  {
     printf("Error: %s Is A Bad Source File.",argv[1]);
     exit(0);
  }
  else if(argv[2][0]=='/')
  {
    printf("Error: %s Is A Bad Source File.",argv[1]);
    exit(0);
  }

  strupr(argv[1]);
  strupr(argv[2]);
    
  if ( find_wildletter(argv[1]) == 1)
  {
     if (find_wildletter(argv[2]) == 1)
        wild_flag = 1;
  }
  for (i = 3; i<=argc; i++)
  {
     strupr(argv[i]);
     if(argv[i][0]=='/')
     if(get_value(argv[i]+1)==BAD_COMMAND)
     {
        USAGE();
        printf("\nInvalid Option %s",argv[i]);
        exit(0);
     }  
  }
  get_pathname(argv[1], pathname);
  result = _dos_findfirst(argv[1], 0 , &file);
  if (result) 
        printf("Error: No Such File %s.\n",argv[1]);
  else
  {
     while(!result)  /* Stop when _dos_findnext returns a non-zero */
     {
        strcpy(infile, pathname);
        strcat(infile, file.name);
        if ( (L_FileInfo(infile,&FileInformation)==SUCCESS) && (FileInformation.BitsPerPixel >=8) )
        {
           if (wild_flag == 1)
              get_outfilename(file.name, argv[2], outfile);
           else
              strcpy(outfile, argv[2]);
           Copyright();
           printf("\nCompressing Image File %s To %s.\n", infile, outfile);

           error=L_CompressRFile(infile,outfile,format,qqfactor);

           if( error < SUCCESS )
           {
              Copyright();
              printf("\nError: %d Was Returned Compressing Image File %s.\n",error,file.name);
           }
        }
        else
        {
           printf("\nError: Unable To Open File %s, Or The Format Is Invalid/Un-Registered.\n",file.name);
           putch(7);
        }
     result = _dos_findnext(&file);
     }
  }
exit(0);
}

get_value(string)
L_CHAR *string;
{
  L_CHAR *exttab[16], *extptr1;
  L_INT pathlen1, ret = OK, source;
 
  exttab[0] = "L2JFIF";
  exttab[1] = "L1JFIF";
  exttab[2] = "JFIF";
  exttab[3] = "L2JTIF";
  exttab[4] = "L1JTIF";
  exttab[5] = "JTIF";
  exttab[6] = "PQ1";
  exttab[7] = "PQ2";
  exttab[8] =  "QFS";
  exttab[9] =  "QMS";
  exttab[10] = "QS";
  exttab[11] = "SQS";
  exttab[12] = "SQT";
  exttab[13] = "MCQ";
  exttab[14] = "MC";
  
  extptr1 = string;
  
  for (source = 0; source < 19; ++source)
   {
      if (!strcmp(extptr1, exttab[source]))
         break;
   }
  
   if (source >= 19)
     {
       qqfactor = atoi(string);
       if (qqfactor <= 0 || qqfactor > 255)
          return(BAD_COMMAND);
       return(OK);
     }
  
    switch (source)
      {
         case  0:
               format = FILE_SAVE_JFIF411;
               qqfactor = 5;
               break;
  
         case  1:
               format = FILE_SAVE_JFIF422;
               qqfactor = 5;
               break;

         case  2:
               format = JFIF;
               qqfactor = 5;
               break;

         case  3:
               format = FILE_SAVE_JTIF411;
               qqfactor = 5;
               break;
  
         case  4:
               format = FILE_SAVE_JTIF422;
               qqfactor = 5;
               break;

         case  5:
               format = JTIF;
               qqfactor = 5;
               break;

         case  6:
               qqfactor = PQ1;
               break;
  
         case  7:
               qqfactor = PQ2;
               break;
  
         case  8:
               qqfactor = QFS;
               break;
  
         case  9:
               qqfactor = QMS;
               break;
  
         case  10:
               qqfactor = QS;
               break;
  
         case  11:
               qqfactor = SQS;
               break;
  
         case  12:
               qqfactor = SQT;
               break;
  
         case  13:
               qqfactor = MCQ;
               break;
  
         case  14:
               qqfactor = MC;
               break;
  
        default:
               ret = BAD_COMMAND;
               break;
      }
  
  return(ret);
}

L_VOID Copyright( L_VOID )
{
  printf("                    LEADTOOLS DOS EVALUATION copy V 2.2\n");
  printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
  printf("                    900 Baxter Street\n");
  printf("                    Charlotte NC 28204\n");
  printf("                    tel# (704) 332-5532\n\n");
#if defined(FOR_386)
  printf("\nDOS32 - File to file software compression utility Version 1.2\n\n");
#else
  printf("\nDOS - File to file software compression utility Version 5.0\n");
  printf("\nThis version has a limit of image width not to exceed 1500 pixels.\n");
#endif
}

L_VOID USAGE( L_VOID )
{  
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
  Copyright();
  printf("USAGE: SCF2F <source file> <target file> [/option1] [/option2] \n");
  printf("<source file> is any TGA, GIF, PCX, TIF, or BMP\n");
  printf("<target file> is any DOS file name\n");
  printf("\nPress any key to continue.");
  L_SleepKey(99);
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
  printf("[option1] /L2JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:2:2)\n");
  printf("          /L1JFIF (LEAD JFIF LEAD JPEG Interchange File Format 4:1:1)\n");
  printf("          /JFIF (JFIF JPEG Interchange File Format)\n");
  printf("          /L2JTIF (LEAD JTIF JPEG TIF 4:2:2)\n");
  printf("          /L1JTIF (LEAD JTIF JPEG TIF 4:1:1)\n");
  printf("          /JTIF (JTIF JPEG TIF)\n");
  printf("[option2] /# any number from 2 to 255\n");
  printf("          or the following options for LEAD compression only\n");
  printf("          /PQ1  default LEAD Perfect Quality compression option1\n");
  printf("          /PQ2  default LEAD Perfect Quality compression option2\n");
  printf("          /QFS LEAD Quality by far more important than Size\n");
  printf("          /QMS LEAD Quality more important than Size\n");
  printf("          /QS  LEAD Quality and Size are equally Important\n");
  printf("          /SQS LEAD Size more important than Quality sharp\n");
  printf("          /SQT LEAD Size more important than Quality less Tiling\n");
  printf("          /MCQ LEAD Maximum Compression, keep Quality as good as possible\n");
  printf("\nExample:  SCF2F *.TGA *.cmp /PQ2  \n");
  printf("\nwill compress all TGA files to LEAD at LEAD Perfect Quality compression option2.\n");
  printf("\nPress any key to continue.\n");
  L_SleepKey(99);
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
}


get_outfilename(from_file, as_file, to_file)
L_CHAR from_file[], as_file[], to_file[];
{
  L_CHAR ext1[120], name1[128], ext2[120], name2[128];
  L_INT i, q, j, ext1_flag = 0, ext2_flag = 0;
  L_INT x, x1;
  
  ext1[0] = 0, ext2[0] = 0, name1[0] = 0, name2[0] = 0;
  for (i = strlen(from_file)-1; i >= 0; i--)
    if (from_file[i] == '.' && from_file[i+1] != '.' && from_file[i-1] != '.')
     {
         ext1_flag = 1;
         break;
      }
  
  strcpy(name1, from_file);
  name1[i] = 0;
  if (ext1_flag == 1)
    strcpy(ext1, from_file+i+1);
  for (i = strlen(as_file)-1; i >= 0; i--)
    if (as_file[i] == '.' && as_file[i+1] != '.' && as_file[i-1] != '.')
     {
        ext2_flag = 1;
        break;
     }
  
  strcpy(name2, as_file);
  name2[i] = 0;
  if (ext2_flag == 1)
     strcpy(ext2, as_file+i+1);
  
  for (i = 0, q = 0; i < strlen(name2); i++)
      {
       if (name2[i] == '*')
           {
           to_file[i] = 0;
           strcat(to_file+i, name1);
           i = i + strlen(name1+q);
           goto exit0;
           }
       if (name2[i] == '?')
          {
          to_file[i] = name1[i];
          q++;
          } 
       else
          to_file[i] = name2[i];
      }
  
   to_file[i] = 0;
   exit0:
  
   to_file[i] = '.';
   i++;
   for (j = 0, q = 0; j < strlen(ext2); i++, j++)
    {
       if (ext2[j] == '*')
        {
           to_file[i] = 0;
           strcat(to_file, ext1+q);
           return(0);
        }
       if (name2[i] == '?')
          {
          to_file[i] = ext1[j];
          q++;
          } 
       else
          to_file[i] = ext2[j];
    }
    to_file[i] = 0;
    if(to_file[i-1] == '.')
       to_file[i-1] = 0;
  
  return(0);
}
  


  
find_wildletter(string)
L_CHAR string[];
{
  L_INT i;
  
  for (i = 0; i < strlen(string); i++)
   if (string[i] == '*')
         return(1);
  
  return(0);
}


get_pathname(in, pathname)
L_CHAR in[], pathname[];
{
  L_INT i;

  strcpy(pathname, in);
  for (i = strlen(in)-1; i >= 0; i--)
    {
       if (in[i] == '\\' || in[i] == ':')
          break;
    }

  if (i == 0)
     pathname[0] = 0;
  else
     pathname[i+1] = 0;
}



