#include <stdio.h>
#include <dos.h>
#include "..\include\L_Bitmap.h"
#include "..\include\L_error.h"

#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2

#if __BORLANDC__
    extern unsigned _stklen = 13000U;
#endif

L_VOID USAGE( L_VOID );
L_VOID Copyright( L_VOID );

L_INT get_value(L_CHAR *string);

L_INT format = FILE_TGA;
L_INT bits = 24;

main(L_INT argc, L_CHAR *argv[])
{
  FILEINFO FileInformation;
  struct find_t file;
  L_INT result;
  L_INT i;
  L_CHAR string[256];
  L_INT error;
  L_CHAR outfile[128], infile[128], pathname[128];
  L_INT wild_flag = 0;
  L_CHAR path[200];
  BITMAPHANDLE CompBitmap; /* A Bitmap used to decompress to 8bit formats */

#if !defined(FOR_386)
  L_RegisterReadJTIF();
  L_RegisterReadJFIF();
  L_RegisterReadCMP();
  L_RegisterWriteBMP();
  L_RegisterWriteGIF();
  L_RegisterWritePCX();
  L_RegisterWriteTGA();
  L_RegisterWriteTIF();
#endif

  strcpy(path, argv[0]);

  for (i = strlen(path)-1; i > 0; i--)
  {
     if (path[i] == '\\' || path[i] == ':')
        break;
  }
  path[i+1] = 0;
  i=0;

  if(argc<=2)
  {
     USAGE();
     if(argc==1)
        printf("Error: No <source file> Or <target file> Specified");
     else
        printf("Error: No <target file> Specified");
     exit(0);
  }
  else if(argv[1][0]=='/')
  {
     printf("Error: Bad source file %s",argv[1]);
     exit(0);
  }
  else if(argv[2][0]=='/')
  {
     printf("Error: Bad source file %s",argv[1]);
     exit(0);
  }
  
  strupr(argv[1]);
  strupr(argv[2]);
  
  if ( find_wildletter(argv[1]) == 1)
  {
     if (find_wildletter(argv[2]) == 1)
        wild_flag = 1;
  }
  
  for (i = 3; i<=argc; i++)
  {
     strupr(argv[i]);
     if(argv[i][0]=='/')
        if(get_value(argv[i]+1)==BAD_COMMAND)
        {
           USAGE();
           if(argc==1)
              printf("Error: No <source file> And <target file> Specified");
           else
              printf("Error: No <target file> Specified");
  
           printf("\nInvalid Option %s",argv[i]);
           exit(0);
        }
  }
  
  
  get_pathname(argv[1], pathname);
  result = _dos_findfirst(argv[1], 0 , &file);
            /* _dos_findfirst will return a 0 if succesfull */
            /*   and any other value if not       */
  
  if (result)   /* if result has any value rather that 0 then  */
                /* False = 0    True= any other value */
                /* and when the function is succesful it return a 0 */
     printf("Error: No Such File %s.\n",argv[1]);
  else
  {
     while(!result)  /* Stop when _dos_findnext returns */
                     /*   a value other than a 0        */
                     /* becuse False =0 and when the
                     /* function is succesful it returns a 0) */
     {
        strcpy(infile, pathname);
        strcat(infile, file.name);
        if (L_FileInfo(infile,&FileInformation)==SUCCESS)
        {
           if (wild_flag == 1)
              get_outfilename(file.name, argv[2], outfile);
           else
              strcpy(outfile, argv[2]);

           Copyright();
           error=L_FileConvert( infile, outfile, format, 0, 0, bits );
       
           if(error<SUCCESS)
           {
              Copyright();
              printf("\nError %d Returned Decompressing Image File %s.\n",error,file.name);
           }
           else
              printf("\nImage File %s Decompressed Successfully.\n",file.name);
        }
        else
        {
           printf("\nError: Unable To Open File %s, Or The Format Is Invalid/Un-Registered.\n",file.name);
           putch(7);
        }
        result = _dos_findnext(&file);
     }   
  }
  exit(0);
}
  
L_VOID Copyright( L_VOID )
{
  printf("                    LEADTOOLS DOS EVALUATION copy V 2.2\n");
  printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
  printf("                    900 Baxter Street\n");
  printf("                    Charlotte NC 28204\n");
  printf("                    tel# (704) 332-5532\n\n");
#if defined(FOR_386)
  printf("\nDOS32 - File to file software decompresion utility Version 1.2\n");
#else
  printf("\nDOS - File to file software decompresion utility Version 5.0\n");
  printf("\nThis version has a limit of image width not to exceed 1500 pixels.\n");
#endif
}

L_VOID USAGE( L_VOID )
{  
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
  Copyright();
  printf("USAGE: SDF2F <source file> <target file> [/option1]\n");
  printf("<source file> is any LEAD, JFIF, or JTIF compressed file formats\n");
  printf("<target file> is any DOS file name\n");
  printf("\nPress any key to continue.");
  L_SleepKey(99);
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
  printf("[option1] /BMP1 decompress to 1bit black and white Windows BMP.\n");
  printf("          /BMP4 decompress to 4bit color mapped Windows BMP.\n");
  printf("          /BMP8 decompress to 8bit color mapped Windows BMP.\n");
  printf("          /BMP24 decompress to 24bit Windows BMP.\n");
  printf("          /GIF decompress to 8bit color mapped GIF.\n");
  printf("          /OS21 decompress to 1bit black and white OS/2 BMP.\n");
  printf("          /OS24 decompress to 4bit color mapped OS/2 BMP.\n");
  printf("          /OS28 decompress to 8bit color mapped OS/2 BMP.\n");
  printf("          /OS224 decompress to 24bit OS/2 BMP.\n");
  printf("          /PCX1 decompress to 1bit black and white PCX.\n");
  printf("          /PCX4 decompress to 4bit color mapped PCX.\n");
  printf("          /PCX8 decompress to 8bit color mapped PCX.\n");
  printf("          /PCX24 decompress to 24bit PCX.\n");
  printf("          /TGA8 decompress to 8bit color mapped TGA.\n");
  printf("          /TGA16 decompress to 16bit TGA.\n");
  printf("          default /TGA24 decompress to 24bit TGA.\n");
  printf("          /TGA32 decompress to 32bit TGA.\n");
  printf("          /TIF8 decompress to 8bit color mapped TIF.\n");
  printf("          /TIF16 decompress to 16bit TIF.\n");
  printf("          /TIF24 decompress to 24bit TIF.\n");
  printf("\n    This option is CASE SENSITIVE!     Press any key to continue.");
  L_SleepKey(99);
  L_ClearVGAScreen();
  L_SetVideoMode( 3, 0 );
  printf("DOS wildcards are also supported for <source file> and <target file>\n");
  printf("\nExample: SDF2F *.cmp *.TGA /TGA24\n");
  printf("\nwill decompress all cmp files to 24bit TGA files.\n");
  printf("\nPress any key to continue.\n");
  L_SleepKey(99);
}  
  
L_INT get_value(L_CHAR *string)
{
  L_INT ret=OK;

  if( string[0] == 'T' && string[1] == 'G' && string[2] == 'A' )
     format=FILE_TGA;
  else if( string[0] == 'T' && string[1] == 'I' && string[2] == 'F' )
     format=FILE_TIF;
  else if( string[0] == 'B' && string[1] == 'M' && string[2] == 'P' )
     format=FILE_BMP;
  else if( string[0] == 'O' && string[1] == 'S' && string[2] == '2' )
     format=FILE_OS2;
  else if( string[0] == 'P' && string[1] == 'C' && string[2] == 'X' )
     format=FILE_PCX;
  else if( string[0] == 'G' && string[1] == 'I' && string[2] == 'F' )
     format=FILE_GIF;
  else
     ret = BAD_COMMAND;
  
  if( string[3] == '1' && string[4] == '6' )
     bits=16;
  else if( string[3] == '1' )
     bits=1;
  else if( string[3] == '4' )
     bits=4;
  else if( string[3] == '8' )
     bits=8;
  else if( string[3] == '2' && string[4] == '4' )
     bits=24;
  else if( string[3] == '3' && string[4] == '2' )
     bits=32;
  else
     ret = BAD_COMMAND;

return(ret);
}



get_outfilename(from_file, as_file, to_file)
L_CHAR from_file[], as_file[], to_file[];
{
  L_CHAR ext1[20], name1[128], ext2[20], name2[128];
  L_INT i, q, j, ext1_flag = 0, ext2_flag = 0;
  L_INT x, x1;
  
  ext1[0] = 0, ext2[0] = 0, name1[0] = 0, name2[0] = 0;
  for (i = strlen(from_file)-1; i >= 0; i--)
    if (from_file[i] == '.' && from_file[i+1] != '.' && from_file[i-1] != '.')
     {
         ext1_flag = 1;
         break;
      }
  
  strcpy(name1, from_file);
  name1[i] = 0;
  if (ext1_flag == 1)
    strcpy(ext1, from_file+i+1);
  for (i = strlen(as_file)-1; i >= 0; i--)
    if (as_file[i] == '.' && as_file[i+1] != '.' && as_file[i-1] != '.')
     {
        ext2_flag = 1;
        break;
     }
  
  strcpy(name2, as_file);
  name2[i] = 0;
  if (ext2_flag == 1)
     strcpy(ext2, as_file+i+1);
  
  for (i = 0, q = 0; i < strlen(name2); i++)
      {
       if (name2[i] == '*')
           {
           to_file[i] = 0;
           strcat(to_file+i, name1);
           i = i + strlen(name1+q);
           goto exit0;
           }
       if (name2[i] == '?')
          {
          to_file[i] = name1[i];
          q++;
          } 
       else
          to_file[i] = name2[i];
      }
  
   to_file[i] = 0;
   exit0:
  
   to_file[i] = '.';
   i++;
   for (j = 0, q = 0; j < strlen(ext2); i++, j++)
    {
       if (ext2[j] == '*')
        {
           to_file[i] = 0;
           strcat(to_file, ext1+q);
           return(0);
        }
       if (name2[i] == '?')
          {
          to_file[i] = ext1[j];
          q++;
          } 
       else
          to_file[i] = ext2[j];
    }
    to_file[i] = 0;
    if(to_file[i-1] == '.')
       to_file[i-1] = 0;
  
  return(0);
}
  

find_wildletter(string)
L_CHAR string[];
{
L_INT i;

for (i = 0; i < strlen(string); i++)
    if (string[i] == '*')
       return(1);

return(0);
}

get_pathname(in, pathname)
L_CHAR in[], pathname[];
{
L_INT i;

strcpy(pathname, in);

for (i = strlen(in)-1; i >= 0; i--)
    {
    if (in[i] == '\\' || in[i] == ':')
       break;
    }

if (i == 0)
   pathname[0] = 0;
else
   pathname[i+1] = 0;
}



