#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <fcntl.h>
#include <ctype.h> 
#include <conio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "..\include\L_Bitmap.h"
#include "..\include\L_error.h"

#define OK 1
#define BAD_COMMAND -2
#define TARGAOLD 1
#define VGA   2

void USAGE( void );
void COPYRIGHT( void );

int mode,page;
char screen[4000];
int curcolumn, currow;
int Width=0,Height=0,Xorigin=-1,Yorigin=-1;
int time=999;
int video=VGA;
int device_bits;
char infile[400];
extern int L_RGB_flag; /* Not Needed but some cards are set as RGB in 24bit mode */
extern int L_BGR_flag; /* and BGR in 16-bit mode */
void getfilename(char * name);
void get_pathname(char *in, char *pathname);
int get_value(char *string);


void main(int argc, char *argv[])
{
  FILE *Stream;
  FILEINFO FileInformation;
  char command[400], commandln[400];
  char path[200];
  char string[400], pathname[400];
  struct find_t file;
  int result;
  int i;
  int lines=0;
  int error;
  int first_option = 0;
  int position, position1, kk;

  strcpy(path, argv[0]);

  L_RegisterReadCMP();
  L_RegisterReadJFIF();
  L_RegisterReadJTIF();
  L_RegisterDitherForLoadAndSave();
  L_RegisterResizeForLoad();

  for (i = strlen(path)-1; i > 0; i--)
  {
     if (path[i] == '\\' || path[i] == ':')
        break;
  }
  path[i+1] = 0;
  i=0;



  L_GetVideoMode(&mode,&page);
  if(mode == 3)
   {
     L_SaveWindow(0,0,79,24,screen,&curcolumn,&currow);
   }

  if(argc<=1)
  {
     USAGE();
     exit(0);
  }


  strcpy(string,argv[1]);
  get_pathname(argv[1], pathname);

  L_SetVideoMode(mode,page);
  L_SetVGASize(SIZE_640x480);

  if(argv[1][0]=='@')
  {
     i=0;
     while(string[i])
     {
        pathname[i]=string[i+1];
        i++;
     }
     pathname[i]= '\0';
     if(Stream=fopen(pathname,"r"))
     {
        while(fgets(commandln, 400, Stream) != NULL)
        {
           Width = 0; Height = 0;
           Xorigin = 0; Yorigin = 0;
           first_option = 0;
           position = 0;
           while(sscanf(commandln+position,"%s",command)!=EOF)
           {
              position1 = strlen(command);
              if( (position1 == 0) || (command[0]=='#') )
                 break;
              position = position + position1;
              strupr(command);
              if(command[0]=='/')
              {
                 get_value(command+1);
                 first_option = 1;
              }
              else if (first_option == 0)
              {
                 strcpy(infile,command);
                 getfilename(infile);
                 first_option = 1;
              }
              else
              {
                 L_SetVideoMode(mode,page);
                 printf("Error: invalid macro line %s\n",commandln);
                 L_SleepKey(5);
                 if(mode == 3)
                    L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
                 exit(0);
              }
              for (kk = position; kk < strlen(commandln); kk++)
              {
                 if (commandln[kk] == 0x0d || commandln[kk] == 0x0a)
                 {
                    position1 = 0;
                    break;
                 }

                 if (commandln[kk] > 32)
                    break;
              }

              position = kk;
              if (position1 == 0)
                 break;
           }
           if(infile[0]!='\0')
           {
              error=L_ViewRScreen(infile,Width,Height,Xorigin,Yorigin);

              if( error < SUCCESS )
              {
                 L_SetVideoMode(mode,page);
                 printf("The file %s is an invalid file format or not found\n",infile);
                 L_SleepKey(2);
              }
              else if( (time>1) )
                 L_SleepKey(time);
           }
           time=0;
           infile[0]='\0';
        }/*end while reading*/
        L_SetVideoMode(mode,page);
        L_SleepKey(5);
        if(mode == 3)
           L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
        exit(0);
     }/*if*/
     else
     {
        L_SetVideoMode(mode,page);
        printf("Error: could not open macro file %s\n",pathname);
        L_SleepKey(5);
        if(mode == 3)
           L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
        exit(0);
     }
  }
  else
  {
     for (i = 2; i<=argc; i++)
     {
        strupr(argv[i]);
        if(argv[i][0]=='/')
           if(get_value(&argv[i][1])==BAD_COMMAND)
           {
              USAGE();
              exit(0);
           }/* end if getvalue*/
     }/*end for*/

     L_GetVideoDeviceBits(&device_bits);

     result = _dos_findfirst(argv[1], 0 , &file);
     if (result)   /* if result has any value rather than 0 */
     {
        L_SetVideoMode(mode,page);
        printf("SHOWCOMP: No Such File %s.\n",argv[1]);
        L_SleepKey(3);
     }
     else
     {
        while(!result)  /* Stop when _dos_findnext returns */
        {
           strcpy(infile, pathname);
           strcat(infile, file.name);
           if(video==VGA)
           {
              error=L_ViewRScreen(infile,Width,Height,Xorigin,Yorigin);
           
              if (error < SUCCESS)
              {
                 L_SetVideoMode(mode,page);
                 COPYRIGHT();
                 printf("Error %d Viewing Image File %s.\n",error,file.name);
                 L_SleepKey(3);
              }
             else if( (time>1) )
                 L_SleepKey(time);

           }
           else if(video==TARGAOLD)
           {
              L_SetVideoMode(mode,page);
              COPYRIGHT();
              error=L_ViewRScreen(infile,0,0,Xorigin,Yorigin);
           
              if (error < SUCCESS)
              {
                 L_SetVideoMode(mode,page);
                 COPYRIGHT();
                 printf("Error %d Viewing Image File %s.\n",error,file.name);
                 L_SleepKey(3);
              }
              else if( (time>1) )
                 L_SleepKey(time);

           }
           result = _dos_findnext(&file);
        }
     }
     L_SetVideoMode(mode,page);
     if(mode == 3)
        L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
  }/*else*/
exit(0);
}
 
void COPYRIGHT( void )
{
  printf("                    LEADTOOLS DOS EVALUATION copy V 2.2\n");
  printf("COPYRIGHT (C) LEAD Technologies, Inc. 1991,1992 ALL RIGHTS RESERVED.\n");
  printf("                    900 Baxter Street\n");
  printf("                    Charlotte NC 28204\n");
  printf("                    tel# (704) 332-5532\n\n");
  printf("\nDOS - File to screen software decompression utility Version 4.0\n");
}

void USAGE( void )
{
  COPYRIGHT();
  printf("\nThis version has a limit of image width not to exceed 1500 pixels.\n");
  printf("\nUSAGE: SHOWCOMP <@macro file name>\n");
  printf("or     SHOWCOMP <source file> [/option1] [/option2] [/option3] [/option4]\n");
  printf("                              [/option5] [/option6]\n\n");
  printf("<source file> is any LEAD, JFIF, or JTIF compressed file format.\n");
  printf("\nPress any key to continue.");
  L_SleepKey(99);
  L_SetVideoMode(mode,page);
  printf("[option1] /TA for TARGA+16, TARGA+32, TARGA+64\n");
  printf(" or       /V320  display to FAST SUPER VGA 320X200\n");
  printf("          /V640  display to FAST SUPER VGA 640X480\n");
  printf("          /V800  display to FAST SUPER VGA 800X600\n");
  printf("          /V1024 display to FAST SUPER VGA 1024X768\n");
  printf("          /VESA640  display to VESA VGA 640X480\n");
  printf("          /VESA800  display to VESA VGA 800X600\n");
  printf("          /VESA1024 display to VESA SUPER VGA 1024X768\n");
  printf("[option2] /W# the New Width of the image displayed on the screen\n");
  printf("[option3] /H# the New Height of the image displayed on the screen\n");
  printf("[option4] /T# number of seconds to keep image displayed on the screen\n");
  printf("[option5] /X# the X (horizontal) position of the image displayed on the screen\n");
  printf("[option6] /Y# the Y (vertical) position of the image displayed on the screen\n");
  printf("[option7] /RV Revese the default color order from RGB to BGR.\n");
  printf("[option8] /8 force 8-bit mode. Use only if Hi color DAC is not installed.\n\n");
  printf("Example: SHOWCOMP *.* /W300 /H200 /T4 /X20 /Y20\n");
  printf("\nwill display all image files to the VGA/SuperVGA screen at the best resolution\n");
  printf("for the selected image file.\n");
  printf("\nPress any key to continue.");
  L_SleepKey(99);
  L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
} 
 
int get_value(char *string)
{
  int ret=OK;

  if (string[0] == 'X')
  {
     Xorigin = atoi(string+1);
     if (Xorigin < 0 || Xorigin > 1024)
        return(BAD_COMMAND);
     else
        return(ret);
  }

  if (string[0] == 'Y')
  {
     Yorigin = atoi(string+1);
     if (Yorigin < 0 || Yorigin > 1024)
        return(BAD_COMMAND);
     else
        return(ret);
  }

  if (string[0] == 'T' && string[1] != 'A')
  {
     time = atoi(string+1);
     if (time < 0)
        return(BAD_COMMAND);
     else
        return(ret);
  }
 
  if (string[0] == 'w' || string[0] == 'W')
  {
     Width = atoi(string+1);
     if (Width < 0)
        return(BAD_COMMAND);
     else
        return(ret);
  }

  if (string[0] == 'h' || string[0] == 'H')
  {
     Height = atoi(string+1);
     if (Height < 0)
        return(BAD_COMMAND);
     else
        return(ret);
  }

  if (string[0] == 'T' && string[1] == 'A')
  {
     video=TARGAOLD;
     if(L_TARGAInit()==0)
      {
         printf("TARGA+ Initialization error\n\n");
         L_SleepKey(5);
         L_RestoreWindow(0,0,79,24,screen,curcolumn,currow);
         exit(0);
      }
  }

  if(string[0] == 'V')
  {
     video=VGA;
     if(strstr(string,"V320"))
     {
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_320x200);
     }  
     else if(strstr(string,"V640"))
     {
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_640x480);
     }  
     else if(strstr(string,"V800"))
     {
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_800x600);
     }  
     else if(strstr(string,"V1024"))
     {
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_1024x768);
     }
     else if(strstr(string,"VESA640"))
     {
        L_SetVESA(1); 
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_640x480);
     }
     else if(strstr(string,"VESA800"))
     {
        L_SetVESA(1); 
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_800x600);
     }
     else if(strstr(string,"VESA1024"))
     {
        L_SetVESA(1); 
        L_SetVideoMode(mode,page);
        L_SetVGASize(SIZE_1024x768);
     }
  }

  /*Reverse Color Order*/
  if( ((string[0] == 'R') || (string[0] == 'r'))  &&  ((string[1] == 'V') || (string[1] == 'v')) )
  {
     if(L_RGB_flag == 0) /** BGR **/
     {
        L_RGB_flag = 1;
        L_BGR_flag = 0;
     }
     else
     {
        L_BGR_flag = 1;
        L_RGB_flag = 0;
     }
  }

 /* Force 8-bit mode if you have a problem you may combine this option with
    VESA */
  if(string[0] == '8')
     L_SetVideoTrueColor(0);

  return(ret);
}



void get_pathname(char in[], char pathname[])
{
 int i;
 
 strcpy(pathname, in);
 for (i = strlen(in)-1; i >= 0; i--)
 {
    if( (in[i] == '\\') || (in[i] == ':') )
       break;
 }

 if (i == 0)
    pathname[0] = 0;
 else
    pathname[i+1] = 0;
}


void getfilename(char * name)
{
  int i=0;

  while(name[i]!=' ')
     i++;

  name[i]='\0';
}
