Following are the code fragments I use to create a two level deep menu.
The main dialog menu has a button whose feel function calls a sub menu.  
This system may be expanded to go as deep as you wish.  I've gone four 
menu levels deep without any problems.

The integer variable "menu" keeps track of which menu the user is currently 
on.  This is used to let ClientSiderAction know which viewports to draw,
and which not to.

While originally I used the same feel_ok and feel_canc functions for
multiple menus, caution led me to replicate the functions seperately
for each menu.  Menu 1.3de using feel_ok, menu 2.3de using feel_ok2, 
and so on.

/* IPAS program header text */

#include "jitter01.3de"
#include "jitter02.3de"

static int menu=1;

void ClientSliderAction(int code)
{
	if (menu==1) see_view( &DialogJ1[VIEWM1J1] );
	if (menu==2) see_view( &DialogJ2[VIEWM2J1] );
      
}
void feel_ok( Dialog *d, int mouse )
{
	if(mouse)
		if(!(press_button(d)))
			return;
	see_button(d);
	gfx_butup();
	dialog_done = 1;
	dlgResult = 1;
}
void feel_ok2( Dialog *d, int mouse )
{
	if(mouse)
		if(!(press_button(d)))
			return;
	see_button(d);
	gfx_butup();
	dialog_done = 1;
	dlgResult = 1;
}



/* Main menu button m1d1 feel function     */
/* Pressing this button calls the sub menu */
void feel_m1d1( Dialog *d, int mouse )
{
	if(mouse)
		if(!(press_button(d)))
			return;
	
	/* set slider action to menu 2, this menu */
	menu=2;

	button_in(d,15,4);
	button_out(d,15,4);

	/* menu2 RadSub, FeelSub, etc. */
	RadSub sub2_rad[] = {
	     60, feel_radio, &rad_m2[0], 0,
	     47, feel_radio, &rad_m2[0], 1,
	     45, feel_radio, &rad_m2[1], 0,
	     46, feel_radio, &rad_m2[1], 1,
	     -1, FNULL, NULL, -1
	}; 
	FeelSub sub2_feel[] = {
		BUT_OK,   feel_ok2,
		BUT_QUIT, feel_quit2,
		-1, FNULL
	};
	
	
	SlidSub sub2_slid[] = {
		SLIDM2D1,M2D1DOWN,M2D1UP,SLID_NUM,1,&slid2[1],
		SLIDM2E1,M2E1DOWN,M2E1UP,SLID_NUM,1,&slid2[2],
		SLIDM2D2,M2D2DOWN,M2D2UP,SLID_NUM,1,&slid2[3],
		SLIDM2E2,M2E2DOWN,M2E2UP,SLID_NUM,1,&slid2[4],
		-1,-1,-1,-1,-1,NULL
	};
       
	ready_dialog( Jitter2, NULL, NULL, NULL, sub2_feel, sub2_rad, NULL, sub2_slid );
	
	center_dialog( Jitter2 );
	save_under_dialog( Jitter2 );
	draw_dialog( Jitter2 );
	do_dialog( Jitter2, -1 );
	
	restore_under_dialog();
	
	gfx_butup();
	/* set menu to main menu */
	menu=1;
	see_view( &Jitter1[VIEWM1J1] );
	dialog_done = 0;
	dlgResult = 0;
} 


/* Main menu */
int ClientDoCustomDialog(void)
{
	char buf[32];
	int z;
	
	FeelSub main_feel[] = {
		BUT_QUIT, feel_quit,
		BUT_OK,   feel_ok,
		BUT_M1D1, feel_m1d1,
		BUT_M1X1, feel_m1x1,
		BUT_M1X2, feel_m1x2,
		BUT_M1X3, feel_m1x3,
		BUT_M1X4, feel_m1x4,
		BUT_M1X5, feel_m1x5,
		BUT_M1X5, feel_m1x6,
		-1, FNULL
	};
	ready_dialog( Jitter1, NULL, NULL, NULL, main_feel, main_rad, NULL, main_slid );

	center_dialog( Jitter1 );
	save_under_dialog( Jitter1 );
	draw_dialog( Jitter1 );

	do_dialog( Jitter1, -1 );
	restore_under_dialog();
...

}



