// --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//
//		CSTR.H
//		String Studio 1.2 - Header file for CSTR.CPP ( or CSTR.LIB )
//		03.july.1994
//		Denis CHEVRON, 1993, 1994
//		ALL RIGHTS RESERVED
//		You can distribute this file as long as you distribute
//		the full CSTR package ( not the CStr.CPP file! )
// --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//		Current implementation is for MFC.
//		CSTR.LIB was compiled with Visual C++ 1.5 under the Windows static large model
//		You must include "stdafx.h" before you include this file
//
// --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//
//
//			CONSTRUCTORS
//			Same as CString
//
//			INPUT
//			From ( long / ulong / int / double ( precision ) / CTime  )
//			FromCurrentTime( mask )
//			FromFileTime
//
//			OUTPUT
//			ToInt, ToUINT, ToLong, ToULong, ToFloat, ToDouble, ToTime
//
//			OPERATIONS
//			Trim : Trim, TrimBegin, TrimEnd
//			Find: Count
//			Extract/Insert: Extract, Insert, Delete, Replace
//			Operators: [] , GetBuffer                 
//
//			OTHERS
//			Blank, Replicate, AddLF, FirstUpper
//
//			NUMBERS
//			IsDigit, IsInRange, Round
//
//			INTERFACE
//			ToCtl, FromCtl, MB, CheckSize, CheckDirSize
//
//			FILES
//			ToFile, FromFile, ToIni, FromIni
// 
// --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef signed long SLong;

			class CStr : public CString
				{ 
				public:
					//  **************** These are contructors for non registred users only: *******************************
					//	If you' re a registered user and you have the CSTR.CPP file, delete or put comments for these lines
					CStr( void ); 
					CStr( const CString& stringSrc); 
					CStr( char ch, int nRepeat = 1);
					CStr( const char* psz); 
					CStr( const char* pch, int nLength); 
					//  **************** These are contructors for registred users only: *******************************
					//	If you' re a registered user and you have the CSTR.CPP file, uncomment these lines
					/*
					CStr( void ):  CString( ) {};														
					CStr( const CString& stringSrc): CString( stringSrc ) {};
					CStr( char ch, int nRepeat = 1): CString(ch, nRepeat ) {};
					CStr( const char* psz): CString( psz ) {};
					CStr( const char* pch, int nLength): CString( pch, nLength ) {};
					*/
					CString Trim( void );
				    CString TrimBegin( void );
					CString TrimEnd( void );
					unsigned int Count( LPCSTR szSubString );
		    		unsigned int Count( char szSubString );
					CString From( long data, int base = 10, LPCSTR szSeparator = ",");
					CString From( unsigned long data, int base = 10, LPCSTR szSeparator = ",");
					CString From( int data, int base = 10, LPCSTR szSeparator = ",");
					CString From( double data, int precision = 2, LPCSTR szSeparator = ",");
					CString From( CTime TimeValue, LPCSTR szFilter = "%m/%d/%y" );	// put %d/%m/%y if you' re french...
					CString FromCurrentTime( LPCSTR szFilter = "%m/%d/%y" ); // put %d/%m/%y if you' re french...
					CString FromFileTime( LPCSTR szFile, LPCSTR szFilter = "%m/%d/%y" );  // put %d/%m/%y if you' re french...
					signed int ToInt( void );
					UINT ToUINT( void );
					signed long ToLong( void );
					unsigned long ToULong( void );
					float ToFloat( void );
					double ToDouble( void );
					CTime ToTime( LPCSTR szFilter = "M/D/Y" ); // put D/M/Y if you' re french...
					CStr Delete( unsigned Pdebut = 0, unsigned Plongueur = 0 );
		      		CStr Replace( LPCSTR szOld, LPCSTR szNew = "" );
      		        CStr Replace( char szOld, char szNew  );
      		        CStr Insert( LPCSTR szSub, int Pos  = 0 );
					CStr Insert( char szSub, int Pos  = 0 );
					CStr Extract( int Pos = 1, LPCSTR szDelimit = "\t" ); 
					CStr Extract( int Pos, char szDelimit );
					char& operator[](int Index );
					virtual LPSTR CStr::GetBuffer( int size = 0);
					CStr Round( void );
					CStr FirstUpper( void );
      				CStr AddLF( void );                   
      				CStr Blank( void );
      				CStr Replicate( char cMotif = ' ', int iLen = 1 );
      				CStr CheckSize( int iLength = 255, BOOL bAddPoints = TRUE ); 
      				CStr CheckDirSize( int iLength = 60, BOOL bShift = TRUE );
      				BOOL IsDigit( void );
      				BOOL IsInRange( double dMini = 0, double dMaxi  = 100);
					CStr FromIni( LPCSTR szSection, LPCSTR szKey, LPCSTR szFile = NULL, int iSize = 512 );
					void ToIni( LPCSTR szSection, LPCSTR szKey, LPCSTR szFile = NULL );         
					CStr FromFile( LPCSTR szFile, BOOL bKeepString = FALSE, BOOL bAddPoints = TRUE );
					BOOL ToFile( LPCSTR szFile, BOOL bAppend = TRUE );
					void ToCtl( CWnd* pWnd, int iCtl, BOOL bAltMode = FALSE );
					CStr FromCtl( CWnd* pWnd, int iCtl );       
					int MB( CWnd* pWnd = NULL, LPCSTR szTitle = NULL, UINT mbType = MB_OK | MB_ICONINFORMATION );
					
				protected: /* don' t call these functions! */
					LPSTR TrimTout( LPSTR str );
					LPSTR TrimAuDebut( LPSTR str );
					LPSTR TrimALaFin( LPSTR str );
			    	void FromDouble( LPSTR pStr, double data, int precision );
					void szReplace( LPCSTR OldStr, LPCSTR NewStr = "" );
    	            char GarbageChar;                                           
    	            CStr NumberFormat( LPCSTR szSeparator = "," );
				};


