/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <limits.h>
#include <math.h>
#include <stdio.h>
#include <string.h>           //**** temp
#include "abm.h"
#include "explode.h"
#include "menu.h"

static  long   SQRT_LONG_MAX,
               SQR_LOGMAXDIAM;

int   nExplosions;
Explosion Explosions[MAXEXPLOSIONS];

HBITMAP  MExplosionBmps[NEXPLOSIONBMPS],
         SExplosionBmps[NEXPLOSIONBMPS];
int      //-- Missile explosions last approx. 59 cycles
         MLogDiams[NEXPLOSIONBMPS] = {234,660,1086,1512,1724,1299,973,0},
         MLogAdvs[NEXPLOSIONBMPS]  = { 85, 85,  64,  21, -21, -43,-43,0},
         MPhyDiams[NEXPLOSIONBMPS] = { 11, 31,  51,  71,  81,  61, 41,0},
         MPhyAdvs[NEXPLOSIONBMPS]  = {  4,  4,   3,   1,  -1,  -2, -2,0},
         //-- Scud and SmartBomb explosions last approx. 41 cycles
         SLogDiams[NEXPLOSIONBMPS] = {106,319,532,745,958,532,319,0},
         SLogAdvs[NEXPLOSIONBMPS]  = { 85, 85, 64, 21,-21,-43,-43,0},
         SPhyDiams[NEXPLOSIONBMPS] = {  5, 15, 25, 35, 45, 25, 15,0},
         SPhyAdvs[NEXPLOSIONBMPS]  = {  4,  4,  3,  1, -1, -2, -2,0},
         MaxMLogDiam,MaxSLogDiam;
         

void LoadExplosions(void)
{
  RECT  rect;
  HDC  hDCmem, hDCtmp;
  int  i;

  for (i=0; i<NEXPLOSIONBMPS; i++)  {
    MPhyDiams[i] = (int)((long)MLogDiams[i] * (long)client.right / (long)XLOG);
    MPhyAdvs[i]  = (int)((long)MLogAdvs[i]  * (long)client.right / (long)XLOG);
    SPhyDiams[i] = (int)((long)SLogDiams[i] * (long)client.right / (long)XLOG);
    SPhyAdvs[i]  = (int)((long)SLogAdvs[i]  * (long)client.right / (long)XLOG);
  }
  for (i=0; i<nExplosions; i++)  {
    Explosions[i].phyXc = (int)((long)Explosions[i].logXc *
                                (long)client.right / (long)XLOG);
    Explosions[i].phyYc = (int)((long)Explosions[i].logYc *
                                (long)client.bottom / (long)YLOG);
  }
  hDCtmp = GetDC(hWndMain);
  for (i=0; i<NEXPLOSIONBMPS; i++)  {
    MExplosionBmps[i] = CreateBitmap(MPhyDiams[i],MPhyDiams[i],
                                     GetDeviceCaps(hDCtmp,PLANES),
                                     GetDeviceCaps(hDCtmp,BITSPIXEL),
                                     NULL);
    SExplosionBmps[i] = CreateBitmap(SPhyDiams[i],SPhyDiams[i],
                                     GetDeviceCaps(hDCtmp,PLANES),
                                     GetDeviceCaps(hDCtmp,BITSPIXEL),
                                     NULL);
  }
  hDCmem = CreateCompatibleDC(hDCtmp);
  ReleaseDC(hWndMain,hDCtmp);

  SelectObject(hDCmem,GetStockObject(WHITE_PEN));
  SelectObject(hDCmem,GetStockObject(WHITE_BRUSH));   //-- for FloodFill()
  for (i=0; i<NEXPLOSIONBMPS; i++)  {
    SelectObject(hDCmem,MExplosionBmps[i]);
    SetRect(&rect,0,0,MPhyDiams[i],MPhyDiams[i]);
    FillRect(hDCmem,&rect,GetStockObject(BLACK_BRUSH));
    Arc(hDCmem, 0,0, MPhyDiams[i]-1,MPhyDiams[i]-1, 
                     MPhyDiams[i]/2,0, MPhyDiams[i]/2,0);
    if (filledExplosions)
      FloodFill(hDCmem,MPhyDiams[i]/2,MPhyDiams[i]/2,RGB(255,255,255));
    SelectObject(hDCmem,SExplosionBmps[i]);
    SetRect(&rect, 0,0, SPhyDiams[i],SPhyDiams[i]);
    FillRect(hDCmem,&rect,GetStockObject(BLACK_BRUSH));
    Arc(hDCmem, 0,0, SPhyDiams[i]-1,SPhyDiams[i]-1, 
                     SPhyDiams[i]/2,0, SPhyDiams[i]/2,0);
    if (filledExplosions)
      FloodFill(hDCmem,SPhyDiams[i]/2,SPhyDiams[i]/2,RGB(255,255,255));
  }
  DeleteDC(hDCmem);
}

int GetBiggestExplosion(void)
{
  int  i, biggest;

  for (biggest=i=0; MLogDiams[i]!=0; i++)
    if (MLogDiams[i] > biggest)
      biggest = MLogDiams[i];

  return biggest;
}

static long SquareRoot(long l)
{
  long  odd,count;

  for (odd=1,count=0; l>0; l-=odd,count++,odd+=2);
  return count;
}

void InitExplosions(void)
{
  int  i;

  nExplosions = 0;
  CheckMenuItem(GetMenu(hWndMain),IDM_OptsFillExpl,
                (filledExplosions) ? MF_CHECKED : MF_UNCHECKED);
  CheckMenuItem(GetMenu(hWndMain),IDM_OptsShowSBTracks,
                (explodeShowSBTracks) ? MF_CHECKED : MF_UNCHECKED);

  SQRT_LONG_MAX = SquareRoot(LONG_MAX);
  MaxMLogDiam = MaxSLogDiam = 0;
  for (i=0; i<NEXPLOSIONBMPS; i++)  {
    if (MLogDiams[i] > MaxMLogDiam)
      MaxMLogDiam = MLogDiams[i];
    if (SLogDiams[i] > MaxSLogDiam)
      MaxSLogDiam = SLogDiams[i];
  }
  SQR_LOGMAXDIAM = MaxMLogDiam * MaxMLogDiam;
}

void DeleteExplosions(void)
{
  int  i;
  
  for (i=0; i<NEXPLOSIONBMPS; i++)  {
    DeleteObject(MExplosionBmps[i]);
    DeleteObject(SExplosionBmps[i]);
  }
}

void NewExplosion(int x, int y, int type, HDC hDC)
{
  Explosion  *exp;

  if (nExplosions == MAXEXPLOSIONS)
    return;

  exp = &Explosions[nExplosions];
  nExplosions++;
  exp->phyXc = x;
  exp->phyYc = y;
  exp->logXc = (int)((long)x * (long)XLOG / (long)client.right);
  exp->logYc = (int)((long)y * (long)YLOG / (long)client.bottom);
  exp->currBmp = -1;
  if (type == MISSILE)  {
    exp->hBmps = MExplosionBmps;
    exp->logDiams = MLogDiams;
    exp->logAdvs = MLogAdvs;
    exp->phyDiams = MPhyDiams;
    exp->maxLogRad2 = MaxMLogDiam / 2;
    exp->maxLogRad2 *= exp->maxLogRad2;
  }
  else  {
    exp->hBmps = SExplosionBmps;
    exp->logDiams = SLogDiams;
    exp->logAdvs = SLogAdvs;
    exp->phyDiams = SPhyDiams;
    exp->maxLogRad2 = MaxSLogDiam / 2;
    exp->maxLogRad2 *= exp->maxLogRad2;
  }
  exp->logDiam = exp->logDiams[0];
  exp->logAdv = exp->logAdvs[0];
  
  AdvanceExplosions(hDC);
}

int AdvanceExplosions(HDC hDC)
{
  Explosion  *exp;
  HBITMAP  *hBmps;
  HDC  hDCmem;
  int  i,s, *logDiams,*logAdvs, *phyDiams;
  
  hDCmem = CreateCompatibleDC(hDC);
  exp = Explosions;
  for (i=0; i<nExplosions; i++,exp++)  {

    logAdvs = exp->logAdvs;
    logDiams = exp->logDiams;
    phyDiams = exp->phyDiams;
    hBmps = exp->hBmps;
    exp->logDiam += exp->logAdv;
    if (exp->logAdv > 0)  {
      if (exp->logDiam > logDiams[exp->currBmp+1])  {
        if (exp->currBmp != -1)  {
          SelectObject(hDCmem,hBmps[exp->currBmp]);
          s = phyDiams[exp->currBmp];
          BitBlt(hDC, exp->phyXc-s/2,exp->phyYc-s/2, s,s, 
                 hDCmem, 0,0,0x220326L);
        }
        exp->currBmp++;
        exp->logAdv = logAdvs[exp->currBmp];
        s = phyDiams[exp->currBmp];
        exp->phyRad2 = s / 2;
        exp->phyRad2 *= exp->phyRad2;
        SelectObject(hDCmem,hBmps[exp->currBmp]);
        BitBlt(hDC, exp->phyXc-s/2,exp->phyYc-s/2, s,s, 
               hDCmem, 0,0,SRCPAINT);
      }
    }
    else  {
      if (exp->logDiam < logDiams[exp->currBmp+1])  {
        if (exp->currBmp != -1)  {
          SelectObject(hDCmem,hBmps[exp->currBmp]);
          s = phyDiams[exp->currBmp];
          BitBlt(hDC, exp->phyXc-s/2,exp->phyYc-s/2, s,s, 
                 hDCmem, 0,0,0x220326L);
        }
        if (logDiams[exp->currBmp+1] == 0)  {
          nExplosions--;
          exp--;
          i--;
          if ((nExplosions != 0) && (i < nExplosions))
            Explosions[i+1] = Explosions[nExplosions];
          continue;
        }
        exp->currBmp++;
        exp->logAdv = logAdvs[exp->currBmp];
        s = phyDiams[exp->currBmp];
        exp->phyRad2 = s / 2;
        exp->phyRad2 *= exp->phyRad2;
        exp->maxLogRad2 = exp->logDiam / 2;
        exp->maxLogRad2 *= exp->maxLogRad2;
        SelectObject(hDCmem,hBmps[exp->currBmp]);
        BitBlt(hDC, exp->phyXc-s/2,exp->phyYc-s/2, s,s, 
               hDCmem, 0,0,SRCPAINT);
      }
    }
  }
  DeleteDC(hDCmem);

  return 0;
}

void PaintExplosions(HDC hDC)
{
  HBITMAP  *hBmps;
  HDC  hDCmem;
  int  i,s, *phyDiams;
  
  hDCmem = CreateCompatibleDC(hDC);
  for (i=nExplosions-1; i>=0; i--)  {
    phyDiams = Explosions[i].phyDiams;
    s = phyDiams[Explosions[i].currBmp];
    Explosions[i].phyRad2 = s / 2;
    Explosions[i].phyRad2 *= Explosions[i].phyRad2;
    hBmps = Explosions[i].hBmps;
    SelectObject(hDCmem,hBmps[Explosions[i].currBmp]);
    BitBlt(hDC, Explosions[i].phyXc-s/2,Explosions[i].phyYc-s/2, s,s,
           hDCmem, 0,0,SRCPAINT);
  }
  DeleteDC(hDCmem);
}

void EraseExplosions(HDC hDC)
{
  HBITMAP  *hBmps;
  HDC  hDCmem;
  int  i,s, *phyDiams;
  
  hDCmem = CreateCompatibleDC(hDC);
  for (i=nExplosions-1; i>=0; i--)  {
    phyDiams = Explosions[i].phyDiams;
    s = phyDiams[Explosions[i].currBmp];
    Explosions[i].phyRad2 = s / 2;
    Explosions[i].phyRad2 *= Explosions[i].phyRad2;
    hBmps = Explosions[i].hBmps;
    SelectObject(hDCmem,hBmps[Explosions[i].currBmp]);
    BitBlt(hDC, Explosions[i].phyXc-s/2,Explosions[i].phyYc-s/2, s,s, 
           hDCmem, 0,0,0x220326L);
  }
  DeleteDC(hDCmem);
}

/************************************************************************/
long CheckAgainstExplosion(int phyX, int phyY, int radius, HDC hDC)
{
  Explosion  *exp,*cExp;
  long  phydx,phydy, c,closest;
  int  i;

  if (explodeShowSBTracks)
    if (radius)
      SetPixel(hDC,phyX,phyY,RGB(0,255,0));
  exp = Explosions;
  for (cExp=NULL,closest=LONG_MAX,i=0; i<nExplosions; i++,exp++)  {
    phydx = abs(phyX - exp->phyXc);
    phydx *= phydx;
    phydy = abs(phyY - exp->phyYc);
    phydy *= phydy;
    c = phydx + phydy + radius;
    if (c < closest)  {
      closest = c;
      cExp = exp;
    }
  }
  if (cExp)
//****    return SquareRoot(labs(closest - cExp->phyRad2)) * ((closest > cExp->phyRad2) ? 1 : -1);
    return (closest - cExp->phyRad2);
  else
    return SQRT_LONG_MAX;
}
/************************************************************************/

int InsideExplosion(int phyX, int phyY, int radius)
{
  Explosion  *exp;
  long  phydx,phydy;
  int  i;

  exp = Explosions;
  for (i=0; i<nExplosions; i++,exp++)  {
    phydx = abs(phyX - exp->phyXc);
    phydx *= phydx;
    phydy = abs(phyY - exp->phyYc);
    phydy *= phydy;
    if ((phydx + phydy + radius) <= exp->phyRad2)
      return 1;
  }
  return 0;
}

int InsideExplosionLogMax(int logX, int logY, int logRad, HDC hDC)
{
  Explosion  *exp;
  long  logdx,logdy;
  int  i;

  hDC=hDC;
  if (explodeShowSBTracks)  {
    int  phyX,phyY;
    phyX = (int)((long)logX * (long)client.right / XLOG);
    phyY = (int)((long)logY * (long)client.bottom / YLOG);
    SetPixel(hDC,phyX,phyY,RGB(logX&255,255,logY&255));
  }

  exp = Explosions;
  for (i=0; i<nExplosions; i++,exp++)  {
    logdx = abs(logX - exp->logXc);
    logdx *= logdx;
    logdy = abs(logY - exp->logYc);
    logdy *= logdy;
    if ((logdx + logdy + logRad) <= exp->maxLogRad2)
      return 1;
  }
  return 0;
}

/**********************************************************************************
long InsideExplosion(int phyX, int phyY, int radius, HDC hDC)
{
  Explosion  *exp,*cExp;
  long  phydx,phydy, c,closest;
  int  i;

  if (explodeShowSBTracks)
    if (radius)
      SetPixel(hDC,phyX,phyY,RGB(0,255,0));
  exp = Explosions;
  for (cExp=NULL,closest=LONG_MAX,i=0; i<nExplosions; i++,exp++)  {
    phydx = abs(phyX - exp->phyXc);
    phydx *= phydx;
    phydy = abs(phyY - exp->phyYc);
    phydy *= phydy;
    c = phydx + phydy + radius;
    if (c < closest)  {
      closest = c;
      cExp = exp;
    }
  }
  if (cExp)
//****    return SquareRoot(labs(closest - cExp->phyRad2)) * ((closest > cExp->phyRad2) ? 1 : -1);
    return (closest - cExp->phyRad2);
  else
    return SQRT_LONG_MAX;
}
**********************************************************************************/

int GetExplosionsNear(int logX, int logY, int radius, Explosion **expAr)
{
  Explosion  *exp,**exp2;
  long  logdx,logdy;
  int   i;

  exp  = Explosions;
  exp2 = expAr;
  for (i=0; i<nExplosions; i++,exp++)  {
    logdx = abs(logX - exp->logXc);
    logdx *= logdx;
    logdy = abs(logY - exp->logYc);
    logdy *= logdy;
    if ((logdx + logdy + radius) <= SQR_LOGMAXDIAM)
      *exp2++ = exp;
  }

  return (exp2 != expAr);
}
