/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <math.h>
#include "abm.h"
#include "explode.h"
#include "missile.h"
#include "trail.h"

HANDLE   hBmpMissile;
int      nMissiles, bmpMissileW,bmpMissileH;
Missile  Missiles[MAXMISSILES];
int      MissileBase[3] = {1,5,9},
         BaseMissiles[3];


void LoadMissiles(void)
{
  Missile  *m;
  HBITMAP  hBmp;
  BITMAP  bmp;
  POINT  far *ptCurr, far *ptLast;
  HDC  hDCsrc,hDCdst;
  int  w,h, planes,bpp, i,j, dx,dy;

  //-- load and scale Missile bitmaps
  hBmpMissile = LoadBitmap(hInst,"BMP_Missile");
  GetObject(hBmpMissile,sizeof bmp,(LPSTR)&bmp);
  bmpMissileW = bmp.bmWidth;
  bmpMissileH = bmp.bmHeight;
  hDCsrc = GetDC(hWndMain);
  planes = GetDeviceCaps(hDCsrc,PLANES);
  bpp = GetDeviceCaps(hDCsrc,BITSPIXEL);
  hDCdst = CreateCompatibleDC(hDCsrc);
  ReleaseDC(hWndMain,hDCsrc);
  hDCsrc = CreateCompatibleDC(hDCdst);
  h = (int)((long)bmpMissileH * client.right / 640L);
  w = (int)((long)bmpMissileW * client.right / 640L);
  hBmp = CreateBitmap(w,h,planes,bpp,NULL);
  SelectObject(hDCsrc,hBmpMissile);
  SelectObject(hDCdst,hBmp);
  StretchBlt(hDCdst,0,0,w,h,
             hDCsrc,0,0,bmpMissileW,bmpMissileH, SRCCOPY);
  bmpMissileW = w;
  bmpMissileH = h;
  DeleteDC(hDCsrc);
  DeleteDC(hDCdst);
  DeleteObject(hBmpMissile);
  hBmpMissile = hBmp;

  //-- resize existing Missile trails
  for (i=0,m=Missiles; i<nMissiles; i++,m++)  {
    GlobalFree(m->pHandle);

    m->startPhy.x = (int)((long)m->startLog.x * client.right / XLOG);
    m->startPhy.y = (int)((long)m->startLog.y * client.bottom / YLOG);
    m->endPhy.x = (int)((long)m->endLog.x * client.right / XLOG);
    m->endPhy.y = (int)((long)m->endLog.y * client.bottom / YLOG);

    dx = abs(m->startPhy.x - m->endPhy.x);
    dy = abs(m->startPhy.y - m->endPhy.y);
    if (dx > dy)  {
      m->deltaBig = dx;
      m->deltaSmall = dy;
      m->xBig = 1;
      m->currPhy = (int)((long)m->currLog * client.right / XLOG);
    }
    else  {
      m->deltaBig = dy;
      m->deltaSmall = dx;
      m->xBig = 0;
      m->currPhy = (int)((long)m->currLog * client.bottom / YLOG);
    }
    m->nPointsPhy = m->deltaBig + 1;
    m->error = (int)(m->nPointsPhy / 2);
    m->xDir = (m->startPhy.x < m->endPhy.x) ? 1 : -1;
    m->yDir = (m->startPhy.y < m->endPhy.y) ? 1 : -1;
    m->pHandle = GlobalAlloc(GMEM_MOVEABLE,sizeof(POINT) * m->nPointsPhy);
    m->pointsPhy = (LPPOINT)GlobalLock(m->pHandle);
    m->pointsPhy[0] = m->startPhy;

    ptCurr = &m->pointsPhy[0];
    ptLast = ptCurr - 1;
    j = 0;
    if (m->xBig)  {
      while (j < m->currPhy)  {
        j++;
        if (j == m->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (m->error > 0)  {
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y;
          m->error -= m->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y + m->yDir;
          m->error += m->deltaBig - m->deltaSmall;
        }
      }
    }
    else  {
      while (j < m->currPhy)  {
        j++;
        if (j == m->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (m->error > 0)  {
          ptCurr->x = ptLast->x;
          ptCurr->y = ptLast->y + m->yDir;
          m->error -= m->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y + m->yDir;
          m->error += m->deltaBig - m->deltaSmall;
        }
      }
    }
  }
}

void DeleteMissiles(void)
{
  //-- Missile bitmap
  DeleteObject(hBmpMissile);
}

void InitMissiles(void)
{
  nMissiles = 0;
}

void FreeMissiles(void)
{
  for (nMissiles--; nMissiles>=0; nMissiles--)
    GlobalFree(Missiles[nMissiles].pHandle);

  nMissiles = 0;
}

int NewMissile(int mBase, POINT *pt)
{
  Missile  *m;
  int  i, dx,dy;

  if (nMissiles == MAXMISSILES)
    return -99;

  if (pt->y > (int)((long)client.bottom * 39 / 40 - 20))
    return -1;

  m = &Missiles[nMissiles];
  m->endPhy = *pt;
  if (mBase >= 0)    //-- key pressed
    i = mBase;
  else  {   //-- mouse pressed
    if (pt->x < (client.right / 3))  {
      if (BaseMissiles[0] > 0)
        i = 0;
      else  {
        if (BaseMissiles[1] > 0)
          i = 1;
        else  {
          if (BaseMissiles[2] > 0)
            i = 2;
          else  {
            MessageBeep(0);
            return -1;
          }
        }
      }
    }
    else  if (pt->x < (client.right * 2 / 3))  {
      if (BaseMissiles[1] > 0)
        i = 1;
      else  {
        i = (pt->x < (client.right / 2)) ? 0:2;
        if (BaseMissiles[i] == 0)  {
          i = (i == 0) ? 2:0;
          if (BaseMissiles[i] == 0)  {
            MessageBeep(0);
            return -1;
          }
        }
      }
    }
    else  {
      if (BaseMissiles[2] > 0)
        i = 2;
      else  {
        if (BaseMissiles[1] > 0)
          i = 1;
        else  {
          if (BaseMissiles[0] > 0)
            i = 0;
          else  {
            MessageBeep(0);
            return -1;
          }
        }
      }
    }
  }
  nMissiles++;
  BaseMissiles[i]--;
  m->startPhy.x = client.right * MissileBase[i] / 10;
  m->startPhy.y = (int)((long)client.bottom * 39 / 40 - 20);
  m->startLog.x = (int)((long)m->startPhy.x * XLOG / client.right);
  m->startLog.y = (int)((long)m->startPhy.y * YLOG / client.bottom);
  m->endLog.x = (int)((long)m->endPhy.x * XLOG / client.right);
  m->endLog.y = (int)((long)m->endPhy.y * YLOG / client.bottom);
  m->color = RGB(255,255,255);

  dx = abs(m->startPhy.x - m->endPhy.x);
  dy = abs(m->startPhy.y - m->endPhy.y);
  if (dx > dy)  {
    m->deltaBig = dx;
    m->deltaSmall = dy;
    m->xBig = 1;
  }
  else  {
    m->deltaBig = dy;
    m->deltaSmall = dx;
    m->xBig = 0;
  }
  m->nPointsPhy = m->deltaBig + 1;
  m->currPhy = -1;
  m->currLog = 0;
  if (i == 1)
    m->advLog = 270;
  else
    m->advLog = 245;
  m->error = (int)(m->nPointsPhy / 2);
  m->xDir = (m->startPhy.x < m->endPhy.x) ? 1 : -1;
  m->yDir = (m->startPhy.y < m->endPhy.y) ? 1 : -1;
  m->pHandle = GlobalAlloc(GMEM_MOVEABLE,sizeof(POINT) * m->nPointsPhy);
  m->pointsPhy = (LPPOINT)GlobalLock(m->pHandle);
  m->pointsPhy[0] = m->startPhy;

  return i;
}

int AdvanceMissiles(HDC hDC)
{
  POINT  far *ptCurr, far *ptLast;
  Missile  *m;
  long  adv;
  int  i;

  m = Missiles;
  for (i=0; i<nMissiles; i++,m++)  {
    if (m->currPhy == -1)  {
      SetPixel(hDC,m->pointsPhy[0].x,m->pointsPhy[0].y,m->color);
      m->currPhy = 0;
    }

    if (m->xBig)  {
      m->currLog += m->advLog;
      adv = m->currLog * client.right / XLOG;
      if (adv > m->nPointsPhy)
        adv = m->nPointsPhy;
      ptCurr = &m->pointsPhy[(int)m->currPhy];
      ptLast = ptCurr - 1;
      while (m->currPhy < adv)  {
        m->currPhy++;
        if (m->currPhy == m->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (m->error > 0)  {
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y;
          m->error -= m->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y + m->yDir;
          m->error += m->deltaBig - m->deltaSmall;
        }
        SetPixel(hDC,ptCurr->x,ptCurr->y,m->color);
      }
    }
    else  {
      m->currLog += m->advLog;
      adv = m->currLog * client.bottom / YLOG;
      if (adv > m->nPointsPhy)
        adv = m->nPointsPhy;
      ptCurr = &m->pointsPhy[(int)m->currPhy];
      ptLast = ptCurr - 1;
      while (m->currPhy < adv)  {
        m->currPhy++;
        if (m->currPhy == m->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (m->error > 0)  {
          ptCurr->x = ptLast->x;
          ptCurr->y = ptLast->y + m->yDir;
          m->error -= m->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + m->xDir;
          ptCurr->y = ptLast->y + m->yDir;
          m->error += m->deltaBig - m->deltaSmall;
        }
        SetPixel(hDC,ptCurr->x,ptCurr->y,m->color);
      }
    }

    if (m->currPhy == m->nPointsPhy)  {
      RemoveMissile(m,hDC);
      i--;
      m--;
    }
  }
  
  return 0;
}

void RemoveMissile(Missile *m, HDC hDC)
{
  while (NewTrail(m->pointsPhy,m->pHandle,(int)m->nPointsPhy) != 0)
    AdvanceTrails(hDC);

  NewExplosion(m->endPhy.x,m->endPhy.y,MISSILE,hDC);

  nMissiles--;
  if ((nMissiles) && (m != &Missiles[nMissiles]))
    *m = Missiles[nMissiles];
}

void PaintMissiles(HDC hDC)
{
  int  i,j;
  
  for (i=nMissiles-1; i>=0; i--)
    for (j=(int)Missiles[i].currPhy; j>=0; j--)
      SetPixel(hDC,Missiles[i].pointsPhy[j].x,Missiles[i].pointsPhy[j].y,
                   Missiles[i].color);
}
