/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <stdlib.h>
#include "abm.h"
#include "trail.h"

int    nTrails;
Trail  Trails[MAXTRAILS];


void InitTrails(void)
{
  nTrails = 0;
}

void FreeTrails(void)
{
  for (nTrails--; nTrails>=0; nTrails--)
    GlobalFree(Trails[nTrails].hMem);

  nTrails = 0;
}

int NewTrail(POINT far *pt, HANDLE hMem, int nPoints)
{
  if (nTrails == MAXTRAILS)
    return -99;
    
  Trails[nTrails].points = pt;
  Trails[nTrails].hMem = hMem;
  Trails[nTrails].nPoints = Trails[nTrails].nPointsCurr = nPoints;
  nTrails++;
  
  return 0;
}

void AdvanceTrails(HDC hDC)
{
  POINT  far *pt;
  int  i,j,k;

  while (nTrails)  {
    i = random(nTrails);
    pt = Trails[i].points;
    for (k=20; k>0; k--)  {
      j = random(Trails[i].nPoints);
      while (pt[j].x == -1)
        if (--j == -1)
          j = Trails[i].nPoints - 1;
      SetPixel(hDC,pt[j].x,pt[j].y,RGB(0,0,0));
      pt[j].x = -1;
      Trails[i].nPointsCurr--;
      if (Trails[i].nPointsCurr == 0)  {
        RemoveTrail(i);
        break;
      }
    }
    if (GetTickCount() > currTimer + 100)
      break;
  }
}

void RemoveTrail(int i)
{
  GlobalFree(Trails[i].hMem);
  nTrails--;
  if ((nTrails) && (i != nTrails))
    Trails[i] = Trails[nTrails];
}
