
; Copyright (c) 1994, UK, John M. Howells, All rights reserved

; program to clear the BIOS x87 co-processor flag - V1.0

; the program will *not* change the co-processor state if either
; Windows is running or if there is a Task Switcher, such as the
; DOS Shell, enabled, to minimze the risk of confusing programs.

	.model	tiny

	.data

no_copro_fnd	db	'No x87 math co-processor found$'
proc_clr	db	'BIOS x87 math co-processor flag CLEARED (Disabled)$'
win_tsw_run	db	'Windows or a Task Switcher running - no change$'
fp_status	dw	?

	.code

	org	100h			; start for COM program

start:

	; first check for the existence of an x87 co-processor

	fninit				; reset FP status word
	mov	fp_status,5a5ah		; initialize temp word to non-zero
	fnstsw	fp_status		; save FP status word
	mov	ax,fp_status		; check FP status word
	cmp	al,0			; see if correct status written
	jne	print_no_copro		; jump if not valid, no coprocessor

	fnstcw	fp_status		; save FP control word
	mov	ax,fp_status		; check FP control word
	and	ax,103fh		; see if selected parts look ok
	cmp	ax,3fh			; check that ones and zeros read ok
	jne	print_no_copro		; jump if not valid, no coprocessor

	; next check that neither Windows nor a Task Switcher is running.
	; the first two checks here are undocumented by Microsoft, but
	; appear to be the only way to check if Windows is running.

	mov	ax,352fh		; By the book get the Interrupt vector
	int	21h			; even if it's unlikely it is not set!
	mov	ax,es			; and check ..
	or	ax,bx			; .. if zero check for ndp, as no ..
	jz	ndp_ok			; .. MPX int means no task switcher

	mov	ax,1600h		; Windows 3.x Enhanced check
	int	2fh			; ask if Windows running in Enhanced
	and	al,07fh			; leave only the check bits needed
	jnz	print_wmess		; if non-zero then Windows running

	mov	ax,4680h		; Windows 3.x Real or Standard check ..
	int	2fh			; .. or DOSSHELL task switcher check
	or	ax,ax			; check return value
	jz	print_wmess		; if zero Windows is running

	mov	bx,0			; must be zero
	mov	di,0			; es:di ..
	mov	es,di			; .. must be zero
	mov	ax,04b02h		; Detect Switcher ..
	int	2Fh			; .. via Multiplex Interrupt
	mov	cx,es			; get es ..
	or	cx,di			; .. OR di
	jnz	print_wmess		; and if non-zero report switcher

ndp_ok:

	; neither Windows nor a task switcher is running and 
	; there is an x87 so clear the BIOS co-processor bit

	mov	ax, 0040H		; segment for BIOS data
	mov	es, ax			; to segment register
	and	byte ptr es:010H, 0FDH	; clear co-processor bit

	; report results and finish

	mov	dx, offset proc_clr	; offset of message
	mov	ah, 9			; to print
	int	21H			; and print it

	mov	ax, 4C00H		; set exit and status
	int	21H			; and quit program

print_no_copro:

	; print message saying no co-processor found

	mov	dx, offset no_copro_fnd	; offset of message
	mov	ah, 9			; to print
	int	21H			; and print it

	mov	ax, 4C01H		; set exit and status
	int	21H			; and quit program

print_wmess:

	; print message saying Windows or Task Switcher running

	mov	dx, offset win_tsw_run	; offset of message
	mov	ah, 9			; to print
	int	21H			; and print it

	mov	ax, 4C02H		; set exit and status
	int	21H			; and quit program

	end	start
