
; Copyright (c) 1994, UK, John M. Howells, All rights reserved

; program to report the status of the BIOS x87 co-processor flag

	.model	tiny

	.data

no_copro_fnd	db	'No x87 math co-processor found$'
copro_set	db	'BIOS x87 math co-processor flag SET (enabled)$'
copro_clr	db	'BIOS x87 math co-processor flag CLEAR (disabled)$'
fp_status	dw	?

	.code

	org	100h				; start for COM program

start:

        ; start by checking for the existence of an x87 co-processor

	fninit				; reset FP status word
	mov	fp_status,5a5ah		; initialize temp word to non-zero
	fnstsw	fp_status		; save FP status word
	mov	ax,fp_status		; check FP status word
	cmp	al,0			; see if correct status written
	jne	print_no_copro		; jump if not valid, no coprocessor

	fnstcw	fp_status		; save FP control word
	mov	ax,fp_status		; check FP control word
	and	ax,103fh		; see if selected parts look ok
	cmp	ax,3fh			; check that ones and zeros read ok
	jne	print_no_copro		; jump if not valid, no coprocessor

        ; okay - there is an x87 so check the BIOS co-processor bit

	mov	ax, 0040h		; segment for BIOS data
	mov	es, ax			; to segment register
	test	byte ptr es:010H, 002H	; test co-processor bit

	mov	dx, offset copro_clr	; assume co-processor bit clear
	jz	copro_print		; and no co-processor

	mov	dx, offset copro_set	; co-processor flag set

copro_print:

	; report results and finish

	mov	ah, 9			; to print
	int	21H			; and print it

	mov	ax, 4C00H		; set exit and status
	int	21H			; and quit program

print_no_copro:

	; print message saying no co-processor found

	mov	dx, offset no_copro_fnd	; offset of message
	mov	ah, 9			; to print
	int	21H			; and print it

	mov	ax, 4C01H		; set exit and status
	int	21H			; and quit program

	end	start
