
                /* Ŀ
                  Titus 2.0                             
                  KorrektSoftware                       
                                                        
                  (c)1991,94  Franz Posch jun.          
                  Gerating 5        Fax: 0861 / 4968    
                  D-83278 Traunstein                    
                                                        
                  Dokumentation:                        
                  Programmierer-Schnittstelle (API)     
                  fr C und C++                         
                 */




/* Ŀ
        Konstanten zur Fehlerbehandlung                                   
 */


typedef short RESULT; /* gibt den (Mi-)Erfolg einer Operation an.
                      RESULT = CORR_OK : Operation fehlerfrei durchgefhrt
                      RESULT # CORR_OK : Der Fehlertext kann mit der Funktion
                                         ErrorText() erfragt werden      */

const RESULT CORR_OK        =   0; /* Operation erfolgreich, immer mglich */
const RESULT CORR_MEMORY    =   1; /* zu wenig Speicher */
const RESULT CORR_UNK_WORD  =   4; /* unbekanntes Wort */                 
const RESULT CORR_NOT_DONE  =  10; /* noch nicht implementiert! */
const RESULT CORR_FULL      =  14; /* Kapazitt des Lexikons erschpft */
const RESULT CORR_CORRUPT   =  29; /* Datei hat ungltiges Format */
const RESULT CORR_UNREG     =  33; /* keine gltige Registrierungsnummer */
const RESULT CORR_NOT_FOUND =  43; /* Suchbegriff nicht gefunden */
const RESULT CORR_NOT_OPEN  =  46; /* kein zugehriges WBuch/Datenbank geffnet */
const RESULT CORR_ERR       =  48; /* unbekannter Fehler, immer mglich */
const RESULT CORR_COMPOUND  = 151; /* Fehlerhafte Wortzusammensetzung */
const RESULT CORR_WORD_WDH  = 152; /* Wortwiederholung */
const RESULT CORR_HYPH      = 153; /* Fehlerhafte Silbentrennung */
const RESULT CORR_TYPO      = 213; /* fehlerhafte Typografie */


const MAX_DICT              =   3; /* Maximale Anzahl der Wrterbcher je Typ (Sys/Usr) */
const MAX_HYPH              =  10; /* max. Anzahl von Silbentrennungen in 1 Wort */
const CORR_WORD_LEN         = 100; /* Maximale Lnge von Wrtern */       
const GRAM_WORD_LEN         =  30; /* Lnge der Grammatik-Info */
const TEXT_INFO_LEN         = 300; /* Lnge der Thesaurus-Info */


/* Ŀ
        Konstanten zu den Korrektureinstellungen                          
 */

const CORR_MANU_SCHNELL       = 1; /* Meldung, keine Auto-Vorschlge */
const CORR_MANU_VORSCHLAG     = 2; /* Meldung, autom. Vorschlge anbieten */
const CORR_AUTO_CORR          = 3; /* automatischer Korrekturdurchlauf */

/* Ŀ
        Datenstrukturen fr die nachfolgenden Funktionen                  
 */

/*
   Hinweise zu Strings: Alle Chars & Strings sind immer im Systemformat!
   - PC8-ASCII fr MS-DOS und OS/2
   - ANSI-ASCII fr Windows
*/

typedef char  NAME[CORR_WORD_LEN]; /* Dateiname inkl. Pfadangabe */
typedef char  GRAM[GRAM_WORD_LEN]; /* Grammatik-Info */
typedef NAME  NAME_REC[MAX_DICT];  /* Dateinamen-Record fr Lexika */
   /* Die 3 Namen der Systemwrterbcher; nicht benutzte WB's werden durch
   leere Strings angezeigt (Name[x,0] = 0C)) */                  
typedef char  TEXTINFO[TEXT_INFO_LEN]; /* Thesaurus-Infos */


typedef struct grWORD_LIST { /* Datensatz in korrigierter Wrterliste */
               NAME word;       /* gefundenes gltiges Wort */
               struct grWORD_LIST *next;   /* Zeiger auf nchsten Eintrag; Ende=NIL */
            } WORD_LIST;


enum MODE /* Die Stufen der Wortzusammensetzungen: */
{
     COMP_NO, /* Keine Zusammensetzungen prfen */
     COMP_I,  /* Nur sichere grammatische Z. erlauben */
     COMP_II, /* Meist regelmige Z. erlauben */
     COMP_III, /* Oft regelmige Z. erlauben */
     COMP_IV   /* COMP_III ohne Prfung auf Fugen-S */
};


extern "C" { // das wird alles Multi-Language programmiert!
	

/* Ŀ
        Funktionen in den Systemwrterbchern                             
 */

RESULT __far __pascal SysOpen(NAME_REC *names);
/* System-Wrternbcher ffnen

   Mgliche Ergebniswerte:
   CORR_NOT_OPEN : eine o. mehrere WB-Datei nicht gefunden; mit SysIsOpen()
                   feststellen, welche fehlgeschlagen ist!
   CORR_OK       : Operation durchgefhrt
*/

RESULT __far __pascal SysClose();
/* System-WB's schlieen; Mglicher Ergebniswert = CORR_OK */


RESULT __far __pascal SysIsOpen(short nr);
/* Gibt den Status des jeweiligen System-WB's an; nr = 0..MAX_DICT-1
   Mgliche Ergebniswerte:
   CORR_OK       : Wrterbuch ist geffnet
   CORR_NOT_OPEN : Wrterbuch ist nicht geffnet
*/


RESULT __far __pascal SysTestWord(NAME *word, GRAM *grammar, BOOL typo);
/* Prft, ob das Wort "word" existiert.
   - "typo" gibt an, ob auf die Typografie geachtet werden soll.
   - Wenn "typo = FALSE", dann wird nicht auf Gro-/Kleinschreibung geachtet.
   - Bei "typo = TRUE" darf der erste Buchstabe jeweils auch gro geschrieben
     werden (z.B. am Satzanfang).
   - Bei einer erfolgreichen Suche wird die originale Schreibweise des Wortes
     in "word" zurckgegeben.

   Mgliche Rckgabewerte:
   CORR_OK        : Wort gefunden
   CORR_UNK_WORD  : Wort nicht gefunden
*/



/* Ŀ
        Funktionen in den Benutzerwrterbchern                           
 */

RESULT __far __pascal UsrOpen(NAME_REC *names);
/* Benutzer-WB's ffnen; mgliche Rckgabewerte wie SysOpen */
/* Falls das WB nicht existiert, wird es erzeugt und initialisiert! */

RESULT __far __pascal UsrClose();
/* Alle Benutzer-WB's schlieen; Rckgabewert = CORR_OK */

RESULT __far __pascal UsrIsOpen(short nr);
/* Geibt Status von Benutzer-WB zurck; Rckgabewerte wie SysIsOpen */

RESULT __far __pascal UsrTestWord(NAME *word, GRAM *grammar, BOOL typo);
/* wie SysTestWord fr Worttest in Benutzerwrterbuch */

RESULT __far __pascal UsrAppendWord(short dict, NAME *word, GRAM *grammar);
/* Fgt Wort in Benutzerlexikon [dict] ein.
   Mgliche Rckgabewerte:
   CORR_OK       : Operation durchgefhrt
   CORR_FULL     : WB ist voll
   CORR_NOT_OPEN : kein WB fr Nummer [dict] geffnet
*/

RESULT __far __pascal UsrDeleteWord(short dict, NAME *word);
/* Lscht Wort in Benutzerwrterbuch [dict]
  Mgliche Rckgabewerte:
  CORR_OK        : Operation durchgefhrt
  CORR_NOT_FOUND : Wort nicht in WB gefunden
  CORR_NOT_OPEN  : kein WB fr Nummer [dict] geffnet
*/

RESULT __far __pascal UsrNextWord(short dict, BOOL reset, NAME *word, GRAM *grammar);
/* liest das nchste Wort aus dem Benutzerwrterbuch
   mgliche Rckgabewerte: wie UsrDeleteWord
   Nach dem letzten Eintrag wird der Code CORR_NOT_FOUND zurckgegeben

   dict  = Wrterbuch-Nummer 0..MAX_DICT-1;
   reset = Leseposition auf 0 zurcksetzen?
*/


/* Ŀ
        Thesaurus-Funktionen                                              
 */

RESULT __far __pascal ThesTestWord(NAME *file, NAME *word);
/* Prft, ob der Eintrag in der Datenbank enthalten ist. Gibt originale
   Schreibweise zurck. Mgliche Rckgabewerte: wie SysTestWord
*/

RESULT __far __pascal ThesGetEntry(NAME *file, NAME *word, TEXTINFO *info);
/* Gibt in "info" den Infotext zum Eintrag "word" zurck.
   Mgliche Rckgabewerte: wie SysTestWord
*/

RESULT __far __pascal ThesGetNextWord(NAME *file, NAME *word, NAME *next, BOOL init);
/* Gibt die nchste Erweiterung des Wortes "word" an; bei "init = TRUE"
   wird die erste Erweiterung zurckgegeben
   Mgliche Rckgabewerte: wie SysTestWord
*/



/* Ŀ
        Funktionen zur Silbentrennung                                     
 */

RESULT __far __pascal HyphTestWord(NAME *word, GRAM *grammar, NAME *hyph, BOOL nothyph);
/* Prfe, ob die Trennungen im Wort gltig sind. Die Datenbank-Trennungen
   werden aus der Grammar-Info geholt; die regelmigen werden z.T. aus der
   Datei TITUS.TDB geholt. Dieser Name ist fest vorgegeben.
   Mgliche Rckgabewerte:
   CORR_OK       : Nur gltige Trennungen im Wort
   CORR_HYPH     : Ungltige Trennungen im Wort
   CORR_MEMORY   : Speicher aus
   CORR_NOT_OPEN : Kein WB oder Trenndatenbank geffnet
*/

RESULT __far __pascal HyphWbWord(NAME *word, NAME *hyph, BOOL nothyph);
/* Suche in WB und fge in das Wort alle Trennungen ein.
   Mgliche Rckgabewerte: wie HyphTestWord
*/

RESULT __far __pascal HyphRegWord(NAME *word, BOOL nothyph);
/* Fge in das Wort die Trennungen nach Trennregeln ein
   Mgliche Rckgabewerte: wie HyphTestWord
*/

RESULT __far __pascal HyphTestKons(NAME *word, NAME *hyph);
RESULT __far __pascal HyphTestCk(NAME *word, NAME *hyph);
/* Prft Sonderflle in der deutschen Silbentrennung: ck-Trennung und
   Konsonantenfall. Diese Prfung wird extra durchgefhrt, da viele
   Textverarbeitungen die Trennungen dynamisch erzeugen und nicht im
   Text abspeichern.
   HyphTestCk: Wenn im Wort "k-k" vorkommt, wird es in "c-k" gendert
   HyphTestKons: Wenn im Wort 3 gleiche Vokale hintereinander vorkommen
               ("oo-o"), wird der 2. Vokal gelscht (Konsonantenfall:"o-o")
   Mgliche Rckgabewerte: wie HyphTestWord
*/


/* Ŀ
        Wortzusammensetzungen                                             
 */

RESULT __far __pascal TestCompoundWord(NAME *word, MODE mode, BOOL typo);
/* prft, ob ein zusammengesetztes Wort den grammatischen Regeln entspricht
   arbeitet nur dann mit Benutzerwrterbchern zusammen, wenn dort auch
   grammatische Infos gespeichert sind!

   Mgliche Rckgabewerte:
   CORR_OK       : Gltige Wortzusammensetzung (nach mode-Stufe)
   CORR_MEMORY   : Speicher aus
   CORR_COMPOUND : Grammatisch falsche Wortzusammensetzung
*/


/* Ŀ
        Speicherlexikon                                                   
 */

RESULT __far __pascal MemSetDictionary(BOOL on);
/* Falls gengend Speicher vorhanden ist, knnen alle gefundenen Wrter
   im Hauptspeicher gemerkt werden. Dies beschleunigt den Suchvorgang.
   Mgliche Rckgabewerte:
   CORR_OK     : Operation durchgefhrt
   CORR_MEMORY : Zu wenig Speicher
*/

RESULT __far __pascal MemSetWord(NAME *word);
/* Dieses Wort wird in das Speicherlexikon aufgenommen; es
   Mgliche Rckgabewerte:
   CORR_OK       : Operation durchgefhrt
   CORR_FULL     : Zu wenig Speicher
*/

RESULT __far __pascal MemTestWord(NAME *word, BOOL typo);
/* Sucht Wort in Speicher-Dictionary
   Mgliche Rckgabewerte:
   CORR_OK       : Operation durchgefhrt
   CORR_MEMORY   : Zu wenig Speicher
   CORR_UNK_WORD : MemDictionary ist nicht geffnet
*/

/* Ŀ
        Statistik-Funktion                                                
 */

typedef struct grSTATISTICS {  /* Record mit allen wesentliche Korrekturzahlen */
              long SentLenSum; /* Summe aller Satzlngen */
              long WordLenSum; /* Summe aller Wortlngen */
              long SentLenMax; /* Grte Satzlnge */
              long WordLenMax; /* Grte Wortlnge */
              long WordCount;  /* Anzahl der geprften Wrter */
              long Unknown;    /* Anzahl der unbekannten Wrter */
              long Typo;       /* Anzahl der typografischen Fehler */
              long Hyph;       /* Anzahl der falsch getrennten Wrter */
              long Grammar;    /* Anzahl der grammatischen Meldungen */
              long GrammError; /* Anzahl der falschen gramm. Meldungen */
              long WordRep;    /* Anzahl der Wortwiederholungen */
            } STATISTICS;

/* Dies sind die mglichen Eingabewerte fr den Statistik-Record. Sie
   decken nicht alle Veriablen ab, die restlichen Variablen werden
   automatisch berechnet. Die Auswertung der Statistikwerte kann direkt
   aus den Record-Werten erfolgen!
*/
const STAT_ALLWORD =  1; /* Anzahl der geprften Wrter                   */
const STAT_UNK     =  2; /* Anzahl der unbekannten Wrter                 */
const STAT_TYPO    =  3; /* Anzahl der typografischen Fehler              */
const STAT_HYPH    =  4; /* Anzahl der Trennfehler                        */
const STAT_WWDH    =  5; /* Anzahl der Wortwiederholungen                 */
const STAT_WLEN    =  6; /* aktuelle Wortlnge                            */
const STAT_SLEN    =  7; /* aktuelle Satzlnge                            */
const STAT_GRAMMAR =  8; /* Anzahl der Grammatik-Meldungen                */
const STAT_ERROR   =  9; /* Anzahl der fehlerhaften Meldungen (Grammatik) */


RESULT StatClear(STATISTICS *stat);
/* Setzt die Werte des Records auf 0 zurck
   Rckgabewert: CORR_OK : Operation durchgefhrt
*/

RESULT StatSet(short code, short val, STATISTICS *stat);
/* Erhht den Wert des entsprechenden Statistik-Eintrages
   code = betreffende STAT_??? Konstante
   val  = entsprechender Wert zu Satz- oder Wortlnge
          (der Wert wird ansonsten ignoriert)

   Rckgabewert:
   CORR_OK  : Operation durchgefhrt
   CORR_UNK : unbekannter Parameter
*/


/* Ŀ
        Korrektur-Vorschlge                                              
 */

RESULT __far __pascal GetProposals(NAME *word, short trace, WORD_LIST *list);
/* Fr ein Wort "word" werden alle hnlichen gltigen Wrter gesucht und
   in "list" zurckgegeben. Das Listenende wird mit (next = NIL)
   gekennzeichnet.
   Die zu durchsuchendenn System- und Benutzerwrterbcher mssen vorher
   geffnet werden.
   Der Umfang der Korrekturvorschlge wird durch Trace (1..10) eingestellt.

   Mgliche Rckgabewerte:
   CORR_OK       : Operation durchgefhrt;
   CORR_MEMORY   : Liste wegen Speichermangel nicht vollstndig
   CORR_NOT_OPEN : Kein System-/Benutzer-Wrterbuch geffnet
*/

RESULT __far __pascal ClearProposals(WORD_LIST *list);
/* Lscht vorher gesuchte Vorschlge und gibt Speicher wieder frei */


/* Ŀ
        Systemeinstellungen                                               
 */

RESULT __far __pascal TitusInit(long code);
/* Setzt Variablen bei Programmstart auf definierte Werte

   "code" ist der entsprechende Registrierungsschlssel
	- Shareware-Version: 31031994
	- Vollversion: auf Anfrage

   mgliche Rckgabewerte:
   CORR_OK : Registrierung ok, Initialisierungen durchgefhrt
   CORR_UNREG : unbekannte Registrierung, Initialisierungen nicht
             durchgefhrt, das System kann nicht stabil laufen!
*/

RESULT __far __pascal TitusClose();
/* Schliet das gesamte System (UsrDic, SysDic, Thes, Speicherwerte,...)  */


/* Ŀ
        Fehlerbehandlung                                                  
 */

RESULT __far __pascal OpenNLS(NAME *path);
/* Datei mit Fehlertexten ffnen; Mgliche Rckgabewerte: wie SysOpen    */

RESULT __far __pascal ErrorText(RESULT error, NAME *text);
/* Aus Fehlercode RESULT den zugehrigen Text aus der jew. NLS-Datei holen
   Rckgabewert: CORR_OK
*/

} /* Ende: extern "C" */
