/*  Project wpdemo
	Lighthouse Engineering
	Copyright   1994 by Lighthouse Engineering.  All Rights Reserved.

	SUBSYSTEM:    wpdemo.exe Application
	FILE:         wavexmpl.cpp
	AUTHOR:       K. Scott Piel


	OVERVIEW
	========
	Source file for implementation of WaveExample (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include <stdio.h>
#include "wpdemo.h"
#include "wavexmpl.h"


DEFINE_RESPONSE_TABLE1(WaveExample, TDialog)
//{{WaveExampleRSP_TBL_BEGIN}}
	EV_BN_CLICKED(IDC_SAYIT, BNClickedSayIt),
	EV_BN_CLICKED(IDC_DOUBLES, BNClickedDoubles),
	EV_BN_CLICKED(IDC_LONGS, BNClickedLongs),
//{{WaveExampleRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{WaveExample Implementation}}


static WaveExampleXfer WaveExampleData;

WaveExample::WaveExample (TWindow* parent, TResId resId, TModule* module):
	TDialog(parent, resId, module)
{
//{{WaveExampleXFER_USE}}
	NumDecimals          = new TEdit(this, IDC_DECIMALS, 3);
	EnunciateValue       = new TEdit(this, IDC_NUMBERFLD, 12);
	MinusRBtn            = new TRadioButton(this, IDC_MINUS, 0);
	NegativeRBtn         = new TRadioButton(this, IDC_NEGATIVE, 0);
	PLusMinusRBtn        = new TRadioButton(this, IDC_PLUSMINUS, 0);
	PosNegRBtn           = new TRadioButton(this, IDC_POSNEG, 0);
	PlayFromResourceRBtn = new TRadioButton(this, IDC_RESOURCE, 0);
	UnsignedRBtn         = new TRadioButton(this, IDC_UNSIGNED, 0);
	PlayFromDiskRBtn     = new TRadioButton(this, IDC_WAVEFILE, 0);
	DoublesRBtn = new TRadioButton(this, IDC_DOUBLES, 0);
	LongsRBtn = new TRadioButton(this, IDC_LONGS, 0);

	SetTransferBuffer(&WaveExampleData);
//{{WaveExampleXFER_USE_END}}

	// INSERT>> Your constructor code here.

}


void WaveExample::BNClickedSayIt ()
{
	// INSERT>> Your code here.

	wpSigns		sign;
	int			precision;
	double		dvalue;
	long		lvalue;
	char		numstr[15];
	unsigned	*resource_list;
	char		**file_list;
	WavePlayer	Player( _hInstance, GetApplication() );

	// what signing method are we to use?

	if(      UnsignedRBtn->GetCheck()  == BF_CHECKED )	sign = wpUNSIGNED;
	else if( MinusRBtn->GetCheck()     == BF_CHECKED )	sign = wpMINUS;
	else if( NegativeRBtn->GetCheck()  == BF_CHECKED )	sign = wpNEGATIVE;
	else if( PLusMinusRBtn->GetCheck() == BF_CHECKED )	sign = wpPLUS;
	else 												sign = wpPOSITIVE;

	// input a precision

	NumDecimals->GetLine( numstr, sizeof(numstr), -1 );

	if( *numstr ) precision = *numstr - '0';
	else          precision = 0;

	// input the value to be stated

	EnunciateValue->GetLine( numstr, sizeof(numstr), -1 );

	if(      DoublesRBtn->GetCheck()  == BF_CHECKED ) sscanf( numstr, "%lf", &dvalue );
	else if( UnsignedRBtn->GetCheck() == BF_CHECKED ) sscanf( numstr, "%lu", &lvalue );
	else                                              sscanf( numstr, "%ld", &lvalue );

	// convert the number to a wave string

	if( DoublesRBtn->GetCheck() == BF_CHECKED )
		resource_list = Player.CvtNumToSndStr( dvalue, precision, sign );
	else
		resource_list = Player.CvtNumToSndStr( lvalue, sign );

	// if playing from disk, convert resource list to file list and play it

	if( PlayFromDiskRBtn->GetCheck() == BF_CHECKED )
	{
		file_list = Player.CvtSndStrToFileList( resource_list );
		delete resource_list;

		Player.Execute( file_list );
		delete file_list;
	}

	// otherwise, play the string from the resources

	else
	{
		Player.Execute( resource_list );
		delete resource_list;
	}
}


WaveExample::~WaveExample ()
{
	Destroy();

	// INSERT>> Your destructor code here.

}

void WaveExample::SetupWindow ()
{
	TDialog::SetupWindow();

	// INSERT>> Your code here.

	if( DoublesRBtn->GetCheck() != BF_CHECKED && LongsRBtn->GetCheck() != BF_CHECKED )
	{
		LongsRBtn->Check();
		UnsignedRBtn->Check();
		PlayFromResourceRBtn->Check();
	}

	NumDecimals->EnableWindow( DoublesRBtn->GetCheck() == BF_CHECKED );

	WavePlayer	Player( _hInstance, GetApplication() );

	GetApplication()->PumpWaitingMessages();
	Player.Execute( IDW_MESSAGE );
}

void WaveExample::BNClickedDoubles ()
{
	// INSERT>> Your code here.

	NumDecimals->EnableWindow( TRUE );
}


void WaveExample::BNClickedLongs ()
{
	// INSERT>> Your code here.

	NumDecimals->EnableWindow( FALSE );
}


