#if !defined(__wavexmpl_h)              // Sentry, use file only if it's not already included.
#define __wavexmpl_h

/*  Project wpdemo
    Lighthouse Engineering
    Copyright   1994 by Lighthouse Engineering.  All Rights Reserved.

    SUBSYSTEM:    wpdemo.exe Application
    FILE:         wavexmpl.h
    AUTHOR:       K. Scott Piel


    OVERVIEW
    ========
    Class definition for WaveExample (TDialog).      
*/

#include <owl\button.h>
#include <owl\radiobut.h>
#include <owl\edit.h>
#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\dialog.h>

#include "wpdemo.rh"            // Definition of all resources.


//{{TDialog = WaveExample}}
struct WaveExampleXfer {
//{{WaveExampleXFER_DATA}}
	char    NumDecimals[ 3 ];
	char    EnunciateValue[ 12 ];
	BOOL    MinusRBtn;
	BOOL    NegativeRBtn;
	BOOL    PLusMinusRBtn;
	BOOL    PosNegRBtn;
	BOOL    PlayFromResourceRBtn;
	BOOL    UnsignedRBtn;
	BOOL    PlayFromDiskRBtn;
    BOOL    DoublesRBtn;
    BOOL    LongsRBtn;
//{{WaveExampleXFER_DATA_END}}
};


class WaveExample : public TDialog {
public:
	WaveExample (TWindow* parent, TResId resId = IDD_EXAMPLE, TModule* module = 0);
	virtual ~WaveExample ();

//{{WaveExampleXFER_DEF}}
protected:
	TEdit *NumDecimals;
	TEdit *EnunciateValue;
	TRadioButton *MinusRBtn;
	TRadioButton *NegativeRBtn;
	TRadioButton *PLusMinusRBtn;
	TRadioButton *PosNegRBtn;
	TRadioButton *PlayFromResourceRBtn;
	TRadioButton *UnsignedRBtn;
	TRadioButton *PlayFromDiskRBtn;
    TRadioButton *DoublesRBtn;
    TRadioButton *LongsRBtn;

//{{WaveExampleXFER_DEF_END}}

//{{WaveExampleVIRTUAL_BEGIN}}
public:
	virtual void SetupWindow ();
//{{WaveExampleVIRTUAL_END}}

//{{WaveExampleRSP_TBL_BEGIN}}
protected:
    void BNClickedSayIt ();
    void BNClickedDoubles ();
    void BNClickedLongs ();
//{{WaveExampleRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(WaveExample);
};    //{{WaveExample}}


#endif                                      // __wavexmpl_h sentry.

