//----------------------------------------------------------------------------
// WavePlayer Class Include File
//
// Version 1.00
// Copyright (C) 1994 by Lighthouse Engineering
// All Rights Reserved
//
// Written by K. Scott Piel - CIS 74151,1035
//----------------------------------------------------------------------------

#ifndef WAVPLAYR_HPP
#define WAVPLAYR_HPP

#include "wavplayr.rh"

//----------------------------------------------------------------------------
// Comment out this define if you do not want to use OWL libraries with this
// build of WavePlayer
//----------------------------------------------------------------------------

#define wpUSES_OWL

//----------------------------------------------------------------------------
// comment out this define if you want to exclude the WavePlayer file list
// of numbers from the compile. This will reduce memory usage.
//----------------------------------------------------------------------------

//#define wpEXCLUDE_FILES

//----------------------------------------------------------------------------
// Valid error codes set by Execute when called.
//----------------------------------------------------------------------------

enum wpErrors
{
	wpNOERROR,		// the last call was completed w/o error
	wpNOTFOUND,		// the resource or file was not found
	wpLOADFAILED,	// the wave could not be loaded into memory
	wpLOCKFAILED,	// the global memory image could not be locked
	wpPLAYFAILED	// the wave would not play
};

//----------------------------------------------------------------------------
// Enumerated control of sign announcement for spoken numbers
//----------------------------------------------------------------------------

enum wpSigns
{
	wpUNSIGNED,		// number is unsigned, use no prefixing
	wpNEGATIVE,		// announce numbers as "negative", do not use "positive"
	wpPOSITIVE,		// announce numbers as "positive" and "negative"
	wpMINUS,		// announce numbers as "minus", do not use "plus"
	wpPLUS			// announce numbers as "plus" and "minus"
};

//----------------------------------------------------------------------------
// Dummy TApplication class used to replace references if OWL is not used
//----------------------------------------------------------------------------

#ifndef wpUSES_OWL

class TApplication
{
	public:

	TApplication() {};
	~TApplication() {};
};

#else

#include <owl\applicat.h>

#endif // wpUSES_OWL

//----------------------------------------------------------------------------
// Wave player class definition
//----------------------------------------------------------------------------

class WavePlayer
{
	private:

	TApplication	*app;		// application that owns this instance
	HINSTANCE		instance;	// current application instance number
	wpErrors		err_code;	// last error code generated
	BOOL			playsound;	// set FALSE is no sound device available

	public:

	WavePlayer( HINSTANCE hInst, TApplication *parent = NULL );
	~WavePlayer();

	BOOL		Execute( char *filename ); 			// a single wave file
	BOOL		Execute( char **filelist );			// a list of wave files
	BOOL		Execute( unsigned resource_id );	// a single wave resource
	BOOL		Execute( unsigned *rsrclist );		// a list of resources

	wpErrors	LastError( void );					// last error code

	// convert numbers to a list of WavePlayer resources to be spoken

	unsigned *CvtNumToSndStr( long val, wpSigns signed = wpUNSIGNED );
	unsigned *CvtNumToSndStr( double val, int precision, wpSigns signed = wpUNSIGNED );

	// convert a list of wave resources to a list of wave files

	char **CvtSndStrToFileList( unsigned *sndstr );
};

#endif // WAVPLAYR_HPP

//--- End Of File ------------------------------------------------------------