/*  Project wpdemo
	Lighthouse Engineering
	Copyright   1994 by Lighthouse Engineering.  All Rights Reserved.

	SUBSYSTEM:    wpdemo.exe Application
	FILE:         wpdemo.cpp
	AUTHOR:       K. Scott Piel


	OVERVIEW
	========
	Source file for implementation of wpDemoApp (TApplication).
*/


#include <owl\owlpch.h>
#include <owl\opensave.h>
#pragma hdrstop

#include "wpdemo.h"
#include "aboutdlg.h"                        // Definition of about dialog.
#include "wavplayr.hpp"
#include "wavexmpll.h"

char HelpFileName[] = "wavplayr.hlp";

//{{wpDemoApp Implementation}}


DEFINE_RESPONSE_TABLE1(wpDemoApp, TApplication)
//{{wpDemoAppRSP_TBL_BEGIN}}
	EV_COMMAND(CM_SAYNUM, SayNumbers),
	EV_COMMAND(CM_PLAYFILE, PlayFile),
	EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
	EV_COMMAND(CM_HELPINFO, HelpInfo),
	EV_COMMAND(CM_HELPREGISTER, RegisterInfo),
	EV_COMMAND(CM_HELPLICENSING, HelpLicensing),
	EV_COMMAND(CM_HELPWAVEPLAYER_REFERENCE, HelpReference),
//{{wpDemoAppRSP_TBL_END}}
END_RESPONSE_TABLE;


class SDIDecFrame : public TDecoratedFrame {
public:
	SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
			TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
	  {  }
	~SDIDecFrame ()
	  {  }
};


wpDemoApp::wpDemoApp () : TApplication("WavePlayer Demonstration")
{
	HelpState   = FALSE;
	ContextHelp = FALSE;
	HelpCursor  = 0;

	FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	FileData.SetFilter("Wave Files (*.wav)|*.wav|");

	// INSERT>> Your constructor code here.

}


wpDemoApp::~wpDemoApp ()
{
	// INSERT>> Your destructor code here.

}


void wpDemoApp::InitMainWindow ()
{
	Client = new TWindow(0, "");
	SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, FALSE);

	nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

	frame->SetIcon(this, IDI_SDIAPPLICATION);

	frame->AssignMenu(SDI_MENU);

	MainWindow = frame;

}


void wpDemoApp::SayNumbers ()
{
	WaveExample(MainWindow).Execute();
}


void wpDemoApp::PlayFile ()
{
	TFileOpenDialog	*opendlg;
	WavePlayer		Player( _hInstance, this );

	// get a file to be opened

	opendlg = new TFileOpenDialog( MainWindow, FileData, 0, "Open Wave File" );

	if( !opendlg ) return;

	if( opendlg->Execute() != IDOK )
	{
		delete opendlg;
		return;
	}

	Player.Execute( FileData.FileName );

	delete opendlg;
}


// Menu Help About wpdemo.exe command
void wpDemoApp::CmHelpAbout ()
{
	AboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
	wpDemoApp     App;
	int             result;

	result = App.Run();

	return result;
}

void wpDemoApp::HelpInfo ()
{
	// INSERT>> Your code here.

	HelpState = MainWindow->WinHelp(HelpFileName, HELP_CONTENTS, 0L);
}


void wpDemoApp::RegisterInfo ()
{
	// INSERT>> Your code here.

	HelpState = MainWindow->WinHelp(HelpFileName, HELP_CONTEXT, Registering_WavePlayer );
}


void wpDemoApp::HelpLicensing ()
{
	// INSERT>> Your code here.

	HelpState = MainWindow->WinHelp(HelpFileName, HELP_CONTEXT, Licensing_Agreement );
}


void wpDemoApp::HelpReference ()
{
	// INSERT>> Your code here.

	HelpState = MainWindow->WinHelp(HelpFileName, HELP_CONTEXT, WavePlayer_Class_Reference );
}


int wpDemoApp::TermInstance (int status)
{
	int result;

	WavePlayer		Player( _hInstance, this );

	Player.Execute( IDW_REGISTER );

	result = TApplication::TermInstance(status);

	// INSERT>> Your code here.

	return result;
}


BOOL wpDemoApp::CanClose ()
{
	BOOL result;

	result = TApplication::CanClose();

	// INSERT>> Your code here.

	if( HelpState )
		MainWindow->WinHelp( HelpFileName, HELP_QUIT, 0L );

	return result;
}

