#if !defined(__wpdemo_h)              // Sentry, use file only if it's not already included.
#define __wpdemo_h

/*  Project wpdemo
	Lighthouse Engineering
	Copyright   1994 by Lighthouse Engineering.  All Rights Reserved.

	SUBSYSTEM:    wpdemo.exe Application
	FILE:         wpdemo.h
	AUTHOR:       K. Scott Piel


	OVERVIEW
	========
	Class definition for wpDemoApp (TApplication).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\opensave.h>

#include "wpdemo.rh"            // Definition of all resources.
#include "wavplayr.hpp"         // definition of WavePlayer class & resource constants
#include "wavplayr.hh"			// help file context ids

//{{TApplication = wpDemoApp}}
class wpDemoApp : public TApplication {
private:
    BOOL            HelpState;            // Has the help engine been used.
	BOOL            ContextHelp;          // SHIFT-F1 state (context sensitive HELP)
	HCURSOR         HelpCursor;           // Context sensitive help cursor
	TWindow *Client;                      // Client window for the frame.
	TOpenSaveDialog::TData FileData;      // Data to control open/saveas standard dialog.

public:
	wpDemoApp ();
	virtual ~wpDemoApp ();

//{{wpDemoAppVIRTUAL_BEGIN}}
public:
	virtual void InitMainWindow();
    virtual int TermInstance (int status);
    virtual BOOL CanClose ();
//{{wpDemoAppVIRTUAL_END}}

//{{wpDemoAppRSP_TBL_BEGIN}}
protected:
	void SayNumbers ();
	void PlayFile ();
	void CmHelpAbout ();
	void HelpInfo ();
	void RegisterInfo ();
    void HelpLicensing ();
    void HelpReference ();
//{{wpDemoAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(wpDemoApp);
};    //{{wpDemoApp}}


#endif                                      // __wpdemo_h sentry.
