.model small
.286
.code


org 0
                   jmp START

;----------------------------------------------------------------------------

SB_BASE:           dw 220h
RECDATA:           db 10000 dup (0)
TEXT:              db 10,13,"SBEcho + A CCS-Production",10,13
                   db "Copyright 1994-xxxx by CCS",10,13
                   db "This is a test- and development-version !!!",10,13
                   db 10,13," Using SB at 220h. Press ESC to abort..."
                   db "$"

TEXT2:             db 10,13,"TNX... -=[ CCS ]=-",10,13,"$"

;----------------------------------------------------------------------------

DSP_WAIT:          pusha
                   mov dx,[word ptr SB_BASE]
                   add dx,0ch                    ;DSP-status regz. 22ch
NOTREADY:          in al,dx
                   test al,80h
                   jne NOTREADY
                   popa
                   ret

DATA_AVAIL:        pusha
                   mov dx,[word ptr SB_BASE]
                   add dx,0eh                    ;Data-status regz. 22eh
NODATA:            in al,dx
                   test al,80h
                   je NODATA
                   popa
                   ret

;----------------------------------------------------------------------------

START:             push cs
                   pop ds
                   mov ah,9
                   mov dx,OFFSET TEXT
                   int 21h
                   mov dx,[word ptr SB_BASE]
                   add dx,6                      ;Reset regz. 226h
                   mov al,1
                   out dx,al
                   xor al,al
                   out dx,al

                   push cs
                   pop dx
                   mov ds,dx
                   mov es,dx
                   mov si,OFFSET RECDATA         ;DS:SI - Play
                   mov bx,si
                   add bx,4000                   ;Delay (4000 bytes)
                   mov di,bx                     ;ES:DI - Record
                   cld                           ;Increment SI and DI
                   mov bx,si                     ;Data area start
                   mov cx,10000
                   add cx,bx                     ;Data area end

                   mov dx,[word ptr SB_BASE]
                   add dx,0ch                    ;Write-data and command...
                                                 ;...regz 22ch

REPEAT:            mov al,10h                    ;Play-command
                   call DSP_WAIT
                   out dx,al
                   lodsb
                   call DSP_WAIT
                   out dx,al

                   mov al,20h                    ;Record-command
                   call DSP_WAIT
                   out dx,al
                   sub dx,2                      ;Read-data regz. 22eh
                   call DATA_AVAIL
                   in al,dx
                   stosb
                   add dx,2

                   cmp si,cx
                   jb SI_OKAY
                   mov si,bx
SI_OKAY:           cmp di,cx
                   jb DI_OKAY
                   mov di,bx
DI_OKAY:           in al,60h
                   cmp al,1
                   jne REPEAT

                   mov ah,9
                   mov dx,OFFSET TEXT2
                   int 21h
                   mov ax,4c00h
                   int 21h
end