;===========================================================================;
;                               SBO + v4.1                                  ;
;   The mini assembler-oscilloscope for SB and compatible (or GUS/SBOS :)   ;
;                  A CCS-Production + (c) 1994-xxxx by CCS                  ;
;                                                                           ;
;      Feel free to play with thiz, but do not rip !!! It'z not fair...     ;
;                If you have any questions, so contact me ;-)               ;
;           (look in the newest release of the CCS-DIST-file !!!)           ;
;                                                                           ;
;===========================================================================;

.model small
.286
.code

;----------------------------------------------------------------------------
;--- Constants --------------------------------------------------------------
;----------------------------------------------------------------------------

BLUE       =  1
LIGHTGREEN = 10
CYAN       = 11
WHITE      = 15
ESCAPE     =  1
SPACE      = 57

;----------------------------------------------------------------------------
;--- Code start -------------------------------------------------------------
;----------------------------------------------------------------------------

org 0
		jmp START                        ;Jump to main

;----------------------------------------------------------------------------
;--- Global used datas and variables ----------------------------------------
;----------------------------------------------------------------------------

POS_X:          dw ?                             ;X-Position
POS_Y:          dw ?                             ;Y-Position
PCOL:           db ?                             ;Pixel color
LASTCOL:        db ?                             ;Last color of a pixel

COLOR_AREA:     db 320 dup (BLUE)                ;Color area (last)
Y_AREA:         dw 320 dup (99)                  ;Y-area (last)

TEXT1           db 10,13,"SBO  v4.1  Assembly version",10,13
                db "A CCS-Production  (c) 1994-xxxx by CCS",10,13,10,13,"$"
TEXT2           db "Tnx 4 watching SBO41 + -=[ CCS ]=-",10,13,"$"

;----------------------------------------------------------------------------
;--- Subroutinez ------------------------------------------------------------
;----------------------------------------------------------------------------

;=== Delay ===

_WAIT:          push cx
                mov cx,300
LOOPCX:         loop LOOPCX
                pop cx
                ret

;=== Looks for a VGA (carry=0, if present) ===

NOVGAD:         db "No VGA detected...",10,13,"$"
VGAD:           db " VGA detected...",10,13,"$"

VGA_DETECT:     pusha                            ;Push regz
                mov ax,1a00h                     ;Get gfx-info (BIOS)
                int 10h
                cmp al,1ah                       ;VGA-bios ?
                je VGAFOUND                      ;Yep !!! VGA found
                stc                              ;Nope, set carry...
                jmp SHORT EXIT_VGA               ;...and exit
VGAFOUND:       clc                              ;Clear carry
EXIT_VGA:       popa                             ;Get regz
                ret                              ;Quit !!!

;=== Looks for a SB and stores the base-address at [SB_BASE] (carry=0) ===

SB_BASE:        dw ?                             ;SB base-address
NOSBD:          db "No SoundBlaster detected...",10,13,"$"
SBD:            db " SoundBlaster detected...$"

SB_DETECT:      pusha
                mov dx,210h                      ;Start from 210h
TRY_NEXT:       push dx
                add dx,6                         ;2x6h -> Reset regz.
                mov al,1                         ;Reset
                out dx,al
                call _WAIT                       ;Wait some microsecs
                xor al,al                        ;Clear reset
                out dx,al
                add dx,4                         ;2xAh -> Input regz.
                in al,dx
                cmp al,0aah                      ;SoundBlaster found ?
                je SBFOUND                       ;Yep !!!
                pop dx                           ;Nope, try next
                add dx,10h
                cmp dx,260h                      ;Adress<=260h ?
                jbe TRY_NEXT                     ;Nope, repeat...
                stc                              ;Set carry and exit
                jmp SHORT EXIT_SB
SBFOUND:        pop dx
                mov [word ptr SB_BASE],dx
                clc                              ;Clear carry
EXIT_SB:        popa
                ret

;=== Sets a pixel at [POS_X][POS_Y] using [PCOL] ===

SETPIXEL:       pusha                            ;Push regz
                push es                          ;Push ES
                mov ax,320                       ;Screen width in AX
                mul [word ptr POS_Y]             ;AX=AX*Y...
                add ax,[word ptr POS_X]          ;AX=AX*Y+X
                mov di,ax                        ;DI->d_ofs
                mov cx,0a000h                    ;VRAM-seg
                mov es,cx                        ;ES->d_seg
                mov al,[byte ptr PCOL]           ;Get new color
                stosb                            ;Store AL in [ES:DI]
                pop es                           ;Get ES
                popa                             ;Get regz
                ret                              ;Ready !

;=== Gets the color of a pixel at [POS_X][POS_Y] and stores it in [LASTCOL] =

GETPIXEL:       pusha                            ;Push regz
                push ds                          ;Push DS
                mov ax,320                       ;Screen width in AX
                mul [word ptr POS_Y]             ;AX=AX*Y...
                add ax,[word ptr POS_X]          ;AX=AX*Y+X
                mov si,ax                        ;SI->s_ofs
                mov cx,0a000h                    ;VRAM-seg
                mov ds,cx                        ;DS->s_seg
                lodsb                            ;Save [DS:SI] in AL
                mov [byte ptr LASTCOL],al        ;Store it
                pop ds                           ;Get DS
                popa                             ;Get regz
                ret                              ;Ready !

;=== Draws a vertical line at [POS_X(2-317)][POS_Y] using [PCOL] ===

VERTLINE:       mov [word ptr POS_X],2           ;Start at X=2
CLINE:          call SETPIXEL                    ;Set pixel
                inc [word ptr POS_X]             ;X=X+1
                cmp [word ptr POS_X],317         ;X<=317 ?
                jbe CLINE                        ;Yope, repeat...
                ret                              ;Ready !

;=== Draws a box at [TOPX][TOPY][BOTX][BOTY] using [PCOL] ===

TOPX:           dw ?                             ;Box coordinates
TOPY:           dw ?
BOTX:           dw ?
BOTY:           dw ?

DRAWBOX:        pusha                            ;Push regz
                mov ax,[word ptr TOPX]           ;Get X-top
                mov bx,[word ptr BOTX]           ;Get X-bottom
                mov [word ptr POS_X],ax          ;Store X-top
CONT1:          mov cx,[word ptr TOPY]           ;Get Y-top
                mov [word ptr POS_Y],cx          ;Store Y-top
                call SETPIXEL                    ;Set pixel
                mov cx,[word ptr BOTY]           ;Get Y-bottom
                mov [word ptr POS_Y],cx          ;Store Y-bottom
                call SETPIXEL                    ;Set pixel
                inc [word ptr POS_X]             ;Increment X
                cmp [word ptr POS_X],bx          ;X<=X-bottom ?
                jbe CONT1                        ;Yope, repeat...
                mov ax,[word ptr TOPY]           ;Get Y-top
                mov bx,[word ptr BOTY]           ;Get Y-bottom
                mov [word ptr POS_Y],ax          ;Store Y-top
CONT2:          mov cx,[word ptr TOPX]           ;Get X-top
                mov [word ptr POS_X],cx          ;Store X-top
                call SETPIXEL                    ;Set pixel
                mov cx,[word ptr BOTX]           ;Get X-bottom
                mov [word ptr POS_X],cx          ;Store X-bottom
                call SETPIXEL                    ;Set pixel
                inc [word ptr POS_Y]             ;Increment Y
                cmp [word ptr POS_Y],bx          ;Y<=Y-bottom ?
                jbe CONT2                        ;Yope, repeat...
                popa                             ;Get regz
                ret                              ;Ready !

;=== Draws a bar using color 100-163 ===

DRAW3DBAR:      pusha                            ;Push regz
                call GENBAR                      ;Generate new colors
                mov ax,36                        ;Y1
                mov bx,163                       ;Y2
                mov cx,64                        ;Counter
                mov dl,100                       ;Color-#
LOOP3D:         mov [byte ptr PCOL],dl           ;Store color
                mov [word ptr POS_Y],ax          ;Store Y1
                call VERTLINE                    ;Draw line
                mov [word ptr POS_Y],bx          ;Store Y2
                call VERTLINE                    ;Draw line
                inc ax                           ;Increment Y1
                dec bx                           ;Decrement Y2
                inc dl                           ;Increment color
                loop LOOP3D                      ;Loop until CX=0
                popa                             ;Get regz
                ret                              ;Ready !

;=== Generates a 3D-bar using colors in [COLTAB_xx], position [COLOFFS_xx] ==

COLTAB_RED:     db 70 dup (0)                    ;Color table red-bar
                db 1,2,3,4,5,6,7,8,9,10,11,12,13
                db 14,15,16,17,18,19,20,21,22,23
                db 24,25,26,27,28,29,30,31,32,33
                db 34,35,36,37,38,39,40,41,42,43
                db 44,45,46,47,48,49,50,51,52,53
                db 54,55,56,57,58,59,60,61,62,63
                db 64 dup (63)
COLTAB_GREEN:   db 70 dup (0)                    ;Color table green-bar
                db 1,2,3,4,5,6,7,8,9,10,11,12,13
                db 14,15,16,17,18,19,20,21,22,23
                db 24,25,26,27,28,29,30,31,32,33
                db 34,35,36,37,38,39,40,41,42,43
                db 44,45,46,47,48,49,50,51,52,53
                db 54,55,56,57,58,59,60,61,62,63
                db 64 dup (63)
COLTAB_BLUE:    db 70 dup (0)                    ;Color table blue-bar
                db 1,2,3,4,5,6,7,8,9,10,11,12,13
                db 14,15,16,17,18,19,20,21,22,23
                db 24,25,26,27,28,29,30,31,32,33
                db 34,35,36,37,38,39,40,41,42,43
                db 44,45,46,47,48,49,50,51,52,53
                db 54,55,56,57,58,59,60,61,62,63
                db 64 dup (63)

COLOFFS_RED:    dw 0                             ;Offset in red-table
COLOFFS_GREEN:  dw 0                             ;Offset in green-table
COLOFFS_BLUE:   dw 0                             ;Offset in blue-table

GENBAR:         pusha                            ;Save regz
                pushf
                mov dx,3dah                      ;EGA/VGA input-stat1 regz.
WVR:            in al,dx
                test al,8
                je WVR                           ;Wait to begin of VR
                mov al,100                       ;Start at DAC 100
                mov bx,[word ptr COLOFFS_RED]    ;Get red-offset
                shr bx,1
                mov si,[word ptr COLOFFS_GREEN]  ;Get green-offset
                shr si,1
                mov di,[word ptr COLOFFS_BLUE]   ;Get blue-offset
                shr di,1
SETDAC:         mov dx,3c8h                      ;Pel write address
                out dx,al                        ;Select DAC-#
                inc dx                           ;Pel data
                push ax
                mov al,[byte ptr COLTAB_RED+bx]  ;Get color from table
                out dx,al                        ;Set red
                mov al,[byte ptr COLTAB_GREEN+si];Get color from table
                out dx,al                        ;Set green
                mov al,[byte ptr COLTAB_BLUE+di] ;Get color from table
                out dx,al                        ;Set blue
                pop ax
                inc bx                           ;Increment red-offset
                inc si                           ;Increment green-offset
                inc di                           ;Increment blue-offset
                inc al                           ;Increment DAC-#
                cmp al,163                       ;Last DAC ?
                jbe SETDAC                       ;Nope, repeat...
                popf
                popa                             ;Yep, get regz and...
                ret                              ;...ready !

;=== Records one byte from SB (AX-regz, with zero-point correction) ===

SAMPLE:         mov dx,[word ptr SB_BASE]        ;Get SB base-address
                add dx,0ch                       ;2xCh-data and status (bit 7)
DSPNOTREADY:    in al,dx
                test al,80h                      ;Test bit 7...
                jne DSPNOTREADY                  ;...=1 -> DSP not ready
                mov al,20h                       ;Direct record command...
                out dx,al                        ;...to DSP
                inc dx
                inc dx                           ;2xEh-data available (bit 7)
DATANOTREADY:   in al,dx
                test al,80h                      ;Test bit 7...
                je DATANOTREADY                  ;...=0 -> no data
                sub dx,4                         ;2xA - data from DSP
                in al,dx                         ;Get value from DSP
                xor ah,ah                        ;AL -> 00AL
                sub ax,28                        ;Zero-point correction
                ret

;=== Gets 100 samples, the last is valid ! ===

GET100SAMPLES:  mov cx,100
GETSAMPLE:      call SAMPLE
                loop GETSAMPLE
                ret

;----------------------------------------------------------------------------
;--- Main -------------------------------------------------------------------
;----------------------------------------------------------------------------

START:          cli                              ;Clear int-flag

                push cs                          ;DS=CS
                pop ds                           ;Print msg
                mov ah,9
                mov dx,OFFSET TEXT1
                int 21h

                call VGA_DETECT                  ;Look vor VGA
                jnc VGA_PRESENT
                mov ah,9
                mov dx,OFFSET NOVGAD
                int 21h
                jmp THE_END
VGA_PRESENT:    mov ah,9
                mov dx,OFFSET VGAD
                int 21h

                call SB_DETECT                   ;Look for a SB
                jnc SB_PRESENT                   ;Carry=0->present
                mov ah,9                         ;Print msg
                mov dx,OFFSET NOSBD
                int 21h
                jmp THE_END

SB_PRESENT:     mov ah,9                         ;Print msg
                mov dx,OFFSET SBD
                int 21h

                mov cx,20000                     ;Wait some seconds
_LOOP:          call _WAIT
                loop _LOOP

                mov ax,19                        ;Switch gfx to 320x200/256
                int 10h

                mov [byte ptr PCOL],CYAN         ;Draw a cyan box
                mov [word ptr TOPX],0
                mov [word ptr TOPY],0
                mov [word ptr BOTX],319
                mov [word ptr BOTY],199
                call DRAWBOX

                mov [byte ptr PCOL],LIGHTGREEN   ;Draw a lightgreen box
                inc [word ptr TOPX]
                inc [word ptr TOPY]
                dec [word ptr BOTX]
                dec [word ptr BOTY]
                call DRAWBOX

                call DRAW3DBAR                   ;Draw 3D-bar

                mov [byte ptr PCOL],BLUE         ;Draw a blue line
                mov [word ptr POS_Y],99          ;Y=99
                call VERTLINE

STARTREC:       mov [word ptr POS_X],2           ;X must begin at 2
RECCONT:        call SAMPLE
                cmp ax,2                         ;Y must be between 2..197
                jae GREATEREQUAL
                mov ax,2
GREATEREQUAL:   cmp ax,197
                jbe SMALLEREQUAL
                mov ax,197
SMALLEREQUAL:   mov [word ptr POS_Y],ax          ;Store Y (no change AX !!!)
                mov [byte ptr PCOL],WHITE        ;Store color
                call GETPIXEL                    ;Get old color
                call SETPIXEL                    ;Set pixel
                mov si,[word ptr POS_X]          ;Get offset
                shl si,1                         ;Double the offset (word !)
                cmp ax,[word ptr Y_AREA+si]      ;Current Y=Old Y ?
                je OKAY                          ;Yep, no change !
                mov bx,[word ptr Y_AREA+si]      ;Nope, get old Y
                mov [word ptr POS_Y],bx          ;Store it
                mov [word ptr Y_AREA+si],ax      ;Store new Y in area
                mov si,[word ptr POS_X]          ;Get offset
                mov cl,[byte ptr COLOR_AREA+si]  ;Get old color
                mov [byte ptr PCOL],cl           ;Store it
                call SETPIXEL                    ;Set pixel with old color
                mov cl,[byte ptr LASTCOL]        ;Store new color...
                mov [byte ptr COLOR_AREA+si],cl  ;...in area

OKAY:
                inc [word ptr POS_X]             ;Increment X
                cmp [word ptr POS_X],317         ;X must end at 317
                ja BAR                           ;X>317 ?
                jmp RECCONT                      ;X<=317 -> repeat
BAR:            call GET100SAMPLES               ;Get red-offset (delayed)
                mov [word ptr COLOFFS_RED],ax    ;Store it
                call GET100SAMPLES               ;Get green-offset (delayed)
                mov [word ptr COLOFFS_GREEN],ax  ;Store it
                call GET100SAMPLES               ;Get blue-offset (delayed)
                mov [word ptr COLOFFS_BLUE],ax   ;Store it
                call GENBAR                      ;And generate the 3D-bar
KEYASK:         in al,60h                        ;Get key
                cmp al,SPACE                     ;SPACE pressed ?
                je BAR                       ;Yope, repeat asking
                cmp al,ESCAPE                    ;ESC pressed ?
                je ESCR                          ;Yope...
                jmp STARTREC                     ;Nopi, start again

ESCR:           mov ax,3                         ;Set text-mode
                int 10h

                mov ah,9                         ;Print msg
                mov dx,OFFSET TEXT2
                int 21h

THE_END:        sti                              ;Set int-flag

                mov ax,4c00h                     ;Ready...
                int 21h
end

;----------------------------------------------------------------------------
;--- Puuuhhh !!!  End of code, after endless hours of bugfixing :) ----------
;----------------------------------------------------------------------------