VarPush anim,bmp,x,y,new,key,col
ScreenGetPixel col,0,0
AnimationOpen anim,0,"winner"   # Use any 320x200 Smacked flic
BitmapAlloc bmp,320,200         # Create a bitmap
BitmapAlloc mouse,0,0
MouseAdd "mouse",0,0,640,480,mouse
AnimationToBitmap anim,bmp      # Decompress to bitmap
VarSet X=160                    # Starting X coord
VarSet Y=120                    # Starting Y coord
:loop
MouseSetXY 320,240              # Set the mouse to the screen
AnimationAdvance anim           # Decompress
BitmapToScreen bmp,X,Y          # Copy to Screen
BitmapSetPalette bmp            # Update palette
InputCharOrDelay key,0          # Get a key
If key="escape" Goto "Done"     # End if escape hit
If key="mouse" Goto "Done"
MouseX new                      # Get new mouse x
If new<320 Gosub "DecX"         # Move to left
If new>320 Gosub "IncX"         # Move to right
MouseY new                      # Get new mouse y
If new<240 Gosub "DecY"         # Move to top
If new>240 Gosub "IncY"         # Move to bottom
Goto "Loop"                     # Keep going
:done
MouseRemoveAll
BitmapFree bmp
BitmapFree mouse
VarPop
Exit

:DecX                           # Moved to the Left
VarPush new,w,nx                # Push local variables
Compute new=320-new             # How far are we moving
VarSet w=X                      # Save old XCoord
Compute X=X-new                 # Subtract, but don't drop under 0
If X<0 VarSet X=0
Compute nx=X+320                # Move to the right of the flic
Compute w=w-X                   # Width to clear
ScreenFilledBox nx,Y,w,200,col  # Clear right side of the bitmap
VarPop                          # Restore the local variables
Return

:DecY
VarPush new,h,ny                # Push Local Variables
Compute new=240-new             # How far are we moving
VarSet h=Y                      # Save old YCoord
Compute Y=Y-new                 # Subtract, but don't drop under 0
If Y<0 VarSet Y=0
Compute ny=Y+200                # Move to the bottom of the flic
Compute h=h-Y                   # Height to clear
ScreenFilledBox X,ny,320,h,col  # Clear bottom side of the bitmap
VarPop                          # Restore the local variables
Return

:IncX
VarPush new,w,nx                # Push Local Variables
Compute new=new-320             # How far are we moving
VarSet w=X                      # Save old XCoord
Compute X=X+new                 # Add, but stay on screen
If X>320 VarSet X=320
Compute w=X-w                   # Figure width that we are moving
Compute nx=X-w                  # Back up to the left of the bitmap
ScreenFilledBox nx,Y,w,200,col  # Clear left side of the bitmap
VarPop                          # Restore the local variables
Return

:IncY
VarPush new,h,ny                # Push Local Variables
Compute new=new-240             # How far are we moving
VarSet h=Y                      # Save old YCoord
Compute Y=Y+new                 # Add, but stay on screen
If Y>280 VarSet Y=280
Compute h=Y-h                   # Figure height that we are moving
Compute ny=Y-h                  # Back up to the top of the bitmap
ScreenFilledBox X,ny,320,h,col  # Clear top side of the bitmap
VarPop                          # Restore the local variables
Return
