// File:         BigeMain.cpp
//
// Created:      Tue Apr 05 09:26:29 1994
//
// Description:  Main routines for "Bigedit2" Windows application
//
//
// STARTBLOCK    File Version Information   (REGENERATE)
//
// Regenerated:  Tue Apr 05 09:26:29 1994
// Skeleton by:  Winpro/3, a product from Xian Corporation
//               bc4owl2.skl version 1.00 developed by:
//                 Terry Richards
//                 Terry Richards Software
//                 (908) 545-6533
//
// ENDBLOCK

#include "Beditcli.h"

// A P P L I C A T I O N  O B J E C T  D E F I N I T I O N

class TAppBigedit2 : public TApplication{

protected:

    int    argc;
    char** argv;

public:

    // Constructor
    TAppBigedit2(const char far* name,int Argc,char* Argv[]);

    virtual void InitMainWindow();

};

// B I G E D I T 2   M A I N  W I N D O W  C L A S S  D E F I N I T I O N

class TBigedit2Frame : public TDecoratedMDIFrame {

protected:

    TMenuDescr   MenuDescr;

public:

    TBigedit2Frame (const char far *title,TResId Menu,TMDIClient* clientWnd);

};

class TBigedit2Client :public TMDIClient{

public:

    StringArray*      pDroppedFiles;  // Files dragged & dropped onto the window

    TBigedit2Client(int argc,char* argv[]);

    // For reasons unknown, you must not override TMDIClient::GetClassName()

    // Function called in response to cm_CreateChild command
    virtual TMDIChild * InitChild();
    TMDIChild*          CreateChildEDIT_CHILD(char * FileName=NULL);

    // Handle files dragged & dropped onto the main window
    void EvDropFiles(TDropInfo dropInfo);

    // NOTE: For MDI we only process the main menu in the client window.
    //       Child menus are processed in the child and any menus not
    //       connected to anything are ignored. Accelerators and button
    //       bar items are also processed here if they do not correspond
    //       to a menu item. Otherwise, they are handled by the menu item
    //       they belong to.

    void CM_FILEOPENMethod();

    DECLARE_RESPONSE_TABLE(TBigedit2Client);

};

DEFINE_RESPONSE_TABLE1(TBigedit2Client,TMDIClient)
    EV_COMMAND (CM_FILEOPEN,CM_FILEOPENMethod),
    EV_WM_DROPFILES,
    //This command enabler is missing from Borlands mdi.cpp so we
    //just do it here instead.
    EV_COMMAND_ENABLE(CM_TILECHILDRENHORIZ, CmChildActionEnable),
END_RESPONSE_TABLE;

//  B I G E D I T 2   --  Main window destructor

// B I G E D I T 2  W I N D O W .  C R E A T E  M D I  C H I L D R E N

// In response to a cm_CreateChild command from a menu or accelerator key,
// the default ObjectWindows message handler CMCreateChild calls this
// function to do the actual creation.

TMDIChild* TBigedit2Client :: InitChild(){

    return CreateChildEDIT_CHILD();

}

// Create MDI child of type TMDIChild

TMDIChild* TBigedit2Client :: CreateChildEDIT_CHILD(char * FileName){

    return new TMDIChild(*this,FileName,new TEditClient(0,FileName));

}

// The user dragged & dropped one or more files onto the main window

void TBigedit2Client :: EvDropFiles(TDropInfo dropInfo){

UINT   cFiles;
UINT   i;
TPoint xyDrop;
char   szBuf[MAXPATH];

    // Find out where the files were dropped and whether they were
    // dropped in the TBigedit2Client client area.  DragQueryPoint
    // returns 0 if the drop was not in the client area.
    // Nothing requires the drop to be restricted to the client
    // area, the generated code just shows how to do it.
    // If you don't care where in the window the drop was made,
    // you can totally eliminate the call to DragQueryPoint.
    // xyDrop is in TBigedit2Client coordinates, not client coordinates

    if (dropInfo.DragQueryPoint(xyDrop)){

        // Find out how many files were dropped.
        cFiles = dropInfo.DragQueryFileCount();

        for (i = 0;i < cFiles;++i){

            dropInfo.DragQueryFile(i,szBuf,MAXPATH);
            CreateChildEDIT_CHILD(szBuf)->Create();

        }

        // Release memory that Windows allocated for use in transferring
        // filenames to the application.

        dropInfo.DragFinish();

    }

    else
        // Files were not dropped in the window's client area
        MessageBeep(-1);

}

void TBigedit2Client :: CM_FILEOPENMethod(){

TFileOpenDialog::TData FilenameData;
char                   Caption[80]="";
char                   szFile[256]="";
char                   szFilter[256]="";
char                   szCustomFilter[256]="";
char                   szInitialDir[256]="";
char                   szDefExt[3]="";
char                   Sep;
int                    i,Len;

    FilenameData.FileName     = szFile;
    FilenameData.Filter       = szFilter;
    FilenameData.CustomFilter = szCustomFilter;
    FilenameData.InitialDir   = szInitialDir;
    FilenameData.DefExt       = szDefExt;

    strcpy(szFilter,"All Files (*.*)|*.*|");
    FilenameData.FilterIndex = 1;  // Initially select the first filter

    if (szFilter[0]){

        Len = strlen(szFilter);
        Sep = szFilter[Len-1];

        for (i=0;i < Len;i++)
            if (szFilter[i] == Sep)
                szFilter[i] = 0;

    }

    FilenameData.Flags = 0;

    FilenameData.Flags |= OFN_ALLOWMULTISELECT;
    FilenameData.Flags |= OFN_CREATEPROMPT;
    FilenameData.Flags |= OFN_PATHMUSTEXIST;
    FilenameData.Flags |= OFN_FILEMUSTEXIST;

    if (TFileOpenDialog(this,FilenameData,0,Caption).Execute() == IDOK) {

        // User selected a file
        // hf = _lopen(ofn.lpstrFile,OF_READ);
        //    .
        //    . /* Perform file operations. */
        //    .

        CreateChildEDIT_CHILD(FilenameData.FileName)->Create();

    }

    else{

        if (FilenameData.Error) {

            char msg[50];
            wsprintf(msg,"GetOpenFileName returned Error #%ld",FilenameData.Error);
            MessageBox(msg,"WARNING",MB_OK | MB_ICONSTOP);

        }

    }

}

TBigedit2Frame :: TBigedit2Frame (const char far *title,TResId Menu,TMDIClient* clientWnd)
                 : TDecoratedMDIFrame(title,Menu,*clientWnd),
                   MenuDescr(MENU_MAIN,1,0,0,0,1,0){

    // Set the window style bits to get the appearance we want.  If we don't
    // do any of this, we'll get the ObjectWindows standard style, which has
    // size border, caption bar, system menu, maximize box, and minimize
    // box and initial size and position set by Windows.

    Attr.ExStyle = WS_EX_ACCEPTFILES;  // Extended style bits

    // Main window will have caption, menu, and size border
    Attr.Style = WS_OVERLAPPED          // Style bits
                | WS_CAPTION
                | WS_THICKFRAME
                | WS_SYSMENU
                | WS_MINIMIZEBOX
                | WS_MAXIMIZEBOX
                | WS_CLIPSIBLINGS
                | WS_VISIBLE;

    Attr.AccelTable = ACCEL;
    SetIcon(GetModule(),ICON_MAIN);

    SetMenuDescr(MenuDescr);

}

TBigedit2Client :: TBigedit2Client(int argc,char* argv[]) : TMDIClient(){

int i;

    //The run-time parameters are available in argc & argv:
    //  argc - The number of parameters
    //  argv - The parameters as an array of null terminated strings with argc elements.

    Attr.ExStyle = WS_EX_ACCEPTFILES;  // Extended style bits
    SetBkgndColor (GetSysColor(COLOR_APPWORKSPACE));

    for (i=1;i<argc;i++)
        CreateChildEDIT_CHILD(argv[i]);

}

TAppBigedit2 :: TAppBigedit2(const char far* name,int Argc,char* Argv[]) : TApplication(name){

    argc = Argc;
    argv = Argv;

}

void TAppBigedit2 :: InitMainWindow(){

TBigedit2Frame * AppFrame;

    AppFrame = new TBigedit2Frame(
        "An MDI Editor",
        MENU_MAIN,new TBigedit2Client(argc,argv));

    MainWindow = AppFrame;

}

//  O W L  M A I N  --  Main procedure for Bigedit2

int OwlMain(int argc,char* argv []){

    return TAppBigedit2("Bigedit2",argc,argv).Run();

}

//   E N D   O F   F I L E   BigeMain.cpp
