// File:         BigeApp.cpp
//
// Created:      Sun May 01 11:43:51 1994
//
// Description:  Application and utility classes for "Biged2s"
//               Windows application.
//
//
// Regenerated:  Sun May 01 11:43:51 1994
// Skeleton by:  Winpro/3, a product from Xian Corporation
//               bc4owl2.skl version 1.00 developed by:
//                 Terry Richards
//                 Terry Richards Software
//                 (908) 545-6533
//

#include "Beditcli.rh"
#include "Beditcli.h"

class TAppBiged2s : public TApplication{

public:

    // Constructor
    TAppBiged2s(const char far* name);

    virtual void InitMainWindow();

};

// B I G E D 2 S   M A I N  W I N D O W  C L A S S  D E F I N I T I O N

class TBiged2sFrame : public TDecoratedFrame {

protected:

    TMenuDescr*  MenuDescr;

public:

    TBiged2sFrame (TWindow* parent,const char far *title,TWindow* clientWnd);
    ~TBiged2sFrame ();

    void CM_FILEOPENMethod();
    void CM_FILENEWMethod();

    DECLARE_RESPONSE_TABLE(TBiged2sFrame);

};

DEFINE_RESPONSE_TABLE1(TBiged2sFrame,TDecoratedFrame)
    EV_COMMAND (CM_FILEOPEN,CM_FILEOPENMethod),
    EV_COMMAND (CM_FILENEW,CM_FILENEWMethod),
END_RESPONSE_TABLE;

TAppBiged2s :: TAppBiged2s(const char far* name) : TApplication(name){

}

void TAppBiged2s :: InitMainWindow(){

TBiged2sFrame * AppFrame;

    AppFrame = new TBiged2sFrame(NULL,
        "An SDI Editor",
        new TEditClient(0,0));

    MainWindow = AppFrame;

}

TBiged2sFrame :: TBiged2sFrame (TWindow* parent,const char far *title,TWindow* clientWnd)
                 : TDecoratedFrame(parent,title,clientWnd){

    // Set the window style bits to get the appearance we want.  If we don't
    // do any of this, we'll get the ObjectWindows standard style, which has
    // size border, caption bar, system menu, maximize box, and minimize
    // box and initial size and position set by Windows.

    // Main window will have caption, menu, and size border
    Attr.Style = WS_OVERLAPPED          // Style bits
                | WS_CAPTION
                | WS_THICKFRAME
                | WS_SYSMENU
                | WS_MINIMIZEBOX
                | WS_MAXIMIZEBOX
                | WS_CLIPSIBLINGS
                | WS_VISIBLE;

    Attr.AccelTable = ACCEL;
    SetIcon(GetModule(),ICON_MAIN);

    //You may want to reset the group counts in the next statement.
    //These values provide basic menu functionality but much
    //more sophisticated behaviour is possible.

    MenuDescr = new TMenuDescr(MENU_CHILD,3,0,0,0,0,0);
    SetMenuDescr(*MenuDescr);

}

TBiged2sFrame :: ~TBiged2sFrame(){

    delete MenuDescr;

}

void TBiged2sFrame :: CM_FILEOPENMethod(){

TFileOpenDialog::TData FilenameData;
char                   Caption[80]="";
char                   szFile[256]="";
char                   szFilter[256]="";
char                   szCustomFilter[256]="";
char                   szInitialDir[256]="";
char                   szDefExt[3]="";
char                   Sep;
int                    i,Len;

    if (!ClientWnd->CanClose())
        return;

    FilenameData.FileName     = szFile;
    FilenameData.Filter       = szFilter;
    FilenameData.CustomFilter = szCustomFilter;
    FilenameData.InitialDir   = szInitialDir;
    FilenameData.DefExt       = szDefExt;

    strcpy(szFilter,"All Files (*.*)|*.*|");
    FilenameData.FilterIndex = 1;  // Initially select the first filter

    if (szFilter[0]){

        Len = strlen(szFilter);
        Sep = szFilter[Len-1];

        for (i=0;i < Len;i++)
            if (szFilter[i] == Sep)
                szFilter[i] = 0;

    }

    FilenameData.Flags = 0;

    FilenameData.Flags |= OFN_ALLOWMULTISELECT;
    FilenameData.Flags |= OFN_CREATEPROMPT;
    FilenameData.Flags |= OFN_PATHMUSTEXIST;
    FilenameData.Flags |= OFN_FILEMUSTEXIST;

    if (TFileOpenDialog(this,FilenameData,0,Caption).Execute() == IDOK) {

        // User selected a file
        // hf = _lopen(ofn.lpstrFile,OF_READ);
        //    .
        //    . /* Perform file operations. */
        //    .

        ((TEditClient*)ClientWnd)->Open(FilenameData.FileName);

    }

    else{

        if (FilenameData.Error) {

            char msg[50];
            wsprintf(msg,"GetOpenFileName returned Error #%ld",FilenameData.Error);
            MessageBox(msg,"WARNING",MB_OK | MB_ICONSTOP);

        }

    }

}

void TBiged2sFrame :: CM_FILENEWMethod(){

    if (!ClientWnd->CanClose())
        return;

    ((TEditClient*)ClientWnd)->Open();

}

//  O W L  M A I N  --  Main procedure for Biged2s

int OwlMain(int /*argc*/,char* /*argv*/ []){

    return TAppBiged2s("Biged2s").Run();

}

//   E N D   O F   F I L E
