diff - display line-by-line differences between pairs of text files
SYNOPSIS
diff [-#] [-abBcdefhHilnNprstTuvw] [-Clines] [-Fregexp] [-Iregexp] [-Llabel [-Llabel1]] [-Sfile] [-Dsymbol] path1 path2

   DESCRIPTION
      The diff installed on this system is the GNU diff. This version of
      diff provides all the features of BSD's diff in addition to
      numerous additional features.

      diff is a differential file comparator.  When run on regular files,
      and when comparing text files that differ during directory
      comparison (see the notes below on comparing directories), diff
      tells what lines must be changed in the files to bring them into
      agreement.  Except in rare circumstances, diff finds a smallest
      sufficient set of differences.  If neither path1 nor path2 is a
      directory, either may be given as "-", in which case the standard
      input is used.  If path1 is a directory, a file in that directory
      whose filename is the same as the filename of path2 is used (and
      vice versa).

      There are several options for output format; the default output
      format contains lines of these forms:

         n1
         a
         n3, n4

         n1, n2
         d
         n3

         n1, n2
         c
         n3, n4

         These lines resemble ed(1) commands to convert path1 into path2.
         The numbers after the letters pertain to path2.  In fact, by
         exchanging a for d and reading backward one may ascertain
         equally how to convert path2 into path1.  As in ed(1), identical
         pairs, where n1 = n2 or n3 = n4, are abbreviated as a single
         number.

         Following each of these lines come all the lines that are
         affected in the first file flagged by "<", then all the lines
         that are affected in the second file flagged by ">".

         If both arguments are directories, diff sorts the contents of
         the directories by name, and then runs the regular file diff
         program as described above on text files which are different.
         Binary files which differ, common subdirectories, and files
         which appear in only one directory are listed.

   OPTIONS
      This diff has these additional (non-BSD) features:

      -a       Always treat files as text and compare them line-by-line,
               even if they do not appear to be ASCII.

      -B       Ignore changes that just insert or delete blank lines.

      -C#      Request -c format and specify number of context lines.

      -Fregexp In context format, for each unit of differences, show some
               of the last preceding line that matches the specified
               regexp.

      -H       Use heuristics to speed handling of large files that have
               numerous scattered small changes.  The algorithm becomes
               asymptotically linear for such files!

      -Iregexp Ignore changes that just insert or delete lines that match
               the specified regexp.

      -Llabel  Use the specified label in file header lines output by the
               -c option.  This option may be given zero, one, or two
               times, to affect neither label, just the first file's
               label, or both labels.  A file's default label is its
               name, a tab, and its modification date.

      -N       In directory comparison, if a file is found in only one
               directory, treat it as present but empty in the other
               directory.

      -p       Equivalent to -c -F'^[_a-zA-Z]'.  This is useful for C
               code because it shows which function each change is in.

      -T       Print a tab rather than a space before the text of a line
               in normal or context format.  This causes the alignment of
               tabs in the line to look normal.

      -u[#]    Produce unified style output with # context lines
               (default 3).   This style is like -c, but it is more
               compact because context lines are printed only once.
               Lines from just the first file are marked "-"; lines from
               just the second file are marked "+".

      -v       Print the version string before any other output.

      The following features are BSD standard:

      -b       Ignore trailing blanks (SPACE and TAB characters) and
               treat all other strings of blanks as equivalent.

      -i       Ignore the case of letters; for example, 'A' will compare
               equal to 'a'.

      -t       Expand TAB characters in output lines.  Normal or -c
               output adds character(s) to the front of each line which
               may alter the indentation of the original source lines and
               make the output listing difficult to interpret.  This
               option will preserve the original source's indentation.

      -w       Ignore all blanks (SPACE and TAB characters); for example,
               "if ( a == b )" will compare equal to "if(a==b)".

      The following four options are mutually exclusive:

      -c[#]    Produce a listing of differences with lines of context.
               The default is to present 3 lines of context and may be
               changed, (to 10, for example), by -c10.  With -c the
               output format is modified slightly:  output begins with
               identification of the files involved and their creation
               dates, then each change is separated by a line with a
               dozen *s.  The lines removed from path1 are marked with
               "-"; those added to path2 are marked "+".  Lines which are
               changed from one file to the other are marked in both
               files with "!".

               Changes which lie within <context> lines of each other are
               grouped together on output.  This is a change from the
               previous diff -c but the resulting output is usually much
               easier to interpret.

      -Dsymbol Output a file containing #ifdef directives based on symbol
               which will allow creating either a version identical to
               path1 (symbol not defined) or path2 (symbol defined).

      -e       Produce a script of a, c and d commands for the editor ed,
               which will recreate path2 from path1.

               In connection with -e, the following shell program may
               help maintain multiple versions of a file.  Only an
               ancestral file ($1) and a chain of version-to-version ed
               scripts ($2, $3, ...) made by diff need be on hand.  A
               "latest version" appears on the standard output.

                  (shift; cat $*; echo '1,$p') | ed - $1

               Extra commands are added to the output when comparing
               directories with -e, so that the result is a sh script for
               converting text files which are common to the two
               directories from their state in directory1 to their state
               in directory2.

      -f       Produce a script similar to that of -e, not useful with
               ed, which is in the opposite order.

      -n       Produce a script similar to that of -e, but in the
               opposite order and with a count of changed lines on each
               insert or delete command.

      -h       Do a fast, half-hearted job.  It works only when changed
               stretches are short and well separated, but does work on
               files of unlimited length.

      Options when comparing directories are:

      -l       Long output format; each text file diff is piped through
               pr(1V) to paginate it, other differences are remembered
               and summarized after all text file differences are
               reported.

      -r       Apply diff recursively to common subdirectories
               encountered.

      -s       Report files which are the same, which are otherwise not
               mentioned.

      -Sname   Start a directory diff in the middle, beginning with file
               name.

   SEE ALSO
      cc(1V), cmp(1), comm(1), cpp(1), diff3(1V), ed(1), pr(1V)

   DIAGNOSTICS
      Exit status is 0 for no differences, 1 for some differences, 2 for
      trouble.

      Missing newline at end of file X Indicates that the last line of
      file X did not have a NEWLINE.  If the lines are different, they
      will be flagged and output, although the output will seem to
      indicate they are the same.

   BUGS
      Editing scripts produced under the -e or -f option are naive about
      creating lines consisting of a single '.'.

      When comparing directories with the -b, -w or -i options specified,
      diff first compares the files (as in cmp(1), and then runs the
      regular diff algorithm if they are not equal.  This may cause a
      small amount of spurious output if the files then turn out to be
      identical because the only differences are insignificant blank
      string or case differences.

      The -D option ignores existing preprocessor controls in the source
      files, and can generate #ifdefs's with overlapping scope.  The
      output should be checked by hand, or run through cc -E (see cc(1V))
      and then diffed with the original source files.  Discrepancies
      revealed should be corrected before compilation.

      The MS-DOS and OS/2 versions are limited to comparing 64K files.
