


IDENT(1)                                                 IDENT(1)


NAME
       ident - identify files

SYNOPSIS
       ident [ -q ] [ file ... ]

DESCRIPTION
       ident searches for all occurrences of the pattern
       $keyword:...$ in the named files or, if no files are
       named, the standard input.

       These patterns are normally inserted automatically by the
       RCS command co(1), but can also be inserted manually.  The
       option -q suppresses the warning given if there are no
       patterns in a file.

       ident works on text files as well as object files and
       dumps.  For example, if the C program in f.c contains

              #include <stdio.h>
              static char const rcsid[] =
                "$Id: f.c,v 5.2 1992/07/28 16:12:44 eggert Exp
              $";
              int main() { return printf("%s\n", rcsid) == EOF; }

       and f.c is compiled into f.o, then the command

              ident  f.c  f.o

       will output

              f.c:
                  $Id: f.c,v 5.2 1992/07/28 16:12:44 eggert Exp $
              f.o:
                  $Id: f.c,v 5.2 1992/07/28 16:12:44 eggert Exp $

       See co(1) for the list of keywords that it maintains.
       ident finds all instances of patterns that look like
       keyword strings, even if they are not actually keywords.
       This gives you information about nonstandard keywords like
       $XConsortium$.

       If a C program defines a string like rcsid above but does
       not use it, lint(1) may complain, and some C compilers
       will optimize away the string.  The most reliable solution
       is to have the program use the rcsid string, as shown in
       the example above.

IDENTIFICATION
       Author: Walter F. Tichy.
       Revision Number: 5.2; Release Date: 1992/07/28.
       Copyright 1982, 1988, 1989 by Walter F. Tichy.
       Copyright 1990, 1992 by Paul Eggert.




GNU                         1992/07/28                          1





IDENT(1)                                                 IDENT(1)


SEE ALSO
       ci(1), co(1), rcs(1), rcsdiff(1), rcsintro(1),
       rcsmerge(1), rlog(1), rcsfile(5)
       Walter F. Tichy, RCS--A System for Version Control,
       Software--Practice & Experience 15, 7 (July 1985),
       637-654.



















































GNU                         1992/07/28                          2


