/*******************************************************************
*                                                                  *
* 	Description:  Implementation of the splash screen class. Class  *
*					  name is TStartupPicture.                          *
*                                                                  *
*  Author : Christof Schneider                                     *
*                                                                  *
*  Date : 20.2.94                                                  *
*																						 *
*  Name : splshscr.cpp                                             *
*                                                                  *
*  Borland Magazin, BorNet, CompuServe                             *
*                                                                  *
*******************************************************************/

#ifndef __SPLSHSCRN_DLL__
// defines

#define __SPLSHSCRN_DLL__

// includes
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "splshscr.h"

// implementation for TStartupPicture

// constructors
TStartupPicture::TStartupPicture (HINSTANCE hInstance, int nResourceId)
{
Initialize (hInstance) ;
ptrBmpStartupPicture = new TBitmap (ResourceInstance, MAKEINTRESOURCE (nResourceId )) ;
}

TStartupPicture::TStartupPicture (HINSTANCE hInstance, LPSTR szPictureName)
{
Initialize (hInstance) ;
ptrBmpStartupPicture = new TBitmap (ResourceInstance, szPictureName) ;
}

TStartupPicture::TStartupPicture (const TBitmap &bmpPicture)
{
Initialize ((HINSTANCE)0) ;
ptrBmpStartupPicture = new TBitmap (bmpPicture) ;
}

TStartupPicture::TStartupPicture (const HBITMAP hBitmap)
{
Initialize ((HINSTANCE)0) ;
ptrBmpStartupPicture = new TBitmap (hBitmap) ;
}

// destructors

TStartupPicture::~TStartupPicture ()
{
// Old picture restores the original desktop
ptrDcDesktop->BitBlt (*ptrRctStartupPicture,
							 *ptrDcOriginalPicture,
							 TPoint (0,0)) ;

// delete all resources
if (ptrBmpStartupPicture != NULL)
	delete ptrBmpStartupPicture ;
if (ptrBmpOriginalPicture != NULL)
	delete ptrBmpOriginalPicture ;
if (ptrDcStartupPicture != NULL)
	delete ptrDcStartupPicture ;
if (ptrPntScreenWidth!= NULL)
	delete ptrPntScreenWidth ;
if (ptrDcOriginalPicture != NULL)
	delete ptrDcOriginalPicture ;
if (ptrDcDesktop != NULL)
	delete ptrDcDesktop ;
if (ptrRctStartupPicture != NULL)
	delete ptrRctStartupPicture ;
}

// member functions

void TStartupPicture::ShowPicture ()
{
// Get size of whole screen and store it in a Point variable
ptrPntScreenWidth = new TPoint (GetSystemMetrics (SM_CXSCREEN),
										  GetSystemMetrics(SM_CYSCREEN)) ;
// Get a permission to read and write to the desktop
ptrDcDesktop = new TScreenDC () ;
// Create a compatible DC (the backup DC in memory)
ptrDcOriginalPicture = new TMemoryDC (*ptrDcDesktop) ;
// Create a Bitmap object that will hold the original desktop contents
ptrBmpOriginalPicture = new TBitmap (*ptrDcDesktop,
												 ptrBmpStartupPicture->Width (),
												 ptrBmpStartupPicture->Height ()) ;
// Select the Original Picture into the backup DC
ptrDcOriginalPicture->SelectObject (*ptrBmpOriginalPicture) ;
// Copy the desktop picture into the memory DC
ptrDcOriginalPicture->BitBlt (0, 0,
										ptrBmpStartupPicture->Width(),
										ptrBmpStartupPicture->Height(),
										*ptrDcDesktop,
										(ptrPntScreenWidth->x - ptrBmpStartupPicture->Width()) / 2,
										(ptrPntScreenWidth->y - ptrBmpStartupPicture->Height()) / 2) ;
// Create another DC in memory for the startup picture
ptrDcStartupPicture = new TMemoryDC () ;
// Create a rectangle, which is as heigh and width as the startup picture an is centered on the screen.
ptrRctStartupPicture = new TRect ((ptrPntScreenWidth->x - ptrBmpStartupPicture->Width()) / 2,
											 (ptrPntScreenWidth->y - ptrBmpStartupPicture->Height()) / 2,
											 (ptrPntScreenWidth->x + ptrBmpStartupPicture->Width()) / 2,
											 (ptrPntScreenWidth->y + ptrBmpStartupPicture->Height()) / 2 ) ;
// Select the startup picture into the proper DC
ptrDcStartupPicture->SelectObject (*ptrBmpStartupPicture) ;

// Show the picture with its desired form on the screen
DrawBitmap (*ptrDcStartupPicture,
				*ptrDcDesktop,
				*ptrRctStartupPicture)  ;
}

void TStartupPicture::ShowPicture (DWORD nMilliseconds)
{
// Show picture
ShowPicture () ;
// Get tick count since program start
DWORD dwTimeLeft = GetTickCount () ;
// Wait for a moment
while ((dwTimeLeft + nMilliseconds) > GetTickCount()) ;
}

void TStartupPicture::ShowStartupPicture (DWORD nMilliseconds, int nWhichVersion)
{
// Save the modus how the startup picture will pop up
nVersion = nWhichVersion ;
// Go on
ShowPicture (nMilliseconds) ;
}

void TStartupPicture::RandomOccupation (int *ptrIntArray, int nNumber)
{
int nRandomNumber ;
int nCount ;

for (int nIndex = nNumber ; nIndex > 0 ; nIndex--)
	{
	// For all numbers left make a random decision which position is the next
	nRandomNumber = (rand () % nIndex) ;
	for (int j = 0, nCount = 0 ; j < nNumber ; j++)
		{
		// find that position and if found write in current index
		if (nCount == nRandomNumber)
			{
			// if current position is empty fill in index number
			if (ptrIntArray[j] == 0)
				{
				ptrIntArray[j] = nIndex - 1 ;
				break ;
				}
			else
				// position is already filled with an index number
				continue ;
			}
			// if position is empty and random position isn't reached, increment count
			if (ptrIntArray[j] == 0)
				nCount++ ;
		}
	}
}

void TStartupPicture::DrawBitmap (TDC& 		refDcSource,
											 TDC&       refDcDestination,
											 TRect&     refRctDestination)
{
TPoint PntPosition (0,0) ;
TPoint PntSrcPosition ;
TRect  RctDestination = refRctDestination ;
TRect  RctTemp(TPoint(0,0), refRctDestination.Size());
TSize  SizCurrentFrame (1, 1) ;



switch (nVersion)
	{
	case HORIZONTALPOPUP :  RctDestination.left += refRctDestination.Width() / 2 ;
									RctDestination.right -= refRctDestination.Width() / 2 ;
									do {
										RctDestination = RctDestination.InflatedBy (1, 0) ;
										refDcDestination.BitBlt (RctDestination, refDcSource, RctDestination.TopLeft() - refRctDestination.TopLeft()) ;
										}
									while (RctDestination != refRctDestination) ;
									return ;

	case VERTICALPOPUP : RctDestination.top += refRctDestination.Height() / 2 ;
								RctDestination.bottom -= refRctDestination.Height() / 2 ;
								do
									{
									RctDestination = RctDestination.InflatedBy (0, 1) ;
									refDcDestination.BitBlt (RctDestination, refDcSource, RctDestination.TopLeft() - refRctDestination.TopLeft()) ;
									}
								while (RctDestination != refRctDestination) ;

								return ;

	case FRAMEPOPUP :	RctDestination.left += refRctDestination.Width() / 2 ;
							RctDestination.right -= refRctDestination.Width() / 2 ;
							RctDestination.top += refRctDestination.Height() / 2 ;
							RctDestination.bottom -= refRctDestination.Height() / 2 ;
							do
								{
								RctDestination = RctDestination.InflatedBy (1, 1) ;
								if (RctDestination.left <= refRctDestination.left && RctDestination.top > refRctDestination.top)
									RctDestination = RctDestination.InflatedBy (-1, 0) ;
								if (RctDestination.top <= refRctDestination.top && RctDestination.left > refRctDestination.left)
									RctDestination = RctDestination.InflatedBy (0, -1) ;
								refDcDestination.BitBlt (RctDestination, refDcSource, RctDestination.TopLeft() - refRctDestination.TopLeft()) ;
								}
							while (RctDestination != refRctDestination) ;
							return ;

	case STARSHINEPOPUP :   // Inialize random number generator
									randomize() ;
									int *nOccupationRow ;
									int *nOccupationColumn ;
									int k, l, m  ;
									int nHorDist ;

									// Get place for random numbers and initialize array with null
									nOccupationRow = new int [refRctDestination.Height()] ;
									nOccupationColumn = new int [refRctDestination.Width()] ;
									memset (nOccupationRow, 0, sizeof (int) * refRctDestination.Height()) ;
									memset (nOccupationColumn, 0, sizeof (int) * refRctDestination.Width()) ;

									// Make as much random numbers as the picture is as hight as wide
									RandomOccupation (nOccupationColumn, refRctDestination.Width()) ;

									// Same thing do with height values
									RandomOccupation (nOccupationRow, refRctDestination.Height()) ;

									// Show bits on the screen in the random order and use a special algorithm for cursoring thorugh random values
									nHorDist = ((rand() % 10) + 1) ;
									for (m = 0, k = 0 ; m < refRctDestination.Width() ; m++, k = m)
										for (l = 0 ; l < refRctDestination.Height() ; k+=nHorDist, l++)
											{
											if (k  >=  refRctDestination.Width())
												k -= refRctDestination.Width() ;

											// Build Point which is next to show
											PntSrcPosition.x = nOccupationColumn[k] ;
											PntSrcPosition.y = nOccupationRow[l] ;
											// Calculate Position on desktop screen
											PntPosition = PntSrcPosition.OffsetBy (refRctDestination.left, refRctDestination.top) ;
											// Show bit on screen
											refDcDestination.BitBlt (TRect(PntPosition, SizCurrentFrame), refDcSource, PntSrcPosition) ;
											}

									// delete resources
									delete [] nOccupationRow ;
									delete [] nOccupationColumn ;
									return ;

	case ZOOMPOPUP :  int 	i ;
							float	nSecondZoomingStepWidth ;
							int 	nStep1, nStep2 ;
							int   nDistance1, nDistance2 ;
							int   nStepsDirection ;
							typedef enum {Horizontal, Vertical} ZoomingDirection ;

							// Which side of rectangle is bigger ?
							if (refRctDestination.Width() > refRctDestination.Height())
								{
								nDistance1 = refRctDestination.Width() / 2 ;
								nDistance2 = refRctDestination.Height() / 2 ;
								nStepsDirection = Horizontal ;
								nSecondZoomingStepWidth = ((int) (nDistance2)) / ((float)(nDistance1 / ZOOMINGSTEPWIDTH)) ;
								PntPosition.x = refRctDestination.left + nDistance1 ;
								PntPosition.y = refRctDestination.left + nDistance2 ;
								}
							else
								{
								nDistance1 = refRctDestination.Height() / 2 ;
								nDistance2 = refRctDestination.Width() / 2 ;
								nStepsDirection = Vertical ;
								nSecondZoomingStepWidth = ((int) (nDistance2)) / ((float)(nDistance1 / ZOOMINGSTEPWIDTH)) ;
								PntPosition.y = refRctDestination.left + nDistance1 ;
								PntPosition.x = refRctDestination.left + nDistance2 ;
								}

							// do zooming

							for (i = 0 , nStep1 = 1, nStep2 = 1; refRctDestination.left < PntPosition.x && refRctDestination.top < PntPosition.y ; i++, nStep1 += i * ZOOMINGSTEPWIDTH, nStep2 += i * nSecondZoomingStepWidth)
								{
								if (nStepsDirection == Horizontal)
									{
									// Calculate new upper left point
									PntPosition.x = refRctDestination.left + nDistance1 - nStep1 ;
									PntPosition.y = refRctDestination.top + nDistance2 - nStep2 ;
									// Calculate new dimensions of rectangle
									SizCurrentFrame.cx = 2 * nStep1 ;
									SizCurrentFrame.cy = 2 * nStep2 ;
									}
								else
									{
									PntPosition.y = refRctDestination.top + nDistance1 - nStep1 ;
									PntPosition.x = refRctDestination.left + nDistance2 - nStep2 ;
									SizCurrentFrame.cx = 2 * nStep2 ;
									SizCurrentFrame.cy = 2 * nStep1 ;
									}
								// check whether upper left point (one of its coordinates) will be less than original point
								if (PntPosition.x < refRctDestination.left)
									PntPosition.x = refRctDestination.left ;
								if (PntPosition.y < refRctDestination.top)
									PntPosition.y = refRctDestination.top ;
								// adjust size of rectangle
								RctDestination.Set (0, 0, SizCurrentFrame.cx, SizCurrentFrame.cy) ;
								if (RctTemp.Contains (RctDestination) == FALSE)
									SizCurrentFrame = refRctDestination.Size() ;

								// Show current picture in current size
								refDcDestination.StretchBlt(TRect(PntPosition, SizCurrentFrame), refDcSource, TRect (TPoint(0, 0), TSize (refRctDestination.Width(), refRctDestination.Height()))) ;
								}
							return ;

	case DEFAULTPOPUP :  // Copy picture from Source DC to screen (desktop)
				 default :  refDcDestination.BitBlt (refRctDestination, refDcSource, PntPosition) ;
								return ;
	}
}

void TStartupPicture::Initialize (HINSTANCE  hInstance)
{
// Initialize

nVersion = 0 ;
ResourceInstance = hInstance ;
ptrBmpStartupPicture = NULL ;
ptrBmpOriginalPicture = NULL ;
ptrDcStartupPicture = NULL ;
ptrDcOriginalPicture = NULL ;
ptrPntScreenWidth = NULL ;
ptrDcDesktop = NULL ;
ptrRctStartupPicture = NULL ;
}

#endif
