/*
 *  File Browse Utility, version 1.4
 *
 *  (c) 1992 Barry Nance
 *
 *  distributed through
 *  BYTE Magazine's Software Corner
*/

// Original program by Mr. Nance was all incorporated in one file: LIST.C.
// I split it up in order to demonstrate some PPT functionality.
// No substantive changes.   This is the header file LIST.H.
// There are also 2 source modules, LIST1.C and LIST2.c.
// Gary L. Levine, Feb/1993.

#define     HELP_LINES    17
#define     CSIZE        256             /* character set size */

#define     BUFSIZE     4096
#define     BUFSIZEL    4096l

#define     STR_SIZE    1000

#define     TRUE           1
#define     FALSE          0

#define     BELL           7
#define     BS             8
#define     TAB            9
#define     LINEFEED      10
#define     FORMFEED      12
#define     CR            13
#define     BACKTAB       15
#define     ESC           27
#define     SPACE         32

#define     HOMEKEY       71
#define     ENDKEY        79
#define     UPKEY         72
#define     DOWNKEY       80
#define     PGUPKEY       73
#define     PGDNKEY       81
#define     LEFTKEY       75
#define     INSKEY        82
#define     RIGHTKEY      77
#define     DELKEY        83
#define     CTRLLEFTKEY  115
#define     CTRLRIGHTKEY 116
#define     F1            59
#define     F2            60
#define     F3            61
#define     F4            62
#define     F5            63
#define     F6            64
#define     F7            65
#define     F8            66
#define     F9            67
#define     F10           68

struct      csavetype
            {
            unsigned int curloc;
            unsigned int curmode;
            };

/************************************/

int     kbdstring(char buff[], int max_chars);
void    getkey(void);

int     fgetrecord(unsigned char buff[], int max_chars);
int     fgetline(unsigned char buff[], int max_chars);
int     fgetbyte(void);

int     fprevrecord(void);
int     fprevline(void);
int     fprevbyte(void);

void    drawbox(void);
void    gohome(void);
void    find_text(void);
void    showfile(void);
void    fill_window(void);
void    show_line_num(void);
void    display_line(void);
void    display_hex(void);
void    adjust_line_number(int amount);

int     get_video_mode(void);
void    save_cursor(struct csavetype *csave);
void    restore_cursor(struct csavetype *csave);
void    scroll_up(unsigned char numlines);
void    scroll_dn(unsigned char numlines);

int     search(unsigned char *pat, int plen, unsigned char *str, int slen);
void    search_setup(unsigned char *pat, int plen, int icase);

/************************************/
