/*
 *  File Browse Utility, version 1.4
 *
 *  (c) 1992 Barry Nance
 *
 *  distributed through
 *  BYTE Magazine's Software Corner
*/

// Original program by Mr. Nance was all incorporated in one file: LIST.C.
// I split it up in order to demonstrate some PPT functionality.
// No substantive changes.   This is the 1st of two source modules,
// LIST1.C and LIST2.c.  There is also a header file, LIST.H.
// Gary L. Levine, Feb/1993.

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <bios.h>
#include <fcntl.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <process.h>
#include <ctype.h>
#include <share.h>
#include <errno.h>
#include <list.h>


/************************************/

char     *fileprompt = "Filename? ";
char     *inv_arg    = "Invalid command line arguments.";
char     *notfound   = "File not found.";
char     *emptyfile  = "File is empty.";
char     *noaccess   = "File in use.  (Try later)";
char     *presskey   = "Press a key to continue.";

char    *help[HELP_LINES] =
            {
"                    File Browser 1.4       (c) 1992 Barry Nance           ",
"                                          BYTE Magazine's Software Corner ",
"                                                                          ",
"      Press:                                                              ",
"  ESC, X, or Q.....Quit                   W.........Toggle line wrap      ",
"  T or HOME........Top of file            H.........Toggle Hex/ASCII      ",
"  B or END.........Bottom of file         D.........Shell to DOS          ",
"  N................Next file              P.........Previous file         ",
"  PgUp or PgDn.....Up/Down a screenful                                    ",
"   or Spacebar..Next screenful                                         ",
"  \x1a.............Up/down/right/left                                     ",
"  F................Find text (any case)                                   ",
"  S................Search (exact case)                                    ",
"  A................Find/search again                                      ",
"                                                                          ",
"                                                                          ",
"                          <Press a key to resume>                         "
            };

unsigned char string[STR_SIZE];
char        string1[101];

char        search_arg[81];
int         search_flag;
int         ignore_case;
int         spos;

long        line_number;
long        linenum_save;

unsigned char CharCode;
unsigned char ScanCode;

int         xesc = FALSE;
int         eof_flag = FALSE;
int         start_of_file = TRUE;
int         line_end_char = 0;
int         hex_mode = FALSE;
int         wrap_mode = FALSE;

int         start_save;
int         eof_save;
int         fbufblock_save;
int         fbufndx_save;

unsigned    top, left, bottom, right, screen_width, screen_height;
int         left_relative_pos;

struct ftime ftimestruc;
struct ffblk findblock;

char        filename[80];
char        drive[5];
char        path[81];
char        name[10];
char        ext[5];

int         count;
int         flag;
int         file_num;
int         current_row;
int         file_is_empty;

int         screen_rcds;
int         screen_lines_hold;
int         screen_lines;
int         lines_read;
int         rcds_read;
int         lines_displayed;

unsigned    i, j, k;

int         fh;
long        filesize;
long        curr_filepos;
long        temp_long;
unsigned    num_blocks;
int         fbufndx;
int         fbufbytes;
unsigned    fbufblock;

char        *filelist_ptr;
char        *list_ptr;
char        *file_buff_ptr;
char        *screen_save_ptr;
char        *dos_screen_save_ptr;

char        line_save[160];

unsigned char low_inten;
unsigned char high_inten;
unsigned char found_attr;

struct  csavetype   cursor_data;
struct  csavetype   my_cpos;
struct  csavetype   dos_cpos;

union       REGS regs;

static int skip[CSIZE];         /* increment to rightmost occurance of ch */
static int cmap[CSIZE];         /* upper to lowercase character map */


/************************************/

void    main(int argc, char *argv[])
        {
        if (get_video_mode() == 7)
            {
            low_inten   = 0x07;
            high_inten  = 0x0f;
            found_attr  = 0x70;
            }
        else
            {
            low_inten   = 0x02;
            high_inten  = 0x03;
            found_attr  = 0x0C;
            }

        file_buff_ptr = malloc(BUFSIZE+10);
        if (file_buff_ptr == NULL)
            {
            printf("Insufficient memory.\n");
            return;
            }
        memset(file_buff_ptr, 0, BUFSIZE+10);

        screen_save_ptr = malloc(4000);
        if (screen_save_ptr == NULL)
            {
            free(file_buff_ptr);
            printf("Insufficient memory.\n");
            return;
            }

        dos_screen_save_ptr = malloc(4000);
        if (dos_screen_save_ptr == NULL)
            {
            free(file_buff_ptr);
            free(screen_save_ptr);
            printf("Insufficient memory.\n");
            return;
            }

        filelist_ptr = calloc(1001, 13);
        if (filelist_ptr == NULL)
            {
            free(file_buff_ptr);
            free(screen_save_ptr);
            free(dos_screen_save_ptr);
            printf("Insufficient memory.\n");
            return;
            }
        list_ptr = filelist_ptr;
        count = 0;

        textattr(low_inten);
        gettext(1, 1, 80, 25, screen_save_ptr);
        save_cursor(&cursor_data);

        if (argc == 1)
            {
            window(1, 25, 80, 25);
            clrscr();
            window(1,  1, 80, 25);
            top = 1; left = 1; bottom = 24; right = 80;
            textattr(low_inten);
            gotoxy(1, 25);
            cputs(fileprompt);
            gotoxy(11, 25);
            kbdstring(filename, 70);
            goto p30;
            }

        if (argc == 2)
            {
            top = 1; left = 1; bottom = 24; right = 80;
            strcpy(filename, argv[1]);
            goto p30;
            }

        if (argc == 6)
            {
            top    = atoi(argv[2]);
            left   = atoi(argv[3]);
            bottom = atoi(argv[4]);
            right  = atoi(argv[5]);
            if (top == 0 || left == 0 || bottom == 0 || right == 0)
                goto p20;
            strcpy(filename, argv[1]);
            goto p30;
            }

p20:
        gotoxy(1, 24);
        textattr(high_inten);
        cputs(inv_arg);
        gohome();

p30:
        if (strlen(filename) == 0)
            gohome();

        if ( (flag = findfirst(filename, &findblock, 0)) != 0 )
            {
            printf("\n%s\n", notfound);
            free(file_buff_ptr);
            free(screen_save_ptr);
            free(dos_screen_save_ptr);
            free(filelist_ptr);
            exit(1);
            }

        screen_width  = right - left - 1;
        screen_height = bottom - top - 1;

        fnsplit(filename, drive, path, name, ext);

        while (flag == 0)
            {
            strcpy(list_ptr, findblock.ff_name);
            list_ptr += 13;
            count++;
            if (count >= 1000)
                break;
            flag = findnext(&findblock);
            }
        list_ptr  = filelist_ptr;
        file_num = 1;

open_a_file:
        drawbox();

        fnmerge(filename, drive, path, list_ptr, NULL);
        if (_osmajor < 2)
            fh = open(filename, O_RDONLY | O_BINARY);
        else
            fh = open(filename, O_RDONLY | O_BINARY | O_DENYNONE);

        if (fh == -1)
            {
            sound(800);
            delay(100);
            nosound();
            gotoxy(left+1, top+1);
            textattr(high_inten);
            if (errno == ENOENT)
                cputs(notfound);
            else
                cputs(noaccess);
            gohome();
            }

        getftime(fh, &ftimestruc);
        filesize   = filelength(fh);
        temp_long  = (filesize + (BUFSIZEL - 1l)) / BUFSIZEL;
        num_blocks = (unsigned) temp_long;

        start_of_file = TRUE;
        eof_flag  = FALSE;
        fbufblock = 0;
        fbufndx   = 0;
        lseek(fh, 0l, SEEK_SET);
        fbufbytes = read(fh, file_buff_ptr, BUFSIZE);

        if (fbufbytes == 0)
            file_is_empty = TRUE;
        else
            file_is_empty = FALSE;

        if (strchr(file_buff_ptr, LINEFEED) != NULL)
            line_end_char = LINEFEED;
        else
            line_end_char = CR;

        textattr(high_inten);
        window(1, 25, 80, 25);
        clrscr();
        window(1, 1, 80, 25);
        gotoxy(1, 25);
        cprintf(
"Line:       [            ]  %9ld bytes  %2d/%2d/%2d %2d:%2.2d:%2.2d  (F1=help)   ",
                      filesize,
                (int) ftimestruc.ft_month,
                (int) ftimestruc.ft_day,
                (int) ftimestruc.ft_year + 80,
                (int) ftimestruc.ft_hour,
                (int) ftimestruc.ft_min,
                (int) ftimestruc.ft_tsec);

        gotoxy(14, 25);
        textattr(high_inten);
        strcpy(string, list_ptr);
        while (strlen(string) < 12)
            strcat(string, " ");
        cputs(string);

        gotoxy(80, 25);

        CharCode = 0;
        ScanCode = HOMEKEY;
        showfile();

get_key:
        getkey();

        if (   CharCode == 'X' 
            || CharCode == 'x'
            || CharCode == 'Q'
            || CharCode == 'q'
            || CharCode == ESC)
                {
                close(fh);
                xesc = TRUE;
                gohome();
                }

        if (CharCode == 'T' || CharCode == 't')
            {
            CharCode = 0;
            ScanCode = HOMEKEY;
            }
        else
        if (CharCode == 'B' || CharCode == 'b')
            {
            CharCode = 0;
            ScanCode = ENDKEY;
            }

        if (CharCode == 'H' || CharCode == 'h')
            {
            lines_read  = 0;
            rcds_read   = 0;
            wrap_mode = FALSE;
            if (hex_mode)
                {
                hex_mode = FALSE;
                line_number = -1L;
                while (rcds_read < (bottom - top - 1) / 2)
                    if (fprevrecord() == -1)
                        break;
                }
            else
                {
                while (rcds_read < screen_rcds)
                    if (fprevrecord() == -1)
                        break;
                hex_mode = TRUE;
                }
            CharCode = 255;
            showfile();
            goto get_key;
            }

        if (CharCode == 'W' || CharCode == 'w')
            {
            if (hex_mode)
                goto get_key;
            rcds_read  = 0;
            lines_read = 0;
            while (rcds_read < screen_rcds)
                if (fprevrecord() == -1)
                    break;
            if (wrap_mode)
                wrap_mode = FALSE;
            else
                wrap_mode = TRUE;
            CharCode = 255;
            line_number = -1L;
            showfile();
            goto get_key;
            }

        if ( CharCode == '?' || (CharCode == 0 && ScanCode == F1) )
            {
            gettext(1, 1, 80, 25, dos_screen_save_ptr);
            save_cursor(&dos_cpos);
            textattr(low_inten);
            window(left+1, top+1, right-1, bottom-1);
            clrscr();
            window(1, 1, 80, 25);
            for (k=0; k<HELP_LINES; k++)
                {
                if (k+4 >= bottom) break;
                gotoxy(2, k+3);
                cputs(help[k]);
                }
            gotoxy(80, 25);
            getkey();
            puttext(1, 1, 80, 25, dos_screen_save_ptr);
            restore_cursor(&dos_cpos);
            goto get_key;
            }

        if (CharCode == 'D' || CharCode == 'd')
            {
            gettext(1, 1, 80, 25, dos_screen_save_ptr);
            save_cursor(&dos_cpos);
            puttext(1, 1, 80, 25, screen_save_ptr);
            restore_cursor(&cursor_data);
            textattr(high_inten);
            printf("\n");
            printf(
"         ͻ   \n");
            printf(
"                Type EXIT to resume file browsing.          \n");
            printf(
"         ͼ   \n");
            textattr(low_inten);
            system("");
            puttext(1, 1, 80, 25, dos_screen_save_ptr);
            restore_cursor(&dos_cpos);
            goto get_key;
            }

        if (CharCode == 'N' || CharCode == 'n')
            {
            if (file_num < count)
                {
                close(fh);
                list_ptr += 13;
                file_num++;
                goto open_a_file;
                }
            goto get_key;
            }

        if (CharCode == 'P' || CharCode == 'p')
            {
            if (file_num > 1)
                {
                close(fh);
                list_ptr -= 13;
                file_num--;
                goto open_a_file;
                }
            goto get_key;
            }

        if (CharCode == 0 || CharCode == 0xE0)
            if (   ScanCode == HOMEKEY
                || ScanCode == ENDKEY
                || ScanCode == PGUPKEY
                || ScanCode == PGDNKEY
                || ScanCode == UPKEY
                || ScanCode == DOWNKEY
                || ScanCode == LEFTKEY
                || ScanCode == RIGHTKEY)
                    {
                    showfile();
                    goto get_key;
                    }

        if (   CharCode == ' ' || CharCode == CR)
                {
                showfile();
                goto get_key;
                }

        if (CharCode == 'F' || CharCode == 'f'
            || CharCode == 'S' || CharCode == 's'
            || CharCode == 'A' || CharCode == 'a')
            {
            find_text();
            goto get_key;
            }

        goto get_key;
        }

/************************************/

void    drawbox(void)
        {
        int      i;

        textattr(low_inten);
        window(left, top, right, bottom);
        clrscr();
        window(1, 1, 80, 25);
        gotoxy(left, top);
        textattr(high_inten);
        cprintf("");

        gotoxy(left+1, top);
        cprintf("%.*s", (right - left) - 1,
"");

        gotoxy(right, top);
        cprintf("");

        for (i=top+1; i<bottom; i++)
            {
            gotoxy(left, i);
            cprintf("");
            gotoxy(right, i);
            cprintf("");
            }

        gotoxy(left, bottom);
        cprintf("");

        gotoxy(left+1, bottom);
        cprintf("%.*s", (right - left) - 1,
"");

        gotoxy(right, bottom);
        cprintf("");
        }

/************************************/

void    find_text(void)
        {
        gettext(1, 25, 80, 25, line_save);
        save_cursor(&my_cpos);
        window(1, 25, 80, 25);
        clrscr();
        window(1,  1, 80, 25);
        if ( strlen(search_arg) < 1 
          || (CharCode != 'A' && CharCode != 'a') )
            {
            textattr(high_inten);
            gotoxy(1, 25);
            if (CharCode == 'S' || CharCode == 's')
                {
                ignore_case = FALSE;
                cputs("Find(case-sen): ");
                gotoxy(17, 25);
                }
            else
                {
                ignore_case = TRUE;
                cputs("Find: ");
                gotoxy(7, 25);
                }
            kbdstring(search_arg, 50);
            if (strlen(search_arg) < 1)
                {
                puttext(1, 25, 80, 25, line_save);
                restore_cursor(&my_cpos);
                return;
                }
            }
        fbufblock_save = fbufblock;
        fbufndx_save   = fbufndx;
        start_save     = start_of_file;
        eof_save       = eof_flag;
        linenum_save   = line_number;
        search_setup(search_arg, strlen(search_arg), ignore_case);
        search_flag = 1;
        if (line_number == 1L
            && (CharCode != 'A' || CharCode != 'a'))
            {
            start_of_file = TRUE;
            eof_flag  = FALSE;
            fbufblock = 0;
            fbufndx   = 0;
            lseek(fh, 0l, SEEK_SET);
            fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
            }
        lines_read = 0;
        gotoxy(1, 25);
        clreol();
        cputs("Looking... ");
        while (1)
            {
            if (fgetrecord(string, STR_SIZE) == -1)
                {
                gotoxy(1, 25);
                cputs("Not found.  <Press a key>");
                gotoxy(80, 25);
                getkey();
                break;
                }
            if ( (spos = search(search_arg, strlen(search_arg),
                          string, strlen(string))) != -1)
                {
                line_number = -1L;
                search_flag = 2;
                if (!wrap_mode && !hex_mode)
                    if (spos > left_relative_pos + screen_width)
                        {
                        left_relative_pos = spos - (screen_width / 2);
                        left_relative_pos = max(0, spos);
                        }
                    else
                        {
                        left_relative_pos = 0;
                        }
                break;
                }
            }
        puttext(1, 25, 80, 25, line_save);
        restore_cursor(&my_cpos);
        if (search_flag == 2)
            {
            showfile();
            }
        else
            {
            line_number   = linenum_save;
            start_of_file = start_save;
            eof_flag  = eof_save;
            fbufblock = fbufblock_save;
            fbufndx   = fbufndx_save;
            lseek(fh, ((long) fbufblock) * BUFSIZEL, SEEK_SET);
            fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
            }
        search_flag = 0;
        }

/************************************/

void    adjust_line_number(int amount)
        {
        if (line_number == -1L)
            return;

        line_number += amount;
        if (line_number < 1L)
            line_number = 1L;
        }

/************************************/

void    showfile(void)
        {
        if (search_flag == 2)
            {
            rcds_read = 0;
            lines_read = 0;
            while (lines_read < screen_lines / 2)
                if (fprevline() == -1)
                    break;
            fill_window();
            show_line_num();
            return;
            }

        if (ScanCode == HOMEKEY)
            {
            left_relative_pos = 0;
            line_number = 1L;
            start_of_file = TRUE;
            eof_flag  = FALSE;
            fbufblock = 0;
            fbufndx   = 0;
            if (filesize == 0l)
                {
                sound(800);
                delay(100);
                nosound();
                gotoxy(left+1, top+1);
                textattr(high_inten);
                cputs(emptyfile);
                return;
                }
            else
                {
                lseek(fh, 0l, SEEK_SET);
                fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
                fill_window();
                show_line_num();
                }
            return;
            }

        if (file_is_empty)
            return;

        if (ScanCode == PGUPKEY)
            {
            if (line_number == 1L)
                return;
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < screen_lines)
                if (fprevline() == -1)
                    {
                    lines_read = 0;
                    while (lines_read < screen_lines)
                        if (fgetline(string, STR_SIZE) == -1)
                            break;
                    return;
                    }
            lines_read = 0;
            rcds_read  = 0;
            while (lines_read < bottom - top - 1)
                if (fprevline() == -1)
                    {
                    line_number = 1L;
                    break;
                    }
            adjust_line_number(rcds_read * -1);
            fill_window();
            show_line_num();
            return;
            }

        if (ScanCode == PGDNKEY)
            {
            if (eof_flag)
                return;
            rcds_read = 0;
            screen_lines_hold = screen_lines;
            fill_window();
            adjust_line_number(screen_lines_hold);
            show_line_num();
            return;
            }

        if (ScanCode == UPKEY)
            {
            if (line_number == 1L)
                return;
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < screen_lines)
                if (fprevline() == -1)
                    {
                    lines_read  = 0;
                    while (lines_read < screen_lines)
                        if (fgetline(string, STR_SIZE) != -1)
                            break;
                    return;
                    }
            if (fprevline() != -1)
                {
                fgetline(string, STR_SIZE);
                scroll_dn(1);
                textattr(low_inten);
                current_row = top + 1;
                if (hex_mode)
                    display_hex();
                else
                    display_line();
                adjust_line_number(-1);
                }
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < screen_lines - 1)
                if (fgetline(string, STR_SIZE) == -1)
                    break;
            show_line_num();
            return;
            }

        if (ScanCode == DOWNKEY)
            {
            if (eof_flag)
                return;
            rcds_read  = 0;
            lines_read = 0;
            if (fgetline(string, STR_SIZE) != -1)
                {
                scroll_up(1);
                textattr(low_inten);
                current_row = bottom - 1;
                if (hex_mode)
                    display_hex();
                else
                    display_line();
                adjust_line_number(1);
                show_line_num();
                }
            return;
            }

        if (ScanCode == LEFTKEY)
            {
            if (left_relative_pos == 0)
                return;
            if (hex_mode || wrap_mode)
                return;
            movetext(left+1, top+1, right-6, bottom-1, 
                        left+6, top+1);
            left_relative_pos -= 5;
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < screen_lines)
                if (fprevline() == -1)
                    break;
            fill_window();
            show_line_num();
            return;
            }

        if (ScanCode == RIGHTKEY)
            {
            if (hex_mode || wrap_mode)
                return;
            if (left_relative_pos >= STR_SIZE - screen_width - 1)
                return;
            left_relative_pos += 5;
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < screen_lines)
                if (fprevline() == -1)
                    break;
            fill_window();
            show_line_num();
            return;
            }

        if (CharCode == CR || CharCode == 255 || CharCode == ' ')
            {
            if (eof_flag)
                return;
            if (CharCode == CR || CharCode == 255)
                left_relative_pos = 0;
            screen_lines_hold = screen_lines;
            rcds_read  = 0;
            lines_read = 0;
            fill_window();
            if (CharCode != 255)
                adjust_line_number(screen_lines_hold);
            show_line_num();
            return;
            }

        if (ScanCode == ENDKEY)
            {
            left_relative_pos = 0;
            line_number = -1L;
            start_of_file = FALSE;
            fbufblock = num_blocks - 1;
            lseek(fh, ((long) fbufblock) * BUFSIZEL, SEEK_SET);
            fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
            fbufndx = fbufbytes - 1;
            rcds_read  = 0;
            lines_read = 0;
            while (lines_read < bottom - top - 2)
                if (fprevline() == -1)
                    break;
            fill_window();
            show_line_num();
            return;
            }
        }

