
/*
 * NEATFADE!
 *
 * This program demonstrates a neat--but otherwise useless--method of
 * fading an image over a background.  Feel free to steal it.
 *
 * Written by Eric W. Lund (CIS ID:74041,1147) and Donald D. Dienst
 * This source file placed in the public domain, June 1, 1994.
 * Requires Fastgraph 3.x or greater to compile.  Requires VGA
 * (register-compatible) to run.
 *
 * Support images:
 *   FG.GIF -- Foreground image, created in Autodesk Animator Pro
 *   BG.GIF -- Background image, clipped and color-reduced from an
 *             image by Alan Gornick, Jr., (C) Aris Multimedia
 *             Entertainment, Inc., 1991-93.  You probably gotta
 *             purchase Aris' "Best of MediaClips" to redistribute
 *             this image in your own works.
 */

#include <fastgraf.h>
#include <stdio.h>
#include <string.h>

void pixelfade (unsigned char *, unsigned char *, int);

#define BG "backgrou.gif"
#define FG "foregrou.gif"
#define UL_X    90
#define UL_Y    95
#define WIDTH   147
#define HEIGHT  19

#define ITERATIONS 16   /* Number of gradations in the fade */
#define TRANSPARENT 0   /* Color used for transparent pixels */

int vpage=1;            /* Visual page (ie, the video page seen by user) */
char plug[]="NEATFADE/Eric W. Lund/Don D. Dienst/1994"; /* A plug, naturally */

void main (void)
{
    int startmode;
    unsigned char key1, key2;
    unsigned char bg_data[WIDTH*HEIGHT], fg_data[WIDTH*HEIGHT];

    startmode=fg_getmode(); /* Store start mode */
    fg_setmode(20); /* Set to standard VGA with page flipping */

    fg_setcolor(1);
    fg_justify (-1,1);
    fg_print (plug, strlen(plug)); /* Plug! */

    fg_setpage(1);  /* Work on page 1 */
    fg_showgif (FG,0); /* Load the Foreground GIF */
    fg_move (UL_X,UL_Y+HEIGHT-1); /* Move to the lower left area of image */
    fg_getimage (fg_data,WIDTH,HEIGHT); /* Store image in RAM */
    fg_showgif (BG,0); /* Load Background GIF */
    fg_move (UL_X,UL_Y+HEIGHT-1); /* Move to same area */
    fg_getimage (bg_data,WIDTH,HEIGHT); /* Store RAM image of background */
    fg_setvpage(1); /* View this page */
    fg_copypage(1,0); /* Make a copy of it, so both pages synch */

    do 
    {
        fg_waitfor (9);
        pixelfade (bg_data, fg_data, 1); /* Fade in */
        fg_waitfor (9);
        pixelfade (fg_data, bg_data, -1); /* Fade out */
        fg_intkey (&key1, &key2); /* Check for keyhits */
    } while (key1==key2 && key2==0); /* Repeat until a key is hit */

    fg_setmode (startmode); /* Reset to original video mode */
    fg_reset();
    printf ("Oh, puke.\n"); /* <stdfilth.h> */
}

/*
 * pixelfade
 *
 * PARAMETERS:
 *  map1 - pointer to a fg_getimage'd bitmap, first image of fade
 *  map2 - pointer to a fg_getimage'd bitmap, last image of fade
 *  dir  - direction of fade (1 = map1 to map2; -1 = map2 to map1)
 *
 * RETURNS:  None
 *
 * DESCRIPTION:  pixelfade creates a series of bitmaps, which it
 * outputs to the screen.  Each bitmap created is (theoretically)
 * one step further from the first image, and one step closer to
 * the last image.  It then returns.  There is NO palette fading
 * here (which is useful for fading to/from a single color screen).
 *
 * REQUIREMENTS:  The two images must use the same palette,
 * and the palette must be sorted in order of decreasing luminosity.
 * It helps a GREAT DEAL if the two images are of similar colors,
 * and the palette contains intermediate colors.
 *
 * MODIFICATION:  The placement of the bitmap and pauses between frames
 * are hand-coded into pixelfade.  It would probably be better to
 * allow passing of a third paramenter, a pointer to an output map,
 * and let the caller do the displaying of images.
 */
void pixelfade (unsigned char *map1, unsigned char *map2, int dir)
{
    int i, n, start=1, end=ITERATIONS;
    unsigned char out[WIDTH*HEIGHT];

    if (dir==-1) /* Change start and end from defaults if backwards */
    {
        start=ITERATIONS-1;
        end=0;
    }

    for (i=start; dir==1?i<=end:i>=end; i+=dir) /* Loop through each map */
    {

/*
    CREATE OUTMAP -- SIMPLE STUFF REALLY; SINCE HIGHER PIXEL NUMBERS
    ARE DARKER THAN LOWER NUMBERS, JUST STEP THROUGH THE NUMBERS
    IN BETWEEN.  IGNORE TRANSPARENT COLORS.
*/

        if (dir==1) /* Forewards fade */
            for (n=0; n<(WIDTH*HEIGHT); n++)
            {
                if (map2[n]==TRANSPARENT) out[n]=map1[n];
                else out[n]=map1[n]+(map2[n]-map1[n])*i/ITERATIONS;
            }
        else /* Backwards fade */
            for (n=0; n<(WIDTH*HEIGHT); n++)
            {
                if (map1[n]==TRANSPARENT) out[n]=map2[n];
                else out[n]=map2[n]+(map1[n]-map2[n])*i/ITERATIONS;
            }
        fg_setpage(!vpage); /* Work on non-visual page */
        fg_move (UL_X,UL_Y+HEIGHT-1); /* Move to lower left of image */
        fg_putimage(out, WIDTH, HEIGHT); /* Output image to screen */
        vpage=!vpage; /* Swap pages (internally) */
        fg_setvpage(vpage); /* Swap pages (externally) and show image */
    }
}

    /***************************************************************/
    /* Alone, listless, breakfast table in an otherwise empty room */
    /***************************************************************/

