[LineStyle]
LineWidth=1
Color=no

[CoordinateSystem]
System=Cartesian
DependentVariable=X
Projection=Perspective
Tilt=30
Rotation=60
xMin=-10
xMax=10
yMin=-10
yMax=10
zMin=-10
zMax=10

[EquationCartesianX]
x= sin(ceil(y)) + floor(z)



[Domain]
Ymin=-10
Ymax=10
Ysteps=40
Zmin=-10
Zmax=10
Zsteps=40

[EquationCartesianY]
if(-5<=x && x<5)

  y = -z

else

  y = z



[Domain]
Xmin=-10
Xmax=10
Xsteps=40
Zmin=-10
Zmax=10
Zsteps=40

[EquationCartesianZ]
//

// Fraunhofer diffraction through

// a circular aperture.

//

d = sqrt(x*x + y*y)

z = 10.0 * pow( sin(d)/d, 2.0 )



[Domain]
Xmin=-10
Xmax=10
Xsteps=40
Ymin=-10
Ymax=10
Ysteps=40

[EquationCylindricalR]
r=10



[Domain]
Thetamin=0
Thetamax=360
Thetasteps=20
Zmin=0
Zmax=10
Zsteps=20

[EquationCylindricalTheta]
theta=10



[Domain]
Rmin=0
Rmax=10
Rsteps=20
Zmin=0
Zmax=10
Zsteps=20

[EquationCylindricalZ]
z=10



[Domain]
Rmin=0
Rmax=10
Rsteps=20
Thetamin=0
Thetamax=360
Thetasteps=20

[EquationSphericalRho]
rho=10*sin(phi)



[Domain]
Phimin=0
Phimax=180
Phisteps=20
Thetamin=0
Thetamax=360
Thetasteps=20

[EquationSphericalPhi]
phi=30*sin(rho)



[Domain]
Rhomin=0
Rhomax=10
Rhosteps=20
Thetamin=0
Thetamax=360
Thetasteps=20

[EquationSphericalTheta]
theta=100*(rho+phi)



[Domain]
Rhomin=0
Rhomax=10
Rhosteps=20
Phimin=0
Phimax=180
Phisteps=20
