CT_PSW		struc
flags		db	?
input		db      ?
CT_PSW		ends

CT_SET		struc
control		dw	?
data		dw	?
launch		dw	?
clear		dw	?
mask_reset	db	?
val_reset	db	?
mask_event	db	?
not_event	db	?
mask_ready	db	?
not_ready	db	?
mask_excep	db	?
not_excep	db	?
mask_state	db	?
inv_state	db	?
mask_dir	db	?
val_dir		db	?
mask_dma	db	?
done_dma	db	?
do_reset	db	?
request		db	?
online		db	?
int_enable	db	?
done_enable	db	?
dma_enable	db	?
CT_SET		ends

CT_PIC		struc
base		dw	?
ack		db	?
chain		db	?
old		dd	?
number		dw	?
save		db	?
CT_PIC		ends

CT_EVENT	equ	20h

_DATA		segment word public 'DATA'
		extrn	_ct_psw:byte
		extrn	_ct_set:word
        	extrn	_ct_pic:word
_DATA		ends

_TEXT		segment	byte public 'CODE'
		assume	cs:_TEXT, ds:_DATA
		public	_cthandle
_cthandle	proc	far
		push	ds
		push	ax
		push	dx
		mov	ax,_DATA
		mov	ds,ax

		mov	dx,word ptr _DATA:_ct_set[control]
		in	al,dx
		mov     ah,byte ptr _DATA:_ct_set[mask_event]
                or	ah,ah		; is intr. detection possible?
                jz      short next	; no
		and	ah,al
		cmp	ah,byte ptr _DATA:_ct_set[not_event]
		jne	short next	; controller set interrupt flag

		test	byte ptr _DATA:_ct_pic[chain],255
		jz	short end	; no other handler
		push	bp
		mov	bp,sp
		mov	ax,word ptr _DATA:_ct_pic[old]
		mov	dx,word ptr _DATA:_ct_pic[old+2]
		xchg	ss:[bp+8],dx
		xchg	ss:[bp+6],ax
		mov	ds,dx
		pop	bp
		pop     dx
		retf	; far jump to old handler
next:
		or	byte ptr _DATA:_ct_psw[flags],CT_EVENT
		mov	byte ptr _DATA:_ct_psw[input],al
end:
		mov	dx,word ptr _DATA:_ct_pic[base]
		mov	al,byte ptr _DATA:_ct_pic[ack]
		cli
		out	dx,al	; acknowledge end-of-interrupt
		mov	ax,20h
		cmp	dx,ax	; primary controller?
		je	short return
		out	20h,al
return:         pop	dx
		pop	ax
		pop	ds
		iret
_cthandle	endp
_TEXT		ends
		end
