Global VocPath As String
Global VocName As String
Global ServerPath As String
Global HelpFilePath As String
Global DaioHelpName As String

Global ServerRunning_P As Integer
Global HelpTaskHandle As Long
Global VocModified_P As Integer
Global iWordCount As Integer
Global iOpenSaveRes As Integer '0 cancel, 1 Ok
Global iConfirmRes As Integer '0 Cancel, 1 Oui, -1 Non
Global Const sVocabExtension = ".vcb"

Sub ChangeTitle (s As String)
    If s = "" Then
        frmMain.Caption = "Daio Vocabulary Lab - No Name"
    Else
        frmMain.Caption = "Daio Vocabulary Lab - " & s
    End If
End Sub

Function ConfirmLoseVoc ()
    ' Si le vocabulaire courant a t modifi
    ' on propose de le sauvegarder avant de continuer.
    Load frmConfirm
    frmConfirm.Show 1

    If iConfirmRes = 1 Then ' On veut le sauvegarder
        Load frmOpenSave
        frmOpenSave.Caption = "Save vocabulary"
        frmOpenSave.txtOpenSave.Text = VocName
        frmOpenSave.dirOpenSave.Path = VocPath
        frmOpenSave.filOpenSave.Path = VocPath
        frmOpenSave.Show 1
        If iOpenSaveRes = True Then
            ConfirmLoseVoc = True
        Else
            ConfirmLoseVoc = False
        End If
    ElseIf iConfirmRes = 0 Then ' Cancel on renonce a l'operation
            ConfirmLoseVoc = False
    Else    ' On passe outre
            ConfirmLoseVoc = True
End If
End Function

Sub EnableCommand (bFlag As Integer)
    frmMain.bnAddWord.Enabled = bFlag
    frmMain.bnTest.Enabled = bFlag
    frmMain.bnTrain.Enabled = bFlag
    frmMain.frmBeep.Enabled = bFlag
    frmMain.frmEcho.Enabled = bFlag
End Sub

Sub ErrorMessage (s As String)
    Load frmError
    frmError.lblError = s
    frmError.Show 1
End Sub

Function ItemPass (szItem As String)
    ItemPass = Val(Right(szItem, 5))
End Function

Function ItemWord (szItem As String)
    ItemWord = LTrim(RTrim(Left(szItem, 16)))
End Function

Function LBlankComplete (szStr As String, icount As Integer)
    For i = Len(szStr) To icount
        szStr = " " + szStr
    Next i
    LBlankComplete = szStr
End Function

Function RBlankComplete (szStr As String, icount As Integer)
    For i = Len(szStr) To icount
        szStr = szStr + " "
    Next i
    RBlankComplete = szStr
End Function

Sub SetComment (s)
    frmMain.lblComment.Caption = s
End Sub

Sub UpdateWordList ()
    Dim TmpChaine As String
    Dim TmpChaine2 As String

    EnableCommand False

    iWordCount = 0
    frmMain.List1.Clear

    frmMain.DVCC.Command = "Get Vocabulary Size"
    iWordCount = frmMain.DVCC.ReturnInteger

    If iWordCount > 1 Then
        frmMain.Frame3D1.Caption = "Vocabulary " & iWordCount & " Words"
    Else
        frmMain.Frame3D1.Caption = "Vocabulary " & iWordCount & " Word"
    End If

    '----------------------------------------------
    For i = 1 To iWordCount

        '--- On recupere le libelle de chaque mot du vocab
        frmMain.DVCC.Command = "Get vocabulary word number " & i - 1
        TmpChaine = frmMain.DVCC.ReturnString

        '--- On recupere le nombre de passes effectuees
        frmMain.DVCC.Command = "Get Training Pass '" & TmpChaine & "'"
        TmpChaine2 = "" & frmMain.DVCC.ReturnInteger

        TmpChaine = RBlankComplete(TmpChaine, 16) + LBlankComplete(TmpChaine2, 2)
        frmMain.List1.AddItem (TmpChaine)
    Next i
    EnableCommand True
End Sub

