VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Daio Vocabulary Lab"
   ClientHeight    =   3765
   ClientLeft      =   2430
   ClientTop       =   2550
   ClientWidth     =   6855
   FillColor       =   &H0000FFFF&
   ForeColor       =   &H00404040&
   Height          =   4455
   Icon            =   MAIN.FRX:0000
   Left            =   2370
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3765
   ScaleWidth      =   6855
   Top             =   1920
   Width           =   6975
   Begin SSCommand bnHelp 
      Caption         =   "&Help"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1020
      Left            =   4620
      Picture         =   MAIN.FRX:0302
      TabIndex        =   6
      Top             =   1995
      Width           =   855
   End
   Begin SSFrame Frame3D1 
      Caption         =   "Vocabulary"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3180
      Left            =   105
      TabIndex        =   8
      Top             =   0
      Width           =   2940
      Begin ListBox List1 
         BackColor       =   &H00FFFFFF&
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Courier"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2565
         Left            =   75
         TabIndex        =   7
         Top             =   300
         Width           =   2775
      End
   End
   Begin SSCommand bnTest 
      Caption         =   "&LiveTest"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   825
      Left            =   3255
      Picture         =   MAIN.FRX:0604
      TabIndex        =   0
      Top             =   240
      Width           =   990
   End
   Begin SSFrame Frame3D3 
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   480
      Left            =   105
      TabIndex        =   12
      Top             =   3255
      Width           =   6525
      Begin Label lblComment 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   90
         TabIndex        =   13
         Top             =   135
         Width           =   6330
      End
   End
   Begin SpinButton Spin1 
      Delay           =   1000
      Height          =   285
      Left            =   5145
      Top             =   1170
      Width           =   210
   End
   Begin SSCommand bnTrain 
      Caption         =   "&Train"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   855
      Left            =   3255
      Picture         =   MAIN.FRX:0906
      TabIndex        =   1
      Top             =   1155
      Width           =   990
   End
   Begin SSCommand ExitButton 
      Caption         =   "&Exit"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1020
      Left            =   5670
      Picture         =   MAIN.FRX:0C08
      TabIndex        =   9
      Top             =   1995
      Width           =   855
   End
   Begin SSFrame Frame3D2 
      Caption         =   "Options"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1695
      Left            =   4515
      TabIndex        =   10
      Top             =   0
      Width           =   2115
      Begin TextBox txtSensivity 
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   375
         MaxLength       =   1
         TabIndex        =   5
         Text            =   "4"
         Top             =   1215
         Width           =   165
      End
      Begin SSPanel Panel3D1 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   1  'Inset
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   1
         Font3D          =   0  'None
         Height          =   330
         Left            =   315
         ShadowColor     =   1  'Black
         TabIndex        =   17
         Top             =   1155
         Width           =   285
      End
      Begin SSCheck frmBeep 
         Caption         =   "&Beep"
         Font3D          =   0  'None
         Height          =   255
         Left            =   345
         TabIndex        =   3
         Top             =   315
         Width           =   735
      End
      Begin SSCheck frmEcho 
         Caption         =   "E&cho"
         Font3D          =   0  'None
         Height          =   240
         Left            =   345
         TabIndex        =   4
         Top             =   735
         Width           =   735
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Sensitivity"
         Height          =   255
         Left            =   885
         TabIndex        =   11
         Top             =   1215
         Width           =   930
      End
      Begin Label Label3 
         BackStyle       =   0  'Transparent
         Height          =   1605
         Left            =   0
         TabIndex        =   16
         Top             =   105
         Width           =   2115
      End
   End
   Begin SSFrame Frame3D4 
      Caption         =   "Commands"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3165
      Left            =   3150
      TabIndex        =   14
      Top             =   0
      Width           =   1245
      Begin SSCommand bnAddWord 
         Caption         =   "&Add"
         Font3D          =   0  'None
         ForeColor       =   &H00000000&
         Height          =   855
         Left            =   105
         Picture         =   MAIN.FRX:0F0A
         TabIndex        =   2
         Top             =   2100
         Width           =   990
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Height          =   3030
         Left            =   45
         TabIndex        =   15
         Top             =   120
         Width           =   1245
      End
   End
   Begin SSFrame Frame3D5 
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   1380
      Left            =   4515
      TabIndex        =   18
      Top             =   1785
      Width           =   2115
   End
   Begin SpeechRecogCtrl DVCC 
      Beep            =   -1  'True
      Echo            =   -1  'True
      Left            =   0
      Level           =   4
      Top             =   3285
   End
   Begin Menu Fichier 
      Caption         =   "&File"
      Begin Menu Nouveau 
         Caption         =   "&New"
      End
      Begin Menu Ouvrir 
         Caption         =   "&Open..."
      End
      Begin Menu Sauver 
         Caption         =   "&Save"
         Enabled         =   0   'False
      End
      Begin Menu SauverSous 
         Caption         =   "S&ave as..."
      End
      Begin Menu SEP 
         Caption         =   "-"
      End
      Begin Menu Quit 
         Caption         =   "&Exit"
      End
   End
   Begin Menu About 
      Caption         =   "&About"
   End
End
Option Explicit
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnString As String, ByVal nSize As Integer) As Integer
Const FormDeltaHeight = 800

Sub About_Click ()
    Load frmAbout
    frmAbout.Show 1
End Sub

Sub bnAddWord_Click ()
    Load frmAddWord
    frmAddWord.Show 1
End Sub

Sub bnAddWord_GotFocus ()
    SetComment ("Add word to current vocabulary")
End Sub

Sub bnHelp_Click ()
    Dim hWindow As Integer
    hWindow = frmMain.hWnd
    OpenHelp hWindow, HelpFilePath
End Sub

Sub bnTest_Click ()
    Dim sz As String
    Dim iTotalPass, iTmp As Integer
    If frmMain.List1.ListCount > 0 Then
	' On teste si au moins un mot a ete
	' appris
	iTotalPass = 0
	For iTmp = 0 To frmMain.List1.ListCount - 1
	    sz = frmMain.List1.List(iTmp)
	    iTotalPass = iTotalPass + ItemPass(sz)
	Next
	If iTotalPass <> 0 Then
	    Load frmLiveTest
	    frmLiveTest.Show 1
	Else
	    ErrorMessage ("Vocabulary not trained")
	End If
    Else
	ErrorMessage ("Empty vocabulary")
    End If
End Sub

Sub bnTest_GotFocus ()
    lblComment.Caption = "Recognition test on the current vocabulary"
End Sub

Sub bnTest_KeyDown (KeyCode As Integer, Shift As Integer)
    lblComment.Caption = "Recognition test on the current vocabulary"
End Sub

Sub bnTrain_Click ()
    Dim sz As String
    Dim iTmp As Integer
    Dim iTotalPass As Integer
    If frmMain.List1.ListCount > 0 Then
	' On teste si au moins un est a apprendre
	iTotalPass = -1
	For iTmp = 0 To frmMain.List1.ListCount - 1
	    sz = frmMain.List1.List(iTmp)
	    If ItemPass(sz) < 6 Then
		iTotalPass = 1
		Exit For
	    End If
	Next
	If iTotalPass = 1 Then
	    Load frmGlobalTrain
	    frmGlobalTrain.Show 1
	Else
	    ErrorMessage ("Vocabulary already trained")
	End If
    Else
	ErrorMessage ("Empty vocabulary")
    End If
End Sub

Sub bnTrain_GotFocus ()
    lblComment.Caption = "Train vocabulary words"
End Sub

Sub bnTrain_KeyDown (KeyCode As Integer, Shift As Integer)
    lblComment.Caption = "Recognition test on the current vocabulary"
End Sub

Sub ExitButton_Click ()
    Dim hWindow As Integer
    hWindow = frmMain.hWnd
    CloseHelp hWindow, HelpFilePath
    
    If VocModified_P = True Then
	If ConfirmLoseVoc() = False Then
	    Exit Sub
	End If
    End If
    ExitDemo
End Sub

Sub ExitButton_GotFocus ()
    lblComment.Caption = "Exit"
End Sub

Sub ExitButton_KeyDown (KeyCode As Integer, Shift As Integer)
    lblComment.Caption = "Exit"
End Sub

Sub ExitDemo ()
    ' Si le serveur est entrain de tourner, il faut l'arreter
    DVCC.Command = "Stop"
    Unload frmMain
End Sub

Sub Form_Load ()
    ' Initialisation des paths
    InitPath

    ' Initialisation par defaut
    VocModified_P = False
    iWordCount = 0

    ' Reset par defaut du vocabulaire.
    DVCC.Command = "Kill vocabulary"
    ChangeTitle ("")
    
    ' Initialisation de la sensibilite
    DVCC.Level = 4
    SetSensitivity (4)

    ' Initialisation du BEEP
    frmBeep.Value = DVCC.Beep

    ' Initialisation du ECHO
    frmEcho.Value = DVCC.Echo
End Sub

Sub Form_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    lblComment.Caption = ""
End Sub

Sub frmBeep_Click (Value As Integer)
    DVCC.Beep = frmBeep.Value
End Sub

Sub frmBeep_KeyDown (KeyCode As Integer, Shift As Integer)
    lblComment.Caption = "Enable / Disable Beep sound"
End Sub

Sub frmEcho_Click (Value As Integer)
    DVCC.Echo = frmEcho.Value
End Sub

Sub frmEcho_KeyDown (KeyCode As Integer, Shift As Integer)
    lblComment.Caption = "Enable / Disable Echo"
End Sub

Sub InitPath ()
    Dim iRetval, iSize As Integer
    Dim szSection, szKey, szDefault  As String
    
    iRetval = 0
    szSection = "daio"
    szKey = "srlroot"
    szDefault = "."
    iSize = 200

    ServerPath = Space(iSize)  ' Allocation memoire sinon plantage
    iRetval = GetProfileString(szSection, szKey, szDefault, ServerPath, iSize)
    ServerPath = Left(ServerPath, iRetval)

    HelpFilePath = ServerPath + "\DVCLVOC.HLP"
    ServerPath = ServerPath + "\DVCLSERV.EXE"
    DaioHelpName = "DAIO Help Aide - DVCLVOC.HLP"
End Sub

Sub Label1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    lblComment.Caption = "Commands Panel"
End Sub

Sub Label3_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    lblComment.Caption = "Options Panel"
End Sub

Sub lblComment_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    lblComment.Caption = ""
End Sub

Sub List1_DblClick ()
    Dim iTmp As Integer
    Dim szWord As String
    If ServerRunning_P = False Then
	iTmp = List1.ListIndex
	If iTmp >= 0 Then
	    szWord = Left(List1.List(iTmp), 16)
	    szWord = LTrim(RTrim(szWord))
	    Load frmPopUp
	    frmPopUp.Word2Handle.Caption = szWord
	    frmPopUp.Show 1
	End If
    End If
End Sub

Sub List1_GotFocus ()
    lblComment.Caption = "DblClick on word you want to modify"
End Sub

Sub List1_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim iTmp As Integer
    Dim szWord As String
    If KeyCode = 46 Then           'delete
	iTmp = List1.ListIndex
	If iTmp >= 0 Then
	    szWord = Left(List1.List(iTmp), 16)
	    szWord = LTrim(RTrim(szWord))
	    DVCC.Command = "Del Word '" & szWord & "'"
	End If
    End If
End Sub

Sub List1_KeyPress (KeyAscii As Integer)
    Dim iTmp As Integer
    Dim szWord As String
    If ServerRunning_P = False Then
	If KeyAscii = 13 Then
	    iTmp = List1.ListIndex
	    If iTmp >= 0 Then
		szWord = Left(List1.List(iTmp), 16)
		szWord = LTrim(RTrim(szWord))
		Load frmPopUp
		frmPopUp.Word2Handle.Caption = szWord
		frmPopUp.Show 1
	    End If
	End If
    End If
End Sub

Sub List1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If iWordCount <> 0 Then
	SetComment ("DblClick on word you want to modify")
    Else
	SetComment ("Empty vocabulary")
    End If
End Sub

Sub Nouveau_Click ()
    If VocModified_P = True Then
	If ConfirmLoseVoc() = False Then
	    Exit Sub
	End If
    End If
    VocModified_P = False
    DVCC.Command = "Kill Voc"
    ChangeTitle ("")
    Sauver.Enabled = False
    UpdateWordList
End Sub

Sub Ouvrir_Click ()
    If VocModified_P = True Then
	If ConfirmLoseVoc() = False Then
	    Exit Sub
	End If
    End If
    Load frmOpenSave
    frmOpenSave.Caption = "Load vocabulary"
    frmOpenSave.txtOpenSave.Text = frmOpenSave.filOpenSave.Pattern
    frmOpenSave.Show 1
End Sub

Sub Quit_Click ()
    ExitDemo
End Sub

Sub Sauver_Click ()
    VocModified_P = False
    DVCC.Command = "Save Voc '" & VocPath & VocName & "'"
End Sub

Sub SauverSous_Click ()
    Load frmOpenSave
    frmOpenSave.Caption = "Save vocabulary"
    frmOpenSave.txtOpenSave.Text = VocName
    frmOpenSave.dirOpenSave.Path = VocPath
    frmOpenSave.filOpenSave.Path = VocPath
    frmOpenSave.Show 1
End Sub

Sub SetSensitivity (iValue)
    txtSensivity.Text = Format$(iValue, "0")
    DVCC.Level = iValue
End Sub

Sub Spin1_SpinDown ()
    Dim Index As Integer
    Index = Val(txtSensivity.Text)
    If Index > 0 Then
	Index = Index - 1
	SetSensitivity (Index)
    End If
End Sub

Sub Spin1_SpinUp ()
    Dim Index As Integer
    Index = Val(txtSensivity.Text)
    If Index < 9 Then
	Index = Index + 1
	SetSensitivity (Index)
    End If
End Sub

Sub txtSensivity_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim iValue As Integer
    iValue = Val(txtSensivity.Text)
    If (KeyCode = 38) And (Shift = 0) Then ' Up
	If iValue < 9 Then
	    iValue = iValue + 1
	    SetSensitivity (iValue)
	End If
    ElseIf (KeyCode = 40) And (Shift = 0) Then 'Down
	If iValue > 0 Then
	    iValue = iValue - 1
	    SetSensitivity (iValue)
	End If
    End If
End Sub

Sub txtSensivity_KeyPress (KeyAscii As Integer)
    Dim iValue As Integer
    iValue = Val(txtSensivity.Text)
    If KeyAscii <> 13 Then
	If iValue > 0 Then
	    SetSensitivity (iValue)
	End If
    Else
	txtSensivity.Text = Format(iValue, "0")
	SetSensitivity (iValue)
    End If
End Sub

Sub txtSensivity_LostFocus ()
    Dim iValue As Integer
    iValue = Val(txtSensivity.Text)
    SetSensitivity (iValue)
End Sub

