VERSION 2.00
Begin Form frmOpenSave 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   ClientHeight    =   2955
   ClientLeft      =   1290
   ClientTop       =   2565
   ClientWidth     =   5880
   ClipControls    =   0   'False
   Height          =   3360
   Left            =   1230
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2955
   ScaleMode       =   0  'User
   ScaleWidth      =   5880
   Top             =   2220
   Width           =   6000
   Begin CommandButton cmdOpenSave 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Index           =   1
      Left            =   4680
      TabIndex        =   9
      Top             =   720
      Width           =   1095
   End
   Begin CommandButton cmdOpenSave 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   372
      Index           =   0
      Left            =   4680
      TabIndex        =   8
      Top             =   240
      Width           =   1092
   End
   Begin DriveListBox drvOpenSave 
      Height          =   315
      Left            =   2400
      TabIndex        =   6
      Top             =   2580
      Width           =   3375
   End
   Begin DirListBox dirOpenSave 
      Height          =   1572
      Left            =   2400
      TabIndex        =   5
      Top             =   720
      Width           =   2052
   End
   Begin FileListBox filOpenSave 
      Height          =   1980
      Left            =   120
      Pattern         =   "*.vcb"
      TabIndex        =   4
      Top             =   720
      Width           =   2055
   End
   Begin TextBox txtOpenSave 
      Height          =   288
      Left            =   120
      MaxLength       =   12
      TabIndex        =   3
      Text            =   "*.*"
      Top             =   360
      Width           =   2052
   End
   Begin Label lblOpenSave 
      BackStyle       =   0  'Transparent
      Caption         =   "Dri&ves:"
      Height          =   252
      Index           =   3
      Left            =   2400
      TabIndex        =   7
      Top             =   2352
      Width           =   1452
   End
   Begin Label lblOpenSave 
      BackStyle       =   0  'Transparent
      Height          =   255
      Index           =   2
      Left            =   2385
      TabIndex        =   2
      Top             =   360
      Width           =   2175
   End
   Begin Label lblOpenSave 
      BackStyle       =   0  'Transparent
      Caption         =   "&Directories"
      Height          =   252
      Index           =   1
      Left            =   2400
      TabIndex        =   1
      Top             =   120
      Width           =   1452
   End
   Begin Label lblOpenSave 
      BackStyle       =   0  'Transparent
      Caption         =   "File &Name:"
      Height          =   252
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1452
   End
End
Sub cmdOpenSave_Click (Index As Integer)
    If Index = 0 Then
        ExitAndProceed
    Else
        Unload frmOpenSave
    End If
End Sub

Sub dirOpenSave_Change ()
    filOpenSave.Path = dirOpenSave.Path         ' When the directory path changes, update the file list box path
    lblOpenSave(2).Caption = dirOpenSave.Path   ' and the path displayed above the directory list box.
    ChDir dirOpenSave.Path                      ' Set the current working directory to the new path.
End Sub

Sub drvOpenSave_Change ()
    dirOpenSave.Path = drvOpenSave.Drive    ' When drive changes, update path of directory list box
    ChDrive drvOpenSave.Drive               ' and set the current working drive to the new drive.
End Sub

Sub ExitAndProceed ()
    Dim sCommand As String
    Dim iTmp, iOrgLen As Integer

    VocName = txtOpenSave.Text
    iOrgLen = Len(VocName)
    VocName = Trim(VocName)
    iTmp = InStr(VocName, ".")
    If (iTmp = 1) Or (Len(VocName) = 0) Or (iTmp > 9) Then
	ErrorMessage ("Invalid name")
        Exit Sub
    End If
    If (iTmp = 0) And (Len(VocName) > 8) Then
	ErrorMessage ("Invalid name")
        Exit Sub
    End If

    ' Si jamais il y a un wild char dans le nom,
    ' On relance en changeant le path
    If InStr(VocName, "?") <> 0 Or InStr(VocName, "*") Then
        filOpenSave.Pattern = VocName
        Exit Sub
    End If

    ' Si pas d'extension au niveau au nom, alors on
    ' ajoute ".vcb"
    iTmp = InStr(VocName, ".")
    If iTmp = 0 Then
        VocName = VocName + sVocabExtension
    End If
    VocPath = filOpenSave.Path
    If Right(VocPath, 1) <> "\" Then
        VocPath = VocPath + "\"
    End If
    ' Reste a verifier que le nom est correct, ou
    ' ou s'il n'y a pas deja un fichier sous ce nom
    If Left(frmOpenSave.Caption, 4) = "Save" Then
        
    Else ' C'est une commande Load
        On Error Resume Next
        Open VocPath + VocName For Input As #1
        If Err Then
            On Error GoTo 0
	    ErrorMessage "File not found"
            Exit Sub
        Else
            On Error GoTo 0
            Close #1
        End If
    End If

    sCommand = frmOpenSave.Caption & " '" & VocPath + VocName & "'"

    ' Si jamais on sauvegarde, on verifie qu'on n'ecrase
    ' pas un autre fichier
    On Error Resume Next
    If InStr(frmOpenSave.Caption, "Save") <> 0 Then
        Open VocPath + VocName For Input As #1
        If Err Then
        Else
            ' Le fichier existe deja, on demande
            ' Confirmation de l'ecrasement
            Close #1
            Load frmConfirm
            frmConfirm.Command3D2.Visible = False
            frmConfirm.Label1.Visible = False
            frmConfirm.Label2.Visible = True
            frmConfirm.Show 1
            If iConfirmRes <> 1 Then
                Exit Sub
            End If
        End If
    End If

    On Error Resume Next
    frmMain.DVCC.Command = sCommand
    If Err Then
	ErrorMessage "Invalid file, aborting..."
        Exit Sub
    End If


    ' Si jamais on charge un fichier, il faut tout mettre
    ' a jour
    If InStr(frmOpenSave.Caption, "Load") <> 0 Then
        UpdateWordList
    End If

    ' On active la commande sauver dans le menu
    ' dans tous les cas
    VocModified_P = False
    frmMain.Sauver.Enabled = True
    ChangeTitle (VocName)
    Unload frmOpenSave
End Sub

Sub filOpenSave_Click ()
' Display the file selected in the text box up in the File Name text box.
    txtOpenSave.Text = filOpenSave.List(filOpenSave.ListIndex)
End Sub

Sub filOpenSave_DblClick ()
' When at root of drive, there is no "\" at the end of the path, so add it.
    If Right(filOpenSave.Path, 1) = "\" Then
        VocName = filOpenSave.FileName
        VocPath = filOpenSave.Path
    Else
        VocPath = filOpenSave.Path & "\"
        VocName = filOpenSave.FileName
    End If
    ExitAndProceed
End Sub

Sub filOpenSave_PathChange ()
' Notice that this doesn't cause a cascading event.
    txtOpenSave.Text = filOpenSave.Pattern
    drvOpenSave.Drive = filOpenSave.Path
    dirOpenSave.Path = filOpenSave.Path
End Sub

Sub filOpenSave_PatternChange ()
' Notice this doesn't cause a cascading event.
    drvOpenSave.Drive = filOpenSave.Path
    dirOpenSave.Path = filOpenSave.Path
End Sub

Sub Form_Load ()
' The form is horizontally and vertically centered when loaded.
   frmOpenSave.Left = Screen.Width / 2 - frmOpenSave.Width / 2
   frmOpenSave.Top = Screen.Height / 2 - frmOpenSave.Width / 2
' Set current drive and directory.
   drvOpenSave.Drive = CurDir
   dirOpenSave.Path = CurDir
' Display the current path.
   lblOpenSave(2).Caption = dirOpenSave.Path
End Sub

Sub txtOpenSave_KeyPress (KeyAscii As Integer)
   ' Equivalent de l'appui sur OK
   If KeyAscii = 13 Then
      ExitAndProceed
   End If
End Sub
