{programm    : wbild.pas
 Funktion    : Anzeige der bildwiederholungsfrequenz unter Windows
 Autor       : Wilfried Lottermoser
}

PROGRAM wbild;
USES owindows,wintypes,winprocs,strings,windos;
TYPE
      TMyApplication                   = object(TApplication)
                                           PROCEDURE InitMainWindow; virtual;
                                           FUNCTION ProcessAppMsg(VAR message: tmsg): boolean;virtual;
                                         END;

      Pfenster     = ^TFenster;
      TFenster     = object (TWindow)
                       WDC             : HDC;
                       gett            : real;
                       f               : ARRAY[0..9] OF real;
                       Count           : byte;
                       busy            : boolean;
                       xres,yres       : STRING;
                       CONSTRUCTOR Init (Mutterfenster: pwindowsobject;ztitel: pchar);
                       PROCEDURE   sync;
                       PROCEDURE   GetWindowClass(VAR awndclass: twndclass);virtual;
                       PROCEDURE   getfreq(VAR msg: tmessage);virtual  wm_first+ wm_user;
                       PROCEDURE   display(strg:STRING);
                       FUNCTION    CanClose:boolean;virtual;
                       DESTRUCTOR  Done;virtual;
                     END; {tfenster}

VAR 
      myapp        : TMyApplication;

{------------------------------------------------------------------------}

PROCEDURE TMyApplication.InitMainWindow;
BEGIN
  MainWindow := New(Pfenster, Init(NIL, 'wbild'));
END;

FUNCTION TMyApplication.ProcessAppMsg(VAR 
      message      : tmsg)             : boolean;
BEGIN
  IF (message.message = wm_timer)THEN BEGIN
    SendMessage(MainWindow^.HWindow,wm_user,0,0);
  END;
  ProcessAppMsg:=TApplication.ProcessAppMsg(message);
END;

{------------------------------------------------------------------------}

CONSTRUCTOR TFenster.Init(mutterfenster: pwindowsobject;ztitel: pchar);
VAR 
      t            : word;
BEGIN
  TWindow.Init(mutterfenster,ztitel);
  { zeitgeber mit 2-sekundentakt setzen}
  IF SetTimer(HWindow,1,3000,NIL)=0 THEN
    MessageBox(HWindow,'fehler beim anlegen des zeitgebers','',mb_ok);
  FOR t:=0 TO 9 DO f[t]:=0;Count:=0;
  Attr.w:=170;Attr.h:=60;
  Str(GetSystemMetrics(sm_cxscreen),xres);
  Str(GetSystemMetrics(sm_cyscreen),yres);
END;

PROCEDURE TFenster.GetWindowClass;
BEGIN
  INHERITED GetWindowClass(awndclass);
  Awndclass.style:=awndclass.style OR cs_dblclks;
  Awndclass.hicon:=0;                 { hiermit wird die Symbolanzeige aktiviert}
END;

PROCEDURE TFenster.sync; { Synchronisation mit vertikalem Kathodenstrahlrueckgang }
VAR 
      m            : tmsg;
BEGIN
  REPEAT UNTIL (port[$3da] AND 8)=0;
  REPEAT UNTIL (port[$3da] AND 8)=8;
  {ankommende botschaften weiterleiten}
  IF PeekMessage(m,0,0,0,pm_remove) THEN BEGIN
    TranslateMessage(m); DispatchMessage(m);
  END;
END;

PROCEDURE TFenster.getfreq(VAR 
      msg          : tmessage);
CONST 
      SyncCount    = 100;
VAR 
      strg         : STRING;
      h,h2,m,m2,s,s2,s100,s200,i       : word;
      freq         : real;
BEGIN
  busy:=true;
  IF f[1]=0 THEN display('wait');
  inc(Count);
  Count:=Count MOD 10;
  sync;
  GetTime(h,m,s,s100);
  FOR i:=1 TO SyncCount DO sync;
  GetTime(h2,m2,s2,s200);
  f[Count]:=SyncCount/(100*(h2*36+m2*0.6+s2/100+s200/10000-h*36-m*0.6-s/100-s100/10000));
  freq:=0;
  FOR i:=0 TO 9 DO freq:=freq+f[i];
  freq:=freq/10;
  Str(freq:3:2,strg);
  IF NOT IsIconic(HWindow) THEN display(xres+'*'+yres+'  v='+strg+'hz') ELSE display(strg);
  busy:=false;
END;

PROCEDURE TFenster.display(strg:STRING);
VAR 
      AChar        : ARRAY[0..255] OF char;
      rect         : trect;
BEGIN
  Strpcopy(AChar,strg);
  Wdc:=GetDC(HWindow);
  SetBkColor(wdc,rgb(0,170,0));                 {Hintergrundfarbe grn}
  SetTextAlign(wdc,ta_center OR ta_bottom);     {Text zentriert}
  WITH rect DO BEGIN
    left:=0; right:=Attr.w; top:=0;  bottom:=Attr.h;
  END;
  IF IsIconic(HWindow) THEN ExtTextOut(wdc,18,25,eto_opaque,@rect,AChar,strlen(AChar),NIL) ELSE
    BEGIN
      ExtTextOut(wdc,Attr.w DIV 2,Attr.h DIV 2,eto_opaque,@rect,AChar,strlen(AChar),NIL);
    END;
  ReleaseDC(HWindow,wdc);
END;

FUNCTION TFenster.CanClose:boolean;
VAR 
      m            : tmsg;
BEGIN
  display('end');
  CanClose:=NOT busy;
  {wenn gerade eine Zeitmessung erfolgt die Botschaft wm_close aufschieben}
  m.message:=wm_close;
  IF busy THEN DispatchMessage(m);
END;

DESTRUCTOR TFenster.Done;
VAR 
      m            : tmsg;
      ms           : tmessage;
BEGIN
  KillTimer(HWindow,1);                 {Zeitgeber entfernen}
  TWindow.Done;
END;

{------------------------------------------------------------------------}

BEGIN
  myapp.Init('');
  myapp.Run;
  myapp.Done;
END.
