#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <mmsystem.h>
#include <commdlg.h>
#include <stdlib.h>
#include <mem.h>
#include "wsnd.h"
#include "testwsnd.hm"


/************************************************/
/*                                              */
/*                                              */
/*                Test WSnd DLL                 */
/*                                              */
/*             For Borland Compiler             */
/*                                              */
/*        Copyright 1994, Denam Systems         */
/*                                              */
/************************************************/

char szWavefile[256];
#define FILTER_SIZE 30
char szFilter[FILTER_SIZE] = "Wave Files (*.wav)\0*.wav\0";
OPENFILENAME ofn;
int nTotLoops;

HINSTANCE hInst;

BOOL ListFiles(HWND hwnd)
{
	BOOL bUseit;
	char szFile[256];
	char szFileTitle[256];
	char szDirName[256];

	memset(&ofn, 0, sizeof(OPENFILENAME));
	szDirName[0] = '\0';
	szFile[0] = '\0';
	szFileTitle[0] = '\0';
	ofn.lpstrTitle = (LPSTR)NULL;
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile = szFile;
	ofn.lpstrInitialDir = szDirName;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_SHAREAWARE;
	bUseit = GetOpenFileName(&ofn);
	if (bUseit)
		lstrcpy(szWavefile, ofn.lpstrFile);
  return bUseit;
}

void GetBoolStr (BOOL bTrueFalse, LPSTR szReturn)
{
	switch (bTrueFalse) {
		case FALSE : lstrcpy(szReturn, "No");  break;
		case TRUE  : lstrcpy(szReturn, "Yes"); break;
    default    : szReturn[0] = (char)0; break;
  }
}  /* GetBoolStr */

void GetChannelStr (CHANNELS Channel, LPSTR szReturn)
{
	switch (Channel) {
		case StereoOutput: lstrcpy(szReturn, "Stereo Output"); break;
		case MonoOutput  : lstrcpy(szReturn, "Mono Output");   break;
		default          : lstrcpy(szReturn, "Unknown Output"); break;
  }
}  /* GetChannelStr */

#pragma argsused
BOOL CALLBACK _export ShowProc(HWND hDlg,
													 UINT message,
													 WPARAM wParam,
													 LPARAM lParam) {
	char     szTs1[81];
	char     szTs2[81];
	UINT     uDeviceID;
	UINT     uManufacturerID;
	UINT     uProductID;
	VERSION  uDriverVersion;
	DWORD    dDeviceFormat;
	CHANNELS cChannels;
	BOOL     bSupportPitch;
	BOOL     bSupportRate;
  BOOL     bSupportVolume;

	switch(message) {
		case WM_INITDIALOG:
    	uDeviceID = GetWaveDeviceID();
    	uManufacturerID = GetWaveManufacturerID();
			uProductID = GetWaveProductID();
			uDriverVersion = GetWaveDriverVersion();
			bSupportVolume = GetWaveSupportVolume();
			bSupportRate = GetWaveSupportPlaybackRate();
			bSupportPitch = GetWaveSupportPitch();
			cChannels = GetWaveChannel();
			dDeviceFormat = GetWaveDeviceFormat();
      /* Product Name */
			GetWaveProductName(szTs2);
			wsprintf(szTs1, "Product Name = %s", (LPSTR)szTs2);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
			/* Manufacturer ID */
			wsprintf(szTs1, "Manufacturer ID = %u", uManufacturerID);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Product ID */
			wsprintf(szTs1, "Product ID = %u", uProductID);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
			/* Device ID */
			wsprintf(szTs1, "Device ID = %u", uDeviceID);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
			/* Driver Version */
			wsprintf(szTs1, "Driver Version = %u", (WORD)uDriverVersion);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Device Format */
			wsprintf(szTs1, "Device Format = %lu", dDeviceFormat);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Available Channels */
      GetChannelStr(cChannels, szTs2);
			wsprintf(szTs1, "Channels = %s", (LPSTR)szTs2);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Pitch */
			GetBoolStr(bSupportPitch, szTs2);
			wsprintf(szTs1, "Supports Pitch = %s", (LPSTR)szTs2);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Playback Rate */
			GetBoolStr(bSupportRate, szTs2);
			wsprintf(szTs1, "Supports Playback Rate = %s", (LPSTR)szTs2);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
      /* Volume */
			GetBoolStr(bSupportVolume, szTs2);
			wsprintf(szTs1, "Supports Volume = %s", (LPSTR)szTs2);
			SendMessage(GetControl(DLG_LISTBOX), LB_ADDSTRING, 0, (LPARAM)(LPCSTR)szTs1);
			return TRUE;
		case WM_COMMAND:
    	switch (wParam) {
				case DLG_QUIT:
					EndDialog(hDlg, FALSE);
					return TRUE; 
			}
      break;
  }
  return FALSE;
}

void ShowIt (HWND hW)
{
	DLGPROC lpfnProc;
	lpfnProc = (DLGPROC)MakeProcInstance((FARPROC)ShowProc, hInst);
	if (lpfnProc) {
		DialogBox(hInst, "DLG_FUNCTIONS", hW, lpfnProc);
		FreeProcInstance((FARPROC)lpfnProc);
		lpfnProc = NULL;
	}
}  /* ShowIt */

#pragma argsused
BOOL CALLBACK _export SetLoopProc(HWND hDlg,
													        UINT message,
													        WPARAM wParam,
																	LPARAM lParam) {
	char szLoop[8];

	switch(message) {
		case WM_INITDIALOG:
			Edit_LimitText(GetControl(DLG_LOOPCOUNT), 4);
      lstrcpy(szLoop, "1");
			Edit_SetText(GetControl(DLG_LOOPCOUNT), szLoop);
			return TRUE;
		case WM_COMMAND:
    	switch (wParam) {
				case DLG_QUIT:
					Edit_GetText(GetControl(DLG_LOOPCOUNT), szLoop, 5);
          nTotLoops = atoi(szLoop);
					EndDialog(hDlg, FALSE);
					return TRUE; 
			}
			break;
  }
  return FALSE;
}  /* SetLoopProc */

void SetLoop (HWND hW)
{
	DLGPROC lpfnProc;
	lpfnProc = (DLGPROC)MakeProcInstance((FARPROC)SetLoopProc, hInst);
	if (lpfnProc) {
		DialogBox(hInst, "DLG_LOOPS", hW, lpfnProc);
		FreeProcInstance((FARPROC)lpfnProc);
		lpfnProc = NULL;
	}
}  /* SetLoop */

#pragma argsused
long FAR PASCAL _export WndProc(HWND hwnd,WORD message, WPARAM wParam, LPARAM lParam)
{
	static HGLOBAL hGlobal;

	switch(message) {
		case WM_CREATE:
			return 0;
		case WM_QUIT:
    	/* Reclaim memory that wave uses */
			RemoveWave(hGlobal);
      return 0;
		case WM_COMMAND:
			switch(wParam) {
				case IDM_LOADWAVE:
          RemoveWave(hGlobal);
					if (ListFiles(hwnd)) {
						hGlobal = MakeWave(hwnd, szWavefile);
          }
					return 0;
				case IDM_SETLOOP:
					SetLoop(hwnd);
          SetWaveLoops(nTotLoops);
        	return 0;
				case IDM_SHOW_FUNCTIONS:
					ShowIt(hwnd);
					return 0;
				case IDM_PLAYWAVE:
					PlayWave(hGlobal);
					return 0;
				case IDM_FULLVOLUME:
        	SetWaveVolume(FULLVOLUME);
        	return 0;
				case IDM_34VOLUME:
					SetWaveVolume(THREEQUARTERVOLUME);
        	return 0;
				case IDM_12VOLUME:
					SetWaveVolume(HALFVOLUME);
        	return 0;
				case IDM_14VOLUME:
					SetWaveVolume(ONEQUARTERVOLUME);
					return 0;
				case IDM_STOPWAVE:
					WaveStop();
          return 0;
				case IDM_QUIT:
					PostQuitMessage(0);
					return 0;
			}
      break;
	}
	return DefWindowProc(hwnd,message,wParam, lParam);
}

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
					 LPSTR lpszCmdLine,int nCmdShow)
{
	MSG      msg;
	HWND     hwnd;
	WNDCLASS wndclass;
	static HINSTANCE hWaveDLL;
  HMENU    hMenu;

	if (!hPrevInstance){
		wndclass.style          = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc    = (WNDPROC)WndProc;
		wndclass.cbClsExtra     = 0;
		wndclass.cbWndExtra     = 0;
		wndclass.hInstance      = hInstance;
		wndclass.hIcon          = NULL;
		wndclass.hCursor        = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground  = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName   = NULL;
		wndclass.lpszClassName  = "Test_WSnd";

		if(!RegisterClass(&wndclass))
			return FALSE;
	}
	hInst = hInstance;
	hwnd = CreateWindow("Test_WSnd", "Test WSnd",
											WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
											50, 50, 250, 150,
											HWND_DESKTOP,
											NULL,
											hInstance,
											NULL);
	if (!hwnd)
		return FALSE;
	hWaveDLL = LoadLibrary("WSND.DLL");
	hMenu = LoadMenu(hInst, "AMENU");
	SetMenu(hwnd, hMenu);
	ShowWindow(hwnd, SW_SHOW);
	while (GetMessage(&msg, NULL, 0, 0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	FreeLibrary(hWaveDLL);
	return msg.wParam;
}  // WinMain


