#include <owl\applicat.h>
#include <owl\framewin.h>

#include "WET.HPP"


// Application class declaration.
class TApp : public TApplication
{
public:
	TApp(): TApplication() {}
	void InitMainWindow();
};

// The main window class.
class TWndw: public TFrameWindow
{
public:
	TWndw(TWindow *parent, const char far *title);

protected:

};


///////////////////////////////////////////////////////////
// TWndw::TWndw()
//
// This is the main window's constructor.
///////////////////////////////////////////////////////////
TWndw::TWndw(TWindow *parent, const char far *title) :
	TFrameWindow(parent, title)
{
	// Set the window's size.
	Attr.X = 40;
	Attr.Y = 40;
	Attr.H = GetSystemMetrics(SM_CYSCREEN) / 1.5;
	Attr.W = GetSystemMetrics(SM_CXSCREEN) / 1.5;
}

///////////////////////////////////////////////////////////
// TApp::InitMainWindow()
//
// This function creates the application's main window.
///////////////////////////////////////////////////////////
void TApp::InitMainWindow()
{
  TFrameWindow *wndw = new TWndw(0, "DLL Test Window");
  SetMainWindow(wndw);
  int block_length;
  unsigned char block[100];
  unsigned char code_key[9]="Test Key";
  lstrcpy(block,"This is a test 0123456789");
  block_length=16;  // just encrypt 1st 16 characters
  MessageBox(wndw->HWindow,"This demo shows how well WET protects your data.","Encryption Demo",MB_OK);
  MessageBox(wndw->HWindow,block,"Encryption test - Clear text",MB_ICONEXCLAMATION);
  EncryptXORBlock(block,block_length,code_key);
  EncryptTranspositionBlock(block,block_length,code_key);
  EncryptSubstitutionBlock(block,block_length,code_key);
  MessageBox(wndw->HWindow,block,"Encryption test - Encrypted (1st 16 char)",MB_ICONEXCLAMATION);
  EncryptSubstitutionBlock(block,block_length,code_key);
  EncryptTranspositionBlock(block,block_length,code_key);
  EncryptXORBlock(block,block_length,code_key);
  MessageBox(wndw->HWindow,block,"Encryption test - Decrypted",MB_ICONEXCLAMATION);
  /*
  For a DES example you could use:
  unsigned char work_string[100];
  unsigned char use_key[8]={'0','1','2','3','4','5','6','7'};
  lstrcpy(work_string,"This is a test 0123456789");
  MessageBox(wndw->HWindow,work_string,"DES Encryption test - Clear Text",MB_ICONEXCLAMATION);
  DESKeyloadEncrypt(use_key);
  EncryptDESBlockCBC(work_string,16);
  MessageBox(wndw->HWindow,work_string,"DES Encryption test - DES Encrypted (1st 16 char)",MB_ICONEXCLAMATION);
  DESKeyloadDecrypt(use_key);
  DecryptDESBlockCBC(work_string,16);
  MessageBox(wndw->HWindow,work_string,"DES Encryption test - Decrypted",MB_ICONEXCLAMATION);
  */
  _exit(0);
}

///////////////////////////////////////////////////////////
// OwlMain()
///////////////////////////////////////////////////////////
int OwlMain(int, char*[])
{
  return TApp().Run();
}

