/* 04.06.94 */

#include <stdio.h>
#include <string.h>
#include "krypto.h"

void CesarEncodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3)
{
	register short	i, k;

	i = Base;
	k = *Char;
	k += Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
	k %= 256; if (k < 0) k += 256;
	*Char = k;
}

void CesarDecodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3)
{
	register short	i, k;

	i = Base;
	k = *Char;
	k -= Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
	k %= 256; if (k < 0) k += 256;
	*Char = k;
}

void CesarEncodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar)
{
	register short	i, k;
	short			Range;

	Range = LastChar - FirstChar + 1;
	for (i = 0; i < strlen((char *) String); i++) {
		k = String[i] - FirstChar;
		k += Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
		k %= Range; if (k < 0) k += Range;
		String[i] = k + FirstChar;
	}
}

void CesarDecodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar)
{
	register short	i, k;
	short			Range;

	Range = LastChar - FirstChar + 1;
	for (i = 0; i < strlen((char *) String); i++) {
		k = String[i] - FirstChar;
		k -= Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
		k %= Range; if (k < 0) k += Range;
		String[i] = k + FirstChar;
	}
}

void CesarEncodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3)
{
	FILE			*input, *output;
	register short	i = 0, k;

	input = fopen(InputFilename, "rb");
	output = fopen(OutputFilename, "wb");
	k = fgetc(input);
	while (!feof(input)) {
		k += Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
		k %= 256; if (k < 0) k += 256;
		fputc(k, output);
		i++;
		k = fgetc(input);
	}
	fclose(input); 
	fclose(output);
}

void CesarDecodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3)
{
	FILE			*input, *output;
	register short	i = 0, k;

	input = fopen(InputFilename, "rb");
	output = fopen(OutputFilename, "wb");
	k = fgetc(input);
	while (!feof(input)) {
		k -= Key1 * (i + 1) * (i + 2) + Key2 * (i + 3) + Key3 + 4;
		k %= 256; if (k < 0) k += 256;
		fputc(k, output);
		i++;
		k = fgetc(input);
	}
	fclose(input);
	fclose(output);
}

void CesarEncodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar)
{
	FILE			*input, *output;
	unsigned char	String[260];

	input = fopen(InputFilename, "rt");
	output = fopen(OutputFilename, "wt");
	fgets((char *) String, 256, input);
	String[strlen((char *) String) - 1] = '\0';
	while (!feof(input)) {
		CesarEncodeString(String, Key1, Key2, Key3, FirstChar, LastChar);
		fprintf(output, "%s\n", String);
		fgets((char *) String, 256, input);
		String[strlen((char *) String) - 1] = '\0';
	}
	fclose(input); 
	fclose(output);
}

void CesarDecodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar)
{
	FILE			*input, *output;
	unsigned char	String[260];

	input = fopen(InputFilename, "rt");
	output = fopen(OutputFilename, "wt");
	fgets((char *) String, 256, input);
	String[strlen((char *) String) - 1] = '\0';
	while (!feof(input)) {
		CesarDecodeString(String, Key1, Key2, Key3, FirstChar, LastChar);
		fprintf(output, "%s\n", String);
		fgets((char *) String, 256, input);
		String[strlen((char *) String) - 1] = '\0';
	}
	fclose(input); 
	fclose(output);
}

void ShiftEncodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB)
{
	register short	i, k;
	short			MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	k = *Char;
	for (i = 0; i < Base; i++) {
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
	}
	k += Start;
	k %= 256; if (k < 0) k += 256;
	*Char = k;
}

void ShiftDecodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB)
{
	register short	i, k;
	short			MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	k = *Char;
	for (i = 0; i < Base; i++) {
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
	}
	k -= Start;
	k %= 256; if (k < 0) k += 256;
	*Char = k;
}

void ShiftEncodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar)
{
	register short	i, k;
	short			Range, MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	Range = LastChar - FirstChar + 1;
	for (i = 0; i < strlen((char *) String); i++) {
		k = String[i] - FirstChar;
		k += Start;
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
		k %= Range; if (k < 0) k += Range;
		String[i] = k + FirstChar;
	}
}

void ShiftDecodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar)
{
	register short	i, k;
	short			Range, MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	Range = LastChar - FirstChar + 1;
	for (i = 0; i < strlen((char *) String); i++) {
		k = String[i] - FirstChar;
		k -= Start;
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
		k %= Range; if (k < 0) k += Range;
		String[i] = k + FirstChar;
	}
}

void ShiftEncodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB)
{
	FILE			*input, *output;
	register short	i = 0, k;
	short			MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	input = fopen(InputFilename, "rb");
	output = fopen(OutputFilename, "wb");
	k = fgetc(input);
	while (!feof(input)) {
		k += Start;
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
		k %= 256; if (k < 0) k += 256;
		fputc(k, output);
		i++;
		k = fgetc(input);
	}
	fclose(input); 
	fclose(output);
}

void ShiftDecodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB)
{
	FILE			*input, *output;
	register short	i = 0, k;
	short			MaskA, MaskB, Insert;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;
	input = fopen(InputFilename, "rb");
	output = fopen(OutputFilename, "wb");
	k = fgetc(input);
	while (!feof(input)) {
		k -= Start;
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
		k %= 256; if (k < 0) k += 256;
		fputc(k, output);
		i++;
		k = fgetc(input);
	}
	fclose(input); 
	fclose(output);
}

void ShiftEncodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar)
{
	FILE			*input, *output;
	unsigned char	String[260];

	input = fopen(InputFilename, "rt");
	output = fopen(OutputFilename, "wt");
	fgets((char *) String, 256, input);
	String[strlen((char *) String) - 1] = '\0';
	while (!feof(input)) {
		ShiftEncodeString(String, Start, LoopA, LoopB, FirstChar, LastChar);
		fprintf(output, "%s\n", String);
		fgets((char *) String, 256, input);
		String[strlen((char *) String) - 1] = '\0';
	}
	fclose(input); 
	fclose(output);
}

void ShiftDecodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar)
{
	FILE			*input, *output;
	unsigned char	String[260];

	input = fopen(InputFilename, "rt");
	output = fopen(OutputFilename, "wt");
	fgets((char *) String, 256, input);
	String[strlen((char *) String) - 1] = '\0';
	while (!feof(input)) {
		ShiftDecodeString(String, Start, LoopA, LoopB, FirstChar, LastChar);
		fprintf(output, "%s\n", String);
		fgets((char *) String, 256, input);
		String[strlen((char *) String) - 1] = '\0';
	}
	fclose(input); 
	fclose(output);
}

short ShiftPeriod(short Start, short LoopA, short LoopB)
{
	short	i, MaskA, MaskB, Insert, Aux;

	MaskA = 1 << LoopA;
	MaskB = 1 << LoopB;

	// Einschwingvorgang:
	Aux = 1 << (SHIFTLENGTH - 1);
	for (i = 0; i < Aux; i++) {
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
	}

	// periodische Schwingung:
	Aux = Start;
	i = 0;
	do {
		Insert = !(Start & MaskA || Start & MaskB);
		Insert <<= SHIFTLENGTH - 1;
		Start >>= 1;
		Start |= Insert;
		i++;
	} while (Start != Aux);
	return i;
}

long IDCalculate(char *Name, short Key1, short Key2)
{
	short			i;
	unsigned long	n;

	n = Key1 + 7369;
	for (i = 0; i < strlen(Name); i++) {
		n *= (Name[i] + 13);
		n %= 123456789L;
	}
	if (n == 0)
    	n = Key1 * 431;
	n *= (Key2 + 57);
	n %= 100000L;
	while (n < 10000)
    	n *= 10;
	return n;
}

void IDShortName(char *Name, char *ShortName)
{
	short	i, Offset;

	i = 1;
	Offset = 0;
	ShortName[0] = Name[0];
	while (Name[i] != ' ' && i < strlen(Name))
		i++;
	Offset = i;
    do {
		i++;
		ShortName[i - Offset] = Name[i];
	} while (i < strlen(Name));
	ShortName[i - Offset] = '\0';
}

void IDLongName(char *Name, char *LongName)
{
	short	i, Offset;

	Offset = 0;
	for (i = 0; i < strlen(Name); i++) {
		LongName[i + Offset] = Name[i];
		if (i == 0) {
			LongName[1] = '.';
			LongName[2] = ' ';
			Offset = 2;
		}			        	
	}
	LongName[i + Offset] = '\0';
}
