/* 04.06.94 */

#define SHIFTLENGTH	8

/* Caesar: einzelnes Zeichen */
void CesarEncodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3);
void CesarDecodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3);
/* Char: das umzuwandelnde Zeichen; hinterher das Ergebnis */
/* Base: die Basis fuer die Berechnung (fuer laengere Strings variieren, sonst zu offensichtlicher Schluesseltext!) */
/* Key 1, 2, 3: die Schluessel, jeweils im Bereich von -256 bis +256 */
/* Basis und Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Caesar: Zeichenkette (String) */
void CesarEncodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
void CesarDecodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
/* String: die umzuwandelnde Zeichenkette, nullterminiert; hinterher das Ergebnis */
/* Key 1, 2, 3: die Schluessel, jeweils im Bereich von -256 bis +256 */
/* FirstChar, LastChar: ASCII-Bereich, dem die Zeichen im Eingangsstring und damit auch im Ausgangsstring angehoeren. So koennen beispielsweise Zahlen in Zahlen verschluesselt werden. */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Caesar: Binaerdatei */
void CesarEncodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3);
void CesarDecodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3);
/* InputFilename, OutputFilename: DOS-Dateinamen der Ein- und Ausgangsdatei */
/* Key 1, 2, 3: die Schluessel, jeweils im Bereich von -256 bis +256 */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Caesar: Textdatei */
void CesarEncodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
void CesarDecodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
/* InputFilename, OutputFilename: DOS-Dateinamen der Ein- und Ausgangsdatei */
/* Key 1, 2, 3: die Schluessel, jeweils im Bereich von -256 bis +256 */
/* FirstChar, LastChar: ASCII-Bereich, dem die Zeichen in der Eingangsdatei und damit auch in der Ausgangsdatei angehoeren. So koennen beispielsweise Zahlen in Zahlen verschluesselt werden. */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Schieberegister: einzelnes Zeichen */
void ShiftEncodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB);
void ShiftDecodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB);
/* Char: das umzuwandelnde Zeichen; hinterher das Ergebnis */
/* Base: die Basis fuer die Berechnung (fuer laengere Strings variieren, sonst zu offensichtlicher Schluesseltext!) */
/* Start: Anfangswert des Schieberegisters; LoopA, LoopB: rueckzufuehrende Bits */
/* Basis und Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Schieberegister: Zeichenkette (String) */
void ShiftEncodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
void ShiftDecodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
/* String: die umzuwandelnde Zeichenkette, nullterminiert; hinterher das Ergebnis */
/* Start: Anfangswert des Schieberegisters; LoopA, LoopB: rueckzufuehrende Bits */
/* FirstChar, LastChar: ASCII-Bereich, dem die Zeichen im Eingangsstring und damit auch im Ausgangsstring angehoeren. So koennen beispielsweise Zahlen in Zahlen verschluesselt werden. */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Schieberegister: Binaerdatei */
void ShiftEncodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB);
void ShiftDecodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB);
/* InputFilename, OutputFilename: DOS-Dateinamen der Ein- und Ausgangsdatei */
/* Start: Anfangswert des Schieberegisters; LoopA, LoopB: rueckzufuehrende Bits */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Schieberegister: Textdatei */
void ShiftEncodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
void ShiftDecodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
/* InputFilename, OutputFilename: DOS-Dateinamen der Ein- und Ausgangsdatei */
/* Start: Anfangswert des Schieberegisters; LoopA, LoopB: rueckzufuehrende Bits */
/* FirstChar, LastChar: ASCII-Bereich, dem die Zeichen in der Eingangsdatei und damit auch in der Ausgangsdatei angehoeren. So koennen beispielsweise Zahlen in Zahlen verschluesselt werden. */
/* Die Schluessel muessen natuerlich fuer Ver- und Entschluesselung identisch sein! */

/* Schieberegister: Periodenlaenge */
short ShiftPeriod(short Start, short LoopA, short LoopB);
/* Start: Anfangswert des Schieberegisters; LoopA, LoopB: rueckzufuehrende Bits */
/* Rueckgabewert: die Periodenlaenge des Schieberegisters */

/* Benutzer-ID: */
long IDCalculate(char *Name, short Key1, short Key2);
/* Name: die berechnende Zeichenkette, nullterminiert; bleibt unveraendert */
/* Key 1, 2: die eigentlichen Schluessel, jeweils im Bereich von -256 bis +256 */
/* Rueckgabewert: die fuenfstellige ID */
void IDShortName(char *Name, char *ShortName);
/* Name: der zu verkuerzende Name, nullterminiert; bleibt unveraendert */
/* Rueckgabewert: der verkuerzte Name in ShortName */
void IDLongName(char *Name, char *LongName);
/* Name: der zu verlaengernde Name, nullterminiert; bleibt unveraendert */
/* Rueckgabewert: der verlaengerte Name in LongName */
