//*                           Record.H
//*
//*           Header file for the Record.Cpp Class functions
//*
//*
//**************************************************************************

#ifndef RECORD_H
#define RECORD_H

#include <string.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE 
#define FALSE 0
#endif

//**************************************************************************
class FieldDef {

public:
	FieldDef(char *name, int size, int offset)
	{
		Name = new char[strlen(name)+1];
		strcpy(Name,name);
                Width  = size;
                Offset = offset;
	};

	~FieldDef(void)
	{
		delete Name;
	};

	char	*Name;
        int      Width;
        int      Offset;
        int      Type;
};


//**************************************************************************
class Record {
private:
	void init(void);

protected:
	FieldDef	**fields;
        int               fldCount;
        int               fldArraySize;
        int               recLen;
	
public:
	Record(void);
	Record(char *fldFile);
	~Record(void);

	int addField(char *name, int width);

	int getFieldNum(char *name);
        const char* getFieldName(int fldNum);

	int getField(char *name, char *field);
	int getField(char *name, int &field);
	int getField(char *name, long &field);
	int getField(char *name, float &field);
        int getField(char *name, double &field);

        int getField(int fldNum, char *field);
	int getField(int fldNum, int &field);
	int getField(int fldNum, long &field);
	int getField(int fldNum, float &field);
        int getField(int fldNum, double &field);

        int getFieldWidth(int fldNum);
        int getFieldWidth(char *name);

	char*	Buffer;
        int     Length(void);
};

#endif
