//*                             Table.H
//*
//*           Header File for the Table.cpp Functions Class
//*
//*
//***************************************************************************


#ifndef TABLE_H
#define TABLE_H

#include "record.h"

#define TBL_OK                  0
#define TBL_EMPTY 		1
#define TBL_BEGIN 		2
#define TBL_END                 3
#define TBL_RANGE               4
#define TBL_NOTFOUND            5

//-------------------------------------------------------------------------
class IndexTable {
private:
        int     handle;
        int     keySize;
	long	keyCount;
	long	current;
	char	*Key;

        struct KeyData
        {
		long	recnum;
		long	parent;
		long	left;
		long	right;
		char	loc;
        }keyData;

public:

	IndexTable(char *name, int keysize);
	~IndexTable(void);
	
	void	addKey(char *key, long recnum);

	long	findKey(char *key);
	long	getFirst(long start=0);
	long	getLast(long start=0);
	long	getNext(void);
	long	getPrev(void);
};

//-------------------------------------------------------------------------
class Table {

private:
	static int usage;
        static IndexTable*     pIndex[10];
        static Table*          pTable[10];

        Record                 *pRecord;

        int             hFile;
	long		cursor;
	long		fileSize;
	long		recCount;
        int             recLength;
        int             keySize;

	char*		indexName(int handle);

public:
	Table(char *file, Record *record);
	~Table(void);

	int openIndex(int *fields, int fcount);
	int closeIndex(int ix);
			
	int Get(void);
	int Search(char *fldName, char *search);
	int Search(int fldNum, char *search);
	int Search(char *key, int ihandle);

	int gotoFirst(int ihandle=-1);
	int gotoLast(int ihandle=-1);
	int gotoNext(int ihandle=-1);
	int gotoPrev(int ihandle=-1);
	int gotoRecNum(long recnum);

        long getRecNum(void)                             {return(cursor);};
	long getRecCount(void) 				{return(recCount);};
};

#endif
