/*------------------------------------------------------------------------------
 *  CKTBL.DLL	TablePane control for Windows
 *  Copyright(C) 1994 by Christian Kratzer Software development and Consulting
 *
 *  File: cktbl.h
 *
 * $Header: e:\users\cktbl\dev\rcsdir/RCS/cktbl.h 1.33 94/09/04 17:23:03 CK_MSVC15_DLL16 Exp $
 * $Log:	cktbl.h $
 * Revision 1.33  94/09/04  17:23:03  CK_MSVC15_DLL16
 * *** empty log message ***
 * 
 * Revision 1.32  94/09/04  14:45:27  CK_VBX_VC15
 * *** empty log message ***
 * 
 * Revision 1.31  94/07/31  18:36:46  CK_MSVC15_DLL16
 * *** empty log message ***
 * 
 *----------------------------------------------------------------------------*/

#ifndef CKTBL_H
#define CKTBL_H

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

#define CKTBL_CLASS			"CKTBL16"  
                                        
#ifndef CKTBL_NOCOLORS
#define CLR_BLACK			RGB(0,0,0)
#define CLR_DARKGRAY		RGB(128,128,128)
#define	CLR_LIGHTGRAY		RGB(192,192,192)
#define	CLR_WHITE			RGB(255,255,255)

#define CLR_BLUE			RGB(0,0,255)
#define CLR_GREEN			RGB(0,255,0)
#define CLR_CYAN			RGB(0,255,255)
#define CLR_RED				RGB(255,0,0)
#define CLR_PINK			RGB(255,0,255)
#define CLR_YELLOW			RGB(255,255,0)
#endif
           
#ifdef CKTBL_LIBRARY                
#define CKAPI				FAR __cdecl 
#define CKCALLBACK 			CALLBACK  
#else                
#define CKAPI				FAR __cdecl __loadds
#define CKCALLBACK 			CALLBACK __loadds                 
#endif
                 
/*------------------------------------------------------------------------------
	CKTBL Messages
------------------------------------------------------------------------------*/

#define CKTBL_BASEID				WM_USER

#define CKTBL_EDIT_START			CKTBL_BASEID + 100
#define CKTBL_EDIT_END				CKTBL_BASEID + 101 
#define CKTBL_EDIT_CANCELLED		CKTBL_BASEID + 102

#define CKTBL_SET_SELECTION			CKTBL_BASEID + 110
#define CKTBL_ADD_SELECTION			CKTBL_BASEID + 111
#define CKTBL_EXTEND_SELECTION		CKTBL_BASEID + 112

#define CKTBL_RESIZE_COLUMN_START	CKTBL_BASEID + 140
#define CKTBL_RESIZE_COLUMN_END	  	CKTBL_BASEID + 141
#define CKTBL_RESIZE_ROW_START		CKTBL_BASEID + 142
#define CKTBL_RESIZE_ROW_END	  	CKTBL_BASEID + 143

#define CKTBL_CHANGED_CURRENTCELL	CKTBL_BASEID + 150
#define CKTBL_CHANGED_SELECTION		CKTBL_BASEID + 151
#define CKTBL_CLICKED_CELL			CKTBL_BASEID + 152
#define CKTBL_DOUBLECLICKED_CELL	CKTBL_BASEID + 153

#define CKTBL_CHANGE_CURSOR			CKTBL_BASEID + 160
                            
#define CKTBL_HSCROLL_BEGIN			CKTBL_BASEID + 170	
#define CKTBL_HSCROLL_END			CKTBL_BASEID + 171                            
#define CKTBL_VSCROLL_BEGIN			CKTBL_BASEID + 172                            
#define CKTBL_VSCROLL_END			CKTBL_BASEID + 173                            
                                                      
#define CKTBL_EDIT_WM_SYSKEYDOWN	CKTBL_BASEID + 180
#define CKTBL_EDIT_WM_SYSKEYUP		CKTBL_BASEID + 181
#define CKTBL_EDIT_WM_CHAR			CKTBL_BASEID + 182       

/*------------------------------------------------------------------------------ 
 *	flags for lParam of CKTBL_EDIT_WM_keyboard messages
 *----------------------------------------------------------------------------*/

#define CKTBL_EDIT_SHIFT_MASK		1
#define CKTBL_EDIT_CTRL_MASK		2
#define CKTBL_EDIT_ALT_MASK			4	                       

/*------------------------------------------------------------------------------ 
 *	passed as wParam of CKTBL_CHANGE_CURSOR message
 *----------------------------------------------------------------------------*/

#define CKTBL_CURSOR_NULL			0
#define CKTBL_CURSOR_STD		 	1
#define CKTBL_CURSOR_RESIZE_ROW	 	2
#define CKTBL_CURSOR_RESIZE_COL	 	3  

/*------------------------------------------------------------------------------
 *	CKTBL Flags
 *----------------------------------------------------------------------------*/

#define CKTBL_RESIZE_ROWS			0x00000001l		/* allow user to resize rows */
#define CKTBL_RESIZE_COLUMNS		0x00000002l		/* allow user to resize columns */

#define CKTBL_EDIT_ROW_LABELS		0x00000004l		/* allow user to edit row labels */
#define CKTBL_EDIT_COLUMN_LABELS	0x00000008l		/* allow user to edit column labels */
#define CKTBL_EDIT_CELLS			0x00000010l		/* allow user to edit cells */

#define CKTBL_SHOW_GRID				0x00000020l		/* show grid */
#define CKTBL_SHOW_SELECTION		0x00000040l		/* show selection */

#define CKTBL_SELECT_ALL			0x00000080l		/* allow selecting all cells */
#define CKTBL_SELECT_CELLS			0x00000100l		/* allow selecting cells */
#define CKTBL_SELECT_ROWS			0x00000200l   	/* allow selecting full rows */
#define CKTBL_SELECT_COLUMNS		0x00000400l		/* allow selecting full columns */

#define CKTBL_EXTENDED_SELECT		0x00000800l		/* allow selecting a range of cells at once */
#define CKTBL_SHIFT_SELECT			0x00001000l		/* allow extending selections using shift-key */
#define CKTBL_CONTROL_SELECT		0x00002000l		/* allow multiple selections usgin control-key */

#define CKTBL_HSCROLL				0x00004000l     /* enable horizontal scrollbar */
#define CKTBL_HSCROLL_ONDEMAND		0x40000000l		/* enable horizontal scrollbar on demand */

#define CKTBL_VSCROLL				0x00008000l		/* enable vertical scrollbar */
#define CKTBL_VSCROLL_ONDEMAND		0x80000000l		/* enable vertical scrollbar on demand */
                                            
#define CKTBL_AUTOROWHEIGHT			0x00010000l		/* adjust row height when changing text, or fonts */
                     
#define CKTBL_HSCROLL_MASK			0x00020000l     /* horizontal scroll mode */
# define CKTBL_HSCROLL_EXTRA		0x00000000l		/* scroll into gray area past last column */
# define CKTBL_HSCROLL_STOP 		0x00020000l		/* stop at last column */

#define CKTBL_VSCROLL_MASK			0x00040000l     /* vertical scroll mode */
# define CKTBL_VSCROLL_EXTRA		0x00000000l		/* scroll into gray area past last row */
# define CKTBL_VSCROLL_STOP 		0x00040000l		/* stop at last row */

#define CKTBL_SMOOTH_SCROLL			0x00080000l		/* enable smooth scrolling */           
                        
#define CKTBL_ROWLABEL_MASK			0x00300000l		
# define CKTBL_ROWLABEL_EMPTY		0x00000000l     /* empty row labels */
# define CKTBL_ROWLABEL_NUMERIC		0x00100000l		/* numeric row labels */
# define CKTBL_ROWLABEL_ALPHA		0x00200000l		/* alphabetic row labels */
 
#define CKTBL_COLLABEL_MASK			0x00C00000l		
# define CKTBL_COLLABEL_EMPTY		0x00000000l     /* empty column labels */
# define CKTBL_COLLABEL_NUMERIC		0x00400000l		/* numeric column labels */
# define CKTBL_COLLABEL_ALPHA		0x00800000l		/* alphabetic column labels */
                  
#define CKTBL_ROWLABEL_3D			0x01000000l		/* draw 3D Row Labels */
#define CKTBL_COLLABEL_3D			0x02000000l     /* draw 3D Column Labels */
                                                             
#define CKTBL_CREATE_LABELSIZE		0x10000000l     /* use columnLabelWidth,rowLabelHeight from CKTBL_CREATE */
#define CKTBL_CREATE_CELLSIZE     	0x20000000l		/* use defaultRowHeight,defaultColumnWidth from CKTBL_CREATE */

#define CKTBL_DEFAULT_FLAGS							\
   (CKTBL_RESIZE_ROWS | CKTBL_RESIZE_COLUMNS |		\
	CKTBL_EDIT_CELLS | 								\
	CKTBL_SHOW_GRID |  CKTBL_SHOW_SELECTION  |		\
	CKTBL_SELECT_ALL | CKTBL_SELECT_CELLS |			\
	CKTBL_SELECT_ROWS | CKTBL_SELECT_COLUMNS |		\
	CKTBL_EXTENDED_SELECT | CKTBL_SHIFT_SELECT | CKTBL_CONTROL_SELECT | \
	CKTBL_HSCROLL | CKTBL_HSCROLL_ONDEMAND |		\
	CKTBL_VSCROLL | CKTBL_VSCROLL_ONDEMAND |  		\
	CKTBL_ROWLABEL_NUMERIC | CKTBL_COLLABEL_ALPHA )


#define CKTBL_CHECK( flags, mask ) 		(((flags)&(mask))==(mask))
#define CKTBL_SETFLAG( flags, mask ) 	((flags)|(mask))
#define CKTBL_CLEARFLAG( flags, mask ) 	((flags)&(~(long)(mask)))


/*------------------------------------------------------------------------------
 *	Cell Format flags
 *----------------------------------------------------------------------------*/

#define CKTBL_MASK_HALIGN			(CKTBL_FMT_LEFT|CKTBL_FMT_CENTER|CKTBL_FMT_RIGHT)
# define CKTBL_FMT_LEFT				0x0000    	/* left justified text */
# define CKTBL_FMT_CENTER			0x0001		/* centered text */
# define CKTBL_FMT_RIGHT			0x0002		/* right justified text */

#define CKTBL_MASK_VALIGN			(CKTBL_FMT_TOP|CKTBL_FMT_BOTTOM)
# define CKTBL_FMT_TOP				0x1000
# define CKTBL_FMT_BOTTOM			0x0000

#define CKTBL_MASK_CELLTYPE			(CKTBL_FMT_SINGLE_LINE|CKTBL_FMT_MULTI_LINE)
# define CKTBL_FMT_SINGLE_LINE		0x0000		/* single line of text */
# define CKTBL_FMT_MULTI_LINE		0x0010		/* multiple line text */

#define CKTBL_FMT_HSCROLL			0x0020		/* WS_HSCROLL	horizontal scroll bar */
#define CKTBL_FMT_VSCROLL			0x0040		/* WS_VSCROLL	vertical scroll bar */
#define CKTBL_FMT_AUTOHSCROLL		0x0080      /* ES_AUTOHSCROLL	*/
#define CKTBL_FMT_AUTOVSCROLL		0x0100		/* ES_AUTOVSCROLL	*/
#define CKTBL_FMT_WORDBREAK			0x0200		/* word wrap (only with CKTBL_FMT_MULTI_LINE) */

#define CKTBL_FMT_VGROW				0x0400	    /* grow horizontally with text, only with CKTBL_FMT_MULTILINE */
#define CKTBL_FMT_VSHRINK			0x0800		/* shrink vertically with text, only with CKTBL_FMT_MULTILINE */
             
#define CKTBL_FMT_AUTOSELECT_MASK	(CKTBL_FMT_NOAUTOSELECT|CKTBL_FMT_AUTOSELECT|CKTBL_FMT_AUTOSELECTEND)             
# define CKTBL_FMT_NOAUTOSELECT		0x2000		/* do not select the text */
# define CKTBL_FMT_AUTOSELECT		0x0000      /* automatically select all text */
# define CKTBL_FMT_AUTOSELECTEND	0x4000		/* automatically select end of text */

#define CKTBL_FMT_TEXTLIMIT			0x8000		/* limit text size to value specified in textLimit */
#define CKTBL_FMT_TABONLIMIT	0x10000000l		/* automatically tab when text limit reached */

/*-----------------------------------------------------------------------------
------------------------------------------------------------------------------*/

#define CKTBL_MULTILINEBREAK					\
	(CKTBL_FMT_MULTI_LINE|						\
	CKTBL_FMT_AUTOVSCROLL|						\
	CKTBL_FMT_VGROW|CKTBL_FMT_VSHRINK|			\
	CKTBL_FMT_WORDBREAK)

#define CKTBL_MULTILINE	   						\
	(CKTBL_FMT_MULTI_LINE|						\
	CKTBL_FMT_HSCROLL|CKTBL_FMT_AUTOHSCROLL|	\
	CKTBL_FMT_AUTOVSCROLL|						\
	CKTBL_FMT_VGROW|CKTBL_FMT_VSHRINK )

#define CKTBL_SINGLELINE_TOP					\
	(CKTBL_FMT_SINGLE_LINE|						\
	CKTBL_FMT_AUTOHSCROLL|						\
	CKTBL_FMT_TOP)

#define CKTBL_SINGLELINE_BOTTOM					\
	(CKTBL_FMT_SINGLE_LINE|						\
	CKTBL_FMT_AUTOHSCROLL|						\
	CKTBL_FMT_BOTTOM)

#define CKTBL_SINGLELINE	CKTBL_SINGLELINE_TOP

/*-----------------------------------------------------------------------------
 *	Create struct for use in CREATESTRUCT of CreateWindow()
 *----------------------------------------------------------------------------*/

typedef struct tagCKTBL_CREATE {
		long	flags;
		int		rows;
		int		columns;
		int		columnLabelWidth;
		int		rowLabelHeight;
		int		defaultColumnWidth;
		int		defaultRowHeight;
		char	reserved[16];
	} CKTBL_CREATE;

/*------------------------------------------------------------------------------
 * a pointer to a CKTBL_EDITARG is passed as lParam in following messages
 *	CKTBL_EDIT_START	call CKTBLStartEdit() if ok
 *	CKTBL_EDIT_END		call CKTBLSetText() if ok
 *----------------------------------------------------------------------------*/

typedef struct tagCKTBL_EDITARG {
		int		row;
		int		column;
		LPSTR   text;
	} CKTBL_EDITARG;

/*------------------------------------------------------------------------------
 *----------------------------------------------------------------------------*/

typedef struct tagCKTBL_ATTRIB {
		DWORD		format;
		COLORREF	foreColor;
		COLORREF	backColor;

		LPSTR		fontName;
		int			fontSize;  			/* font size in 1/10 points */
		BOOL		fontBold;
		BOOL		fontItalic;
		BOOL		fontStrikeOut;
		BOOL		fontUnderline;

		HFONT		hFont; 				/* overrides above, not deleted by CKTBLL */  
		
		WORD		textLimit;			/* only used if format contains CKTBL_FMT_TEXTLIMT */
	} CKTBL_ATTRIB;

/*------------------------------------------------------------------------------
------------------------------------------------------------------------------*/

#define CKTBL_ATTR_FORMAT			0x0001
#define CKTBL_ATTR_BACKCOLOR		0x0002
#define CKTBL_ATTR_FORECOLOR		0x0004
#define CKTBL_ATTR_FONT								\
		(CKTBL_ATTR_FONTNAME|CKTBL_ATTR_FONTSIZE|	\
		 CKTBL_ATTR_FONTBOLD|CKTBL_ATTR_FONTITALIC|	\
		 CKTBL_ATTR_FONTUNDERLINE|CKTBL_ATTR_FONTSTRIKEOUT )
# define CKTBL_ATTR_FONTNAME   		0x0008
# define CKTBL_ATTR_FONTSIZE   		0x0010
# define CKTBL_ATTR_FONTBOLD   		0x0020
# define CKTBL_ATTR_FONTITALIC		0x0040
# define CKTBL_ATTR_FONTUNDERLINE	0x0080
# define CKTBL_ATTR_FONTSTRIKEOUT	0x0100
#define CKTBL_ATTR_HFONT			0x0200
#define CKTBL_ATTR_TEXTLIMIT		0x0400
                             	
   
/*------------------------------------------------------------------------------
 *	Helper functions
 *----------------------------------------------------------------------------*/

void CKAPI CKTBLModifyAttrStruct( CKTBL_ATTRIB FAR* dst, CKTBL_ATTRIB FAR* src, short fields, DWORD formatMask ); 	//NEW
LPSTR CKAPI CKTBLIndexAsNumber( int index, LPSTR buffer );
LPSTR CKAPI CKTBLIndexAsAlpha( int index, LPSTR buffer, int bufferSize );                           
  
/*------------------------------------------------------------------------------
 *	Public Protocol
 *----------------------------------------------------------------------------*/

LRESULT CKCALLBACK CKTBLWindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

void	CKAPI CKTBLClear			( HWND hWnd );
void	CKAPI CKTBLSetSize			( HWND hWnd, int rows, int columns );
void	CKAPI CKTBLSetColumns		( HWND hWnd, int columns );
void	CKAPI CKTBLSetRows			( HWND hWnd, int rows );

int		CKAPI CKTBLGetColumns		( HWND hWnd );
int		CKAPI CKTBLGetRows			( HWND hWnd );

void	CKAPI CKTBLSetFlags			( HWND hWnd, DWORD flags );
long	CKAPI CKTBLGetFlags			( HWND hWnd );

BOOL	CKAPI CKTBLHasVScrollBar	( HWND hWnd );
BOOL	CKAPI CKTBLHasHScrollBar	( HWND hWnd );

void 	CKAPI CKTBLSetTextLimit		( HWND hWnd, int row, int col, int limit );
int		CKAPI CKTBLGetTextLimit		( HWND hWnd, int row, int col );

int		CKAPI CKTBLGetCurrentRow	( HWND hWnd );
int		CKAPI CKTBLGetCurrentColumn	( HWND hWnd );
void	CKAPI CKTBLSetCurrentCell 	( HWND hWnd, int row, int col );

int		CKAPI CKTBLGetTopRow		( HWND hWnd );                             
int		CKAPI CKTBLGetLeftColumn	( HWND hWnd );
void	CKAPI CKTBLSetLeftTop		( HWND hWnd, int left, int top );

BOOL 	CKAPI CKTBLInEdit			( HWND hWnd );
void	CKAPI CKTBLStartEdit		( HWND hWnd, int row, int column, LPSTR text );
void	CKAPI CKTBLStartEditRequest	( HWND hWnd, int row, int column, LPSTR text );
BOOL 	CKAPI CKTBLEndEdit			( HWND Hwnd, BOOL acceptChanges );
void 	CKAPI CKTBLShowCell			( HWND hWnd, int row, int col  );

void	CKAPI CKTBLSetCellAttr		( HWND hWnd, CKTBL_ATTRIB FAR* attrib );
void	CKAPI CKTBLGetCellAttr		( HWND hWnd, CKTBL_ATTRIB FAR* attrib );

void	CKAPI CKTBLSetLabelAttr		( HWND hWnd, CKTBL_ATTRIB FAR* attrib );
void	CKAPI CKTBLGetLabelAttr		( HWND hWnd, CKTBL_ATTRIB FAR* attrib );

void	CKAPI CKTBLSetDefaultColumnWidth( HWND hWnd, int width );
void	CKAPI CKTBLSetDefaultRowHeight  ( HWND hWnd, int height );

int		CKAPI CKTBLGetDefaultColumnWidth( HWND hWnd );
int		CKAPI CKTBLGetDefaultRowHeight  ( HWND hWnd );

void	CKAPI CKTBLSetColumnWidth   	( HWND hWnd, int column, int width );
void	CKAPI CKTBLSetRowHeight     	( HWND hWnd, int row, int height );

int		CKAPI CKTBLGetColumnWidth   	( HWND hWnd, int column  );
int		CKAPI CKTBLGetRowHeight     	( HWND hWnd, int row );

int		CKAPI CKTBLGetTextHeight		( HWND hWnd, int row, int col, LPCSTR text );
int		CKAPI CKTBLGetRowTextHeight		( HWND hWnd, int row, int skipColumn );
void	CKAPI CKTBLUpdateRowHeight		( HWND hWnd, int row );

void	CKAPI CKTBLInsertRowsAfter		( HWND hWnd, int row, int number );
void	CKAPI CKTBLInsertColumnsAfter	( HWND hWnd, int column ,int number );

void	CKAPI CKTBLRemoveRows			( HWND hWnd, int rowStart, int rowEnd );
void	CKAPI CKTBLRemoveColumns		( HWND hWnd, int columnStart, int columnEnd);

void	CKAPI CKTBLSetText		   	( HWND hWnd, int row, int column, LPCSTR text );
void	CKAPI CKTBLSetTextPrim	   	( HWND hWnd, int row, int column, LPCSTR text );
void 	CKAPI CKTBLSetRowText		( HWND hWnd, int row, LPCSTR text, int colSep, int lineSep );

int		CKAPI CKTBLGetTextLength	( HWND hWnd, int row, int column );
void	CKAPI CKTBLGetText			( HWND hWnd, int row, int column, LPSTR text, int maxLength );
  
int 	CKAPI CKTBLGetRowTextLength	( HWND hWnd, int row  );
void 	CKAPI CKTBLGetRowText		( HWND hWnd, int row, LPSTR text, int maxLength, int colSep, int lineSep );  
  
void	CKAPI CKTBLSetAttr			( HWND hWnd, int row, int column, CKTBL_ATTRIB FAR* attrib );
void	CKAPI CKTBLModifyAttr		( HWND hWnd, int row, int column, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask  );
void	CKAPI CKTBLGetAttr			( HWND hWnd, int row, int column, CKTBL_ATTRIB FAR* attrib );

void	CKAPI CKTBLSetRectText		( HWND hWnd, RECT FAR* rect, LPSTR text );
void	CKAPI CKTBLSetRectAttr		( HWND hWnd, RECT FAR* rect, CKTBL_ATTRIB FAR* attrib );
void	CKAPI CKTBLModifyRectAttr	( HWND hWnd, RECT FAR* rect, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask );
                                        
void	CKAPI CKTBLSetSelAttr		( HWND hWnd, CKTBL_ATTRIB FAR* attrib );
void	CKAPI CKTBLModifySelAttr	( HWND hWnd, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formtMask );

/*------------------------------------------------------------------------------
 *	Selections are stored as rectangles
 *	left,top specify the column and row of the leftTop cell in the selection
 *	right,bottom specify the column and row of the rightBottom cell in the selection
 *
 *	left==0 indicates a row selection
 *	top==0 indicats a column selection
 *	left==0 && top==0 indicates total selection
 *----------------------------------------------------------------------------*/

void 	CKAPI CKTBLClearSelection	( HWND hWnd );
void	CKAPI CKTBLSetSelection		( HWND hWnd, RECT FAR* cells );
void	CKAPI CKTBLChangeSelection	( HWND hWnd, RECT FAR* cells, int index );
void	CKAPI CKTBLAddSelection		( HWND hWnd, RECT FAR* cells );

void	CKAPI CKTBLSetSelectionOrg	( HWND hWnd, RECT FAR* cells, POINT FAR* origin );
void	CKAPI CKTBLAddSelectionOrg	( HWND hWnd, RECT FAR* cells, POINT FAR* origin );

int		CKAPI CKTBLGetSelectionSize ( HWND hWnd );
BOOL	CKAPI CKTBLGetSelection		( HWND hWnd, RECT FAR* cells, int n );

#ifdef CKTBL_LIBRARY
BOOL	CKAPI CKTBLInitLib( HANDLE hInstanceExe );
void  	CKAPI CKTBLExitLib();
#endif


#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

#endif /* CKTBL_H */


