// cktblctr.h : header file
//
        
/////////////////////////////////////////////////////////////////////////////
// CCKTBLControl window
     
#include "cktbl.h"     
         
struct CKTBLPrintStruct;
                     
class CCKTBLControl : public CWnd
{
	DECLARE_DYNCREATE( CCKTBLControl )
	
// Construction
public:
	CCKTBLControl();
 	BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd );

// Attributes
public:
    
// High Level CCKTBLControl Operations

	void AddFlags( DWORD flags );
	void RemoveFlags( DWORD flags );  
	void SetFlagsTo( DWORD flags, BOOL value );  
    void GetText( int row, int col, CString * text );
            
// Misc Helper functions            
            
   	void UpdateSelectionRowHeighths();
       
// Printing support 

	virtual void OnPrint( CDC* pDC, CPrintInfo* pInfo );      
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);  

	virtual void Paginate( CDC* pDC, CPrintInfo* pInfo );
    virtual void SetMargins( CDC *pDC, CPrintInfo * pInfo, int left=15, int top=15, int right=10, int bottom=10 );	// margins in mm
                                       
    virtual void DrawTable(CDC* pDC, CPrintInfo* pInfo=NULL );    
	virtual void DrawCell(CDC * pDC, int row, int col, CRect * rect, CKTBLPrintStruct * ps );

// Archive support 

	virtual void SerializeRaw(CArchive& ar);
  	void ReadFromArchive(CArchive& ar);
	void WriteToArchive(CArchive& ar);

                                                        
   
// Basic CCKTBLControl Operations (map directly to C API)

public:           
	void Clear			();
	void SetSize		( int rows, int columns );
	void SetColumns		( int columns );
	void SetRows		( int rows );
      
	int	GetColumns		();
	int GetRows			();

	void SetFlags		(DWORD flags );
	long GetFlags		();

	int	GetCurrentRow	();
	int GetCurrentColumn();
	void SetCurrentCell	(int row, int col );

	int	GetTopRow		();
	int GetLeftColumn	();
	void SetLeftTop		(int left, int top );

	BOOL InEdit			();
	void StartEdit		(int row, int column, LPSTR text );
	void StartEditRequest(int row, int column, LPSTR text );
	BOOL EndEdit		(BOOL acceptChanges );
	void ShowCell		(int row, int col  );
        
	void SetCellAttr	( CKTBL_ATTRIB FAR* attrib );
	void GetCellAttr	( CKTBL_ATTRIB FAR* attrib );
	                       
	void SetLabelAttr	( CKTBL_ATTRIB FAR* attrib );
	void GetLabelAttr	( CKTBL_ATTRIB FAR* attrib );
	
	void SetDefaultColumnWidth	( int width );
	void SetDefaultRowHeight	( int height );

	int GetDefaultColumnWidth	();
	int GetDefaultRowHeight 	();

	void SetColumnWidth   	( int column, int width );
	void SetRowHeight     	( int row, int height );

	int GetColumnWidth   	( int column  );
	int GetRowHeight     	( int row );
                            
	int GetTextHeight		( int row, int col, LPCSTR text );
	int GetRowTextHeight	( int row, int skipColumn );
	void UpdateRowHeight	( int row );

	void InsertRowsAfter	( int row, int number=1 );
	void InsertColumnsAfter	( int column ,int number=1 );

	void RemoveRows			( int rowStart, int rowEnd );
	void RemoveColumns		( int columnStart, int columnEnd);

	void SetText			( int row, int column, LPCSTR text );
	void SetTextPrim		( int row, int column, LPCSTR text );
	void SetRowText			( int row, LPCSTR text, int colSep, int lineSep );

	int GetTextLength		( int row, int column );
	void GetText			( int row, int column, LPSTR text, int maxLength );
  
	int GetRowTextLength	( int row  ); 
	void GetRowText			( int row, LPSTR text, int maxLength, int colSep, int lineSep );
  
	void SetAttr			( int row, int column, CKTBL_ATTRIB FAR* attrib );
	void ModifyAttr			( int row, int column, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask  ); 
	void GetAttr			( int row, int column, CKTBL_ATTRIB FAR* attrib );

	void SetRectText		( RECT FAR* rect, LPSTR text );
	void SetRectAttr		( RECT FAR* rect, CKTBL_ATTRIB FAR* attrib );
	void ModifyRectAttr		( RECT FAR* rect, CKTBL_ATTRIB FAR* attrib, short fields, DWORD formatMask );
                                        
	void SetSelAttr			( CKTBL_ATTRIB FAR* attrib ); 	
	void ModifySelAttr		( CKTBL_ATTRIB FAR* attrib, short fields, DWORD formtMask );	
  
	void ClearSelection		();
	void SetSelection		( RECT FAR* cells );
	void ChangeSelection	( RECT FAR* cells, int index );
	void AddSelection		( RECT FAR* cells );

	void SetSelectionOrg	( RECT FAR* cells, POINT FAR* origin );
	void AddSelectionOrg	( RECT FAR* cells, POINT FAR* origin );

	int GetSelectionSize	();
	BOOL GetSelection		( RECT FAR* cells, int n );
	
// Overridables (override to customize behaviour)
// see comments in CKTBLCtrl.cpp 

	virtual BOOL OnEditStart( int row, int col, CString text );
	virtual BOOL OnEditEnd( int row, int col, CString text);
	virtual void OnEditCancelled(int row, int col );
 	
	virtual BOOL OnResizeColumnStart( int column );
	virtual BOOL OnResizeColumnEnd( int column, long width );
	virtual BOOL OnResizeRowStart( int row  );
	virtual BOOL OnResizeRowEnd( int row, long height );
	
	virtual void OnChangedCurrentCell();
	virtual void OnChangedSelection();
	virtual void OnClickedCell( int row, int col );
	virtual void OnDoubleClickedCell( int row, int col );
	
	virtual BOOL OnChangeCursor( int state );
     
	virtual void OnHScrollBegin();
	virtual void OnHScrollEnd();
	virtual void OnVScrollBegin();
	virtual void OnVScrollEnd();

// Implementation
public:
	virtual ~CCKTBLControl();
protected:
	virtual WNDPROC* GetSuperWndProcAddr();
       
protected:
	// Generated message map functions
	//{{AFX_MSG(CCKTBLControl)  
	//}}AFX_MSG
	
	// CKTBL Messages
	afx_msg LRESULT OnMsgEditStart( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgEditEnd( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgEditCancelled( WPARAM wParam, LPARAM lParam );
     
	afx_msg LRESULT OnMsgResizeColumnStart( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgResizeColumnEnd( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgResizeRowStart( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgResizeRowEnd( WPARAM wParam, LPARAM lParam );
	
	afx_msg LRESULT OnMsgChangedCurrentCell( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgChangedSelection( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgClickedCell( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgDoubleClickedCell( WPARAM wParam, LPARAM lParam );
	
	afx_msg LRESULT OnMsgChangeCursor( WPARAM wParam, LPARAM lParam );
     
	afx_msg LRESULT OnMsgHScrollBegin( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgHScrollEnd( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgVScrollBegin( WPARAM wParam, LPARAM lParam );
	afx_msg LRESULT OnMsgVScrollEnd( WPARAM wParam, LPARAM lParam );

	DECLARE_MESSAGE_MAP()
	                                 
};

/////////////////////////////////////////////////////////////////////////////
